package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ArbenvioService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Arbenvio;
import com.ejie.y41b.model.Solarb;

/**
 * ArbenvioController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/arbenvio")
public class ArbenvioController {

	private static final Logger logger = LoggerFactory
			.getLogger(ArbenvioController.class);

	@Autowired
	private ArbenvioService arbenvioService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbenvioController.logger.info("[GET - View] : arbenvio");
		return "arbenvio";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param enid
	 *            Long
	 * @return arbenvio Arbenvio
	 */
	@RequestMapping(value = "/{enid}", method = RequestMethod.GET)
	public @ResponseBody
	Arbenvio getById(@PathVariable BigDecimal enid) {
		Arbenvio arbenvio = new Arbenvio();
		arbenvio.setEnid(enid);
		arbenvio = this.arbenvioService.find(arbenvio);
		ArbenvioController.logger
				.info("[GET - findBy_PK] : Obtener Arbenvio por PK");
		return arbenvio;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbenvio
	 *            Arbenvio
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Arbenvio> getAll(@ModelAttribute Arbenvio filterArbenvio) {
		ArbenvioController.logger
				.info("[GET - find_ALL] : Obtener Arbenvio por filtro");
		return this.arbenvioService.findAll(filterArbenvio, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @return Arbenvio
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Arbenvio edit(@RequestBody Arbenvio arbenvio) {
		Arbenvio arbenvioAux = this.arbenvioService.update(arbenvio);
		ArbenvioController.logger
				.info("[PUT] : Arbenvio actualizado correctamente");
		return arbenvioAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @return Arbenvio
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Arbenvio add(@RequestBody Arbenvio arbenvio) {
		Arbenvio arbenvioAux = this.arbenvioService.add(arbenvio);
		ArbenvioController.logger
				.info("[POST] : Arbenvio insertado correctamente");
		return arbenvioAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param enid
	 *            Long
	 * @return arbenvio
	 */
	@RequestMapping(value = "/{enid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Arbenvio remove(@PathVariable BigDecimal enid) {
		Arbenvio arbenvio = new Arbenvio();
		arbenvio.setEnid(enid);
		this.arbenvioService.remove(arbenvio);
		ArbenvioController.logger
				.info("[DELETE] : Arbenvio borrado correctamente");
		return arbenvio;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbenvioIds
	 *            List
	 * @return arbenvioList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> arbenvioIds) {
		List<Arbenvio> arbenvioList = new ArrayList<Arbenvio>();
		for (List<String> arbenvioId : arbenvioIds) {
			Iterator<String> iterator = arbenvioId.iterator();
			Arbenvio arbenvio = new Arbenvio(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			arbenvio.setEnid(ObjectConversionManager.convert(iterator.next(),
					BigDecimal.class));
			arbenvioList.add(arbenvio);
		}
		this.arbenvioService.removeMultiple(arbenvioList);
		ArbenvioController.logger
				.info("[POST - DELETE_ALL] : Arbenvio borrados correctamente");
		return arbenvioIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbenvio
	 *            Arbenvio
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Arbenvio filterArbenvio,
			@ModelAttribute Pagination pagination) {
		List<Arbenvio> arbenvios = this.arbenvioService.findAll(filterArbenvio,
				pagination);
		Long recordNum = this.arbenvioService.findAllCount(filterArbenvio);
		ArbenvioController.logger.info("[GET - jqGrid] : Obtener Arbenvio");
		return new JQGridJSONModel(pagination, recordNum, arbenvios);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param sacodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/dameEnviosExp", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@RequestParam(value = "sacodigo", required = false) String sacodigo,
			@ModelAttribute() Pagination pagination) {
		Arbenvio filterArbenvio = new Arbenvio();
		Solarb solarb = new Solarb();
		solarb.setSacodigo(sacodigo);
		filterArbenvio.setSolarb(solarb);

		List<Arbenvio> arbenvios = this.arbenvioService.findAll(filterArbenvio,
				pagination);
		Long recordNum = this.arbenvioService.findAllCount(filterArbenvio);
		ArbenvioController.logger.info("[GET - jqGrid] : Obtener Arbenvio");
		return new JQGridJSONModel(pagination, recordNum, arbenvios);
	}

}
