package com.ejie.y41b.control;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbdoctempController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/arbdoctemp")
public class ArbdoctempController {

	private static final Logger logger = LoggerFactory.getLogger(ArbdoctempController.class);

	@Autowired
	private ArbdoctempService arbdoctempService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbdoctempController.logger.info("[GET - View] : arbdoctemp");
		return "arbdoctemp";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param x5codocumento
	 *            String
	 * @return arbdoctemp Arbdoctemp
	 */
	@RequestMapping(value = "/{x5codocumento}", method = RequestMethod.GET)
	public @ResponseBody Arbdoctemp getById(@PathVariable String x5codocumento) {
		Arbdoctemp arbdoctemp = new Arbdoctemp();
		arbdoctemp.setX5codocumento(x5codocumento);
		try {
			arbdoctemp = this.arbdoctempService.find(arbdoctemp);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
		ArbdoctempController.logger.info("[GET - findBy_PK] : Obtener Arbdoctemp por PK");
		return arbdoctemp;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbdoctemp
	 *            Arbdoctemp
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Arbdoctemp> getAll(@ModelAttribute Arbdoctemp filterArbdoctemp) {
		ArbdoctempController.logger.info("[GET - find_ALL] : Obtener Arbdoctemp por filtro");
		return this.arbdoctempService.findAll(filterArbdoctemp, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Arbdoctemp edit(@RequestBody Arbdoctemp arbdoctemp) {
		Arbdoctemp arbdoctempAux = this.arbdoctempService.update(arbdoctemp);
		ArbdoctempController.logger.info("[PUT] : Arbdoctemp actualizado correctamente");
		return arbdoctempAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Arbdoctemp add(@RequestBody Arbdoctemp arbdoctemp) {
		Arbdoctemp arbdoctempAux = this.arbdoctempService.add(arbdoctemp);
		ArbdoctempController.logger.info("[POST] : Arbdoctemp insertado correctamente");
		return arbdoctempAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param x5codocumento
	 *            String
	 * @return arbdoctemp
	 */
	@RequestMapping(value = "/{x5codocumento}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Arbdoctemp remove(@PathVariable String x5codocumento) {
		Arbdoctemp arbdoctemp = new Arbdoctemp();
		arbdoctemp.setX5codocumento(x5codocumento);
		this.arbdoctempService.remove(arbdoctemp);
		ArbdoctempController.logger.info("[DELETE] : Arbdoctemp borrado correctamente");
		return arbdoctemp;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbdoctempIds
	 *            List
	 * @return arbdoctempList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> arbdoctempIds) {
		List<Arbdoctemp> arbdoctempList = new ArrayList<Arbdoctemp>();
		for (List<String> arbdoctempId : arbdoctempIds) {
			Iterator<String> iterator = arbdoctempId.iterator();
			Arbdoctemp arbdoctemp = new Arbdoctemp(); // NOPMD - Objeto nuevo en
														// la lista (parametro
														// del servicio)
			arbdoctemp.setX5codocumento(iterator.next());
			arbdoctempList.add(arbdoctemp);
		}
		this.arbdoctempService.removeMultiple(arbdoctempList);
		ArbdoctempController.logger.info("[POST - DELETE_ALL] : Arbdoctemp borrados correctamente");
		return arbdoctempIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Arbdoctemp filterArbdoctemp,
			@ModelAttribute Pagination pagination) {
		List<Arbdoctemp> arbdoctemps = this.arbdoctempService.findAll(filterArbdoctemp, pagination);
		Long recordNum = this.arbdoctempService.findAllCount(filterArbdoctemp);
		ArbdoctempController.logger.info("[GET - jqGrid] : Obtener Arbdoctemp");
		return new JQGridJSONModel(pagination, recordNum, arbdoctemps);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param sacodigo
	 *            String
	 * @param tipoProcedimiento
	 *            String
	 * @param filterArbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/findAllDocumentsExp", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGridDocExp(
			@RequestParam(value = "sacodigo", required = false) String sacodigo,
			@RequestParam(value = "tipo", required = false) String tipoProcedimiento,
			@ModelAttribute() Arbdoctemp filterArbdoctemp, @ModelAttribute() Pagination pagination) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(sacodigo);
		tramiteComun.setTipoProcedimiento(new TipoProcedimiento(tipoProcedimiento));

		List<DocumentoExpediente> arbdoctemps = this.arbdoctempService.findAllDocumentosExpediente(tramiteComun,
				pagination);

		Long recordNum = this.arbdoctempService.findAllDocumentosExpedienteCount(tramiteComun);
		ArbdoctempController.logger.info("[GET - jqGrid] : Obtener Arbdoctemp");
		return new JQGridJSONModel(pagination, recordNum, arbdoctemps);
	}

	/**
	 * Method 'getByIdDocumentoComunicacion'.
	 * 
	 * @param codocumento
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{codocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumentoComunicacion(@PathVariable() String codocumento,
			HttpServletResponse response) {
		try {
			Arbdoctemp arbdoctemp = new Arbdoctemp();
			arbdoctemp.setX5codocumento(codocumento);
			arbdoctemp = this.arbdoctempService.find(arbdoctemp);

			Blob contenido = arbdoctemp.getX5datafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(arbdoctemp.getX5nofile()) + "\"");
			response.setContentType(arbdoctemp.getX5conttype());
			response.setContentLength(arbdoctemp.getX5sizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllDocumentosTramite'.
	 * 
	 * @param idTramite
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocumentosTramite/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocumentosTramite(@PathVariable() String idTramite,
			HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(idTramite);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Arbdoctemp> listDocumentoHecho = null;

				if (censoMonitor != null && censoMonitor.getPerfilArbitraje() != null) {
					listDocumentoHecho = this.arbdoctempService.findAllDocumentosTramite(tramiteComun, pagination);
				}

				if (listDocumentoHecho == null) {
					throw new Exception("No data Found.");
				}

				Long total = new Long(0);
				if (censoMonitor != null && censoMonitor.getPerfilArbitraje() != null) {
					total = this.arbdoctempService.findAllDocumentosTramiteCount(tramiteComun);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listDocumentoHecho);
				return data;
			} else {
				List<Arbdoctemp> listDocumentoHecho = null;

				if (censoMonitor != null && censoMonitor.getPerfilArbitraje() != null
						&& !censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)) {
					listDocumentoHecho = this.arbdoctempService.findAllDocumentosTramite(tramiteComun, null);
				}
				if (listDocumentoHecho == null) {
					throw new Exception("No data Found.");
				}
				return listDocumentoHecho;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getDocumentosTramiteForm'.
	 * 
	 * @param idTramiteSanciones
	 *            String
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "documentosTramite/{idTramiteArbitraje}", method = RequestMethod.GET)
	public ModelAndView getDocumentosTramiteForm(@PathVariable() String idTramiteArbitraje, Model model) {

		model.addAttribute("idTramiteArbitraje", idTramiteArbitraje);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("documentosTramiteArbitraje", "model", model);
	}
}
