package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ArbcolegioService;

//import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Arbcolegio;

/**
 * ArbcolegioController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/arbcolegio")
public class ArbcolegioController {

	private static final Logger logger = LoggerFactory
			.getLogger(ArbcolegioController.class);

	@Autowired
	private ArbcolegioService arbcolegioService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbcolegioController.logger.info("[GET - View] : arbcolegio");
		return "arbcolegio";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param xjtrid
	 *            Long
	 * @return arbcolegio Arbcolegio
	 */
	@RequestMapping(value = "/{xjtrid}", method = RequestMethod.GET)
	public @ResponseBody
	Arbcolegio getById(@PathVariable String xjtrid) {
		Arbcolegio arbcolegio = new Arbcolegio();
		arbcolegio.setXjtrid(xjtrid);
		arbcolegio = this.arbcolegioService.find(arbcolegio);
		ArbcolegioController.logger
				.info("[GET - findBy_PK] : Obtener Arbcolegio por PK");
		return arbcolegio;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbcolegio
	 *            Arbcolegio
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Arbcolegio> getAll(@ModelAttribute Arbcolegio filterArbcolegio) {
		ArbcolegioController.logger
				.info("[GET - find_ALL] : Obtener Arbcolegio por filtro");
		return this.arbcolegioService.findAll(filterArbcolegio, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @return Arbcolegio
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Arbcolegio edit(@RequestBody Arbcolegio arbcolegio) {
		Arbcolegio arbcolegioAux = this.arbcolegioService.update(arbcolegio);
		ArbcolegioController.logger
				.info("[PUT] : Arbcolegio actualizado correctamente");
		return arbcolegioAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @return Arbcolegio
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Arbcolegio add(@RequestBody Arbcolegio arbcolegio) {
		Arbcolegio arbcolegioAux = this.arbcolegioService.add(arbcolegio);
		ArbcolegioController.logger
				.info("[POST] : Arbcolegio insertado correctamente");
		return arbcolegioAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param xjtrid
	 *            Long
	 * @return arbcolegio
	 */
	@RequestMapping(value = "/{xjtrid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Arbcolegio remove(@PathVariable String xjtrid) {
		Arbcolegio arbcolegio = new Arbcolegio();
		arbcolegio.setXjtrid(xjtrid);
		this.arbcolegioService.remove(arbcolegio);
		ArbcolegioController.logger
				.info("[DELETE] : Arbcolegio borrado correctamente");
		return arbcolegio;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbcolegioIds
	 *            List
	 * @return arbcolegioList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> arbcolegioIds) {
		List<Arbcolegio> arbcolegioList = new ArrayList<Arbcolegio>();
		for (List<String> arbcolegioId : arbcolegioIds) {
			Iterator<String> iterator = arbcolegioId.iterator();
			Arbcolegio arbcolegio = new Arbcolegio(); // NOPMD - Objeto nuevo en
														// la lista (parametro
														// del servicio)
			arbcolegio.setXjtrid(ObjectConversionManager.convert(
					iterator.next(), String.class));
			arbcolegioList.add(arbcolegio);
		}
		this.arbcolegioService.removeMultiple(arbcolegioList);
		ArbcolegioController.logger
				.info("[POST - DELETE_ALL] : Arbcolegio borrados correctamente");
		return arbcolegioIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbcolegio
	 *            Arbcolegio
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Arbcolegio filterArbcolegio,
			@ModelAttribute Pagination pagination) {
		List<Arbcolegio> arbcolegios = this.arbcolegioService.findAll(
				filterArbcolegio, pagination);
		Long recordNum = this.arbcolegioService.findAllCount(filterArbcolegio);
		ArbcolegioController.logger.info("[GET - jqGrid] : Obtener Arbcolegio");
		return new JQGridJSONModel(pagination, recordNum, arbcolegios);
	}

}
