package com.ejie.y41b.control;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Arbbandeja;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.service.ArbbandejaService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbbandejaController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/arbbandeja")
public class ArbbandejaController {

	private static final Logger logger = LoggerFactory.getLogger(ArbbandejaController.class);

	@Autowired()
	private ArbbandejaService arbbandejaService;

	@Autowired()
	private SolarbService solarbService;

	@Autowired()
	private CensoMonitorService censoMonitorService;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbbandejaController.logger.info("[GET - View] : arbbandeja");
		return "arbbandeja";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param baid
	 *            String
	 * @return arbbandeja Arbbandeja
	 */
	@RequestMapping(value = "/{abid}", method = RequestMethod.GET)
	public @ResponseBody() Arbbandeja getById(@PathVariable() String abid) {
		Arbbandeja arbbandeja = new Arbbandeja();
		arbbandeja.setAbid(abid);
		arbbandeja = this.arbbandejaService.find(arbbandeja);
		ArbbandejaController.logger.info("[GET - findBy_PK] : Obtener Arbbandeja por PK");
		return arbbandeja;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbbandeja
	 *            Arbbandeja
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody() List<Arbbandeja> getAll(@ModelAttribute() Arbbandeja filterArbbandeja) {
		ArbbandejaController.logger.info("[GET - find_ALL] : Obtener Arbbandeja por filtro");
		return this.arbbandejaService.findAll(filterArbbandeja, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Arbbandeja
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() Arbbandeja edit(@RequestBody() Arbbandeja arbbandeja) {
		Arbbandeja arbbandejaAux = this.arbbandejaService.update(arbbandeja);
		ArbbandejaController.logger.info("[PUT] : Arbbandeja actualizado correctamente");
		return arbbandejaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Arbbandeja
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() Arbbandeja add(@RequestBody() Arbbandeja arbbandeja) {
		Arbbandeja arbbandejaAux = this.arbbandejaService.add(arbbandeja);
		ArbbandejaController.logger.info("[POST] : Arbbandeja insertado correctamente");
		return arbbandejaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param baid
	 *            String
	 * @return arbbandeja
	 */
	@RequestMapping(value = "/{abid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() Arbbandeja remove(@PathVariable() String abid) {
		Arbbandeja arbbandeja = new Arbbandeja();
		arbbandeja.setAbid(abid);
		this.arbbandejaService.remove(arbbandeja);
		ArbbandejaController.logger.info("[DELETE] : Arbbandeja borrado correctamente");
		return arbbandeja;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbbandejaIds
	 *            List
	 * @return arbbandejaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() List<List<String>> removeMultiple(@RequestBody() List<List<String>> arbbandejaIds) {
		List<Arbbandeja> arbbandejaList = new ArrayList<Arbbandeja>();
		for (List<String> arbbandejaId : arbbandejaIds) {
			Iterator<String> iterator = arbbandejaId.iterator();
			Arbbandeja arbbandeja = new Arbbandeja(); // NOPMD - Objeto nuevo en
														// la lista (parametro
														// del servicio)
			arbbandeja.setAbid(ObjectConversionManager.convert(iterator.next(), String.class));
			arbbandejaList.add(arbbandeja);
		}
		this.arbbandejaService.removeMultiple(arbbandejaList);
		ArbbandejaController.logger.info("[POST - DELETE_ALL] : Arbbandeja borrados correctamente");
		return arbbandejaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            the request
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGrid(@ModelAttribute() Arbbandeja filterArbbandeja,
			@ModelAttribute() Pagination pagination,
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "mocodigo", required = false) String mocodigo_,
			@RequestParam(value = "checkNuevo", required = false) String checkNuevo_,
			@RequestParam(value = "checkLaudoPendienteFirma", required = false) String checkLaudoPendienteFirma_,
			HttpServletRequest request) {
		try {
			// EVOLUTIVO 0134898 2.11
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String mocodigo = ("".equals(mocodigo_)) ? null : mocodigo_;

			// EVOLUTIVO 0159047: Bandeja de arbitraje. Control de nuevos
			// expedientes
			String ultimoTramiteAsigRes = ("".equals(checkNuevo_)) ? null : checkNuevo_;

			String laudoPendienteFirma = ("".equals(checkLaudoPendienteFirma_)) ? null : checkLaudoPendienteFirma_;

			ArbbandejaController.logger.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: "
					+ trcodigo + " mocodigo: " + mocodigo);
			// EVOLUTIVO 0134898 2.11
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);

			filterArbbandeja.setMonitor(censoMonitor);
			// EVOLUTIVO 0134898 2.11
			filterArbbandeja.setTrcodigo(trcodigo);
			filterArbbandeja.setMocodigo(mocodigo);
			filterArbbandeja.setTrFechaDesde(trFechaDesde);
			filterArbbandeja.setTrFechaHasta(trFechaHasta);
			// EVOLUTIVO 0134898 2.11

			// EVOLUTIVO 0159047: Bandeja de arbitraje. Control de nuevos
			// expedientes
			filterArbbandeja.setUltimoTramiteAsigRes(ultimoTramiteAsigRes);

			filterArbbandeja.setLaudoPendienteFirma(Y41bUtils.isFilled(laudoPendienteFirma));

			String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();

			List<Arbbandeja> arbbandejas = this.arbbandejaService.dameBandeja(filterArbbandeja, pagination,
					censoMonitor, perfil);

			request.getSession().setAttribute("paginationArbbandeja", pagination);

			httpSession.setAttribute("arbbandejaBusqueda", filterArbbandeja);

			Long recordNum = this.arbbandejaService.dameBandejaCount(filterArbbandeja, censoMonitor, perfil);

			ArbbandejaController.logger.info("[GET - jqGrid] : Obtener Arbbandeja");

			return new JQGridJSONModel(pagination, recordNum, arbbandejas);
		} catch (Exception e) {
			e.printStackTrace();
			ArbbandejaController.logger.error("Error producido en getAllJQGrid: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbbandeja
	 *            Arbbandeja
	 * @param request
	 *            the request
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/arbbandejaSession", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGridSession(@ModelAttribute() Arbbandeja filterArbbandeja,
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "mocodigo", required = false) String mocodigo_,
			@RequestParam(value = "checkNuevo", required = false) String checkNuevo_,
			@RequestParam(value = "checkLaudoPendienteFirma", required = false) String checkLaudoPendienteFirma_,
			HttpServletRequest request) {
		try {
			// EVOLUTIVO 0134898 2.11
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String mocodigo = ("".equals(mocodigo_)) ? null : mocodigo_;

			// EVOLUTIVO 0159047: Bandeja de arbitraje. Control de nuevos
			// expedientes
			String ultimoTramiteAsigRes = ("".equals(checkNuevo_)) ? null : checkNuevo_;

			String laudoPendienteFirma = ("".equals(checkLaudoPendienteFirma_)) ? null : checkLaudoPendienteFirma_;

			ArbbandejaController.logger.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: "
					+ trcodigo + " mocodigo: " + mocodigo);
			// EVOLUTIVO 0134898 2.11
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			// String oficina = "";
			// oficina = censoMonitor.getOrganismo().getCodOrg();
			// filterArbbandeja.setExpedien(new Expedien());
			// filterArbbandeja.getExpedien().setExcoor(oficina);
			filterArbbandeja.setMonitor(censoMonitor);
			// EVOLUTIVO 0134898 2.11
			filterArbbandeja.setTrcodigo(trcodigo);
			filterArbbandeja.setMocodigo(mocodigo);
			filterArbbandeja.setTrFechaDesde(trFechaDesde);
			filterArbbandeja.setTrFechaHasta(trFechaHasta);
			// EVOLUTIVO 0134898 2.11

			// EVOLUTIVO 0159047: Bandeja de arbitraje. Control de nuevos
			// expedientes
			filterArbbandeja.setUltimoTramiteAsigRes(ultimoTramiteAsigRes);

			filterArbbandeja.setLaudoPendienteFirma(Y41bUtils.isFilled(laudoPendienteFirma));

			String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = (Pagination) request.getSession().getAttribute("paginationArbbandeja");

				// Si al refrescar la tabla existen menos elementos y la pgina
				// guardada en sesin no existe, se debe seleccionar la ltima
				// pgina con datos
				Long totalReg = new Long(0);
				totalReg = this.arbbandejaService.dameBandejaCount(filterArbbandeja, censoMonitor, perfil);
				Long pagSession = new Long(0);
				Long page = new Long(0);
				pagSession = pagination.getPage() * pagination.getRows();
				pagSession = pagSession - pagination.getRows();

				if (pagSession >= totalReg) {
					page = totalReg / pagination.getRows();
					pagination.setPage(page);
				}
			}

			List<Arbbandeja> arbbandejas = this.arbbandejaService.dameBandeja(filterArbbandeja, pagination,
					censoMonitor, perfil);

			httpSession.setAttribute("arbbandejaBusqueda", filterArbbandeja);

			Long recordNum = this.arbbandejaService.dameBandejaCount(filterArbbandeja, censoMonitor, perfil);

			ArbbandejaController.logger.info("[GET - jqGrid] : Obtener Arbbandeja");

			return new JQGridJSONModel(pagination, recordNum, arbbandejas);
		} catch (Exception e) {
			e.printStackTrace();
			ArbbandejaController.logger.error("Error producido en getAllJQGrid: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/numeroEntradasBandeja", method = RequestMethod.GET)
	public @ResponseBody() Long getAllCount(@ModelAttribute() Arbbandeja filterArbbandeja,
			@ModelAttribute() Pagination pagination,
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "mocodigo", required = false) String mocodigo_,
			@RequestParam(value = "checkNuevo", required = false) String checkNuevo_,
			@RequestParam(value = "checkLaudoPendienteFirma", required = false) String checkLaudoPendienteFirma_,
			HttpServletRequest request) {
		try {
			ArbbandejaController.logger
					.info("**** ELIMINAMOS LAS ENTRADAS DE AVISOS CADUCADAS DE TIPO PLAZO DE ALEGACIONES");
			this.arbbandejaService.deleteBandejaAvisosCaducados();
			// EVOLUTIVO 0134898 2.11
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String mocodigo = ("".equals(mocodigo_)) ? null : mocodigo_;

			// EVOLUTIVO 0159047: Bandeja de arbitraje. Control de nuevos
			// expedientes
			String ultimoTramiteAsigRes = ("".equals(checkNuevo_)) ? null : checkNuevo_;

			String laudoPendienteFirma = ("".equals(checkLaudoPendienteFirma_)) ? null : checkLaudoPendienteFirma_;

			ArbbandejaController.logger.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: "
					+ trcodigo + " mocodigo: " + mocodigo);
			// EVOLUTIVO 0134898 2.11
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			// String oficina = "";
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			ArbbandejaController.logger.info("**** MONITOR CONECTADO **" + censoMonitor.getMocodigo() + ".");
			// EVOLUTIVO 0134898 2.11
			filterArbbandeja.setTrcodigo(trcodigo);
			filterArbbandeja.setMocodigo(mocodigo);
			filterArbbandeja.setTrFechaDesde(trFechaDesde);
			filterArbbandeja.setTrFechaHasta(trFechaHasta);
			// EVOLUTIVO 0134898 2.11

			// EVOLUTIVO 0159047: Bandeja de arbitraje. Control de nuevos
			// expedientes
			filterArbbandeja.setUltimoTramiteAsigRes(ultimoTramiteAsigRes);

			filterArbbandeja.setLaudoPendienteFirma(Y41bUtils.isFilled(laudoPendienteFirma));

			censoMonitor = this.censoMonitorService.find(censoMonitor);

			filterArbbandeja.setMonitor(censoMonitor);
			String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();

			Long recordNum = this.arbbandejaService.dameBandejaCount(filterArbbandeja, censoMonitor, perfil);

			ArbbandejaController.logger.info("[GET - jqGrid] : Obtener Arbbandeja");
			return recordNum;
		} catch (Exception e) {
			e.printStackTrace();
			ArbbandejaController.logger.error("Error producido en getAllJQGridCount: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/busqueda", method = RequestMethod.GET)
	public @ResponseBody() Object getAllSanciones(HttpServletRequest request) {
		try {

			Pagination pagination = null;

			pagination = new Pagination();
			pagination.setSort("ABFEC");
			pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);

			List<Arbbandeja> consultasBusqueda = this.arbbandejaService.findAll(null, pagination);
			if (consultasBusqueda == null) {
				throw new Exception("No data Found.");
			}
			return consultasBusqueda;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllConsultaExcel(HttpServletRequest request, HttpServletResponse response) {
		try {

			HttpSession httpSession = request.getSession();
			Arbbandeja filterArbbandeja = (Arbbandeja) httpSession.getAttribute("arbbandejaBusqueda");

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_BANDARBITRAJES + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();

			String xslString = this.y41bExcelGeneratorService.getArbbandejaExcel(filterArbbandeja, censoMonitor,
					perfil);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'getAllTramitesPendientes'.
	 * 
	 * @param excodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/findAllTramitesPendientes/{sacodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllTramitesPendientes(@PathVariable() String sacodigo,
			HttpServletRequest request) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);

			sacodigo = new String(Y41bUtilsDokusi.decode(sacodigo));

			Arbbandeja filterArbbandeja = new Arbbandeja();
			filterArbbandeja.setSolarb(new Solarb(sacodigo));
			filterArbbandeja.setMonitor(censoMonitor);

			String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Arbbandeja> arbbandejas = this.arbbandejaService.dameBandejaTP(filterArbbandeja, pagination,
						censoMonitor, perfil);

				Long recordNum = this.arbbandejaService.dameBandejaTPCount(filterArbbandeja, censoMonitor, perfil);

				ArbbandejaController.logger.info("[GET - jqGrid] : Obtener Arbbandeja");

				return new JQGridJSONModel(pagination, recordNum, arbbandejas);
			} else {
				List<Arbbandeja> arbbandejas = this.arbbandejaService.dameBandejaTP(filterArbbandeja, null,
						censoMonitor, perfil);

				if (arbbandejas == null) {
					throw new Exception("No data Found.");
				}
				return arbbandejas;
			}
		} catch (Exception e) {
			e.printStackTrace();
			ArbbandejaController.logger.error("Error producido en getAllJQGrid: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllTramitesPendientes'.
	 * 
	 * @param excodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllAvisos/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllAvisos(@PathVariable() String excodigo, HttpServletRequest request) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);

			excodigo = new String(Y41bUtilsDokusi.decode(excodigo));

			Arbbandeja filterArbbandeja = new Arbbandeja();
			filterArbbandeja.setSolarb(new Solarb(excodigo));
			filterArbbandeja.setMonitor(censoMonitor);

			String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Arbbandeja> arbbandejas = this.arbbandejaService.dameBandejaAvisos(filterArbbandeja, pagination,
						censoMonitor, perfil);

				Long recordNum = this.arbbandejaService.dameBandejaAvisosCount(filterArbbandeja, censoMonitor, perfil);

				ArbbandejaController.logger.info("[GET - jqGrid] : Obtener Arbbandeja");

				return new JQGridJSONModel(pagination, recordNum, arbbandejas);
			} else {
				List<Arbbandeja> arbbandejas = this.arbbandejaService.dameBandejaAvisos(filterArbbandeja, null,
						censoMonitor, perfil);

				if (arbbandejas == null) {
					throw new Exception("No data Found.");
				}
				return arbbandejas;
			}
		} catch (Exception e) {
			e.printStackTrace();
			ArbbandejaController.logger.error("Error producido en getAllJQGrid: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getCreateFormTP'.
	 * 
	 * @param excodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 * @throws Exception
	 */
	@RequestMapping(value = "/tramitesPendientes/{sacodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormTP(@PathVariable() String sacodigo, Model model, HttpServletRequest request)
			throws Exception {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		sacodigo = new String(Y41bUtilsDokusi.decode(sacodigo));

		Solarb solarb = new Solarb();
		solarb.setSacodigo(sacodigo);

		solarb = this.solarbService.find(solarb);

		String numArbitraje = solarb.getCodCompletoConPrefijo();

		model.addAttribute("idArbitraje", sacodigo);
		model.addAttribute("numArbitraje", numArbitraje);
		return new ModelAndView("tramitesPendientesArbitrajes", "model", model);
	}

	/**
	 * Method 'getCreateFormTP'.
	 * 
	 * @param excodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 * @throws Exception
	 */
	@RequestMapping(value = "/avisos/{excodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAvisos(@PathVariable() String excodigo, Model model, HttpServletRequest request)
			throws Exception {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		excodigo = new String(Y41bUtilsDokusi.decode(excodigo));

		Solarb solarb = new Solarb();
		solarb.setSacodigo(excodigo);
		solarb = this.solarbService.find(solarb);

		model.addAttribute("idArbitraje", excodigo);
		model.addAttribute("numArbitraje", solarb.getCodCompletoConPrefijo());
		return new ModelAndView("avisosArbitrajes", "model", model);
	}
}
