package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ArbainstanciaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Arbainstancia;

/**
 * ArbainstanciaController  
 *  
 */
 
@Controller
@RequestMapping (value = "/arbainstancia")

public class ArbainstanciaController  {

	private static final Logger logger = LoggerFactory.getLogger(ArbainstanciaController.class);

	@Autowired
	private ArbainstanciaService arbainstanciaService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbainstanciaController.logger.info("[GET - View] : arbainstancia");
		return "arbainstancia";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param aicodigo String
	 * @return arbainstancia Arbainstancia
	 */
	@RequestMapping(value = "/{aicodigo}", method = RequestMethod.GET)
	public @ResponseBody Arbainstancia getById(@PathVariable String aicodigo) {
        Arbainstancia arbainstancia = new Arbainstancia();
		arbainstancia.setAicodigo(aicodigo);
        arbainstancia = this.arbainstanciaService.find(arbainstancia);
        ArbainstanciaController.logger.info("[GET - findBy_PK] : Obtener Arbainstancia por PK");
        return arbainstancia;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterArbainstancia Arbainstancia
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Arbainstancia> getAll(@ModelAttribute Arbainstancia filterArbainstancia) {
		ArbainstanciaController.logger.info("[GET - find_ALL] : Obtener Arbainstancia por filtro");
	    return this.arbainstanciaService.findAll(filterArbainstancia, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param arbainstancia Arbainstancia 
	 * @return Arbainstancia
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Arbainstancia edit(@RequestBody Arbainstancia arbainstancia) {		
        Arbainstancia arbainstanciaAux = this.arbainstanciaService.update(arbainstancia);
		ArbainstanciaController.logger.info("[PUT] : Arbainstancia actualizado correctamente");
        return arbainstanciaAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param arbainstancia Arbainstancia 
	 * @return Arbainstancia
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Arbainstancia add(@RequestBody Arbainstancia arbainstancia) {		
        Arbainstancia arbainstanciaAux = this.arbainstanciaService.add(arbainstancia);
        ArbainstanciaController.logger.info("[POST] : Arbainstancia insertado correctamente");
    	return arbainstanciaAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param aicodigo String
	 * @return arbainstancia
	 */
	@RequestMapping(value = "/{aicodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Arbainstancia remove(@PathVariable String aicodigo) {
        Arbainstancia arbainstancia = new Arbainstancia();
        arbainstancia.setAicodigo(aicodigo);
        this.arbainstanciaService.remove(arbainstancia);
       	ArbainstanciaController.logger.info("[DELETE] : Arbainstancia borrado correctamente");
       	return arbainstancia;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param arbainstanciaIds List
	 * @return arbainstanciaList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> arbainstanciaIds) {
        List<Arbainstancia> arbainstanciaList = new ArrayList<Arbainstancia>();
        for (List<String> arbainstanciaId:arbainstanciaIds) {
		    Iterator<String> iterator = arbainstanciaId.iterator();
		    Arbainstancia arbainstancia = new Arbainstancia(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        arbainstancia.setAicodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    arbainstanciaList.add(arbainstancia);
	    }
        this.arbainstanciaService.removeMultiple(arbainstanciaList);
		ArbainstanciaController.logger.info("[POST - DELETE_ALL] : Arbainstancia borrados correctamente");
		return arbainstanciaIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterArbainstancia Arbainstancia
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Arbainstancia filterArbainstancia, @ModelAttribute Pagination pagination) {
        List<Arbainstancia> arbainstancias = this.arbainstanciaService.findAll(filterArbainstancia, pagination);
        Long recordNum = this.arbainstanciaService.findAllCount(filterArbainstancia);
        ArbainstanciaController.logger.info("[GET - jqGrid] : Obtener Arbainstancia");
		return new JQGridJSONModel(pagination, recordNum, arbainstancias);
	}
	
}	
