package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ArbadhtramService;

//import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.model.Arbadhtram;

/**
 * ArbadhtramController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/arbadhtram")
public class ArbadhtramController {

	private static final Logger logger = LoggerFactory
			.getLogger(ArbadhtramController.class);

	@Autowired
	private ArbadhtramService arbadhtramService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbadhtramController.logger.info("[GET - View] : arbadhtram");
		return "arbadhtram";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param trid
	 *            Long
	 * @return arbadhtram Arbadhtram
	 */
	@RequestMapping(value = "/{trid}", method = RequestMethod.GET)
	public @ResponseBody
	Arbadhtram getById(@PathVariable String trid) {
		Arbadhtram arbadhtram = new Arbadhtram();
		arbadhtram.setTrid(trid);
		arbadhtram = this.arbadhtramService.find(arbadhtram);
		ArbadhtramController.logger
				.info("[GET - findBy_PK] : Obtener Arbadhtram por PK");
		return arbadhtram;
	}

	/**
	 * Method 'getByExcodigo'.
	 * 
	 * @param trexcodigo
	 *            Long
	 * @param codocumento
	 *            String
	 * @return Long
	 */
	@RequestMapping(value = "/findByExpediente/{trexcodigo}/{codocumento}", method = RequestMethod.GET)
	public @ResponseBody
	Long getByIdExpediente(@PathVariable String trexcodigo,
			@PathVariable String codocumento) {
		Arbadhtram arbadhtramaux = new Arbadhtram();
		arbadhtramaux.setTrexcodigo(trexcodigo);
		Long l = (Long) this.arbadhtramService.findByExpediente(arbadhtramaux,
				codocumento);
		ArbadhtramController.logger
				.info("[GET - findBy_PK] : Obtener Long por PK");
		return l;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbadhtram
	 *            Arbadhtram
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Arbadhtram> getAll(@ModelAttribute Arbadhtram filterArbadhtram) {
		ArbadhtramController.logger
				.info("[GET - find_ALL] : Obtener Arbadhtram por filtro");
		return this.arbadhtramService.findAll(filterArbadhtram, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Arbadhtram edit(@RequestBody Arbadhtram arbadhtram) {
		Arbadhtram arbadhtramAux = this.arbadhtramService.update(arbadhtram);
		ArbadhtramController.logger
				.info("[PUT] : Arbadhtram actualizado correctamente");
		return arbadhtramAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Arbadhtram add(@RequestBody Arbadhtram arbadhtram) {
		Arbadhtram arbadhtramAux = this.arbadhtramService.add(arbadhtram);
		ArbadhtramController.logger
				.info("[POST] : Arbadhtram insertado correctamente");
		return arbadhtramAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param trid
	 *            Long
	 * @return arbadhtram
	 */
	@RequestMapping(value = "/{trid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Arbadhtram remove(@PathVariable String trid) {
		Arbadhtram arbadhtram = new Arbadhtram();
		arbadhtram.setTrid(trid);
		this.arbadhtramService.remove(arbadhtram);
		ArbadhtramController.logger
				.info("[DELETE] : Arbadhtram borrado correctamente");
		return arbadhtram;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbadhtramIds
	 *            List
	 * @return arbadhtramList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> arbadhtramIds) {
		List<Arbadhtram> arbadhtramList = new ArrayList<Arbadhtram>();
		for (List<String> arbadhtramId : arbadhtramIds) {
			Iterator<String> iterator = arbadhtramId.iterator();
			Arbadhtram arbadhtram = new Arbadhtram(); // NOPMD - Objeto nuevo en
														// la lista (parametro
														// del servicio)
			arbadhtram.setTrid(ObjectConversionManager.convert(iterator.next(),
					String.class));
			arbadhtramList.add(arbadhtram);
		}
		this.arbadhtramService.removeMultiple(arbadhtramList);
		ArbadhtramController.logger
				.info("[POST - DELETE_ALL] : Arbadhtram borrados correctamente");
		return arbadhtramIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbadhtram
	 *            Arbadhtram
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Arbadhtram filterArbadhtram,
			@ModelAttribute Pagination pagination) {
		List<Arbadhtram> arbadhtrams = this.arbadhtramService.findAll(
				filterArbadhtram, pagination);
		Long recordNum = this.arbadhtramService.findAllCount(filterArbadhtram);
		ArbadhtramController.logger.info("[GET - jqGrid] : Obtener Arbadhtram");
		return new JQGridJSONModel(pagination, recordNum, arbadhtrams);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param sacodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/dameTramitesExp", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@RequestParam(value = "adhid", required = false) String adhid,
			@ModelAttribute() Pagination pagination) {

		Arbadhtram filterArbadhtram = new Arbadhtram();
		filterArbadhtram.setTrexcodigo(adhid);

		List<Arbadhtram> tramites = this.arbadhtramService.findAll(
				filterArbadhtram, pagination);
		Long recordNum = this.arbadhtramService.findAllCount(filterArbadhtram);
		ArbadhtramController.logger.info("[GET - jqGrid] : Obtener Arbadhtram");
		return new JQGridJSONModel(pagination, recordNum, tramites);
	}

}
