package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ArbadhsolcomdocService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Arbadhsolcomdoc;

/**
 * ArbadhsolcomdocController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/arbadhsolcomdoc")
public class ArbadhsolcomdocController {

	private static final Logger logger = LoggerFactory
			.getLogger(ArbadhsolcomdocController.class);

	@Autowired
	private ArbadhsolcomdocService arbadhsolcomdocService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbadhsolcomdocController.logger.info("[GET - View] : arbadhsolcomdoc");
		return "arbadhsolcomdoc";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param xmcodocumento
	 *            Long
	 * @return arbadhsolcomdoc Arbadhsolcomdoc
	 * @throws Exception
	 */
	@RequestMapping(value = "/{xmcodocumento}", method = RequestMethod.GET)
	public @ResponseBody
	Arbadhsolcomdoc getById(@PathVariable String xmcodocumento)
			throws Exception {
		Arbadhsolcomdoc arbadhsolcomdoc = new Arbadhsolcomdoc();
		arbadhsolcomdoc.setXmcodocumento(xmcodocumento);
		arbadhsolcomdoc = this.arbadhsolcomdocService.find(arbadhsolcomdoc);
		ArbadhsolcomdocController.logger
				.info("[GET - findBy_PK] : Obtener Arbadhsolcomdoc por PK");
		return arbadhsolcomdoc;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Arbadhsolcomdoc> getAll(
			@ModelAttribute Arbadhsolcomdoc filterArbadhsolcomdoc) {
		ArbadhsolcomdocController.logger
				.info("[GET - find_ALL] : Obtener Arbadhsolcomdoc por filtro");
		return this.arbadhsolcomdocService.findAll(filterArbadhsolcomdoc, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Arbadhsolcomdoc edit(@RequestBody Arbadhsolcomdoc arbadhsolcomdoc) {
		Arbadhsolcomdoc arbadhsolcomdocAux = this.arbadhsolcomdocService
				.update(arbadhsolcomdoc);
		ArbadhsolcomdocController.logger
				.info("[PUT] : Arbadhsolcomdoc actualizado correctamente");
		return arbadhsolcomdocAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Arbadhsolcomdoc add(@RequestBody Arbadhsolcomdoc arbadhsolcomdoc) {
		Arbadhsolcomdoc arbadhsolcomdocAux = this.arbadhsolcomdocService
				.add(arbadhsolcomdoc);
		ArbadhsolcomdocController.logger
				.info("[POST] : Arbadhsolcomdoc insertado correctamente");
		return arbadhsolcomdocAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param xmcodocumento
	 *            Long
	 * @return arbadhsolcomdoc
	 */
	@RequestMapping(value = "/{xmcodocumento}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Arbadhsolcomdoc remove(@PathVariable String xmcodocumento) {
		Arbadhsolcomdoc arbadhsolcomdoc = new Arbadhsolcomdoc();
		arbadhsolcomdoc.setXmcodocumento(xmcodocumento);
		this.arbadhsolcomdocService.remove(arbadhsolcomdoc);
		ArbadhsolcomdocController.logger
				.info("[DELETE] : Arbadhsolcomdoc borrado correctamente");
		return arbadhsolcomdoc;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbadhsolcomdocIds
	 *            List
	 * @return arbadhsolcomdocList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> arbadhsolcomdocIds) {
		List<Arbadhsolcomdoc> arbadhsolcomdocList = new ArrayList<Arbadhsolcomdoc>();
		for (List<String> arbadhsolcomdocId : arbadhsolcomdocIds) {
			Iterator<String> iterator = arbadhsolcomdocId.iterator();
			Arbadhsolcomdoc arbadhsolcomdoc = new Arbadhsolcomdoc(); // NOPMD -
																		// Objeto
																		// nuevo
																		// en la
																		// lista
																		// (parametro
																		// del
																		// servicio)
			arbadhsolcomdoc.setXmcodocumento(ObjectConversionManager.convert(
					iterator.next(), String.class));
			arbadhsolcomdocList.add(arbadhsolcomdoc);
		}
		this.arbadhsolcomdocService.removeMultiple(arbadhsolcomdocList);
		ArbadhsolcomdocController.logger
				.info("[POST - DELETE_ALL] : Arbadhsolcomdoc borrados correctamente");
		return arbadhsolcomdocIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute Arbadhsolcomdoc filterArbadhsolcomdoc,
			@ModelAttribute Pagination pagination) {
		List<Arbadhsolcomdoc> arbadhsolcomdocs = this.arbadhsolcomdocService
				.findAll(filterArbadhsolcomdoc, pagination);
		Long recordNum = this.arbadhsolcomdocService
				.findAllCount(filterArbadhsolcomdoc);
		ArbadhsolcomdocController.logger
				.info("[GET - jqGrid] : Obtener Arbadhsolcomdoc");
		return new JQGridJSONModel(pagination, recordNum, arbadhsolcomdocs);
	}

}
