package com.ejie.y41b.control;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.net.io.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbadhsolcomdocDao;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhinterv;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DatosMailOrigen;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteBusqueda;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ArbadhintervService;
import com.ejie.y41b.service.ArbadhsolService;
import com.ejie.y41b.service.ArbexpService;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.service.EstablecimientoService;
import com.ejie.y41b.service.PlantillaTramiteService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.model.AdhesionTele;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfReader;

/**
 * ArbadhsolController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/arbadhsol")
public class ArbadhsolController {

	private static final Logger logger = LoggerFactory.getLogger(ArbadhsolController.class);

	@Autowired
	private ArbadhsolService arbadhsolService;

	@Autowired()
	private CensoMonitorService censoMonitorService;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired
	private Properties appConfiguration;
	@Autowired
	private ArbexpService arbexpService;
	@Autowired
	private AdjuntardocsService adjuntardocsService;
	@Autowired
	private PlantillaTramiteService plantillaTramiteService;
	@Autowired()
	private Y41bUDAErrorManager errorManager;
	@Autowired()
	private ArbadhsolcomdocDao arbadhsolcomdocDao;
	@Autowired()
	private ArbadhintervService arbadhintervService;

	@Autowired()
	private EstablecimientoService establecimientoService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbadhsolController.logger.info("[GET - View] : arbadhsol");
		return "arbadhsol";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param adhid
	 *            BigDecimal
	 * @return arbadhsol Arbadhsol
	 */
	@RequestMapping(value = "/datosSolicitud/{adhid}", method = RequestMethod.GET)
	public @ResponseBody Arbadhsol getById(@PathVariable String adhid) {
		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(adhid);
		arbadhsol = this.arbadhsolService.find(arbadhsol);

		// 0158849: Validar datos de establecimiento en Solicitudes de adhesin
		// Si existe ya el establecimiento activamos un flag para que salga que
		// ya esta adherido y que no se peuda guardar

		Arbadhsol arbadhsoltemp = new Arbadhsol();
		arbadhsoltemp.setAdhid(adhid);
		arbadhsoltemp = this.arbadhsolService.findDatosValidacion(arbadhsoltemp);

		if (null != arbadhsoltemp && null != arbadhsoltemp.getAdhescodigo()) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(arbadhsoltemp.getAdhescodigo());
			// establecimiento.setAhfeba(ahfeba) no nula
			// establecimiento.set
			List<Establecimiento> listaEstablecimientos = this.establecimientoService
					.findAllLikeEstablecimiento(establecimiento, null, null, false);
			if (!listaEstablecimientos.isEmpty()) {
				establecimiento = listaEstablecimientos.get(0);
				if ("A".equals(establecimiento.getEsinadar()) || "L".equals(establecimiento.getEsinadar())) {
					arbadhsol.setEstablecimientoAdherido("S");
				}
			}
		}

		// 0116048 3.7
		// si es una baja ponemos el flag de validacionOK a S y generamos un
		// arbadhsoltemp para que no tenga
		// que hacer la validacion al guardar
		if (null != arbadhsol && null != arbadhsol.getAdhescodigo()
				&& (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
						|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo()))) {
			if (null == arbadhsoltemp) {
				Arbadhsol arbadhsoltemp2 = this.arbadhsolService.guardarDatosValidacion(arbadhsol);
			}

			arbadhsol.setValidacionOK("S");
		}
		// 0116048 3.7

		// 0158849: Validar datos de establecimiento en Solicitudes de adhesin
		ArbadhsolController.logger.info("[GET - findBy_PK] : Obtener Arbadhsol por PK");
		return arbadhsol;
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param adhid
	 *            BigDecimal
	 * @return arbadhsol Arbadhsol
	 * @throws ParseException
	 */
	@RequestMapping(value = "/bajaOficio", method = RequestMethod.GET)
	public @ResponseBody Arbadhsol generarBajaOficio() throws ParseException {
		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhestado(Y41bConstantes.ID_ESTADO_SOL_ADH_PENDIENTE);
		arbadhsol.setAdhtipo(Y41bConstantes.ADH_TIPO_BAJA_OFICIO);
		BigDecimal anyo = new BigDecimal(Y41bUtils.formatearDateToString(Y41bUtils.hoy(), "yyyy"));
		arbadhsol.setAdhsolnran(anyo);
		arbadhsol.setAdhsolcoor(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
		arbadhsol = this.arbadhsolService.add(arbadhsol);

		StringBuffer numeroExpediente = new StringBuffer("");
		numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_BAJA);
		numeroExpediente.append("-").append(arbadhsol.getAdhsolcoor()).append("-").append(arbadhsol.getAdhsolnror())
				.append("-").append(arbadhsol.getAdhsolnran());
		arbadhsol.setNumExpediente(numeroExpediente.toString());
		return arbadhsol;
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param adhid
	 *            BigDecimal
	 * @return arbadhsol Arbadhsol
	 */
	@RequestMapping(value = "/datosComunicacion/{adhid}", method = RequestMethod.GET)
	public @ResponseBody Arbadhsol getDatosComunicacionById(@PathVariable String adhid) {
		Arbadhsol arbadhsol = new Arbadhsol();
		if (!adhid.equals("-1")) {
			arbadhsol.setAdhid(adhid);
			arbadhsol = this.arbadhsolService.findDatosComunicacion(arbadhsol);
		}
		ArbadhsolController.logger.info("[GET - findBy_PK] : Obtener Arbadhsol por PK");
		return arbadhsol;
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param adhid
	 *            BigDecimal
	 * @return arbadhsol Arbadhsol
	 */
	@RequestMapping(value = "/datosEstablecimientoValidado/{adhid}", method = RequestMethod.GET)
	public @ResponseBody Arbadhsol getDatosEstablecimientoValidadoById(@PathVariable String adhid) {
		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(adhid);
		arbadhsol = this.arbadhsolService.findDatosValidacion(arbadhsol);

		// 0116048 3.6
		Arbadhsol arbadhsolaux = new Arbadhsol();
		arbadhsolaux.setAdhid(adhid);
		arbadhsolaux = this.arbadhsolService.find(arbadhsolaux);
		arbadhsol.setAdhnrdi(arbadhsolaux.getAdhnrdi());
		// 0116048 3.6

		ArbadhsolController.logger.info("[GET - findBy_PK] : Obtener Arbadhsol por PK");
		return arbadhsol;
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idInterv
	 *            BigDecimal
	 * @return arbadhsol Arbadhsol
	 */
	@RequestMapping(value = "/detalleEstablecimiento/{adhid}/{idInterv}", method = RequestMethod.GET)
	public @ResponseBody EstablecimientoDetalle detalleEstablecimiento(@PathVariable String adhid,
			@PathVariable BigDecimal idInterv, Model model) {
		try {
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(adhid);
			arbadhsol = this.arbadhsolService.find(arbadhsol);

			Arbadhinterv arbadhinterv = new Arbadhinterv();
			arbadhinterv.setUaidinterv(idInterv);
			EstablecimientoDetalle establecimientoDetalle = null;
			if (idInterv.longValue() == -1L) {
				establecimientoDetalle = this.arbadhsolService.findDetalleEstablecimiento(arbadhsol);
			} else {
				establecimientoDetalle = this.arbadhintervService.findEstablecimiento(arbadhinterv);
			}
			if (establecimientoDetalle == null) {
				throw new Exception(idInterv.toString());
			}
			return establecimientoDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idInterv.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbadhsol
	 *            Arbadhsol
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Arbadhsol> getAll(@ModelAttribute Arbadhsol filterArbadhsol) {
		ArbadhsolController.logger.info("[GET - find_ALL] : Obtener Arbadhsol por filtro");
		return this.arbadhsolService.findAll(filterArbadhsol, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 * @throws Exception
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Arbadhsol edit(@RequestBody Arbadhsol arbadhsol) throws Exception {
		Arbadhsol arbadhsolAux = this.arbadhsolService.update(arbadhsol);
		ArbadhsolController.logger.info("[PUT] : Arbadhsol actualizado correctamente");
		return arbadhsolAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Arbadhsol add(@RequestBody Arbadhsol arbadhsol) {
		Arbadhsol arbadhsolAux = this.arbadhsolService.add(arbadhsol);
		ArbadhsolController.logger.info("[POST] : Arbadhsol insertado correctamente");
		return arbadhsolAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	@RequestMapping(value = "/guardarDatosValidacion", method = RequestMethod.POST)
	public @ResponseBody Arbadhsol guardarDatosValidacion(@RequestBody Arbadhsol arbadhsol) {
		Arbadhsol arbadhsolAux = this.arbadhsolService.guardarDatosValidacion(arbadhsol);

		// 0158849: Validar datos de establecimiento en Solicitudes de adhesin
		// Si existe ya el establecimiento activamos un flag para que salga que
		// ya esta adherido y que no se peuda guardar
		Establecimiento establecimiento = new Establecimiento();
		establecimiento.setEscodigo(arbadhsolAux.getAdhescodigo());
		// establecimiento.setAhfeba(ahfeba) no nula
		// establecimiento.set
		List<Establecimiento> listaEstablecimientos = this.establecimientoService
				.findAllLikeEstablecimiento(establecimiento, null, null, false);
		if (!listaEstablecimientos.isEmpty()) {
			establecimiento = listaEstablecimientos.get(0);
			if ("A".equals(establecimiento.getEsinadar()) || "L".equals(establecimiento.getEsinadar())) {
				arbadhsolAux.setEstablecimientoAdherido("S");
			}

		}
		// 0158849: Validar datos de establecimiento en Solicitudes de adhesin

		ArbadhsolController.logger.info("[POST] : Arbadhsol insertado correctamente");
		return arbadhsolAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 * @throws Exception
	 */
	@RequestMapping(value = "/guardarDatosComunicacion", method = RequestMethod.POST)
	public @ResponseBody Arbadhsol guardarDatosComunicacion(@RequestBody Arbadhsol arbadhsol) throws Exception {
		Arbadhsol arbadhsolAux = this.arbadhsolService.guardarDatosComunicacion(arbadhsol);
		ArbadhsolController.logger.info("[POST] : Arbadhsol insertado correctamente");
		return arbadhsolAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param adhid
	 *            BigDecimal
	 * @return arbadhsol
	 */
	@RequestMapping(value = "/{adhid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Arbadhsol remove(@PathVariable String adhid) {
		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(adhid);
		this.arbadhsolService.remove(arbadhsol);
		ArbadhsolController.logger.info("[DELETE] : Arbadhsol borrado correctamente");
		return arbadhsol;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbadhsolIds
	 *            List
	 * @return arbadhsolList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> arbadhsolIds) {
		List<Arbadhsol> arbadhsolList = new ArrayList<Arbadhsol>();
		for (List<String> arbadhsolId : arbadhsolIds) {
			Iterator<String> iterator = arbadhsolId.iterator();
			Arbadhsol arbadhsol = new Arbadhsol(); // NOPMD - Objeto nuevo en la
													// lista (parametro del
													// servicio)
			arbadhsol.setAdhid(ObjectConversionManager.convert(iterator.next(), String.class));
			arbadhsolList.add(arbadhsol);
		}
		this.arbadhsolService.removeMultiple(arbadhsolList);
		ArbadhsolController.logger.info("[POST - DELETE_ALL] : Arbadhsol borrados correctamente");
		return arbadhsolIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbadhsol
	 *            Arbadhsol
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            {@link HttpServletRequest}
	 * @return JQGridJSONModel
	 * @throws Exception
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody JQGridJSONModel getAllJQGrid(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoco", required = false) String esnoco_,
			@RequestParam(value = "checkPendientes", required = false) String checkPendientes_,
			@RequestParam(value = "checkAceptadas", required = false) String checkAceptadas_,
			@RequestParam(value = "checkRechazadas", required = false) String checkRechazadas_,
			@ModelAttribute Arbadhsol filterArbadhsol, @ModelAttribute Pagination pagination,
			HttpServletRequest request) throws Exception {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = this.censoMonitorService.find(censoMonitor);

		// parseo de fechas
		Locale locale = LocaleContextHolder.getLocale();
		if (!Y41bUtils.esNullOCadenaVacia(trFechaDesde_)) {
			filterArbadhsol.setAdhfechaDesde(Y41bUtils.parseDateTime(trFechaDesde_.concat(" 00:00:00"), locale));
		}
		if (!Y41bUtils.esNullOCadenaVacia(trFechaHasta_)) {
			filterArbadhsol.setAdhfechaHasta(Y41bUtils.parseDateTime(trFechaHasta_.concat(" 23:59:59"), locale));
		}
		// Establecimiento
		filterArbadhsol.setAdhesnom(esnoco_);
		filterArbadhsol.setAdhnif(esnif_);

		// control checks
		filterArbadhsol
				.setAdhestadoP(("on".equals(checkPendientes_)) ? Y41bConstantes.ESTADO_ARBADHSOL_PENDIENTE : null);
		filterArbadhsol.setAdhestadoA(("on".equals(checkAceptadas_)) ? Y41bConstantes.ESTADO_ARBADHSOL_ACEPTADA : null);
		filterArbadhsol
				.setAdhestadoR(("on".equals(checkRechazadas_)) ? Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA : null);

		List<Arbadhsol> arbadhsols = this.arbadhsolService.findBandeja(filterArbadhsol, censoMonitor, pagination);
		Long recordNum = this.arbadhsolService.findBandejaCount(filterArbadhsol, censoMonitor);

		request.getSession().setAttribute("paginationAdhbandeja", pagination);
		httpSession.setAttribute("adhbandejaBusqueda", filterArbadhsol);

		ArbadhsolController.logger.info("[GET - jqGrid] : Obtener Arbadhsol");
		return new JQGridJSONModel(pagination, recordNum, arbadhsols);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbadhsol
	 *            Arbadhsol
	 * @param request
	 *            the request
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/adhbandejaSession", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGridSession(
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoco", required = false) String esnoco_,
			@RequestParam(value = "checkPendientes", required = false) String checkPendientes_,
			@RequestParam(value = "checkAceptadas", required = false) String checkAceptadas_,
			@RequestParam(value = "checkRechazadas", required = false) String checkRechazadas_,
			@ModelAttribute() Arbadhsol filterArbadhsol, @ModelAttribute() Pagination paginationReq,
			HttpServletRequest request) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			if (!Y41bUtils.esNullOCadenaVacia(trFechaDesde_)) {
				filterArbadhsol.setAdhfechaDesde(Y41bUtils.parseDateTime(trFechaDesde_.concat(" 00:00:00"), locale));
			}
			if (!Y41bUtils.esNullOCadenaVacia(trFechaHasta_)) {
				filterArbadhsol.setAdhfechaHasta(Y41bUtils.parseDateTime(trFechaHasta_.concat(" 23:59:59"), locale));
			}
			// Establecimiento
			filterArbadhsol.setAdhesnom(esnoco_);
			filterArbadhsol.setAdhnif(esnif_);
			// control checks
			filterArbadhsol
					.setAdhestadoP(("on".equals(checkPendientes_)) ? Y41bConstantes.ESTADO_ARBADHSOL_PENDIENTE : null);
			filterArbadhsol
					.setAdhestadoA(("on".equals(checkAceptadas_)) ? Y41bConstantes.ESTADO_ARBADHSOL_ACEPTADA : null);
			filterArbadhsol
					.setAdhestadoR(("on".equals(checkRechazadas_)) ? Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA : null);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = (Pagination) request.getSession().getAttribute("paginationAdhbandeja");

				// Si al refrescar la tabla existen menos elementos y la pgina
				// guardada en sesin no existe, se debe seleccionar la ltima
				// pgina con datos
				if (pagination != null) {
					Long totalReg = new Long(0);
					totalReg = this.arbadhsolService.findBandejaCount(filterArbadhsol, censoMonitor);
					Long pagSession = new Long(0);
					Long page = new Long(0);
					pagSession = pagination.getPage() * pagination.getRows();
					pagSession = pagSession - pagination.getRows();

					if (pagSession >= totalReg) {
						page = totalReg / pagination.getRows();
						pagination.setPage(page);
					}
				} else {
					pagination = paginationReq;
					Long page = new Long(1);
					pagination.setPage(page);
				}
			}

			List<Arbadhsol> arbadhsols = this.arbadhsolService.findBandeja(filterArbadhsol, censoMonitor, pagination);

			httpSession.setAttribute("adhbandejaBusqueda", filterArbadhsol);

			Long recordNum = this.arbadhsolService.findBandejaCount(filterArbadhsol, censoMonitor);

			return new JQGridJSONModel(pagination, recordNum, arbadhsols);
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbadhsol
	 *            Arbadhsol
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            {@link HttpServletRequest}
	 * @return JQGridJSONModel
	 * @throws Exception
	 */
	@RequestMapping(value = "/numRegistrosBandeja", method = RequestMethod.GET)
	public @ResponseBody Long getnumRegistrosBandeja(
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoco", required = false) String esnoco_,
			@RequestParam(value = "checkPendientes", required = false) String checkPendientes_,
			@RequestParam(value = "checkAceptadas", required = false) String checkAceptadas_,
			@RequestParam(value = "checkRechazadas", required = false) String checkRechazadas_,
			@ModelAttribute Arbadhsol filterArbadhsol, @ModelAttribute Pagination pagination,
			HttpServletRequest request) throws Exception {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = this.censoMonitorService.find(censoMonitor);

		// parseo de fechas
		Locale locale = LocaleContextHolder.getLocale();
		if (!Y41bUtils.esNullOCadenaVacia(trFechaDesde_)) {
			filterArbadhsol.setAdhfechaDesde(Y41bUtils.parseDateTime(trFechaDesde_.concat(" 00:00:00"), locale));
		}
		if (!Y41bUtils.esNullOCadenaVacia(trFechaHasta_)) {
			filterArbadhsol.setAdhfechaHasta(Y41bUtils.parseDateTime(trFechaHasta_.concat(" 23:59:59"), locale));
		}
		// Establecimiento
		filterArbadhsol.setAdhesnom(esnoco_);
		filterArbadhsol.setAdhnif(esnif_);
		// control checks
		filterArbadhsol
				.setAdhestadoP(("on".equals(checkPendientes_)) ? Y41bConstantes.ESTADO_ARBADHSOL_PENDIENTE : null);
		filterArbadhsol.setAdhestadoA(("on".equals(checkAceptadas_)) ? Y41bConstantes.ESTADO_ARBADHSOL_ACEPTADA : null);
		filterArbadhsol
				.setAdhestadoR(("on".equals(checkRechazadas_)) ? Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA : null);

		Long recordNum = this.arbadhsolService.findBandejaCount(filterArbadhsol, censoMonitor);

		ArbadhsolController.logger.info("[GET - jqGrid] : Obtener Arbadhsol count");
		return recordNum;
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandeja", method = RequestMethod.GET)
	public void generarBandejaExcel(@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoco", required = false) String esnoco_,
			@RequestParam(value = "checkPendientes", required = false) String checkPendientes_,
			@RequestParam(value = "checkAceptadas", required = false) String checkAceptadas_,
			@RequestParam(value = "checkRechazadas", required = false) String checkRechazadas_,
			HttpServletRequest request, HttpServletResponse response) {

		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);

			Arbadhsol filterArbadhsol = new Arbadhsol();
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			if (!Y41bUtils.esNullOCadenaVacia(trFechaDesde_)) {
				filterArbadhsol.setAdhfechaDesde(Y41bUtils.parseDateTime(trFechaDesde_.concat(" 00:00:00"), locale));
			}
			if (!Y41bUtils.esNullOCadenaVacia(trFechaHasta_)) {
				filterArbadhsol.setAdhfechaHasta(Y41bUtils.parseDateTime(trFechaHasta_.concat(" 23:59:59"), locale));
			}
			// Establecimiento
			filterArbadhsol.setAdhesnom(esnoco_);
			filterArbadhsol.setAdhnif(esnif_);
			// control checks
			filterArbadhsol
					.setAdhestadoP(("on".equals(checkPendientes_)) ? Y41bConstantes.ESTADO_ARBADHSOL_PENDIENTE : null);
			filterArbadhsol
					.setAdhestadoA(("on".equals(checkAceptadas_)) ? Y41bConstantes.ESTADO_ARBADHSOL_ACEPTADA : null);
			filterArbadhsol
					.setAdhestadoR(("on".equals(checkRechazadas_)) ? Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA : null);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_BANDADHESIONES + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getAdhbandejaExcel(filterArbadhsol, censoMonitor);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateFormTabsDetalleDocs'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintTabsDetalleCom", method = RequestMethod.GET)
	public ModelAndView getCreateFormTabsDetalleDocs(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilArbitraje() == null || censoMonitor.getPerfilArbitraje().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("tabsAdhSolicitudesDetalleCom", "model", model);
		}

	}

	/**
	 * Method 'getCreateFormDetalleConsulta'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintDetalle", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalleConsulta(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilArbitraje() == null || censoMonitor.getPerfilArbitraje().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleAdhSolicitudes", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintComunicacion/{adhid}", method = RequestMethod.GET)
	public ModelAndView getCreateFormDocumentos(@PathVariable String adhid, Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (!adhid.equals("-1")) {
			// Volcamos los documentos de la comunicacin a la temporal
			this.arbadhsolService.addTramiteAdjuntarDocsComTableTemporal(adhid);
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(adhid);
			arbadhsol = this.arbadhsolService.find(arbadhsol);
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
				model.addAttribute("idProcedimiento", Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA);
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
				model.addAttribute("idProcedimiento", Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA);
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
				model.addAttribute("idProcedimiento", Y41bConstantes.TIPO_PROC_ADHESIONES_MOD);
			}
		}

		if (censoMonitor.getPerfilArbitraje() == null || censoMonitor.getPerfilArbitraje().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("comunicacionAdhSolicitudes", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "validarDatosEstablecimiento", method = RequestMethod.GET)
	public String getCreateForm2(Model model) {
		ArbadhsolController.logger.info("[GET - View] : arbadhsol");
		return "validarEstAdhSolicitudes";
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 * @throws Exception
	 */
	@RequestMapping(value = "/aceptar", method = RequestMethod.PUT)
	public @ResponseBody String aceptarSolicitudAdhesion(@RequestBody Arbadhsol arbadhsol, HttpServletRequest request)
			throws Exception {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			arbadhsol.setAdhestado(Y41bConstantes.ESTADO_ARBADHSOL_ACEPTADA);
			StringBuffer idZipFile = new StringBuffer();
			idZipFile.append(Calendar.getInstance().getTimeInMillis()).append("_").append(arbadhsol.getAdhid());
			this.arbadhsolService.finalizarSolicitudAdhesion(arbadhsol, censoMonitor, idZipFile.toString());
			ArbadhsolController.logger.info("[PUT] : Arbadhsol actualizado correctamente");
			return idZipFile.toString();
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 * @throws Exception
	 */
	@RequestMapping(value = "/rechazar", method = RequestMethod.PUT)
	public @ResponseBody String rechazarSolicitudAdhesion(@RequestBody Arbadhsol arbadhsol, HttpServletRequest request)
			throws Exception {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			arbadhsol.setAdhestado(Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA);
			StringBuffer idZipFile = new StringBuffer();
			idZipFile.append(Calendar.getInstance().getTimeInMillis()).append("_").append(arbadhsol.getAdhid());
			this.arbadhsolService.finalizarSolicitudAdhesion(arbadhsol, censoMonitor, idZipFile.toString());
			ArbadhsolController.logger.info("[PUT] : Arbadhsol actualizado correctamente");
			return idZipFile.toString();
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoComunicacion'.
	 * 
	 * @param idzip
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findZipById/{idzip}", method = RequestMethod.GET)
	public @ResponseBody void getZipById(@PathVariable String idzip, HttpServletResponse response) {
		try {

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			// Se mira si se ha creado ZIP
			String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
			File zipFile = new File(strTmpZipDirectory + idzip + Y41bConstantes.EXTENSION_ZIP);
			if (zipFile.exists()) {
				// Cambiamos el objeto Response para visualizar el contenido
				// del archivo
				response.setHeader("Content-Disposition",
						"attachment; filename=\"" + idzip + Y41bConstantes.EXTENSION_ZIP + "\"");
				response.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
				File fileZip = new File(zipFile.getPath());
				FileInputStream fileInputStreamZip = new FileInputStream(fileZip);
				Util.copyStream(fileInputStreamZip, response.getOutputStream());
				// response.setContentLength(fileZip.length());
				// Vaciamos el stream
				response.getOutputStream().flush();
				fileInputStreamZip.close();
				// Eliminamos el fichero zip
				zipFile.delete();
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllDocsComunicacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsComunicacion/{adhid}", method = RequestMethod.GET)
	public @ResponseBody Object getAllDocsComunicacion(@PathVariable String adhid, HttpServletRequest request) {
		try {
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(adhid);
			arbadhsol = this.arbadhsolService.find(arbadhsol);

			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidExpediente(arbadhsol.getAdhid().toString());
			adjuntardocsFilter.setThidTramite(arbadhsol.getAdhid().toString());

			Long total = new Long(0);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;
				adjuntardocsFilter.setTrpcodigo(arbadhsol.getTipoProcedimiento());
				listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;
				adjuntardocsFilter.setTrpcodigo(arbadhsol.getTipoProcedimiento());
				listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllPlantillasComunicacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllPlantilla/{adhid}", method = RequestMethod.GET)
	public @ResponseBody Object getAllPlantillasComunicacion(@PathVariable String adhid, HttpServletRequest request) {
		try {
			PlantillaTramite plantillaTramite = new PlantillaTramite();
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(adhid);
			arbadhsol = this.arbadhsolService.find(arbadhsol);
			Tramite tramite = new Tramite();
			plantillaTramite.setPcodigo(arbadhsol.getTipoProcedimiento());
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_ALTA);
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_BAJA);
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_MOD);
			}
			plantillaTramite.setTramite(tramite);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);
				Long total = this.plantillaTramiteService.findAllPlantillaTramiteCount(plantillaTramite);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listPlantillaTramiteBusqueda);
				return data;
			} else {
				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				return listPlantillaTramiteBusqueda;
			}
		} catch (Exception e) {

		}
		return null;
	}

	/**
	 * Method 'addPlantillaComunicacion'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/addPlantillaComunicacion", method = RequestMethod.POST)
	public @ResponseBody void addPlantillaComunicacion(@RequestBody Adjuntardocs adjuntardocs,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(adjuntardocs.getThidExpediente());
			tramiteComun.setIdTramite(tramiteComun.getIdExpediente());
			this.arbadhsolService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_ARB_COMUNICACION);

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoComunicacion'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDocComunicacion/{adhid}/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody void getByIdDocumentoComunicacion(@PathVariable String adhid, @PathVariable Long thcodocumento,
			HttpServletResponse response) {
		try {
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(adhid);
			arbadhsol = this.arbadhsolService.find(arbadhsol);

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			adjuntardocsAux.setThidTramite(adhid.toString());
			adjuntardocsAux.setThidExpediente(adhid.toString());
			adjuntardocsAux.setTipoProcedimiento(new TipoProcedimiento(arbadhsol.getTipoProcedimiento()));
			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsComunicacion/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable Long thcodocumento, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocsComunicacion'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirDocsComunicacion/{adhid}", method = RequestMethod.POST)
	public @ResponseBody List<Map<String, Object>> addDocsComunicacion(@PathVariable String adhid,
			@RequestParam(value = "files[]", required = false) MultipartFile file, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thtedesfile = request.getParameter("thtedesfile");

			String requiereFirma = request.getParameter("requiereFirma");
			String rolFirma = null;
			if (requiereFirma != null && requiereFirma.equals("on")) {
				rolFirma = request.getParameter("rolFirma");
				requiereFirma = Y41bConstantes.SI;
			} else {
				requiereFirma = Y41bConstantes.NO;
			}

			TipoDocumento tipoDocumento = new TipoDocumento();

			adjuntardocsAux.setThcodocumento(this.arbadhsolcomdocDao.getNewPK().toString());
			adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION);
			tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ARB_COMUNICACION);

			if (Y41bConstantes.SI.equals(requiereFirma)) {
				Perfil perfilFirma = new Perfil();
				perfilFirma.setIdPerfil(rolFirma);
				adjuntardocsAux.setPerfil(perfilFirma);
				adjuntardocsAux.setThfechasolfirma(Calendar.getInstance().getTime());
				adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			}

			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			adjuntardocsAux.setThtedesfile(thtedesfile);

			// Blob blob = new SerialBlob(file.getBytes());
			// adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThdatafileinputstream(file.getInputStream());
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(adhid);
			arbadhsol = this.arbadhsolService.find(arbadhsol);

			adjuntardocsAux.setThidExpediente(adhid.toString());
			adjuntardocsAux.setThidTramite(adhid.toString());
			adjuntardocsAux.setTipoProcedimiento(new TipoProcedimiento(arbadhsol.getTipoProcedimiento()));
			adjuntardocsAux.setThfecha(new Date());
			adjuntardocsAux.setTrpcodigo(arbadhsol.getTipoProcedimiento());
			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/arbadhsol/guardarComunicacion/" + file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41bVistaWar/arbadhsol/guardarComunicacion/" + file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'getAllOrigenMail'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllOrigenMail", method = RequestMethod.GET)
	public @ResponseBody Object getAllOrigenMail(HttpServletRequest request) {
		return this.arbexpService.findAllMailOrigen(null);
	}

	/**
	 * Method 'getOrigenMail'.
	 * 
	 * @param idDatomail
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/origenmail/{idDatomail}", method = RequestMethod.GET)
	public @ResponseBody Object getOrigenMail(@PathVariable String idDatomail, HttpServletRequest request) {
		try {

			DatosMailOrigen datosMailOrigen = new DatosMailOrigen();
			datosMailOrigen.setIdDatomail(idDatomail);

			datosMailOrigen = this.arbexpService.findMailOrigen(null, datosMailOrigen);

			if (datosMailOrigen == null) {
				throw new Exception("No data Found. /origenmail/{idDatomail}");
			} else {
				return datosMailOrigen;
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found. /origenmail/{idDatomail}");
		}
	}

	// /**
	// * Method 'getOrigenMail'.
	// *
	// * @param idDatomail
	// * String
	// * @param tramiteComun
	// * TramiteComun
	// * @param request
	// * HttpServletRequest
	// * @return Object
	// * @throws Exception
	// */
	// @RequestMapping(value = "/actualizarLocalizador/{oid}", method =
	// RequestMethod.GET)
	// public @ResponseBody
	// Long actualizarLocalizador(@PathVariable String oid,
	// HttpServletRequest request) throws Exception {
	// Arbadhdoc documentoXM = new Arbadhdoc();
	// documentoXM.setX5iddocumentum(oid);
	// Long num = this.arbadhsolService
	// .actualizarDocumentoLocalizadorBBDD(documentoXM);
	// return num;
	// }

	/**
	 * Method 'getExpedientePestania2'.
	 * 
	 * @param model
	 *            Model
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maintTramitacion", method = RequestMethod.GET)
	public ModelAndView maintTramitacion(Model model, HttpServletRequest httpRequest) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = this.censoMonitorService.find(censoMonitor);

		String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();
		if (perfil != null && Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO.equals(perfil)) {
			// Si perfil sin acceso devolvemos listado vacio
			return new ModelAndView("accessDenied", "model", model);
		} else {
			return new ModelAndView("tramitacionAdhSolicitudes", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param escodigo
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/bajaOficioValidacion/{adhid}", method = RequestMethod.POST)
	public @ResponseBody EstablecimientoDetalle getEstablecimientoById(@PathVariable String adhid,
			@RequestBody Arbadhsol arbadhsol, Model model, HttpServletRequest httpRequest) {

		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		EstablecimientoDetalle establecimientoDetalle = this.arbadhsolService.bajaOficioValidacion(arbadhsol,
				censoMonitor);

		return establecimientoDetalle;

	}

	// 0116048 3.4
	@RequestMapping(value = "/buscarDuplicado/{adhid}", method = RequestMethod.GET)
	public @ResponseBody EstablecimientoDetalle buscarDuplicado(@PathVariable String adhid,
			HttpServletRequest httpRequest) {

		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		EstablecimientoDetalle est = new EstablecimientoDetalle();

		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(adhid);
		// arbadhsol = this.arbadhsolService.find(arbadhsol);
		Arbadhsol validacionEstablecimiento = this.arbadhsolService.findDatosValidacion(arbadhsol);

		if (null != validacionEstablecimiento) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnif(validacionEstablecimiento.getAdhnif());
			establecimiento.setEsnoraLocalidadId(validacionEstablecimiento.getAdheslocali());
			establecimiento.setEsnoraMunicipioId(validacionEstablecimiento.getAdhesmunici());
			establecimiento.setEsnoraProvinciaId(validacionEstablecimiento.getAdhesprovin());
			establecimiento.setEsnoraCalleId(validacionEstablecimiento.getAdhescalle());
			establecimiento.setEsnoraProvinciaId(validacionEstablecimiento.getAdhesprovin());
			establecimiento.setEsnoraPortalId(validacionEstablecimiento.getAdhesportal());
			establecimiento.setEsinadar(Y41bConstantes.SI);

			List<Establecimiento> listaEstablecimientos = this.establecimientoService.findAllLike(establecimiento, null,
					false);

			if (!listaEstablecimientos.isEmpty()) {
				est.setAhcodigo("D");
			}
			if (!"D".equals(est.getAhcodigo())
					&& !Y41bUtils.esNullOCadenaVacia(validacionEstablecimiento.getAdhesnrtel())) {
				// buscamos por el primer telefono
				establecimiento = new Establecimiento();
				// establecimiento.setEsnif(validacionEstablecimiento.getAdhnif());
				establecimiento.setEsnrtel(validacionEstablecimiento.getAdhesnrtel());
				establecimiento.setEsinadar(Y41bConstantes.SI);

				listaEstablecimientos = this.establecimientoService.findAllLike(establecimiento, null, false);

				if (!listaEstablecimientos.isEmpty()) {
					est.setAhcodigo("DT");
				} else if (!Y41bUtils.esNullOCadenaVacia(validacionEstablecimiento.getAdhesnrtel())) {
					// buscamos el primer telefono en el 2 numero
					establecimiento = new Establecimiento();
					// establecimiento.setEsnif(validacionEstablecimiento.getAdhnif());
					establecimiento.setEsnrtel2(validacionEstablecimiento.getAdhesnrtel());
					establecimiento.setEsinadar(Y41bConstantes.SI);

					listaEstablecimientos = this.establecimientoService.findAllLike(establecimiento, null, false);

					if (!listaEstablecimientos.isEmpty()) {
						est.setAhcodigo("DT");
					}
				}

			}

			if (!"D".equals(est.getAhcodigo()) && !"DT".equals(est.getAhcodigo())
					&& !Y41bUtils.esNullOCadenaVacia(validacionEstablecimiento.getAdhesnrtel2())) {
				// buscamos el segundo telefono en el 1 numero
				establecimiento = new Establecimiento();
				// establecimiento.setEsnif(validacionEstablecimiento.getAdhnif());
				establecimiento.setEsnrtel(validacionEstablecimiento.getAdhesnrtel2());
				establecimiento.setEsinadar(Y41bConstantes.SI);

				listaEstablecimientos = this.establecimientoService.findAllLike(establecimiento, null, false);

				if (!listaEstablecimientos.isEmpty()) {
					est.setAhcodigo("DT");
				} else if (!Y41bUtils.esNullOCadenaVacia(validacionEstablecimiento.getAdhesnrtel2())) {
					// buscamos el segundo telefono en el 2 numero
					establecimiento = new Establecimiento();
					// establecimiento.setEsnif(validacionEstablecimiento.getAdhnif());
					establecimiento.setEsnrtel2(validacionEstablecimiento.getAdhesnrtel2());
					establecimiento.setEsinadar(Y41bConstantes.SI);

					listaEstablecimientos = this.establecimientoService.findAllLike(establecimiento, null, false);

					if (!listaEstablecimientos.isEmpty()) {
						est.setAhcodigo("DT");
					}
				}
			}
		}

		return est;
	}
	// 0116048 3.4

	@RequestMapping(value = "/buscarDuplicado2", method = RequestMethod.POST)
	public @ResponseBody EstablecimientoDetalle buscarDuplicado2(@RequestBody Arbadhsol arbadhsolaux) {

		// HttpSession httpSession = httpRequest.getSession(false);
		// CensoMonitor censoMonitor = (CensoMonitor) httpSession
		// .getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		EstablecimientoDetalle est = new EstablecimientoDetalle();

		// Arbadhsol arbadhsol = new Arbadhsol();
		// arbadhsol.setAdhid(adhid);
		// arbadhsol = this.arbadhsolService.find(arbadhsol);
		// Arbadhsol validacionEstablecimiento =
		// this.arbadhsolService.findDatosValidacion(arbadhsol);

		if (null != arbadhsolaux) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnif(arbadhsolaux.getAdhnif());
			establecimiento.setEsnoraLocalidadId(arbadhsolaux.getAdheslocali());
			establecimiento.setEsnoraMunicipioId(arbadhsolaux.getAdhesmunici());
			establecimiento.setEsnoraProvinciaId(arbadhsolaux.getAdhesprovin());
			establecimiento.setEsnoraCalleId(arbadhsolaux.getAdhescalle());
			establecimiento.setEsnoraProvinciaId(arbadhsolaux.getAdhesprovin());
			establecimiento.setEsnoraPortalId(arbadhsolaux.getAdhesportal());
			establecimiento.setEsinadar(Y41bConstantes.SI);

			List<Establecimiento> listaEstablecimientos = this.establecimientoService.findAllLike(establecimiento, null,
					false);

			if (!listaEstablecimientos.isEmpty()) {
				est.setAhcodigo("D");
			}

			if (!"D".equals(est.getAhcodigo()) && !Y41bUtils.esNullOCadenaVacia(arbadhsolaux.getAdhesnrtel())) {
				// buscamos por el primer telefono
				establecimiento = new Establecimiento();
				// establecimiento.setEsnif(validacionEstablecimiento.getAdhnif());
				establecimiento.setEsnrtel(arbadhsolaux.getAdhesnrtel());
				establecimiento.setEsinadar(Y41bConstantes.SI);

				listaEstablecimientos = this.establecimientoService.findAllLike(establecimiento, null, false);

				if (!listaEstablecimientos.isEmpty()) {
					est.setAhcodigo("DT");
				} else if (!Y41bUtils.esNullOCadenaVacia(arbadhsolaux.getAdhesnrtel())) {
					// buscamos el primer telefono en el 2 numero
					establecimiento = new Establecimiento();
					// establecimiento.setEsnif(validacionEstablecimiento.getAdhnif());
					establecimiento.setEsnrtel2(arbadhsolaux.getAdhesnrtel());
					establecimiento.setEsinadar(Y41bConstantes.SI);

					listaEstablecimientos = this.establecimientoService.findAllLike(establecimiento, null, false);

					if (!listaEstablecimientos.isEmpty()) {
						est.setAhcodigo("DT");
					}
				}

			}

			if (!"D".equals(est.getAhcodigo()) && !"DT".equals(est.getAhcodigo())
					&& !Y41bUtils.esNullOCadenaVacia(arbadhsolaux.getAdhesnrtel2())) {
				// buscamos el segundo telefono en el 1 numero
				establecimiento = new Establecimiento();
				// establecimiento.setEsnif(validacionEstablecimiento.getAdhnif());
				establecimiento.setEsnrtel(arbadhsolaux.getAdhesnrtel2());
				establecimiento.setEsinadar(Y41bConstantes.SI);

				listaEstablecimientos = this.establecimientoService.findAllLike(establecimiento, null, false);

				if (!listaEstablecimientos.isEmpty()) {
					est.setAhcodigo("DT");
				} else if (!Y41bUtils.esNullOCadenaVacia(arbadhsolaux.getAdhesnrtel2())) {
					// buscamos el segundo telefono en el 2 numero
					establecimiento = new Establecimiento();
					// establecimiento.setEsnif(validacionEstablecimiento.getAdhnif());
					establecimiento.setEsnrtel2(arbadhsolaux.getAdhesnrtel2());
					establecimiento.setEsinadar(Y41bConstantes.SI);

					listaEstablecimientos = this.establecimientoService.findAllLike(establecimiento, null, false);

					if (!listaEstablecimientos.isEmpty()) {
						est.setAhcodigo("DT");
					}
				}
			}

		}

		return est;
	}

	// private boolean existeEstablecimientoDistintoDe(List<Establecimiento>
	// listaEstablecimientos,
	// String codigoEstablecimiento) {
	//
	// boolean existe = false;
	//
	// if (listaEstablecimientos != null) {
	// if (Y41bUtils.esNullOCadenaVacia(codigoEstablecimiento)
	// && !listaEstablecimientos.isEmpty()) {
	// existe = true;
	// } else if (!Y41bUtils.esNullOCadenaVacia(codigoEstablecimiento)
	// && !listaEstablecimientos.isEmpty()) {
	// if(listaEstablecimientos.size()>1){
	// existe = true;
	// }else{
	// if(!listaEstablecimientos.get(0).getEscodigo().equals(codigoEstablecimiento)){
	// existe = true;
	// }
	// }
	// }
	// }
	//
	// return existe;
	// }

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "adhFormulario", method = RequestMethod.GET)
	public ModelAndView getCreateFormAdhFormulario(Model model, HttpServletRequest request) {
		ArbadhsolController.logger.info("[GET - View] : adhFormulario");
		HttpSession sesion = request.getSession();
		return new ModelAndView("adhFormulario", "model", model);
	}

	/**
	 * Method 'addAdjuntarDocs'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirAdhFormulario", method = RequestMethod.POST)
	public @ResponseBody List<Map<String, Object>> addAdjuntarDocs(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletResponse response,
			HttpServletRequest request) {
		try {

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thtedesfile = request.getParameter("thtedesfile");
			if (Y41bUtils.esNullOCadenaVacia(thtedesfile)) {
				throw new Y41bUDAException("required.consumidornombre", true, new Exception());
			}
			if (file == null) {
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (!Y41bConstantes.CONTENT_TYPE_PDF.equalsIgnoreCase(file.getContentType())) {
				throw new Y41bUDAException("error.adjuntardocstramite.pdfException", true, new Exception());
			}

			adjuntardocsAux.setThtedesfile(thtedesfile);

			Blob blob = new SerialBlob(file.getBytes());
			adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThfecha(new Date());

			AdhesionTele adhesiontele = new AdhesionTele();

			String provincia = "";

			try {

				PdfReader reader = new PdfReader(file.getBytes());

				AcroFields flds = reader.getAcroFields();

				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("nombre"))) {
					adhesiontele.setAdhesnom(Y41bUtils.upperCase(flds.getField("nombre")));
				}
				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("dninif"))) {
					adhesiontele.setAdhnif(Y41bUtils.upperCase(flds.getField("dninif")));
				}
				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("nombreComercial"))) {
					adhesiontele.setAdhesnoco(Y41bUtils.upperCase(flds.getField("nombreComercial")));
				}
				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("domicilio"))) {
					adhesiontele.setAdhesdirecnocapv(Y41bUtils.upperCase(flds.getField("domicilio")));
				}
				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("portal"))) {
					adhesiontele.setAdhesportal(Y41bUtils.upperCase(flds.getField("portal")));
				}
				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("municipio"))) {
					adhesiontele.setAdhesmunici(Y41bUtils.upperCase(flds.getField("municipio")));
				}
				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("cp"))) {
					adhesiontele.setAdhesnombrecp(Y41bUtils.upperCase(flds.getField("cp")));
				}
				if ("ARABA/ALAVA".equalsIgnoreCase(flds.getField("territorioHistorico"))) {
					adhesiontele.setAdhesprovin(Y41bConstantes.CODIGO_PROVINCIA_ARABA);
				} else if ("BIZKAIA".equalsIgnoreCase(flds.getField("territorioHistorico"))) {
					adhesiontele.setAdhesprovin(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA);
				} else if ("GIPUZKOA".equalsIgnoreCase(flds.getField("territorioHistorico"))) {
					adhesiontele.setAdhesprovin(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA);
				}
				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("territorioHistorico"))) {
					provincia = Y41bUtils.upperCase(flds.getField("territorioHistorico"));
				}
				adhesiontele.setAdhesextranjero(Y41bConstantes.VALOR_NO);
				// en espiso se va a acumular: domicilio, municipio,
				// territoriohistorico todo lo que no sea el cp
				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("telefono"))) {
					adhesiontele.setAdhesnrtel(Y41bUtils.upperCase(flds.getField("telefono")));
				}
				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("telefono2"))) {
					adhesiontele.setAdhesnrtel2(Y41bUtils.upperCase(flds.getField("telefono2")));
				}

				adhesiontele.setAdhescoem(flds.getField("Email"));

				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("web")) && ((flds.getField("web").length() >= 7
						&& "http://".equals(flds.getField("web").substring(0, 7)))
						|| (flds.getField("web").length() >= 8
								&& "https://".equals(flds.getField("web").substring(0, 8))))) {
					adhesiontele.setAdhesurl(flds.getField("web"));
				} else if (!Y41bUtils.esNullOCadenaVacia(flds.getField("web"))) {
					adhesiontele.setAdhesurl("http://".concat(flds.getField("web")));
				}

				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("representante"))) {
					adhesiontele.setAdhesnorep(Y41bUtils.upperCase(flds.getField("representante")));
				}

				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("dniRepresentante"))) {
					adhesiontele.setAdhesnifrep(Y41bUtils.upperCase(flds.getField("dniRepresentante")));
				}

				if (flds.getField("asociacionEmpresarial") != null
						&& !flds.getField("asociacionEmpresarial").isEmpty()) {
					adhesiontele.setAdhorgemp(Y41bUtils.upperCase(flds.getField("asociacionEmpresarial")));
				}

				// esto tiene que entrar en un nuevo campo por hacer
				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("actividadEmpresarial"))) {
					adhesiontele.setAdhSectorCampania(Y41bUtils.upperCase(flds.getField("actividadEmpresarial")));
				}

				if (!Y41bUtils.esNullOCadenaVacia(flds.getField("comentario"))) {
					adhesiontele.setAdhtexto(Y41bUtils.upperCase(flds.getField("comentario")));
				}

				// System.out.println(flds.getField("dataUdalerria"));
				// System.out.println(flds.getField("urtea"));
				// System.out.println(flds.getField("ilabetea"));
				// System.out.println(flds.getField("eguna"));
				// System.out.println(flds.getField("municipioFecha"));
				// System.out.println(flds.getField("dia"));
				// System.out.println(flds.getField("mes"));
				// System.out.println(flds.getField("anio"));

				adhesiontele.setAdhfecregen(new Date());
				adhesiontele.setAdhtipo(Y41bConstantes.ADH_TIPO_ALTA);

				reader.close();

			} catch (IOException e) {

				// TODO Auto-generated catch block

				e.printStackTrace();

			}

			if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhesnom())) {
				throw new Y41bUDAException("required.pdfrellenable.nombre", true, new Exception());
			}
			if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhnif())
					|| (!Y41bUtils.isValidNIF(adhesiontele.getAdhnif())
							&& !Y41bUtils.isValidCIF(adhesiontele.getAdhnif())
							&& !Y41bUtils.isValidNIE(adhesiontele.getAdhnif()))) {
				throw new Y41bUDAException("required.pdfrellenable.dninif", true, new Exception());
			}
			if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhesnoco())) {
				throw new Y41bUDAException("required.pdfrellenable.nombrecomercial", true, new Exception());
			}
			if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhesdirecnocapv())) {
				throw new Y41bUDAException("required.pdfrellenable.domicilio", true, new Exception());
			}
			if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhesportal())) {
				throw new Y41bUDAException("required.pdfrellenable.portal", true, new Exception());
			}
			if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhesmunici())) {
				throw new Y41bUDAException("required.pdfrellenable.municipio", true, new Exception());
			}

			if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhesnombrecp())) {
				throw new Y41bUDAException("required.pdfrellenable.cp", true, new Exception());
			}
			if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhesprovin())) {
				throw new Y41bUDAException("required.pdfrellenable.territoriohistorico", true, new Exception());
			}
			if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhesnrtel())) {
				throw new Y41bUDAException("required.pdfrellenable.telefono", true, new Exception());
			}

			// if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhescoem())) {
			// throw new Y41bUDAException("required.pdfrellenable.email", true,
			// new Exception());
			// }
			// if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhesurl())) {
			// throw new Y41bUDAException("required.pdfrellenable.web", true,
			// new Exception());
			// }
			if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhesnorep())) {
				throw new Y41bUDAException("required.pdfrellenable.nombrerep", true, new Exception());
			}
			if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhesnifrep())
					|| (!Y41bUtils.isValidNIF(adhesiontele.getAdhesnifrep())
							&& !Y41bUtils.isValidNIE(adhesiontele.getAdhesnifrep()))) {
				throw new Y41bUDAException("required.pdfrellenable.dninifrep", true, new Exception());
			}
			if (Y41bUtils.esNullOCadenaVacia(adhesiontele.getAdhSectorCampania())) {
				throw new Y41bUDAException("required.pdfrellenable.actividademp", true, new Exception());
			}

			adhesiontele
					.setAdhespiso(adhesiontele.getAdhesdirecnocapv().concat(" ").concat(adhesiontele.getAdhesportal())
							.concat(" ").concat(provincia).concat(" ").concat(adhesiontele.getAdhesmunici()));

			if (adhesiontele.getAdhespiso() != null && adhesiontele.getAdhespiso().length() > 39) {
				adhesiontele.setAdhespiso(adhesiontele.getAdhespiso().substring(0, 40));
			}
			// adhesiontele.setAdhespiso(adhesiontele.getAdhespiso().substring(0,
			// 40));

			this.arbadhsolService.registrarAdhFormulario(adhesiontele, adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			ArbadhsolController.logger.error("Y41bUDAException addAdjuntarDocs (anyadirAdhFormulario)", e);
			throw e;
		} catch (Exception e) {
			ArbadhsolController.logger.error("Exception addAdjuntarDocs (anyadirAdhFormulario)", e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
