package com.ejie.y41b.control;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.service.ArbadhtramService;
import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.Arbadhtram;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.service.ArbadhdocService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbadhdocController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/arbadhdoc")
public class ArbadhdocController {

	private static final Logger logger = LoggerFactory.getLogger(ArbadhdocController.class);

	@Autowired
	private ArbadhdocService arbadhdocService;

	@Autowired()
	private Properties appConfiguration;
	@Autowired()
	private ArbadhtramService arbadhtramService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbadhdocController.logger.info("[GET - View] : arbadhdoc");
		return "arbadhdoc";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param x5codocumento
	 *            String
	 * @return arbadhdoc Arbadhdoc
	 */
	@RequestMapping(value = "/{x5codocumento}", method = RequestMethod.GET)
	public @ResponseBody Arbadhdoc getById(@PathVariable String x5codocumento) {
		Arbadhdoc arbadhdoc = new Arbadhdoc();
		arbadhdoc.setX5codocumento(x5codocumento);
		try {
			arbadhdoc = this.arbadhdocService.find(arbadhdoc);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
		ArbadhdocController.logger.info("[GET - findBy_PK] : Obtener Arbadhdoc por PK");
		return arbadhdoc;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbadhdoc
	 *            Arbadhdoc
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Arbadhdoc> getAll(@ModelAttribute Arbadhdoc filterArbadhdoc) {
		ArbadhdocController.logger.info("[GET - find_ALL] : Obtener Arbadhdoc por filtro");
		return this.arbadhdocService.findAll(filterArbadhdoc, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Arbadhdoc edit(@RequestBody Arbadhdoc arbadhdoc) {
		Arbadhdoc arbadhdocAux = this.arbadhdocService.update(arbadhdoc);
		ArbadhdocController.logger.info("[PUT] : Arbadhdoc actualizado correctamente");
		return arbadhdocAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Arbadhdoc add(@RequestBody Arbadhdoc arbadhdoc) {
		Arbadhdoc arbadhdocAux = this.arbadhdocService.add(arbadhdoc);
		ArbadhdocController.logger.info("[POST] : Arbadhdoc insertado correctamente");
		return arbadhdocAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param x5codocumento
	 *            String
	 * @return arbadhdoc
	 */
	@RequestMapping(value = "/{x5codocumento}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Arbadhdoc remove(@PathVariable String x5codocumento) {
		Arbadhdoc arbadhdoc = new Arbadhdoc();
		arbadhdoc.setX5codocumento(x5codocumento);
		this.arbadhdocService.remove(arbadhdoc);
		ArbadhdocController.logger.info("[DELETE] : Arbadhdoc borrado correctamente");
		return arbadhdoc;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbadhdocIds
	 *            List
	 * @return arbadhdocList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> arbadhdocIds) {
		List<Arbadhdoc> arbadhdocList = new ArrayList<Arbadhdoc>();
		for (List<String> arbadhdocId : arbadhdocIds) {
			Iterator<String> iterator = arbadhdocId.iterator();
			Arbadhdoc arbadhdoc = new Arbadhdoc(); // NOPMD - Objeto nuevo en la
													// lista (parametro del
													// servicio)
			arbadhdoc.setX5codocumento(iterator.next());
			arbadhdocList.add(arbadhdoc);
		}
		this.arbadhdocService.removeMultiple(arbadhdocList);
		ArbadhdocController.logger.info("[POST - DELETE_ALL] : Arbadhdoc borrados correctamente");
		return arbadhdocIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbadhdoc
	 *            Arbadhdoc
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Arbadhdoc filterArbadhdoc,
			@ModelAttribute Pagination pagination) {
		List<Arbadhdoc> arbadhdocs = this.arbadhdocService.findAll(filterArbadhdoc, pagination);
		Long recordNum = this.arbadhdocService.findAllCount(filterArbadhdoc);
		ArbadhdocController.logger.info("[GET - jqGrid] : Obtener Arbadhdoc");
		return new JQGridJSONModel(pagination, recordNum, arbadhdocs);
	}

	/**
	 * Method 'getDocumentosTramiteForm'.
	 * 
	 * @param idTramiteAdhesiones
	 *            String
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "documentosTramite/{idTramiteAdhesiones}", method = RequestMethod.GET)
	public ModelAndView getDocumentosTramiteForm(@PathVariable() String idTramiteAdhesiones, Model model) {

		model.addAttribute("idTramiteAdhesiones", idTramiteAdhesiones);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("documentosTramiteAdhesiones", "model", model);
	}

	/**
	 * Method 'getAllDocumentosTramite'.
	 * 
	 * @param idTramite
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocumentosTramite/{idTramite}/{tipo}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocumentosTramite(@PathVariable() String idTramite, @PathVariable() String tipo,
			HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(idTramite);
			String tipoProcedimiento = "";
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(tipo)) {
				tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA;
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(tipo)) {
				tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_MOD;
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(tipo) || Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(tipo)) {
				tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA;
			}
			tramiteComun.setTipoProcedimiento(new TipoProcedimiento(tipoProcedimiento));

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Arbadhdoc> listDocumentoHecho = null;

				if (censoMonitor != null && censoMonitor.getPerfilArbitraje() != null) {
					listDocumentoHecho = this.arbadhdocService.findAllDocumentosTramite(tramiteComun, pagination);
				}

				if (listDocumentoHecho == null) {
					throw new Exception("No data Found.");
				}

				Long total = new Long(0);
				if (censoMonitor != null && censoMonitor.getPerfilArbitraje() != null) {
					total = this.arbadhdocService.findAllDocumentosTramiteCount(tramiteComun);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listDocumentoHecho);
				return data;
			} else {
				List<Arbadhdoc> listDocumentoHecho = null;

				if (censoMonitor != null && censoMonitor.getPerfilArbitraje() != null
						&& !censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)) {
					listDocumentoHecho = this.arbadhdocService.findAllDocumentosTramite(tramiteComun, null);
				}
				if (listDocumentoHecho == null) {
					throw new Exception("No data Found.");
				}
				return listDocumentoHecho;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllDocumentosTramite'.
	 * 
	 * @param idTramite
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/docsSolicitud/{tipo}/{adhid}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocumentosSolicitud(@PathVariable() String tipo, @PathVariable() String adhid,
			HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			List<Arbadhdoc> listDocumentoHecho = null;

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				if (censoMonitor != null && censoMonitor.getPerfilArbitraje() != null) {
					listDocumentoHecho = this.arbadhdocService.findAllDocsSolicitud(tipo, adhid, null);
				}

				if (listDocumentoHecho == null) {
					throw new Exception("No data Found.");
				}

				Long total = new Long(0);
				if (censoMonitor != null && censoMonitor.getPerfilArbitraje() != null) {
					total = this.arbadhdocService.findAllDocsSolicitudCount(tipo, adhid);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listDocumentoHecho);
				return data;
			} else {

				if (censoMonitor != null && censoMonitor.getPerfilArbitraje() != null
						&& !censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)) {
					listDocumentoHecho = this.arbadhdocService.findAllDocsSolicitud(tipo, adhid, null);
				}
				if (listDocumentoHecho == null) {
					throw new Exception("No data Found.");
				}
				return listDocumentoHecho;
			}

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllDocumentosTramite'.
	 * 
	 * @param idTramite
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/docsRespuesta/{tipo}/{adhid}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocumentosRespuesta(@PathVariable() String tipo, @PathVariable() String adhid,
			HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			Arbadhtram arbadhtram = new Arbadhtram();
			arbadhtram.setTrexcodigo(adhid);
			String tipoProcedimiento = "";
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(tipo)) {
				arbadhtram.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_ALTA);
				tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA;
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(tipo)) {
				arbadhtram.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_MOD);
				tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_MOD;
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(tipo) || Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(tipo)) {
				arbadhtram.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_BAJA);
				tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA;
			}
			List<Arbadhtram> lArbadhtram = this.arbadhtramService.findAll(arbadhtram, null);

			if (lArbadhtram != null && lArbadhtram.size() > 0) {
				TramiteComun tramiteComun = new TramiteComun();
				tramiteComun.setIdTramite(lArbadhtram.get(0).getTrid().toString());
				tramiteComun.setTipoProcedimiento(new TipoProcedimiento(tipoProcedimiento));

				Pagination pagination = null;
				if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
					pagination = new Pagination();
					pagination.setPage(Long.valueOf(request.getParameter("page")));
					pagination.setRows(Long.valueOf(request.getParameter("rows")));
					pagination.setSort(request.getParameter("sidx"));
					pagination.setAscDsc(request.getParameter("sord"));
					List<Arbadhdoc> listDocumentoHecho = null;

					if (censoMonitor != null && censoMonitor.getPerfilArbitraje() != null) {
						listDocumentoHecho = this.arbadhdocService.findAllDocumentosTramite(tramiteComun, pagination);
					}

					if (listDocumentoHecho == null) {
						throw new Exception("No data Found.");
					}

					Long total = new Long(0);
					if (censoMonitor != null && censoMonitor.getPerfilArbitraje() != null) {
						total = this.arbadhdocService.findAllDocumentosTramiteCount(tramiteComun);
					}
					JQGridJSONModel data = new JQGridJSONModel();
					data.setPage(request.getParameter("page"));
					data.setRecords(total.intValue());
					data.setTotal(total, pagination.getRows());
					data.setRows(listDocumentoHecho);
					return data;
				} else {
					List<Arbadhdoc> listDocumentoHecho = null;

					if (censoMonitor != null && censoMonitor.getPerfilArbitraje() != null && !censoMonitor
							.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)) {
						listDocumentoHecho = this.arbadhdocService.findAllDocumentosTramite(tramiteComun, null);
					}
					if (listDocumentoHecho == null) {
						throw new Exception("No data Found.");
					}
					return listDocumentoHecho;
				}
			} else {
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(0);
				data.setTotal(0L, 0L);
				data.setRows(null);
				return data;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getByIdDocumentoComunicacion'.
	 * 
	 * @param codocumento
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{codocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumentoComunicacion(@PathVariable() String codocumento,
			HttpServletResponse response) {
		try {
			Arbadhdoc arbadhdoc = new Arbadhdoc();
			arbadhdoc.setX5codocumento(codocumento);
			arbadhdoc = this.arbadhdocService.find(arbadhdoc);

			Blob contenido = arbadhdoc.getX5datafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(arbadhdoc.getX5nofile()) + "\"");
			response.setContentType(arbadhdoc.getX5conttype());
			response.setContentLength(arbadhdoc.getX5sizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

}
