package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SolarbController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/arbCalendarPruebas")
public class ArbCalendarPruebasController {

	private static final Logger logger = LoggerFactory
			.getLogger(ArbCalendarPruebasController.class);

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired()
	private Y41bUDAErrorManager errorManager;

	@Autowired()
	private SolarbService solarbService;

	@Autowired()
	private Properties appConfiguration;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;
		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		ArbCalendarPruebasController.logger.info("[GET - View] : solarb");
		HttpSession sesion = request.getSession();
		sesion.setAttribute("diasConPrueba", null);
		sesion.setAttribute("horasDiaConPrueba", null);
		return "arbCalendarPruebas";
	}

	/**
	 * 
	 * @param fecha
	 *            String
	 * @return HashMap<String, Object>
	 */
	@RequestMapping(value = "/getById/{fecha}", method = RequestMethod.GET)
	public @ResponseBody()
	HashMap<String, Object> getById(@PathVariable() String fecha,
			HttpServletRequest request) {
		try {
			HttpSession sesion = request.getSession();
			sesion.setAttribute("horasDiaConPrueba", null);
			HashMap<String, Object> calendar = new HashMap<String, Object>();
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				calendar.put("fechaTexto", Y41bUtils.formatearDateToString(
						dateFormat.parse(fecha),
						Y41bConstantes.FORMATO_FULL_FECHA_ES,
						Y41bConstantes.CASTELLANO));
			} else {
				calendar.put("fechaTexto", Y41bUtils
						.formatearDateToStringEuskera(dateFormat.parse(fecha),
								Y41bConstantes.FORMATO_FULL_FECHA_EU,
								Y41bConstantes.EUSKERA));
			}

			List<Solarb> lista = (List<Solarb>) sesion
					.getAttribute("diasConPrueba");
			if (lista != null) {
				calendar.put("horas",
						this.solarbService.getHorasDiaConPrueba(fecha, lista));
				sesion.setAttribute("horasDiaConPrueba", calendar);
			}
			return calendar;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * 
	 * @param anio
	 *            int
	 * @param mes
	 *            int
	 * @return HashMap<String, Object>
	 */
	@RequestMapping(value = "/getDiasConPrueba/{anio}/{mes}", method = RequestMethod.GET)
	public @ResponseBody()
	HashMap<String, Object> getDiasConPrueba(@PathVariable() int anio,
			@PathVariable() int mes, HttpServletRequest request) {
		try {
			HttpSession sesion = request.getSession();
			sesion.setAttribute("diasConPrueba", null);
			HashMap<String, Object> datos = this.solarbService
					.getDiasConPrueba(anio, mes);
			sesion.setAttribute("diasConPrueba",
					(List<Solarb>) datos.get("diasConPrueba"));
			return datos;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Method 'addPlantillaNotificacion'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/imprimir", method = RequestMethod.GET)
	public @ResponseBody()
	void imprimir(@RequestParam(value = "data", required = false) String data,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			HttpSession sesion = request.getSession();
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			HashMap<String, Object> calendar = (HashMap<String, Object>) sesion
					.getAttribute("horasDiaConPrueba");
			Solarb solarb = new Solarb();
			// ArrayList<HashMap<String, String>> calendarioPintado =new
			// ArrayList<HashMap<String, String>>();
			ArrayList<HashMap<String, String>> calendarioPintado = null;
			if (data != null) {
				calendarioPintado = new ObjectMapper().readValue(
						Y41bUtilsDokusi.decode(data), ArrayList.class);
			}
			solarb.setTablaHorasPrueba(this.pintarTablaPruebas(
					(ArrayList<HashMap<String, String>>) calendar.get("horas"),
					calendarioPintado));
			solarb.setFechaImpresion(Y41bUtils.parseDateToString(
					Y41bUtils.hoy(), idioma));
			solarb.setFechaPrueba((String) calendar.get("fechaTexto"));
			String rutaRTF = (String) this.appConfiguration
					.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) this.appConfiguration
					.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_ARBITRAJE_PRUEBAS_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_ARBITRAJE_PRUEBAS_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(
					Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String ficheroGenerado = Y41bGenerarDocumento.generarDocumentoWord(
					rutaCompletaXML, solarb, plantilla);

			byte[] bContenido = ficheroGenerado.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"pruebas.rtf\"");
			response.setContentType(Y41bConstantes.CONTENT_TYPE_MSWORD);
			response.setContentLength(bContenido.length);
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	private String pintarTablaPruebas(ArrayList<HashMap<String, String>> horas,
			ArrayList<HashMap<String, String>> calendarioPintado) {
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer stablaDoc = new StringBuffer(Y41bConstantes.NUM_1000);
		HashMap<String, String> datos = null;
		stablaDoc.append("\\\\par ");
		for (int i = 0; i < horas.size(); i++) {
			datos = horas.get(i);
			stablaDoc
					.append("\\\\b ")
					.append(this.appMessageSource.getMessage(
							"arbitraje.audiencia.hora", null, locale))
					.append(": ").append((String) datos.get("hora"));
			stablaDoc.append("\\\\par ");
			stablaDoc
					.append(this.appMessageSource.getMessage(
							"arbitraje.audiencia.numExpediente", null, locale))
					.append(": ")
					.append((String) datos.get("expediente"))
					.append("   -   ")
					.append((String) datos.get("audiencia"))
					.append("\\\\'aa ")
					.append(this.appMessageSource.getMessage(
							"arbitraje.audiencia.audiencia", null, locale))
					.append("\\\\b0 ").append("\\\\par ");
			stablaDoc
					.append("\\\\tab ")
					.append(this.appMessageSource.getMessage(
							"arbitraje.audiencia.secretario", null, locale))
					.append("\\\\tab ")
					.append(this.aniadirResaltado(calendarioPintado,
							Y41bConstantes.TIPO_INTERVINIENTEARB_SECRETARIO,
							(String) datos.get("secretario"),
							(String) datos.get("secretarioId")))
					.append("\\\\par ");
			stablaDoc
					.append("\\\\tab ")
					.append(this.appMessageSource.getMessage(
							"arbitraje.audiencia.reclamante", null, locale))
					.append("\\\\tab ")
					.append(this.aniadirResaltado(calendarioPintado,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE,
							(String) datos.get("reclamante"),
							(String) datos.get("reclamanteId")))
					.append("\\\\par ");
			stablaDoc
					.append("\\\\tab ")
					.append(this.appMessageSource.getMessage(
							"arbitraje.audiencia.reclamado", null, locale))
					.append("\\\\tab ")
					.append(this.aniadirResaltado(calendarioPintado,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO,
							(String) datos.get("reclamado"),
							(String) datos.get("reclamadoId")))
					.append("\\\\par ");
			stablaDoc
					.append("\\\\tab ")
					.append(this.appMessageSource.getMessage(
							"arbitraje.audiencia.arbitroP", null, locale))
					.append("\\\\tab ")
					.append(this.aniadirResaltado(calendarioPintado,
							Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO,
							(String) datos.get("arbitroP"),
							(String) datos.get("arbitroPId")))
					.append("\\\\par ");
			stablaDoc
					.append("\\\\tab ")
					.append(this.appMessageSource.getMessage(
							"arbitraje.audiencia.arbitroC", null, locale))
					.append("\\\\tab ")
					.append(this.aniadirResaltado(calendarioPintado,
							Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO,
							(String) datos.get("arbitroC"),
							(String) datos.get("arbitroCId")))
					.append("\\\\par ");
			stablaDoc
					.append("\\\\tab ")
					.append(this.appMessageSource.getMessage(
							"arbitraje.audiencia.arbitroE", null, locale))
					.append("\\\\tab ")
					.append(this.aniadirResaltado(calendarioPintado,
							Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO,
							(String) datos.get("arbitroE"),
							(String) datos.get("arbitroEId")))
					.append("\\\\par ");
			stablaDoc.append("\\\\tab  \\\\tab  \\\\par");
			stablaDoc.append("\\\\par ");
		}
		return stablaDoc.toString();
	}

	private String aniadirResaltado(
			ArrayList<HashMap<String, String>> calendarioPintado, String tipo,
			String nombre, String codigo) {
		String cadena = nombre;

		ArrayList<String> coloresCalendario = new ArrayList<String>();
		// 7 Yellow 4 Green 3 Cyan 5 Magenta 6 Red

		if (calendarioPintado != null && !Y41bUtils.esNullOCadenaVacia(codigo)) {
			coloresCalendario.add("rgb(255,255,0)");
			coloresCalendario.add("rgb(0,255,0)");
			coloresCalendario.add("rgb(0,255,255)");
			coloresCalendario.add("rgb(255,0,255)");
			coloresCalendario.add("rgb(255,0,0)");
			String[] coloresRTF = new String[] { "7", "4", "3", "5", "6" };
			HashMap<String, String> dato = null;
			String color = "";
			for (int i = 0; i < calendarioPintado.size(); i++) {
				dato = calendarioPintado.get(i);
				if (((String) dato.get("codigo")).equals(codigo)
						&& ((String) dato.get("tipo")).equals(tipo)) {
					color = ((String) dato.get("color")).replaceAll(" ", "");
					int indice = coloresCalendario.indexOf(color);
					if (indice > -1) {
						cadena = "{\\\\highlight".concat(coloresRTF[indice])
								.concat(nombre).concat("}");
					}
					break;
				}
			}
		}

		return cadena.toString();
	}
}
