package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.AlertaProgramacion;
import com.ejie.y41b.service.AlertaProgramacionService;

/**
 * AlertaProgramacionController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/alertaprogramacion")
public class AlertaProgramacionController {

	private static final Logger logger = LoggerFactory
			.getLogger(AlertaProgramacionController.class);

	@Autowired
	private AlertaProgramacionService alertaProgramacionService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AlertaProgramacionController.logger
				.info("[GET - View] : alertaprogramacion");
		return "alertaprogramacion";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param crcodigo
	 *            String
	 * @return alertaProgramacion AlertaProgramacion
	 */
	@RequestMapping(value = "/{crcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	AlertaProgramacion getById(@PathVariable String crcodigo) {
		AlertaProgramacion alertaProgramacion = new AlertaProgramacion();
		alertaProgramacion.setCrcodigo(crcodigo);
		alertaProgramacion = this.alertaProgramacionService
				.find(alertaProgramacion);
		AlertaProgramacionController.logger
				.info("[GET - findBy_PK] : Obtener AlertaProgramacion por PK");
		return alertaProgramacion;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterAlertaProgramacion
	 *            AlertaProgramacion
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<AlertaProgramacion> getAll(
			@ModelAttribute AlertaProgramacion filterAlertaProgramacion) {
		AlertaProgramacionController.logger
				.info("[GET - find_ALL] : Obtener AlertaProgramacion por filtro");
		return this.alertaProgramacionService.findAll(filterAlertaProgramacion,
				null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	AlertaProgramacion edit(@RequestBody AlertaProgramacion alertaProgramacion) {
		AlertaProgramacion alertaProgramacionAux = this.alertaProgramacionService
				.update(alertaProgramacion);
		AlertaProgramacionController.logger
				.info("[PUT] : AlertaProgramacion actualizado correctamente");
		return alertaProgramacionAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	AlertaProgramacion add(@RequestBody AlertaProgramacion alertaProgramacion) {
		AlertaProgramacion alertaProgramacionAux = this.alertaProgramacionService
				.add(alertaProgramacion);
		AlertaProgramacionController.logger
				.info("[POST] : AlertaProgramacion insertado correctamente");
		return alertaProgramacionAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param crcodigo
	 *            String
	 * @return alertaProgramacion
	 */
	@RequestMapping(value = "/{crcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	AlertaProgramacion remove(@PathVariable String crcodigo) {
		AlertaProgramacion alertaProgramacion = new AlertaProgramacion();
		alertaProgramacion.setCrcodigo(crcodigo);
		this.alertaProgramacionService.remove(alertaProgramacion);
		AlertaProgramacionController.logger
				.info("[DELETE] : AlertaProgramacion borrado correctamente");
		return alertaProgramacion;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param alertaProgramacionIds
	 *            List
	 * @return alertaProgramacionList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> alertaProgramacionIds) {
		List<AlertaProgramacion> alertaProgramacionList = new ArrayList<AlertaProgramacion>();
		for (List<String> alertaProgramacionId : alertaProgramacionIds) {
			Iterator<String> iterator = alertaProgramacionId.iterator();
			AlertaProgramacion alertaProgramacion = new AlertaProgramacion(); // NOPMD
																				// -
																				// Objeto
																				// nuevo
																				// en
																				// la
																				// lista
																				// (parametro
																				// del
																				// servicio)
			alertaProgramacion.setCrcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			alertaProgramacionList.add(alertaProgramacion);
		}
		this.alertaProgramacionService.removeMultiple(alertaProgramacionList);
		AlertaProgramacionController.logger
				.info("[POST - DELETE_ALL] : AlertaProgramacion borrados correctamente");
		return alertaProgramacionIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterAlertaProgramacion
	 *            AlertaProgramacion
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute AlertaProgramacion filterAlertaProgramacion,
			@ModelAttribute Pagination pagination) {
		List<AlertaProgramacion> alertaProgramacions = this.alertaProgramacionService
				.findAll(filterAlertaProgramacion, pagination);
		Long recordNum = this.alertaProgramacionService
				.findAllCount(filterAlertaProgramacion);
		AlertaProgramacionController.logger
				.info("[GET - jqGrid] : Obtener AlertaProgramacion");
		return new JQGridJSONModel(pagination, recordNum, alertaProgramacions);
	}

	/**
	 * Method 'getProgramaciones'.
	 * 
	 * @param alcodigo
	 *            identificador de la alerta
	 * @return alertaProgramacionList
	 */
	@RequestMapping(value = "/programaciones", method = RequestMethod.GET)
	public @ResponseBody()
	List<AlertaProgramacion> getProgramaciones(
			@RequestParam(value = "alcodigo", required = false) String alcodigo) {

		if (alcodigo != null && !alcodigo.equals("")) {
			AlertaProgramacion filterAlertaProgramacion = new AlertaProgramacion();
			Alerta alerta = new Alerta();
			alerta.setAlcodigo(alcodigo);
			filterAlertaProgramacion.setAlerta(alerta);
			return this.alertaProgramacionService.findAll(
					filterAlertaProgramacion, null);
		} else {
			return (List<AlertaProgramacion>) new ArrayList<AlertaProgramacion>();
		}
	}

}
