package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AdjuntarAlertaprogra;
import com.ejie.y41b.model.AdjuntarDistribuidor;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.AlertaProgramacion;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.PlantillaControlMercadoDetalle;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteBusqueda;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.service.AdjuntarAlertaprograService;
import com.ejie.y41b.service.AdjuntarDistribuidorService;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.AlertaService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.PlantillaTramiteService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AlertaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/alerta")
@SessionAttributes({ "codAlerta", "modoBusquedaAlerta", "modoAlerta", "alertaBusqueda", "codProgramacion",
		"modoAlertaProgramacion" })
public class AlertaController {

	private static final Logger logger = LoggerFactory.getLogger(AlertaController.class);

	@Autowired
	private AlertaService alertaService;
	@Autowired
	private AdjuntarDistribuidorService adjuntarDistribuidorService;
	@Autowired
	private AdjuntardocsService adjuntardocsService;
	@Autowired
	private AdjuntarAlertaprograService adjuntarAlertaprograService;
	@Autowired
	private DenunciaService denunciaService;
	@Autowired
	private Y41bExcelGeneratorService y41bExcelGeneratorService;
	@Autowired
	private PlantillaTramiteService plantillaTramiteService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "alertas", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaAlerta", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Alerta alerta = new Alerta();
		alerta.setAlactiva(Y41bConstantes.VALOR_SI);
		model.addAttribute("alertaBusqueda", alerta);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("alertas", "model", model);
		}
	}

	/**
	 * Metodo que evita que la llamada a 'alertasBusquedaConPrecarga' devuelva
	 * una excepcion variable de sesion. Si no existe, entra aqui y la crea. Si
	 * ya existe, Spring ignora este metodo.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return Alerta
	 */
	@ModelAttribute(value = "alertaBusqueda")
	public Alerta getAlerta(HttpServletRequest request) {
		return new Alerta();
	}

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "alertasBusquedaConPrecarga", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlertasBusquedaConPrecarga(Model model,
			@ModelAttribute(value = "alertaBusqueda") Alerta alerta, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaAlerta", "");

		model.addAttribute("alertaBusqueda", alerta);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("alertas", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionAlerta", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaAlerta", Y41bConstantes.MODO_POPUP_SELECCION);
		if (!model.containsAttribute("vieneDe")) {
			model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BUSQUEDA);
		}

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("seleccionAlerta", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormAltaAlerta'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaAlerta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaAlerta(Model model, HttpServletRequest request) {
		model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BANDEJAS);
		return this.getCreateFormAltaAlertaBusqueda(model, request);
	}

	/**
	 * Method 'getCreateFormAltaAlertaBusqueda'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "alertasBusquedaConPrecarga/altaAlerta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaAlertaBusqueda(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codAlerta", Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoAlerta", Y41bConstantes.MODO_POPUP_ALTA);
		if (!model.containsAttribute("vieneDe")) {
			model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BUSQUEDA);
		}

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("alertaDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModAlerta'.
	 * 
	 * @param codAlerta_
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "alertasBusquedaConPrecarga/modAlerta", method = RequestMethod.GET)
	public ModelAndView getCreateFormModAlerta(@RequestParam(value = "codAlerta", required = false) String codAlerta_,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (codAlerta_ != null) {
			model.addAttribute("codAlerta", codAlerta_);

			Alerta alerta = new Alerta();
			alerta.setAlcodigo(codAlerta_);

			this.adjuntarAlertaprograService.addAlertaprograTableTemporal(alerta);
			this.adjuntardocsService.addDocsTableTemporal(codAlerta_);
		}
		model.addAttribute("modoAlerta", Y41bConstantes.MODO_POPUP_MODIFICACION);
		if (!model.containsAttribute("vieneDe")) {
			model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BUSQUEDA);
		}

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("alertaDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModAlertaBandeja'.
	 * 
	 * @param codAlerta_
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "detalleAlerta", method = RequestMethod.GET)
	public ModelAndView getCreateFormModAlertaBandeja(
			@RequestParam(value = "codAlerta", required = false) String codAlerta_, Model model,
			HttpServletRequest request) {
		model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BANDEJAS);
		return this.getCreateFormModAlerta(codAlerta_, model, request);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param alcodigo_
	 *            String
	 * @return alerta Alerta
	 */
	@RequestMapping(value = "findAlerta", method = RequestMethod.GET)
	public @ResponseBody Alerta getAlertaById(@RequestParam(value = "alcodigo", required = false) String alcodigo_) {
		Alerta alerta = new Alerta();
		alerta.setAlcodigo(alcodigo_);
		alerta = this.alertaService.find(alerta);
		AlertaController.logger.info("[GET - findBy_PK] : Obtener Alerta por PK");
		return alerta;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterAlerta
	 *            Alerta
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Alerta> getAll(@ModelAttribute Alerta filterAlerta) {
		AlertaController.logger.info("[GET - find_ALL] : Obtener Alerta por filtro");
		return this.alertaService.findAll(filterAlerta, null);
	}

	/**
	 * Method 'getAllAlertas'.
	 * 
	 * @param alcoor_
	 *            String
	 * @param alcoca_
	 *            String
	 * @param alcopa_
	 *            String
	 * @param alaecosan_
	 *            String
	 * @param alnror_
	 *            String
	 * @param alnran_
	 *            String
	 * @param alfeenDesde_
	 *            String
	 * @param alfeenHasta_
	 *            String
	 * @param alfeComunicacionDesde_
	 *            String
	 * @param alfeComunicacionHasta_
	 *            String
	 * @param alfePlazoDesde_
	 *            String
	 * @param alfePlazoHasta_
	 *            String
	 * @param alcops_
	 *            String
	 * @param alnoprse_
	 *            String
	 * @param alnomaps_
	 *            String
	 * @param alnomops_
	 *            String
	 * @param alcodigobarras_
	 *            String
	 * @param escodigo_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param alanulada_
	 *            String
	 * @param alactiva_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/findAllAlertas", method = RequestMethod.GET)
	public @ResponseBody Object getAllAlertas(@RequestParam(value = "alcoor", required = false) String alcoor_,
			@RequestParam(value = "alcoca", required = false) String alcoca_,
			@RequestParam(value = "alcopa", required = false) String alcopa_,
			@RequestParam(value = "alaecosan", required = false) String alaecosan_,
			@RequestParam(value = "alnror", required = false) String alnror_,
			@RequestParam(value = "alnran", required = false) String alnran_,
			@RequestParam(value = "alfeenDesde", required = false) String alfeenDesde_,
			@RequestParam(value = "alfeenHasta", required = false) String alfeenHasta_,
			@RequestParam(value = "alfeComunicacionDesde", required = false) String alfeComunicacionDesde_,
			@RequestParam(value = "alfeComunicacionHasta", required = false) String alfeComunicacionHasta_,
			@RequestParam(value = "alfePlazoDesde", required = false) String alfePlazoDesde_,
			@RequestParam(value = "alfePlazoHasta", required = false) String alfePlazoHasta_,
			@RequestParam(value = "alcops", required = false) String alcops_,
			@RequestParam(value = "alnoprse", required = false) String alnoprse_,
			@RequestParam(value = "alnomaps", required = false) String alnomaps_,
			@RequestParam(value = "alnomops", required = false) String alnomops_,
			@RequestParam(value = "alcodigobarras", required = false) String alcodigobarras_,
			@RequestParam(value = "escodigo", required = false) String escodigo_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "alanulada", required = false) String alanulada_,
			@RequestParam(value = "alactiva", required = false) String alactiva_, HttpServletRequest request,
			Model model) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date alfeenDesde = Y41bUtils.parseDate(alfeenDesde_, locale);
			Date alfeenHasta = Y41bUtils.parseDate(alfeenHasta_, locale);

			Date alfeComunicacionDesde = Y41bUtils.parseDate(alfeComunicacionDesde_, locale);
			Date alfeComunicacionHasta = Y41bUtils.parseDate(alfeComunicacionHasta_, locale);

			Date alfePlazoDesde = Y41bUtils.parseDate(alfePlazoDesde_, locale);
			Date alfePlazoHasta = Y41bUtils.parseDate(alfePlazoHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String alcoor = ("".equals(alcoor_)) ? null : alcoor_;
			String alcoca = ("".equals(alcoca_)) ? null : alcoca_;
			String alcopa = ("".equals(alcopa_)) ? null : alcopa_;
			String alaecosan = ("".equals(alaecosan_)) ? null : alaecosan_;
			String alnror = ("".equals(alnror_)) ? null : alnror_;
			String alnran = ("".equals(alnran_)) ? null : alnran_;
			String alcops = ("".equals(alcops_)) ? null : alcops_;
			String alnoprse = ("".equals(alnoprse_)) ? null : alnoprse_;
			String alnomaps = ("".equals(alnomaps_)) ? null : alnomaps_;
			String alnomops = ("".equals(alnomops_)) ? null : alnomops_;
			String alcodigobarras = ("".equals(alcodigobarras_)) ? null : alcodigobarras_;
			String escodigo = ("".equals(escodigo_)) ? null : escodigo_;
			String esnif = ("".equals(esnif_)) ? null : esnif_;
			String esnombre = ("".equals(esnombre_)) ? null : esnombre_;

			// control checks
			String alanulada = ("on".equals(alanulada_)) ? Y41bConstantes.VALOR_SI : null;
			String alactiva = ("on".equals(alactiva_)) ? Y41bConstantes.VALOR_SI : null;

			Alerta filterAlerta = new Alerta();

			filterAlerta.setAlcoor(alcoor);
			if (alcoor != null && alcoor.equals(Y41bConstantes.ORIGEN_ALERTA_CE)) {
				filterAlerta.setAlcopa(alcopa);
			} else if (alcoor != null && alcoor.equals(Y41bConstantes.ORIGEN_ALERTA_CCAA)) {
				filterAlerta.setAlcoca(alcoca);
			} else if (alcoor != null && alcoor.equals(Y41bConstantes.ORIGEN_ALERTA_INC)) {
				filterAlerta.setAlaecosan(alaecosan);
			}

			filterAlerta.setAlnror(alnror);
			if (alnran != null) {
				filterAlerta.setAlnran(new Long(alnran));
			} else {
				filterAlerta.setAlnran(null);
			}
			filterAlerta.setAlcops(alcops);
			filterAlerta.setAlnoprse(alnoprse);
			filterAlerta.setAlnomaps(alnomaps);
			filterAlerta.setAlnomops(alnomops);
			filterAlerta.setAlcodigobarras(alcodigobarras);

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(escodigo);
			establecimiento.setEsnif(esnif);
			establecimiento.setEsnombre(esnombre);
			filterAlerta.setEstablecimiento(establecimiento);

			filterAlerta.setAlfeenDesde(alfeenDesde);
			filterAlerta.setAlfeenHasta(alfeenHasta);
			filterAlerta.setAlfeComunicacionDesde(alfeComunicacionDesde);
			filterAlerta.setAlfeComunicacionHasta(alfeComunicacionHasta);
			filterAlerta.setAlfePlazoDesde(alfePlazoDesde);
			filterAlerta.setAlfePlazoHasta(alfePlazoHasta);

			filterAlerta.setAlfeenDesdeStr(alfeenDesde_);
			filterAlerta.setAlfeenHastaStr(alfeenHasta_);
			filterAlerta.setAlfeComunicacionDesdeStr(alfeComunicacionDesde_);
			filterAlerta.setAlfeComunicacionHastaStr(alfeComunicacionHasta_);
			filterAlerta.setAlfePlazoDesdeStr(alfePlazoDesde_);
			filterAlerta.setAlfePlazoHastaStr(alfePlazoHasta_);

			filterAlerta.setAlanulada(alanulada);
			filterAlerta.setAlactiva(alactiva);

			model.addAttribute("alertaBusqueda", filterAlerta);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Alerta> alertas = this.alertaService.findAllLike(filterAlerta, pagination, false);

				if (alertas == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.alertaService.findAllLikeCount(filterAlerta, false);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(alertas);
				return data;
			} else {
				List<Alerta> alertas = this.alertaService.findAllLike(filterAlerta, pagination, false);
				if (alertas == null) {
					throw new Exception("No data Found.");
				}
				return alertas;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Alerta edit(@RequestBody Alerta alerta) {
		Alerta alertaAux = this.alertaService.update(alerta);
		AlertaController.logger.info("[PUT] : Alerta actualizado correctamente");
		return alertaAux;
	}

	/**
	 * Method 'guardarAlerta'.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param codAlertaAlta
	 *            String
	 * @param modoAlerta
	 *            String
	 * @param model
	 *            Model
	 * @return Alerta
	 */
	@RequestMapping(value = "/guardarAlerta", method = RequestMethod.POST)
	public @ResponseBody Alerta guardarAlerta(@RequestBody Alerta alerta,
			@ModelAttribute(value = "codAlerta") String codAlertaAlta,
			@ModelAttribute(value = "modoAlerta") String modoAlerta, Model model) {
		try {

			Alerta alertaAux;
			if (modoAlerta != null && modoAlerta.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
				alertaAux = this.alertaService.updateAlerta(alerta);
				alertaAux.setModoAlerta(Y41bConstantes.MODO_POPUP_MODIFICACION);
			} else {
				alertaAux = this.alertaService.addAlerta(alerta, codAlertaAlta);

				alertaAux.setModoAlerta(Y41bConstantes.MODO_POPUP_ALTA);
			}
			model.addAttribute("modoAlerta", Y41bConstantes.MODO_POPUP_MODIFICACION);

			logger.info("Entity correctly inserted!");
			return alertaAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'importXML'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return Alerta
	 */
	@RequestMapping(value = "/importXML", method = RequestMethod.POST)
	public @ResponseBody Alerta importXML(@RequestParam(value = "files[]", required = false) MultipartFile file,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			Alerta alerta = this.alertaService.procesarFichero(file.getBytes());

			logger.info("Entity correctly inserted!");

			return alerta;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Alerta add(@RequestBody Alerta alerta) {
		Alerta alertaAux = this.alertaService.add(alerta);
		AlertaController.logger.info("[POST] : Alerta insertado correctamente");
		return alertaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param alcodigo
	 *            String
	 * @return alerta
	 */
	@RequestMapping(value = "/{alcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Alerta remove(@PathVariable String alcodigo) {
		Alerta alerta = new Alerta();
		alerta.setAlcodigo(alcodigo);
		this.alertaService.remove(alerta);
		AlertaController.logger.info("[DELETE] : Alerta borrado correctamente");
		return alerta;
	}

	/**
	 * Method 'removeAlerta'.
	 * 
	 * @param alcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeAlerta/{alcodigo}", method = RequestMethod.DELETE)
	public void removeAlerta(@PathVariable String alcodigo, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Alerta alerta = new Alerta();
			alerta.setAlcodigo(alcodigo);
			this.alertaService.removeAlerta(alerta);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + alcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param alertaIds
	 *            List
	 * @return alertaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> alertaIds) {
		List<Alerta> alertaList = new ArrayList<Alerta>();
		for (List<String> alertaId : alertaIds) {
			Iterator<String> iterator = alertaId.iterator();
			Alerta alerta = new Alerta(); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			alerta.setAlcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
			alertaList.add(alerta);
		}
		this.alertaService.removeMultiple(alertaList);
		AlertaController.logger.info("[POST - DELETE_ALL] : Alerta borrados correctamente");
		return alertaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterAlerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Alerta filterAlerta,
			@ModelAttribute Pagination pagination) {
		List<Alerta> alertas = this.alertaService.findAll(filterAlerta, pagination);
		Long recordNum = this.alertaService.findAllCount(filterAlerta);
		AlertaController.logger.info("[GET - jqGrid] : Obtener Alerta");
		return new JQGridJSONModel(pagination, recordNum, alertas);
	}

	/**
	 * Method 'getAllAlertaDistribuidor'.
	 * 
	 * @param codAlerta
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllAlertaDistribuidor", method = RequestMethod.GET)
	public @ResponseBody Object getAllAlertaDistribuidor(@ModelAttribute(value = "codAlerta") String codAlerta,
			HttpServletRequest request) {
		try {
			AdjuntarDistribuidor adjuntarDistribuidor = new AdjuntarDistribuidor();
			adjuntarDistribuidor.setRdcoal(codAlerta);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));

				String orderBy = request.getParameter("sidx");
				if ("nombreMunicipio".equals(orderBy)) {
					orderBy = "nombre_municipio";
				} else if ("nombreProvincia".equals(orderBy)) {
					orderBy = "nombre_provincia";
				}

				pagination.setSort(orderBy);
				pagination.setAscDsc(request.getParameter("sord"));

				List<AdjuntarDistribuidor> listAdjuntarDistribuidor = null;

				listAdjuntarDistribuidor = this.adjuntarDistribuidorService.findAll(adjuntarDistribuidor, pagination);

				if (listAdjuntarDistribuidor == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntarDistribuidorService.findAllCount(adjuntarDistribuidor);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntarDistribuidor);
				return data;
			} else {
				List<AdjuntarDistribuidor> listAdjuntarDistribuidor = null;

				listAdjuntarDistribuidor = this.adjuntarDistribuidorService.findAll(adjuntarDistribuidor, pagination);

				if (listAdjuntarDistribuidor == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntarDistribuidor;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addAlertaDistribuidor'.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @param codAlertaAlta
	 *            String
	 * @return AdjuntarDistribuidor
	 */
	@RequestMapping(value = "/addAlertaDistribuidor", method = RequestMethod.POST)
	public @ResponseBody AdjuntarDistribuidor addAlertaDistribuidor(
			@RequestBody AdjuntarDistribuidor adjuntarDistribuidor,
			@ModelAttribute(value = "codAlerta") String codAlertaAlta) {
		try {
			AdjuntarDistribuidor adjuntarDistribuidorAux = this.adjuntarDistribuidorService
					.addAlertaDistribuidor(adjuntarDistribuidor, codAlertaAlta);
			logger.info("Entity correctly inserted!");
			return adjuntarDistribuidorAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editAlertaFabricanteDistribuidor'.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @param response
	 *            HttpServletResponse
	 * @return AdjuntarDistribuidor
	 */
	@RequestMapping(value = "/updateAlertaFabricanteDistribuidor", method = RequestMethod.PUT)
	public @ResponseBody AdjuntarDistribuidor editAlertaFabricanteDistribuidor(
			@RequestBody AdjuntarDistribuidor adjuntarDistribuidor, HttpServletResponse response) {
		try {
			AdjuntarDistribuidor adjuntarDistribuidorAux = this.adjuntarDistribuidorService
					.updateAlertaFabricanteDistribuidor(adjuntarDistribuidor);
			logger.info("Entity correctly inserted!");
			return adjuntarDistribuidorAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAlertaDistribuidor'.
	 * 
	 * @param rdcodigo
	 *            String
	 * @param codAlerta
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarAlertaDistribuidor/{rdcodigo}", method = RequestMethod.DELETE)
	public void removeAlertaDistribuidor(@PathVariable String rdcodigo,
			@ModelAttribute(value = "codAlerta") String codAlerta, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			AdjuntarDistribuidor adjuntarDistribuidor = new AdjuntarDistribuidor();
			adjuntarDistribuidor.setRdcodigo(rdcodigo);
			adjuntarDistribuidor.setRdcoal(codAlerta);

			this.adjuntarDistribuidorService.remove(adjuntarDistribuidor);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllAlertaDocs'.
	 * 
	 * @param codAlerta
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllAlertaDocs", method = RequestMethod.GET)
	public @ResponseBody Object getAllAlertaDocs(@ModelAttribute(value = "codAlerta") String codAlerta,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidExpediente(codAlerta);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoAlerta'.
	 * 
	 * @param iddocumento
	 *            String
	 * @param codAlertaAlta
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findAlertaDocumento/{iddocumento}", method = RequestMethod.GET)
	public @ResponseBody void getByIdDocumentoAlerta(@PathVariable String iddocumento,
			@ModelAttribute(value = "codAlerta") String codAlertaAlta, HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThcodocumento(iddocumento);
			adjuntardocsAux.setThidTramite(codAlertaAlta);

			adjuntardocsAux = this.adjuntardocsService.findDocByPK(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addAlertaDocs'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param codAlertaAlta
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/addAlertaDocs", method = RequestMethod.POST)
	public @ResponseBody List<Map<String, Object>> addAlertaDocs(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "codAlerta") String codAlertaAlta, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String tedesfile = request.getParameter("tedesfile");

			adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

			Blob blob = new SerialBlob(file.getBytes());
			adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(codAlertaAlta);
			adjuntardocsAux.setThidTramite(codAlertaAlta);

			adjuntardocsAux.setThtedesfile(tedesfile);

			adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			adjuntardocsAux.setTipoProcedimiento(tipoProcedimiento);

			adjuntardocsAux.setThfecha(new Date());

			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/alerta/addAlertaDocs/" + file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41bVistaWar/alerta/addAlertaDocs/" + file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'removeAlertaDocs'.
	 * 
	 * @param iddocumento
	 *            String
	 * @param codAlerta
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarAlertaDocs/{iddocumento}", method = RequestMethod.DELETE)
	public void removeAlertaDocs(@PathVariable String iddocumento,
			@ModelAttribute(value = "codAlerta") String codAlerta, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThcodocumento(iddocumento);

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllAlertaProgramacion'.
	 * 
	 * @param codAlerta
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllAlertaProgramacion", method = RequestMethod.GET)
	public @ResponseBody Object getAllAlertaProgramacion(@ModelAttribute(value = "codAlerta") String codAlerta,
			HttpServletRequest request) {
		try {
			AdjuntarAlertaprogra adjuntarAlertaprogra = new AdjuntarAlertaprogra();
			adjuntarAlertaprogra.setCrcoal(codAlerta);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));

				String orderBy = request.getParameter("sidx");
				if ("tipoCaracterAlerta.tcanombree".equals(orderBy)) {
					orderBy = "tipocaracteralertatcanombree";
				} else if ("tipoCaracterAlerta.tcanombre".equals(orderBy)) {
					orderBy = "tipocaracteralertatcanombre";
				}
				pagination.setSort(orderBy);
				pagination.setAscDsc(request.getParameter("sord"));

				List<AdjuntarAlertaprogra> listAdjuntarAlertaprogra = null;

				listAdjuntarAlertaprogra = this.adjuntarAlertaprograService.findAll(adjuntarAlertaprogra, pagination);

				if (listAdjuntarAlertaprogra == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntarAlertaprograService.findAllCount(adjuntarAlertaprogra);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntarAlertaprogra);
				return data;
			} else {
				List<AdjuntarAlertaprogra> listAdjuntarAlertaprogra = null;

				listAdjuntarAlertaprogra = this.adjuntarAlertaprograService.findAll(adjuntarAlertaprogra, pagination);

				if (listAdjuntarAlertaprogra == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntarAlertaprogra;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAlertaProgramacionById'.
	 * 
	 * @param crcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "findAlertaProgramacion/{crcodigo}", method = RequestMethod.GET)
	public @ResponseBody AdjuntarAlertaprogra getAlertaProgramacionById(@PathVariable String crcodigo) {
		try {
			AdjuntarAlertaprogra adjuntarAlertaprogra = new AdjuntarAlertaprogra();
			adjuntarAlertaprogra.setCrcodigo(crcodigo);

			adjuntarAlertaprogra = this.adjuntarAlertaprograService.find(adjuntarAlertaprogra);
			if (adjuntarAlertaprogra == null) {
				throw new Exception(crcodigo);
			}
			return adjuntarAlertaprogra;
		} catch (Exception e) {
			throw new ResourceNotFoundException(crcodigo);
		}
	}

	/**
	 * Method 'addAlertaProgramacion'.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param codAlertaAlta
	 *            String
	 * @param codProgramacion
	 *            String
	 * @param modoAlertaProgramacion
	 *            String
	 * @param model
	 *            Model
	 * @return AdjuntarAlertaprogra
	 */
	@RequestMapping(value = "/addAlertaProgramacion", method = RequestMethod.POST)
	public @ResponseBody AdjuntarAlertaprogra addAlertaProgramacion(
			@RequestBody AdjuntarAlertaprogra adjuntarAlertaprogra,
			@ModelAttribute(value = "codAlerta") String codAlertaAlta,
			@ModelAttribute(value = "codProgramacion") String codProgramacion,
			@ModelAttribute(value = "modoAlertaProgramacion") String modoAlertaProgramacion, Model model) {
		try {

			AdjuntarAlertaprogra adjuntarAlertaprograAux = null;
			if (modoAlertaProgramacion != null
					&& modoAlertaProgramacion.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
				adjuntarAlertaprogra.setCrcodigo(codProgramacion);
				adjuntarAlertaprograAux = this.adjuntarAlertaprograService.updateAlertaprogra(adjuntarAlertaprogra,
						codAlertaAlta);
			} else {
				adjuntarAlertaprogra.setCrcodigo(codProgramacion);
				adjuntarAlertaprograAux = this.adjuntarAlertaprograService.addAlertaprogra(adjuntarAlertaprogra,
						codAlertaAlta);
			}

			model.addAttribute("modoAlertaProgramacion", Y41bConstantes.MODO_POPUP_MODIFICACION);
			logger.info("Entity correctly inserted!");
			return adjuntarAlertaprograAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'updateNumProgramacionesAlertaProgramacion'.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param codAlertaAlta
	 *            String
	 * @param codProgramacion
	 *            String
	 * @param modoAlertaProgramacion
	 *            String
	 * @param model
	 *            Model
	 * @return AdjuntarAlertaprogra
	 */
	@RequestMapping(value = "/updateNumProgramacionesAlertaProgramacion", method = RequestMethod.POST)
	public @ResponseBody AdjuntarAlertaprogra updateNumProgramacionesAlertaProgramacion(
			@RequestBody AdjuntarAlertaprogra adjuntarAlertaprogra,
			@ModelAttribute(value = "codAlerta") String codAlertaAlta,
			@ModelAttribute(value = "codProgramacion") String codProgramacion,
			@ModelAttribute(value = "modoAlertaProgramacion") String modoAlertaProgramacion, Model model) {
		try {

			AdjuntarAlertaprogra adjuntarAlertaprograAux = null;
			adjuntarAlertaprogra.setCrcodigo(codProgramacion);
			adjuntarAlertaprograAux = this.adjuntarAlertaprograService
					.updateNumProgramacionesAlertaProgramacion(adjuntarAlertaprogra, codAlertaAlta);

			model.addAttribute("modoAlertaProgramacion", Y41bConstantes.MODO_POPUP_MODIFICACION);
			logger.info("Entity correctly inserted!");
			return adjuntarAlertaprograAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAlertaProgramacion'.
	 * 
	 * @param crcodigo
	 *            String
	 * @param codAlerta
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarAlertaProgramacion/{crcodigo}", method = RequestMethod.DELETE)
	public void removeAlertaProgramacion(@PathVariable String crcodigo,
			@ModelAttribute(value = "codAlerta") String codAlerta, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			AdjuntarAlertaprogra adjuntarAlertaprogra = new AdjuntarAlertaprogra();
			adjuntarAlertaprogra.setCrcodigo(crcodigo);

			this.adjuntarAlertaprograService.remove(adjuntarAlertaprogra);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getCreateFormMaintY41bAlertaDetalleProgramacion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bAlertaDetalle_Programacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormMaintY41bAlertaDetalleProgramacion(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		model.addAttribute("codProgramacion", Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		model.addAttribute("modoAlertaProgramacion", Y41bConstantes.MODO_POPUP_ALTA);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("alertaDetalle_Programacion", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormMaintY41bAlertaDetalleProgramacion'.
	 * 
	 * @param crcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bAlertaDetalle_ProgramacionMod/{crcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMaintY41bAlertaDetalleProgramacion(@PathVariable() String crcodigo, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		model.addAttribute("codProgramacion", crcodigo);
		model.addAttribute("modoAlertaProgramacion", Y41bConstantes.MODO_POPUP_MODIFICACION);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("alertaDetalle_Programacion", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormMaintY41bAlertaDetalleProgramacion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bAlertaDetalle_Importar", method = RequestMethod.GET)
	public ModelAndView getCreateFormMaintY41bAlertaDetalleImportar(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("alertaDetalle_ImportarXml", "model", model);
		}
	}

	/**
	 * Method 'getAllAlertasExcel'.
	 * 
	 * @param alcoor_
	 *            String
	 * @param alcoca_
	 *            String
	 * @param alcopa_
	 *            String
	 * @param alaecosan_
	 *            String
	 * @param alnror_
	 *            String
	 * @param alnran_
	 *            String
	 * @param alfeenDesde_
	 *            String
	 * @param alfeenHasta_
	 *            String
	 * @param alfeComunicacionDesde_
	 *            String
	 * @param alfeComunicacionHasta_
	 *            String
	 * @param alfePlazoDesde_
	 *            String
	 * @param alfePlazoHasta_
	 *            String
	 * @param alcops_
	 *            String
	 * @param alnoprse_
	 *            String
	 * @param alnomaps_
	 *            String
	 * @param alnomops_
	 *            String
	 * @param alcodigobarras_
	 *            String
	 * @param escodigo_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param alanulada_
	 *            String
	 * @param alactiva_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllAlertasExcel(@RequestParam(value = "alcoor", required = false) String alcoor_,
			@RequestParam(value = "alcoca", required = false) String alcoca_,
			@RequestParam(value = "alcopa", required = false) String alcopa_,
			@RequestParam(value = "alaecosan", required = false) String alaecosan_,
			@RequestParam(value = "alnror", required = false) String alnror_,
			@RequestParam(value = "alnran", required = false) String alnran_,
			@RequestParam(value = "alfeenDesde", required = false) String alfeenDesde_,
			@RequestParam(value = "alfeenHasta", required = false) String alfeenHasta_,
			@RequestParam(value = "alfeComunicacionDesde", required = false) String alfeComunicacionDesde_,
			@RequestParam(value = "alfeComunicacionHasta", required = false) String alfeComunicacionHasta_,
			@RequestParam(value = "alfePlazoDesde", required = false) String alfePlazoDesde_,
			@RequestParam(value = "alfePlazoHasta", required = false) String alfePlazoHasta_,
			@RequestParam(value = "alcops", required = false) String alcops_,
			@RequestParam(value = "alnoprse", required = false) String alnoprse_,
			@RequestParam(value = "alnomaps", required = false) String alnomaps_,
			@RequestParam(value = "alnomops", required = false) String alnomops_,
			@RequestParam(value = "alcodigobarras", required = false) String alcodigobarras_,
			@RequestParam(value = "escodigo", required = false) String escodigo_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "alanulada", required = false) String alanulada_,
			@RequestParam(value = "alactiva", required = false) String alactiva_, HttpServletRequest request,
			HttpServletResponse response) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date alfeenDesde = Y41bUtils.parseDate(alfeenDesde_, locale);
			Date alfeenHasta = Y41bUtils.parseDate(alfeenHasta_, locale);

			Date alfeComunicacionDesde = Y41bUtils.parseDate(alfeComunicacionDesde_, locale);
			Date alfeComunicacionHasta = Y41bUtils.parseDate(alfeComunicacionHasta_, locale);

			Date alfePlazoDesde = Y41bUtils.parseDate(alfePlazoDesde_, locale);
			Date alfePlazoHasta = Y41bUtils.parseDate(alfePlazoHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String alcoor = ("".equals(alcoor_)) ? null : alcoor_;
			String alcoca = ("".equals(alcoca_)) ? null : alcoca_;
			String alcopa = ("".equals(alcopa_)) ? null : alcopa_;
			String alaecosan = ("".equals(alaecosan_)) ? null : alaecosan_;
			String alnror = ("".equals(alnror_)) ? null : alnror_;
			String alnran = ("".equals(alnran_)) ? null : alnran_;
			String alcops = ("".equals(alcops_)) ? null : alcops_;
			String alnoprse = ("".equals(alnoprse_)) ? null : alnoprse_;
			String alnomaps = ("".equals(alnomaps_)) ? null : alnomaps_;
			String alnomops = ("".equals(alnomops_)) ? null : alnomops_;
			String alcodigobarras = ("".equals(alcodigobarras_)) ? null : alcodigobarras_;
			String escodigo = ("".equals(escodigo_)) ? null : escodigo_;
			String esnif = ("".equals(esnif_)) ? null : esnif_;
			String esnombre = ("".equals(esnombre_)) ? null : esnombre_;

			// control checks
			String alanulada = ("on".equals(alanulada_)) ? Y41bConstantes.VALOR_SI : null;
			String alactiva = ("on".equals(alactiva_)) ? Y41bConstantes.VALOR_SI : null;

			Alerta filterAlerta = new Alerta();

			filterAlerta.setAlcoor(alcoor);
			if (alcoor != null && alcoor.equals(Y41bConstantes.ORIGEN_ALERTA_CE)) {
				filterAlerta.setAlcopa(alcopa);
			} else if (alcoor != null && alcoor.equals(Y41bConstantes.ORIGEN_ALERTA_CCAA)) {
				filterAlerta.setAlcoca(alcoca);
			} else if (alcoor != null && alcoor.equals(Y41bConstantes.ORIGEN_ALERTA_INC)) {
				filterAlerta.setAlaecosan(alaecosan);
			}

			filterAlerta.setAlnror(alnror);
			if (alnran != null) {
				filterAlerta.setAlnran(new Long(alnran));
			} else {
				filterAlerta.setAlnran(null);
			}
			filterAlerta.setAlcops(alcops);
			filterAlerta.setAlnoprse(alnoprse);
			filterAlerta.setAlnomaps(alnomaps);
			filterAlerta.setAlnomops(alnomops);
			filterAlerta.setAlcodigobarras(alcodigobarras);

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(escodigo);
			establecimiento.setEsnif(esnif);
			establecimiento.setEsnombre(esnombre);
			filterAlerta.setEstablecimiento(establecimiento);

			filterAlerta.setAlfeenDesde(alfeenDesde);
			filterAlerta.setAlfeenHasta(alfeenHasta);
			filterAlerta.setAlfeComunicacionDesde(alfeComunicacionDesde);
			filterAlerta.setAlfeComunicacionHasta(alfeComunicacionHasta);
			filterAlerta.setAlfePlazoDesde(alfePlazoDesde);
			filterAlerta.setAlfePlazoHasta(alfePlazoHasta);

			filterAlerta.setAlfeenDesdeStr(alfeenDesde_);
			filterAlerta.setAlfeenHastaStr(alfeenHasta_);
			filterAlerta.setAlfeComunicacionDesdeStr(alfeComunicacionDesde_);
			filterAlerta.setAlfeComunicacionHastaStr(alfeComunicacionHasta_);
			filterAlerta.setAlfePlazoDesdeStr(alfePlazoDesde_);
			filterAlerta.setAlfePlazoHastaStr(alfePlazoHasta_);

			filterAlerta.setAlanulada(alanulada);
			filterAlerta.setAlactiva(alactiva);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_ALERTAS + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getAlertasExcel(filterAlerta);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllAlertaProgramacionDocs'.
	 * 
	 * @param codProgramacion
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsAlertaProgramacion", method = RequestMethod.GET)
	public @ResponseBody Object getAllAlertaProgramacionDocs(
			@ModelAttribute(value = "codProgramacion") String codProgramacion, HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidExpediente(codProgramacion);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addAlertaDocs'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param codProgramacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/addAlertaProgramacionDocs", method = RequestMethod.POST)
	public @ResponseBody List<Map<String, Object>> addAlertaProgramacionDocs(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "codProgramacion") String codProgramacion, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String tedesfile = request.getParameter("thtedesfile");

			TipoDocumento tipoDocumento = new TipoDocumento();
			tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_AIP);

			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			// En la lista de documentos asociados solo podr haber un
			// mximo de 1
			// documento de tipo acuerdo de inicio de procedimiento.
			Adjuntardocs adjuntardocsAux2 = new Adjuntardocs();
			TipoDocumento tipoDocumentoAux2 = new TipoDocumento();
			tipoDocumentoAux2.setIdTipodoc(Y41bConstantes.TIPO_DOC_AIP);

			adjuntardocsAux2.setTipoDocumento(tipoDocumentoAux2);
			adjuntardocsAux2.setThidExpediente(codProgramacion);

			Long numAcuerdoInicioProcedimiento = this.adjuntardocsService.findAllCount(adjuntardocsAux2);

			if (numAcuerdoInicioProcedimiento > 0) {
				throw new Y41bUDAException("error.comunicacionsoivre.AcuerdoInicioProcedimientoException", true, null);
			}

			adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

			Blob blob = new SerialBlob(file.getBytes());
			adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(codProgramacion);
			adjuntardocsAux.setThidTramite(codProgramacion);

			adjuntardocsAux.setThtedesfile(tedesfile);

			adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			adjuntardocsAux.setTipoProcedimiento(tipoProcedimiento);

			adjuntardocsAux.setThfecha(new Date());

			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllPlantillasAlertasProgramacion'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllPlantilla", method = RequestMethod.GET)
	public @ResponseBody() Object getAllPlantillasAlertasProgramacion(HttpServletRequest request) {
		try {
			PlantillaTramite plantillaTramite = new PlantillaTramite();

			Tramite tramite = new Tramite();
			tramite.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);
			plantillaTramite.setTramite(tramite);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.plantillaTramiteService.findAllPlantillaTramiteCount(plantillaTramite);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listPlantillaTramiteBusqueda);
				return data;
			} else {
				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return listPlantillaTramiteBusqueda;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addPlantillaComunicacionSoivre'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param codAlertaAlta
	 *            String
	 * @param codProgramacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/addPlantilla", method = RequestMethod.POST)
	public @ResponseBody() void addPlantillaComunicacionSoivre(@RequestBody() Adjuntardocs adjuntardocs,
			@ModelAttribute(value = "codAlerta") String codAlertaAlta,
			@ModelAttribute(value = "codProgramacion") String codProgramacion, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			AlertaProgramacion alertaProgramacion = new AlertaProgramacion();
			alertaProgramacion.setCrcodigo(codProgramacion);
			Alerta alerta = new Alerta();
			alerta.setAlcodigo(codAlertaAlta);
			alertaProgramacion.setAlerta(alerta);

			this.alertaService.addPlantilla(adjuntardocs, alertaProgramacion, Y41bConstantes.TIPO_DOC_AIP);

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getEtiqueta'.
	 * 
	 * @param alcodigo_
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/etiqueta", method = RequestMethod.GET)
	public @ResponseBody void getEtiqueta(@RequestParam(value = "alcodigo", required = false) String alcodigo_,
			HttpServletResponse response) {
		try {
			Alerta alerta = new Alerta();
			alerta.setAlcodigo(alcodigo_);

			PlantillaControlMercadoDetalle plantillaControlMercadoDetalle = this.alertaService
					.findPlantillaControlMercadoDetalle(alerta);

			if (plantillaControlMercadoDetalle == null) {
				throw new Exception(alcodigo_);
			}

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_CONTROL_MERCADO_ALERTAS_ETIQUETA_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_CONTROL_MERCADO_ETIQUETA_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaControlMercadoDetalle, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			StringBuffer nombreFichero = new StringBuffer().append(plantillaControlMercadoDetalle.getTipoOrigen())
					.append("-").append(plantillaControlMercadoDetalle.getCodigoOrigen()).append(".rtf");

			response.setHeader("Content-Disposition", "attachment; filename=\"" + nombreFichero + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(alcodigo_);
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(alcodigo_);
		}
	}
}
