package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.AdjuntartipPregProtocService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.AdjuntartipPregProtoc;

/**
 * AdjuntartipPregProtocController  
 *  
 */
 
@Controller
@RequestMapping (value = "/adjuntartippregprotoc")

public class AdjuntartipPregProtocController  {

	private static final Logger logger = LoggerFactory.getLogger(AdjuntartipPregProtocController.class);

	@Autowired
	private AdjuntartipPregProtocService adjuntartipPregProtocService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AdjuntartipPregProtocController.logger.info("[GET - View] : adjuntartippregprotoc");
		return "adjuntartippregprotoc";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param trcodigo String
	 * @return adjuntartipPregProtoc AdjuntartipPregProtoc
	 */
	@RequestMapping(value = "/{trcodigo}", method = RequestMethod.GET)
	public @ResponseBody AdjuntartipPregProtoc getById(@PathVariable String trcodigo) {
        AdjuntartipPregProtoc adjuntartipPregProtoc = new AdjuntartipPregProtoc();
		adjuntartipPregProtoc.setTrcodigo(trcodigo);
        adjuntartipPregProtoc = this.adjuntartipPregProtocService.find(adjuntartipPregProtoc);
        AdjuntartipPregProtocController.logger.info("[GET - findBy_PK] : Obtener AdjuntartipPregProtoc por PK");
        return adjuntartipPregProtoc;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterAdjuntartipPregProtoc AdjuntartipPregProtoc
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<AdjuntartipPregProtoc> getAll(@ModelAttribute AdjuntartipPregProtoc filterAdjuntartipPregProtoc) {
		AdjuntartipPregProtocController.logger.info("[GET - find_ALL] : Obtener AdjuntartipPregProtoc por filtro");
	    return this.adjuntartipPregProtocService.findAll(filterAdjuntartipPregProtoc, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param adjuntartipPregProtoc AdjuntartipPregProtoc 
	 * @return AdjuntartipPregProtoc
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody AdjuntartipPregProtoc edit(@RequestBody AdjuntartipPregProtoc adjuntartipPregProtoc) {		
        AdjuntartipPregProtoc adjuntartipPregProtocAux = this.adjuntartipPregProtocService.update(adjuntartipPregProtoc);
		AdjuntartipPregProtocController.logger.info("[PUT] : AdjuntartipPregProtoc actualizado correctamente");
        return adjuntartipPregProtocAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param adjuntartipPregProtoc AdjuntartipPregProtoc 
	 * @return AdjuntartipPregProtoc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody AdjuntartipPregProtoc add(@RequestBody AdjuntartipPregProtoc adjuntartipPregProtoc) {		
        AdjuntartipPregProtoc adjuntartipPregProtocAux = this.adjuntartipPregProtocService.add(adjuntartipPregProtoc);
        AdjuntartipPregProtocController.logger.info("[POST] : AdjuntartipPregProtoc insertado correctamente");
    	return adjuntartipPregProtocAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param trcodigo String
	 * @return adjuntartipPregProtoc
	 */
	@RequestMapping(value = "/{trcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody AdjuntartipPregProtoc remove(@PathVariable String trcodigo) {
        AdjuntartipPregProtoc adjuntartipPregProtoc = new AdjuntartipPregProtoc();
        adjuntartipPregProtoc.setTrcodigo(trcodigo);
        this.adjuntartipPregProtocService.remove(adjuntartipPregProtoc);
       	AdjuntartipPregProtocController.logger.info("[DELETE] : AdjuntartipPregProtoc borrado correctamente");
       	return adjuntartipPregProtoc;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param adjuntartipPregProtocIds List
	 * @return adjuntartipPregProtocList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> adjuntartipPregProtocIds) {
        List<AdjuntartipPregProtoc> adjuntartipPregProtocList = new ArrayList<AdjuntartipPregProtoc>();
        for (List<String> adjuntartipPregProtocId:adjuntartipPregProtocIds) {
		    Iterator<String> iterator = adjuntartipPregProtocId.iterator();
		    AdjuntartipPregProtoc adjuntartipPregProtoc = new AdjuntartipPregProtoc(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        adjuntartipPregProtoc.setTrcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    adjuntartipPregProtocList.add(adjuntartipPregProtoc);
	    }
        this.adjuntartipPregProtocService.removeMultiple(adjuntartipPregProtocList);
		AdjuntartipPregProtocController.logger.info("[POST - DELETE_ALL] : AdjuntartipPregProtoc borrados correctamente");
		return adjuntartipPregProtocIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterAdjuntartipPregProtoc AdjuntartipPregProtoc
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute AdjuntartipPregProtoc filterAdjuntartipPregProtoc, @ModelAttribute Pagination pagination) {
        List<AdjuntartipPregProtoc> adjuntartipPregProtocs = this.adjuntartipPregProtocService.findAll(filterAdjuntartipPregProtoc, pagination);
        Long recordNum = this.adjuntartipPregProtocService.findAllCount(filterAdjuntartipPregProtoc);
        AdjuntartipPregProtocController.logger.info("[GET - jqGrid] : Obtener AdjuntartipPregProtoc");
		return new JQGridJSONModel(pagination, recordNum, adjuntartipPregProtocs);
	}
	
}	
