package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.AdjuntarprodagrupadoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Adjuntarprodagrupado;

/**
 * AdjuntarprodagrupadoController  
 *  
 */
 
@Controller
@RequestMapping (value = "/adjuntarprodagrupado")

public class AdjuntarprodagrupadoController  {

	private static final Logger logger = LoggerFactory.getLogger(AdjuntarprodagrupadoController.class);

	@Autowired
	private AdjuntarprodagrupadoService adjuntarprodagrupadoService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AdjuntarprodagrupadoController.logger.info("[GET - View] : adjuntarprodagrupado");
		return "adjuntarprodagrupado";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param e8codigo String
	 * @param tircodigo String
	 * @return adjuntarprodagrupado Adjuntarprodagrupado
	 */
	@RequestMapping(value = "/{e8codigo}/{tircodigo}", method = RequestMethod.GET)
	public @ResponseBody Adjuntarprodagrupado getById(@PathVariable String e8codigo, @PathVariable String tircodigo) {
        Adjuntarprodagrupado adjuntarprodagrupado = new Adjuntarprodagrupado();
		adjuntarprodagrupado.setE8codigo(e8codigo);
		adjuntarprodagrupado.setTircodigo(tircodigo);
        adjuntarprodagrupado = this.adjuntarprodagrupadoService.find(adjuntarprodagrupado);
        AdjuntarprodagrupadoController.logger.info("[GET - findBy_PK] : Obtener Adjuntarprodagrupado por PK");
        return adjuntarprodagrupado;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterAdjuntarprodagrupado Adjuntarprodagrupado
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Adjuntarprodagrupado> getAll(@ModelAttribute Adjuntarprodagrupado filterAdjuntarprodagrupado) {
		AdjuntarprodagrupadoController.logger.info("[GET - find_ALL] : Obtener Adjuntarprodagrupado por filtro");
	    return this.adjuntarprodagrupadoService.findAll(filterAdjuntarprodagrupado, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param adjuntarprodagrupado Adjuntarprodagrupado 
	 * @return Adjuntarprodagrupado
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Adjuntarprodagrupado edit(@RequestBody Adjuntarprodagrupado adjuntarprodagrupado) {		
        Adjuntarprodagrupado adjuntarprodagrupadoAux = this.adjuntarprodagrupadoService.update(adjuntarprodagrupado);
		AdjuntarprodagrupadoController.logger.info("[PUT] : Adjuntarprodagrupado actualizado correctamente");
        return adjuntarprodagrupadoAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param adjuntarprodagrupado Adjuntarprodagrupado 
	 * @return Adjuntarprodagrupado
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Adjuntarprodagrupado add(@RequestBody Adjuntarprodagrupado adjuntarprodagrupado) {		
        Adjuntarprodagrupado adjuntarprodagrupadoAux = this.adjuntarprodagrupadoService.add(adjuntarprodagrupado);
        AdjuntarprodagrupadoController.logger.info("[POST] : Adjuntarprodagrupado insertado correctamente");
    	return adjuntarprodagrupadoAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param e8codigo String
	 * @param tircodigo String
	 * @return adjuntarprodagrupado
	 */
	@RequestMapping(value = "/{e8codigo}/{tircodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Adjuntarprodagrupado remove(@PathVariable String e8codigo, @PathVariable String tircodigo) {
        Adjuntarprodagrupado adjuntarprodagrupado = new Adjuntarprodagrupado();
        adjuntarprodagrupado.setE8codigo(e8codigo);
        adjuntarprodagrupado.setTircodigo(tircodigo);
        this.adjuntarprodagrupadoService.remove(adjuntarprodagrupado);
       	AdjuntarprodagrupadoController.logger.info("[DELETE] : Adjuntarprodagrupado borrado correctamente");
       	return adjuntarprodagrupado;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param adjuntarprodagrupadoIds List
	 * @return adjuntarprodagrupadoList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> adjuntarprodagrupadoIds) {
        List<Adjuntarprodagrupado> adjuntarprodagrupadoList = new ArrayList<Adjuntarprodagrupado>();
        for (List<String> adjuntarprodagrupadoId:adjuntarprodagrupadoIds) {
		    Iterator<String> iterator = adjuntarprodagrupadoId.iterator();
		    Adjuntarprodagrupado adjuntarprodagrupado = new Adjuntarprodagrupado(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        adjuntarprodagrupado.setE8codigo(ObjectConversionManager.convert(iterator.next(), String.class));
	        adjuntarprodagrupado.setTircodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    adjuntarprodagrupadoList.add(adjuntarprodagrupado);
	    }
        this.adjuntarprodagrupadoService.removeMultiple(adjuntarprodagrupadoList);
		AdjuntarprodagrupadoController.logger.info("[POST - DELETE_ALL] : Adjuntarprodagrupado borrados correctamente");
		return adjuntarprodagrupadoIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterAdjuntarprodagrupado Adjuntarprodagrupado
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Adjuntarprodagrupado filterAdjuntarprodagrupado, @ModelAttribute Pagination pagination) {
        List<Adjuntarprodagrupado> adjuntarprodagrupados = this.adjuntarprodagrupadoService.findAll(filterAdjuntarprodagrupado, pagination);
        Long recordNum = this.adjuntarprodagrupadoService.findAllCount(filterAdjuntarprodagrupado);
        AdjuntarprodagrupadoController.logger.info("[GET - jqGrid] : Obtener Adjuntarprodagrupado");
		return new JQGridJSONModel(pagination, recordNum, adjuntarprodagrupados);
	}
	
}	
