package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHechoDetalle;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.service.ArbadhdocService;
import com.ejie.y41b.service.ArbadhsolService;
import com.ejie.y41b.service.ArbadhtramService;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.Arbtramexp4Service;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.SandoctempService;
import com.ejie.y41b.service.SanexprelService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * AdjuntardocsTramiteController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/adjuntardocstramite")
@SessionAttributes({ "tramiteComunAdjDocTramite" })
public class AdjuntardocsTramiteController {

	private static final Logger logger = LoggerFactory
			.getLogger(AdjuntardocsTramiteController.class);

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private SoltramexpService soltramexpService;

	@Autowired
	private InstramexpService instramexpService;

	@Autowired
	private SantramexpService santramexpService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;
	@Autowired
	private SandoctempService sandoctempService;
	@Autowired
	private ExpedienService expedienService;
	@Autowired
	private SolarbService solarbService;
	@Autowired
	private ArbdoctempService arbdoctempService;
	@Autowired
	private Arbtramexp4Service arbtramexp4Service;
	@Autowired
	private ArbadhsolService arbadhsolService;
	@Autowired
	private ArbadhdocService arbadhdocService;
	@Autowired
	private ArbadhtramService arbadhtramService;

	@Autowired()
	private SanexprelService sanexprelService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormModalAdjuntarDocs'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "maint/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModalAdjuntarDocs(
			@RequestParam(value = "tipo", required = false) String tipoTramite,
			@PathVariable String codProcedimiento,
			@PathVariable String idExpediente, @PathVariable String idTramite,
			Model model) throws Exception {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService
					.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
			tramiteComun.setIdTipoTramite(tipoTramite);
		} else if (codProcedimiento != null
				&& codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun
					.setNumExpediente(expediente.getCodCompletoConPrefijo());
			tramiteComun.setIdTipoTramite(tipoTramite);
		} else if (codProcedimiento != null
				&& codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			Solarb solarb = new Solarb();
			tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi
					.decode(idExpediente)));
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());
			tramiteComun.setIdTipoTramite(tipoTramite);
		} else if (codProcedimiento != null
				&& (codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
						|| codProcedimiento
								.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD) || codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			tramiteComun.setIdExpediente(idExpediente);
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(new String(tramiteComun.getIdExpediente()));
			arbadhsol = this.arbadhsolService.find(arbadhsol);
			tramiteComun.setNumExpediente(arbadhsol.getNumExpediente());
		} else if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			String numExp = this.instramexpService
					.findNumExpedienteActuacion(idExpediente);
			tramiteComun.setNumExpediente(numExp);
			tramiteComun.setIdTipoTramite(tipoTramite);
		}

		model.addAttribute("tramiteComunAdjDocTramite", tramiteComun);
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));
		logger.info("Entra getCreateFormModalAdjuntarDocs");
		return new ModelAndView("modalAdjuntarDocsTramite", "model", model);
	}

	/**
	 * Method 'getCreateFormModalAdjuntarDocs'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "maintDocsExpediente", method = RequestMethod.GET)
	public ModelAndView getCreateFormModalAdjuntarDocsExpediente(Model model)
			throws Exception {

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("modalAdjuntarDocsTramiteExpediente", "model",
				model);
	}

	/**
	 * Method 'getCreateFormModalAdjuntarDocs'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "maintDocsExpedientesRelacionados", method = RequestMethod.GET)
	public ModelAndView getCreateFormModalAdjuntarDocsExpedientesRelacionados(
			Model model) throws Exception {

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView(
				"modalAdjuntarDocsTramiteExpedientesRelacionados", "model",
				model);
	}

	/**
	 * Method 'getCreateFormModalAdjuntarDocsOrigenExpediente'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "maintDocsOrigenExpediente", method = RequestMethod.GET)
	public ModelAndView getCreateFormModalAdjuntarDocsOrigenExpediente(
			Model model) throws Exception {

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("modalAdjuntarDocsOrigenExpediente", "model",
				model);
	}

	/**
	 * Method 'getByIdDocumentoAdjuntarDocsTramite'.
	 * 
	 * @param codocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDocAdjuntarDocsTramite/{codocumento}", method = RequestMethod.GET)
	public @ResponseBody
	void getByIdDocumentoAdjuntarDocsTramite(
			@PathVariable String codocumento,
			@ModelAttribute(value = "tramiteComunAdjDocTramite") TramiteComun tramiteComun,
			HttpServletResponse response) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
				documentoHechoDetalle.setQ5codocumento(codocumento);

				documentoHechoDetalle = this.denunciaService
						.findDocumentoHecho(documentoHechoDetalle);

				Blob contenido = documentoHechoDetalle.getQ5datafile();
				byte[] bContenido = contenido.getBytes(1,
						(int) contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader(
						"Content-Disposition",
						"attachment; filename=\""
								+ StringEscapeUtils
										.unescapeHtml(documentoHechoDetalle
												.getQ5nofile()) + "\"");
				response.setContentType(documentoHechoDetalle
						.getQ5contenttypefile());
				response.setContentLength(documentoHechoDetalle.getQ5sizefile());
				response.getOutputStream().write(bContenido);

				// Vaciamos el stream
				response.getOutputStream().flush();

			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SANCIONES)) {
				Sandoctemp sandoctemp = new Sandoctemp();
				sandoctemp.setU5codocumento(codocumento);

				sandoctemp = this.sandoctempService.find(sandoctemp);

				Blob contenido = sandoctemp.getU5datafile();
				byte[] bContenido = contenido.getBytes(1,
						(int) contenido.length());

				/*
				 * se borra en el dao despues de cargar el modelo
				 * this.denunciaService .removeLobTablaTemporal(sandoctemp);
				 */

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader(
						"Content-Disposition",
						"attachment; filename=\""
								+ StringEscapeUtils.unescapeHtml(sandoctemp
										.getU5nofile()) + "\"");
				response.setContentType(sandoctemp.getU5conttype());
				response.setContentLength(sandoctemp.getU5sizefile());
				response.getOutputStream().write(bContenido);

				// Vaciamos el stream
				response.getOutputStream().flush();
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				Arbdoctemp arbdoctemp = new Arbdoctemp();
				arbdoctemp.setX5codocumento(codocumento);

				arbdoctemp = this.arbdoctempService.find(arbdoctemp);

				Blob contenido = arbdoctemp.getX5datafile();
				byte[] bContenido = contenido.getBytes(1,
						(int) contenido.length());

				/*
				 * se borra en el dao despues de cargar el modelo
				 * this.denunciaService .removeLobTablaTemporal(sandoctemp);
				 */

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader(
						"Content-Disposition",
						"attachment; filename=\""
								+ StringEscapeUtils.unescapeHtml(arbdoctemp
										.getX5nofile()) + "\"");
				response.setContentType(arbdoctemp.getX5conttype());
				response.setContentLength(arbdoctemp.getX5sizefile());
				response.getOutputStream().write(bContenido);

				// Vaciamos el stream
				response.getOutputStream().flush();
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(
									Y41bConstantes.TIPO_PROC_ADHESIONES_MOD) || tipoProcedimiento
							.getPcodigo().equals(
									Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				Arbadhdoc arbadhdoc = new Arbadhdoc();
				arbadhdoc.setX5codocumento(codocumento);

				arbadhdoc = this.arbadhdocService.find(arbadhdoc);

				Blob contenido = arbadhdoc.getX5datafile();
				byte[] bContenido = contenido.getBytes(1,
						(int) contenido.length());

				/*
				 * se borra en el dao despues de cargar el modelo
				 * this.denunciaService .removeLobTablaTemporal(sandoctemp);
				 */

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader(
						"Content-Disposition",
						"attachment; filename=\""
								+ StringEscapeUtils.unescapeHtml(arbadhdoc
										.getX5nofile()) + "\"");
				response.setContentType(arbadhdoc.getX5conttype());
				response.setContentLength(arbadhdoc.getX5sizefile());
				response.getOutputStream().write(bContenido);

				// Vaciamos el stream
				response.getOutputStream().flush();
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
				documentoHechoDetalle.setQ5codocumento(codocumento);

				documentoHechoDetalle = this.denunciaService
						.findDocumentoHecho(documentoHechoDetalle);

				Blob contenido = documentoHechoDetalle.getQ5datafile();
				byte[] bContenido = contenido.getBytes(1,
						(int) contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader(
						"Content-Disposition",
						"attachment; filename=\""
								+ StringEscapeUtils
										.unescapeHtml(documentoHechoDetalle
												.getQ5nofile()) + "\"");
				response.setContentType(documentoHechoDetalle
						.getQ5contenttypefile());
				response.setContentLength(documentoHechoDetalle.getQ5sizefile());
				response.getOutputStream().write(bContenido);

				// Vaciamos el stream
				response.getOutputStream().flush();
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllTipoProcExpedientesRelacionados'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/findAllTipoProcExpedientesRelacionados", method = RequestMethod.GET)
	public @ResponseBody()
	List<TipoProcedimiento> getAllTipoProcExpedientesRelacionados(
			@ModelAttribute(value = "tramiteComunAdjDocTramite") TramiteComun tramiteComun,
			HttpServletRequest request) {

		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			Pagination pagination = new Pagination();
			Sanexprel sanexprel = new Sanexprel();
			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				sanexprel.setRlhdcodigo(tramiteComun.getIdExpediente());
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SANCIONES)) {
				Expedien expedien = new Expedien();
				expedien.setExcodigo(tramiteComun.getIdExpediente());
				sanexprel.setExpedienByRlexcodigo(expedien);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				sanexprel.setRlarbcodigo(tramiteComun.getIdExpediente());
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(
									Y41bConstantes.TIPO_PROC_ADHESIONES_MOD) || tipoProcedimiento
							.getPcodigo().equals(
									Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				return new ArrayList<TipoProcedimiento>();
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				sanexprel.setRlinscodigo(tramiteComun.getIdExpediente());
			}

			return this.sanexprelService
					.findAllTipoProcExpedientesRelacionados(sanexprel,
							pagination);

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllNumExpedientesExpedientesRelacionados'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/findAllNumExpedientesExpedientesRelacionados", method = RequestMethod.GET)
	public @ResponseBody()
	List<Sanexprel> getAllNumExpedientesExpedientesRelacionados(
			@ModelAttribute(value = "tramiteComunAdjDocTramite") TramiteComun tramiteComun,
			HttpServletRequest request) {

		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			String pcodigo = "";
			if (!"".equalsIgnoreCase((String) request.getParameter("pcodigo"))
					&& null != (String) request.getParameter("pcodigo")) {
				pcodigo = request.getParameter("pcodigo");
			}

			Pagination pagination = new Pagination();
			Sanexprel sanexprel = new Sanexprel();
			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				sanexprel.setRlhdcodigo(tramiteComun.getIdExpediente());
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SANCIONES)) {
				Expedien expedien = new Expedien();
				expedien.setExcodigo(tramiteComun.getIdExpediente());
				sanexprel.setExpedienByRlexcodigo(expedien);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				sanexprel.setRlarbcodigo(tramiteComun.getIdExpediente());
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(
									Y41bConstantes.TIPO_PROC_ADHESIONES_MOD) || tipoProcedimiento
							.getPcodigo().equals(
									Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				return new ArrayList<Sanexprel>();
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				sanexprel.setRlinscodigo(tramiteComun.getIdExpediente());
			}

			TipoProcedimiento tipoProcedimientoAux = new TipoProcedimiento();
			tipoProcedimientoAux.setPcodigo(pcodigo);
			sanexprel.setTipoProcedimiento(tipoProcedimientoAux);

			return this.sanexprelService
					.findAllNumExpedientesExpedientesRelacionados(sanexprel,
							pagination);

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllComunicacionDocs'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsAdjuntarDocsTramite", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllComunicacionDocs(
			@ModelAttribute(value = "tramiteComunAdjDocTramite") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();
			List<DocumentoExpediente> listDocumentoExpediente = null;
			Pagination pagination = null;
			Long total = new Long(0);
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

					listDocumentoExpediente = this.soltramexpService
							.findAllDocumentosHechoComunicacion(tramiteComun,
									pagination);

					if (listDocumentoExpediente == null) {
						throw new Exception("No data Found.");
					}
					total = this.soltramexpService
							.findAllDocumentosHechoComunicacionCount(tramiteComun);
				} else if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_SANCIONES)) {
					listDocumentoExpediente = this.santramexpService
							.findAllDocumentosHechoComunicacion(tramiteComun,
									pagination);
					if (listDocumentoExpediente == null) {
						throw new Exception("No data Found.");
					}
					total = this.santramexpService
							.findAllDocumentosHechoComunicacionCount(tramiteComun);
				} else if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					listDocumentoExpediente = this.arbtramexp4Service
							.findAllDocumentosHechoComunicacion(tramiteComun,
									pagination);
					if (listDocumentoExpediente == null) {
						throw new Exception("No data Found.");
					}
					total = this.arbtramexp4Service
							.findAllDocumentosHechoComunicacionCount(tramiteComun);
				} else if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& (tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| tipoProcedimiento
										.getPcodigo()
										.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD) || tipoProcedimiento
								.getPcodigo()
								.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					listDocumentoExpediente = this.arbadhtramService
							.findAllDocumentosHechoComunicacion(tramiteComun,
									null);
					if (listDocumentoExpediente == null) {
						throw new Exception("No data Found.");
					}
					total = this.arbadhtramService
							.findAllDocumentosHechoComunicacionCount(tramiteComun);
				} else if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

					listDocumentoExpediente = this.instramexpService
							.findAllDocumentosAdjuntos(tramiteComun, pagination);

					if (listDocumentoExpediente == null) {
						throw new Exception("No data Found.");
					}
					total = this.instramexpService
							.findAllDocumentosAdjuntosCount(tramiteComun);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listDocumentoExpediente);
				return data;
			} else {
				if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					listDocumentoExpediente = this.soltramexpService
							.findAllDocumentosHechoComunicacion(tramiteComun,
									null);
				} else if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_SANCIONES)) {
					listDocumentoExpediente = this.santramexpService
							.findAllDocumentosHechoComunicacion(tramiteComun,
									null);
				} else if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					listDocumentoExpediente = this.arbtramexp4Service
							.findAllDocumentosHechoComunicacion(tramiteComun,
									null);
				} else if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& (tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| tipoProcedimiento
										.getPcodigo()
										.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD) || tipoProcedimiento
								.getPcodigo()
								.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					listDocumentoExpediente = this.arbadhtramService
							.findAllDocumentosHechoComunicacion(tramiteComun,
									null);
				} else if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

					listDocumentoExpediente = this.instramexpService
							.findAllDocumentosAdjuntos(tramiteComun, null);
				}
				if (listDocumentoExpediente == null) {
					throw new Exception("No data Found.");
				}
				return listDocumentoExpediente;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllComunicacionDocs'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsAdjuntarDocsTramiteExpedientesRelacionados", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllComunicacionDocs(
			@RequestParam(value = "hdcodigo", required = false) String hdcodigo,
			@ModelAttribute(value = "tramiteComunAdjDocTramite") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			List<DocumentoExpediente> listDocumentoExpediente = null;
			Pagination pagination = null;
			Long total = new Long(0);
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdExpediente(hdcodigo);
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				listDocumentoExpediente = this.denunciaService
						.findAllDocumentosHechoExpedientesRelacionados(
								tramiteComunAux, pagination);

				if (listDocumentoExpediente == null) {
					throw new Exception("No data Found.");
				}
				total = this.denunciaService
						.findAllDocumentosHechoExpedientesRelacionadosCount(tramiteComunAux);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listDocumentoExpediente);
				return data;
			} else {

				listDocumentoExpediente = this.denunciaService
						.findAllDocumentosHechoExpedientesRelacionados(
								tramiteComunAux, null);

				if (listDocumentoExpediente == null) {
					throw new Exception("No data Found.");
				}
				return listDocumentoExpediente;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllComunicacionDocsOrigenExpediente'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsAdjuntarDocsTramiteOrigenExpediente", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllComunicacionDocsOrigenExpediente(
			@ModelAttribute(value = "tramiteComunAdjDocTramite") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			List<DocumentoExpediente> listDocumentoExpediente = null;
			Pagination pagination = null;
			Long total = new Long(0);
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				listDocumentoExpediente = this.instramexpService
						.findAllDocumentosAdjuntosOrigenExpediente(
								tramiteComun, pagination);

				if (listDocumentoExpediente == null) {
					throw new Exception("No data Found.");
				}
				total = this.instramexpService
						.findAllDocumentosAdjuntosOrigenExpedienteCount(tramiteComun);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listDocumentoExpediente);
				return data;
			} else {

				listDocumentoExpediente = this.instramexpService
						.findAllDocumentosAdjuntosOrigenExpediente(
								tramiteComun, null);

				if (listDocumentoExpediente == null) {
					throw new Exception("No data Found.");
				}
				return listDocumentoExpediente;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
