package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentosFirmaArbitros;
import com.ejie.y41b.model.DocumentosFirmaArbitrosTemp;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.DocumentosFirmaArbitrosService;
import com.ejie.y41b.service.DocumentosFirmaArbitrosTempService;
import com.ejie.y41b.service.IntervinientesService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjuntardocsController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/adjuntardocs")
public class AdjuntardocsController {

	private static final Logger logger = LoggerFactory.getLogger(AdjuntardocsController.class);

	@Autowired
	private AdjuntardocsService adjuntardocsService;

	@Autowired
	private IntervinientesService intervinientesService;

	@Autowired
	private DocumentosFirmaArbitrosTempService documentosFirmaArbitrosTempService;

	@Autowired
	private DocumentosFirmaArbitrosService documentosFirmaArbitrosService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AdjuntardocsController.logger.info("[GET - View] : adjuntardocs");
		return "adjuntardocs";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @return adjuntardocs Adjuntardocs
	 */
	@RequestMapping(value = "/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody Adjuntardocs getById(@PathVariable String thcodocumento) {
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThcodocumento(thcodocumento);
		adjuntardocs = this.adjuntardocsService.find(adjuntardocs);
		AdjuntardocsController.logger.info("[GET - findBy_PK] : Obtener Adjuntardocs por PK");
		return adjuntardocs;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterAdjuntardocs
	 *            Adjuntardocs
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Adjuntardocs> getAll(@ModelAttribute Adjuntardocs filterAdjuntardocs) {
		AdjuntardocsController.logger.info("[GET - find_ALL] : Obtener Adjuntardocs por filtro");
		return this.adjuntardocsService.findAll(filterAdjuntardocs, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Adjuntardocs edit(@RequestBody Adjuntardocs adjuntardocs) {
		Adjuntardocs adjuntardocsAux = this.adjuntardocsService.update(adjuntardocs);
		AdjuntardocsController.logger.info("[PUT] : Adjuntardocs actualizado correctamente");
		return adjuntardocsAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Adjuntardocs add(@RequestBody Adjuntardocs adjuntardocs) {
		Adjuntardocs adjuntardocsAux = this.adjuntardocsService.add(adjuntardocs);
		AdjuntardocsController.logger.info("[POST] : Adjuntardocs insertado correctamente");
		return adjuntardocsAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @return adjuntardocs
	 */
	@RequestMapping(value = "/{thcodocumento}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Adjuntardocs remove(@PathVariable String thcodocumento) {
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThcodocumento(thcodocumento);
		this.adjuntardocsService.remove(adjuntardocs);
		AdjuntardocsController.logger.info("[DELETE] : Adjuntardocs borrado correctamente");
		return adjuntardocs;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param adjuntardocsIds
	 *            List
	 * @return adjuntardocsList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> adjuntardocsIds) {
		List<Adjuntardocs> adjuntardocsList = new ArrayList<Adjuntardocs>();
		for (List<String> adjuntardocsId : adjuntardocsIds) {
			Iterator<String> iterator = adjuntardocsId.iterator();
			Adjuntardocs adjuntardocs = new Adjuntardocs(); // NOPMD - Objeto
															// nuevo en la lista
															// (parametro del
															// servicio)
			adjuntardocs.setThcodocumento(ObjectConversionManager.convert(iterator.next(), String.class));
			adjuntardocsList.add(adjuntardocs);
		}
		this.adjuntardocsService.removeMultiple(adjuntardocsList);
		AdjuntardocsController.logger.info("[POST - DELETE_ALL] : Adjuntardocs borrados correctamente");
		return adjuntardocsIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterAdjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Adjuntardocs filterAdjuntardocs,
			@ModelAttribute Pagination pagination) {
		List<Adjuntardocs> adjuntardocss = this.adjuntardocsService.findAll(filterAdjuntardocs, pagination);
		Long recordNum = this.adjuntardocsService.findAllCount(filterAdjuntardocs);
		AdjuntardocsController.logger.info("[GET - jqGrid] : Obtener Adjuntardocs");
		return new JQGridJSONModel(pagination, recordNum, adjuntardocss);
	}

	/**
	 * Method 'borraAdjuntarDocs'.
	 * 
	 */
	@RequestMapping(value = "/eliminarAdjuntarDocs", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() void borraAdjuntarDocs() {
		try {
			this.adjuntardocsService.removeAdjuntardocsAntiguos();
		} catch (Exception e) {
			throw new Y41bUDAException("sanciones.error.eliminacionTramites.Dependencias", true, null);
		}
	}

	/**
	 * Method 'getDetalleAdjuntarDocumento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "detalleAdjuntarDocumento", method = RequestMethod.GET)
	public ModelAndView getDetalleAdjuntarDocumento(Model model, HttpServletRequest request) {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("modalAdjuntarDocsTramiteDetalle", "model", model);
		}
	}

	/**
	 * Method 'getByCoDocYidTramite'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param thidTramite
	 *            String
	 * @return adjuntardocs Adjuntardocs
	 */
	@RequestMapping(value = "adjuntarDocumento/{thcodocumento}/{thidTramite}", method = RequestMethod.GET)
	public @ResponseBody Adjuntardocs getByCoDocYidTramite(@PathVariable() String thcodocumento,
			@PathVariable() String thidTramite) {
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThcodocumento(thcodocumento);
		adjuntardocs.setThidTramite(thidTramite);
		adjuntardocs = this.adjuntardocsService.find(adjuntardocs);

		// 0155021 si el documento esta en alguna de las tablas es firma de
		// arbitros
		DocumentosFirmaArbitros doc1 = new DocumentosFirmaArbitros();
		doc1.setIddocumentosfirmaarb(thcodocumento);
		doc1 = this.documentosFirmaArbitrosService.find(doc1);
		DocumentosFirmaArbitrosTemp doc2 = new DocumentosFirmaArbitrosTemp();
		doc2.setIddocumentosfirmaarbtemp(thcodocumento);
		doc2 = this.documentosFirmaArbitrosTempService.find(doc2);
		if (null != doc1 || null != doc2) {
			adjuntardocs.setPerfil(new Perfil(Y41bConstantes.PERFIL_FIRMA_ARBITRO, "Arbitros", "Arbitroak"));
		}
		// 0155021
		AdjuntardocsController.logger.info("[GET - findBy_PK] : Obtener Adjuntardocs por PK");
		return adjuntardocs;
	}

	/**
	 * Method 'actualizardoc'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return Adjuntardocs
	 */
	@RequestMapping(value = "actualizardoc", method = RequestMethod.POST)
	public @ResponseBody List<Map<String, Object>> addAdjuntarDocs(
			@RequestParam(value = "files[]", required = false) MultipartFile file, HttpServletResponse response,
			HttpServletRequest request) {
		try {

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thcodocumento = request.getParameter("thcodocumento");
			String thidTramite = request.getParameter("thidTramite");

			String idInterviniente = request.getParameter("idInterviniente");
			String thnumregistroentrada = request.getParameter("thnumregistroentrada");
			String thfechaentrada = request.getParameter("thfecharegentrada");
			String thnumregistroorigen = request.getParameter("thnumregistroorigen");
			String thfecharegistroorigen = request.getParameter("thfecharegistroorigen");
			String idTipodoc = request.getParameter("idTipodoc");
			String thtedesfile = request.getParameter("thtedesfile");
			String requiereFirma = request.getParameter("requiereFirma");
			String rolFirma = request.getParameter("rolFirma");
			String thdestino = request.getParameter("thdestino");

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(idInterviniente);

			intervinientes = this.intervinientesService.find(intervinientes);

			if (intervinientes != null && intervinientes.getTipoInterviniente() != null) {
				if (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);
				} else if (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE);
				} else if (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO);
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE);
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO);
				} else if (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO);
				} else if (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE);
				} else if (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO);
				} else if (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE);
				} else {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_OTROS);
				}
			}

			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setThidTramite(thidTramite);

			adjuntardocsAux.setIdInterviniente(idInterviniente);
			adjuntardocsAux.setThnumregistroentrada(thnumregistroentrada);
			adjuntardocsAux.setThnumregistroorigen(thnumregistroorigen);
			TipoDocumento tipoDocumento = new TipoDocumento();
			tipoDocumento.setIdTipodoc(idTipodoc);
			adjuntardocsAux.setTipoDocumento(tipoDocumento);
			adjuntardocsAux.setThtedesfile(thtedesfile);
			adjuntardocsAux.setThdestino(thdestino);

			if (rolFirma != null && !"".equals(rolFirma) && requiereFirma != null && !"".equals(requiereFirma)) {
				adjuntardocsAux.setThrequierefirma(Y41bConstantes.VALOR_SI);
				adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
				adjuntardocsAux.setThfechasolfirma(new Date());
			} else {
				adjuntardocsAux.setThrequierefirma(Y41bConstantes.VALOR_NO);
				rolFirma = null;
			}

			Perfil perfil = new Perfil();
			// 155021 si el perfil que guardamos pasa a ser firma arbitros,
			// guardamos en la temporal y cambiamos el perfil para que pueda
			// guardar
			if (Y41bConstantes.PERFIL_FIRMA_ARBITRO.equals(rolFirma)) {
				DocumentosFirmaArbitrosTemp documento = new DocumentosFirmaArbitrosTemp();
				documento.setIddocumentosfirmaarbtemp(adjuntardocsAux.getThcodocumento());
				documento = this.documentosFirmaArbitrosTempService.find(documento);
				if (documento == null) {
					this.documentosFirmaArbitrosTempService
							.add(new DocumentosFirmaArbitrosTemp(adjuntardocsAux.getThcodocumento()));
				}
				rolFirma = Y41bConstantes.PERFIL_INSTRUCTOR;
			} else {

				// si no es firma arbitros y encontramos el documento en algun
				// lado
				// es que se ha cambiado el perfil de la firma asiq borramos de
				// las
				// tablas ese documento

				DocumentosFirmaArbitros doc1 = new DocumentosFirmaArbitros();
				doc1.setIddocumentosfirmaarb(thcodocumento);
				this.documentosFirmaArbitrosService.remove(doc1);
				DocumentosFirmaArbitrosTemp doc2 = new DocumentosFirmaArbitrosTemp();
				doc2.setIddocumentosfirmaarbtemp(thcodocumento);
				this.documentosFirmaArbitrosTempService.remove(doc2);
			}

			// 155021
			perfil.setIdPerfil(rolFirma);
			adjuntardocsAux.setPerfil(perfil);

			// Tratamos fechas
			Locale locale = LocaleContextHolder.getLocale();
			adjuntardocsAux.setThfechaentrada(Y41bUtils.parseDate(thfechaentrada, locale));
			adjuntardocsAux.setThfecharegistroorigen(Y41bUtils.parseDate(thfecharegistroorigen, locale));

			if (file != null && file.getSize() > 0 && file.getOriginalFilename() != null
					&& !"".equals(file.getOriginalFilename())) {
				// Tratamos archivo
				// Blob blob = new SerialBlob(file.getBytes());
				// adjuntardocsAux.setThdatafile(blob);
				adjuntardocsAux.setThdatafileinputstream(file.getInputStream());
				adjuntardocsAux.setThcontenttypefile(file.getContentType());
				adjuntardocsAux.setThnofile(file.getOriginalFilename());
				adjuntardocsAux.setThsizefile((int) file.getSize());

			}

			adjuntardocsAux = this.adjuntardocsService.updateAdjuntarDocumentos(adjuntardocsAux);
			AdjuntardocsController.logger.info("[PUT] : Adjuntardocs actualizado correctamente");

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
