package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.AdjuntarDistribuidorService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.AdjuntarDistribuidor;

/**
 * AdjuntarDistribuidorController  
 *  
 */
 
@Controller
@RequestMapping (value = "/adjuntardistribuidor")

public class AdjuntarDistribuidorController  {

	private static final Logger logger = LoggerFactory.getLogger(AdjuntarDistribuidorController.class);

	@Autowired
	private AdjuntarDistribuidorService adjuntarDistribuidorService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AdjuntarDistribuidorController.logger.info("[GET - View] : adjuntardistribuidor");
		return "adjuntardistribuidor";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param rdcodigo String
	 * @return adjuntarDistribuidor AdjuntarDistribuidor
	 */
	@RequestMapping(value = "/{rdcodigo}", method = RequestMethod.GET)
	public @ResponseBody AdjuntarDistribuidor getById(@PathVariable String rdcodigo) {
        AdjuntarDistribuidor adjuntarDistribuidor = new AdjuntarDistribuidor();
		adjuntarDistribuidor.setRdcodigo(rdcodigo);
        adjuntarDistribuidor = this.adjuntarDistribuidorService.find(adjuntarDistribuidor);
        AdjuntarDistribuidorController.logger.info("[GET - findBy_PK] : Obtener AdjuntarDistribuidor por PK");
        return adjuntarDistribuidor;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterAdjuntarDistribuidor AdjuntarDistribuidor
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<AdjuntarDistribuidor> getAll(@ModelAttribute AdjuntarDistribuidor filterAdjuntarDistribuidor) {
		AdjuntarDistribuidorController.logger.info("[GET - find_ALL] : Obtener AdjuntarDistribuidor por filtro");
	    return this.adjuntarDistribuidorService.findAll(filterAdjuntarDistribuidor, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param adjuntarDistribuidor AdjuntarDistribuidor 
	 * @return AdjuntarDistribuidor
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody AdjuntarDistribuidor edit(@RequestBody AdjuntarDistribuidor adjuntarDistribuidor) {		
        AdjuntarDistribuidor adjuntarDistribuidorAux = this.adjuntarDistribuidorService.update(adjuntarDistribuidor);
		AdjuntarDistribuidorController.logger.info("[PUT] : AdjuntarDistribuidor actualizado correctamente");
        return adjuntarDistribuidorAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param adjuntarDistribuidor AdjuntarDistribuidor 
	 * @return AdjuntarDistribuidor
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody AdjuntarDistribuidor add(@RequestBody AdjuntarDistribuidor adjuntarDistribuidor) {		
        AdjuntarDistribuidor adjuntarDistribuidorAux = this.adjuntarDistribuidorService.add(adjuntarDistribuidor);
        AdjuntarDistribuidorController.logger.info("[POST] : AdjuntarDistribuidor insertado correctamente");
    	return adjuntarDistribuidorAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param rdcodigo String
	 * @return adjuntarDistribuidor
	 */
	@RequestMapping(value = "/{rdcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody AdjuntarDistribuidor remove(@PathVariable String rdcodigo) {
        AdjuntarDistribuidor adjuntarDistribuidor = new AdjuntarDistribuidor();
        adjuntarDistribuidor.setRdcodigo(rdcodigo);
        this.adjuntarDistribuidorService.remove(adjuntarDistribuidor);
       	AdjuntarDistribuidorController.logger.info("[DELETE] : AdjuntarDistribuidor borrado correctamente");
       	return adjuntarDistribuidor;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param adjuntarDistribuidorIds List
	 * @return adjuntarDistribuidorList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> adjuntarDistribuidorIds) {
        List<AdjuntarDistribuidor> adjuntarDistribuidorList = new ArrayList<AdjuntarDistribuidor>();
        for (List<String> adjuntarDistribuidorId:adjuntarDistribuidorIds) {
		    Iterator<String> iterator = adjuntarDistribuidorId.iterator();
		    AdjuntarDistribuidor adjuntarDistribuidor = new AdjuntarDistribuidor(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        adjuntarDistribuidor.setRdcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    adjuntarDistribuidorList.add(adjuntarDistribuidor);
	    }
        this.adjuntarDistribuidorService.removeMultiple(adjuntarDistribuidorList);
		AdjuntarDistribuidorController.logger.info("[POST - DELETE_ALL] : AdjuntarDistribuidor borrados correctamente");
		return adjuntarDistribuidorIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterAdjuntarDistribuidor AdjuntarDistribuidor
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute AdjuntarDistribuidor filterAdjuntarDistribuidor, @ModelAttribute Pagination pagination) {
        List<AdjuntarDistribuidor> adjuntarDistribuidors = this.adjuntarDistribuidorService.findAll(filterAdjuntarDistribuidor, pagination);
        Long recordNum = this.adjuntarDistribuidorService.findAllCount(filterAdjuntarDistribuidor);
        AdjuntarDistribuidorController.logger.info("[GET - jqGrid] : Obtener AdjuntarDistribuidor");
		return new JQGridJSONModel(pagination, recordNum, adjuntarDistribuidors);
	}
	
}	
