package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.AdjuntarComusoivrerel;
import com.ejie.y41b.service.AdjuntarComusoivrerelService;

/**
 * AdjuntarComusoivrerelController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/adjuntarcomusoivrerel")
public class AdjuntarComusoivrerelController {

	private static final Logger logger = LoggerFactory
			.getLogger(AdjuntarComusoivrerelController.class);

	@Autowired
	private AdjuntarComusoivrerelService adjuntarComusoivrerelService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AdjuntarComusoivrerelController.logger
				.info("[GET - View] : adjuntarcomusoivrerel");
		return "adjuntarcomusoivrerel";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param v7codigo
	 *            String
	 * @return adjuntarComusoivrerel AdjuntarComusoivrerel
	 */
	@RequestMapping(value = "/{v7codigo}", method = RequestMethod.GET)
	public @ResponseBody
	AdjuntarComusoivrerel getById(@PathVariable String v7codigo) {
		AdjuntarComusoivrerel adjuntarComusoivrerel = new AdjuntarComusoivrerel();
		adjuntarComusoivrerel.setV7codigo(v7codigo);
		adjuntarComusoivrerel = this.adjuntarComusoivrerelService
				.find(adjuntarComusoivrerel);
		AdjuntarComusoivrerelController.logger
				.info("[GET - findBy_PK] : Obtener AdjuntarComusoivrerel por PK");
		return adjuntarComusoivrerel;
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return AdjuntarComusoivrerel
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	AdjuntarComusoivrerel edit(
			@RequestBody AdjuntarComusoivrerel adjuntarComusoivrerel) {
		AdjuntarComusoivrerel adjuntarComusoivrerelAux = this.adjuntarComusoivrerelService
				.update(adjuntarComusoivrerel);
		AdjuntarComusoivrerelController.logger
				.info("[PUT] : AdjuntarComusoivrerel actualizado correctamente");
		return adjuntarComusoivrerelAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return AdjuntarComusoivrerel
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	AdjuntarComusoivrerel add(
			@RequestBody AdjuntarComusoivrerel adjuntarComusoivrerel) {
		AdjuntarComusoivrerel adjuntarComusoivrerelAux = this.adjuntarComusoivrerelService
				.add(adjuntarComusoivrerel);
		AdjuntarComusoivrerelController.logger
				.info("[POST] : AdjuntarComusoivrerel insertado correctamente");
		return adjuntarComusoivrerelAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param v7codigo
	 *            String
	 * @return adjuntarComusoivrerel
	 */
	@RequestMapping(value = "/{v7codigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	AdjuntarComusoivrerel remove(@PathVariable String v7codigo) {
		AdjuntarComusoivrerel adjuntarComusoivrerel = new AdjuntarComusoivrerel();
		adjuntarComusoivrerel.setV7codigo(v7codigo);
		this.adjuntarComusoivrerelService.remove(adjuntarComusoivrerel);
		AdjuntarComusoivrerelController.logger
				.info("[DELETE] : AdjuntarComusoivrerel borrado correctamente");
		return adjuntarComusoivrerel;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param adjuntarComusoivrerelIds
	 *            List
	 * @return adjuntarComusoivrerelList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> adjuntarComusoivrerelIds) {
		List<AdjuntarComusoivrerel> adjuntarComusoivrerelList = new ArrayList<AdjuntarComusoivrerel>();
		for (List<String> adjuntarComusoivrerelId : adjuntarComusoivrerelIds) {
			Iterator<String> iterator = adjuntarComusoivrerelId.iterator();
			AdjuntarComusoivrerel adjuntarComusoivrerel = new AdjuntarComusoivrerel(); // NOPMD
																						// -
																						// Objeto
																						// nuevo
																						// en
																						// la
																						// lista
																						// (parametro
																						// del
																						// servicio)
			adjuntarComusoivrerel.setV7codigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			adjuntarComusoivrerelList.add(adjuntarComusoivrerel);
		}
		this.adjuntarComusoivrerelService
				.removeMultiple(adjuntarComusoivrerelList);
		AdjuntarComusoivrerelController.logger
				.info("[POST - DELETE_ALL] : AdjuntarComusoivrerel borrados correctamente");
		return adjuntarComusoivrerelIds;
	}

}
