package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.AdjuntarCampanhaprograService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.AdjuntarCampanhaprogra;

/**
 * AdjuntarCampanhaprograController  
 *  
 */
 
@Controller
@RequestMapping (value = "/adjuntarcampanhaprogra")

public class AdjuntarCampanhaprograController  {

	private static final Logger logger = LoggerFactory.getLogger(AdjuntarCampanhaprograController.class);

	@Autowired
	private AdjuntarCampanhaprograService adjuntarCampanhaprograService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AdjuntarCampanhaprograController.logger.info("[GET - View] : adjuntarcampanhaprogra");
		return "adjuntarcampanhaprogra";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param pgcodigo String
	 * @param pgnombre String
	 * @param pgcotpg String
	 * @param pgcocm String
	 * @param pgfedesd Date
	 * @param pgfehast Date
	 * @param pgcoor String
	 * @param pginsese String
	 * @param pgnumTomasMuestrasSol Integer
	 * @param pgnumControlesEstandarSol Integer
	 * @param pgnumControlesOtrosSol Integer
	 * @param pgnumInspecAdicionalesSol Integer
	 * @param pgfase String
	 * @return adjuntarCampanhaprogra AdjuntarCampanhaprogra
	 */
	@RequestMapping(value = "/{pgcodigo}/{pgnombre}/{pgcotpg}/{pgcocm}/{pgfedesd}/{pgfehast}/{pgcoor}/{pginsese}/{pgnumTomasMuestrasSol}/{pgnumControlesEstandarSol}/{pgnumControlesOtrosSol}/{pgnumInspecAdicionalesSol}/{pgfase}", method = RequestMethod.GET)
	public @ResponseBody AdjuntarCampanhaprogra getById(@PathVariable String pgcodigo, @PathVariable String pgnombre, @PathVariable String pgcotpg, @PathVariable String pgcocm, @PathVariable Date pgfedesd, @PathVariable Date pgfehast, @PathVariable String pgcoor, @PathVariable String pginsese, @PathVariable Integer pgnumTomasMuestrasSol, @PathVariable Integer pgnumControlesEstandarSol, @PathVariable Integer pgnumControlesOtrosSol, @PathVariable Integer pgnumInspecAdicionalesSol, @PathVariable String pgfase) {
        AdjuntarCampanhaprogra adjuntarCampanhaprogra = new AdjuntarCampanhaprogra();
		adjuntarCampanhaprogra.setPgcodigo(pgcodigo);
		adjuntarCampanhaprogra.setPgnombre(pgnombre);
		adjuntarCampanhaprogra.setPgcotpg(pgcotpg);
		adjuntarCampanhaprogra.setPgcocm(pgcocm);
		adjuntarCampanhaprogra.setPgfedesd(pgfedesd);
		adjuntarCampanhaprogra.setPgfehast(pgfehast);
		adjuntarCampanhaprogra.setPgcoor(pgcoor);
		adjuntarCampanhaprogra.setPginsese(pginsese);
		adjuntarCampanhaprogra.setPgnumTomasMuestrasSol(pgnumTomasMuestrasSol);
		adjuntarCampanhaprogra.setPgnumControlesEstandarSol(pgnumControlesEstandarSol);
		adjuntarCampanhaprogra.setPgnumControlesOtrosSol(pgnumControlesOtrosSol);
		adjuntarCampanhaprogra.setPgnumInspecAdicionalesSol(pgnumInspecAdicionalesSol);
		adjuntarCampanhaprogra.setPgfase(pgfase);
        adjuntarCampanhaprogra = this.adjuntarCampanhaprograService.find(adjuntarCampanhaprogra);
        AdjuntarCampanhaprograController.logger.info("[GET - findBy_PK] : Obtener AdjuntarCampanhaprogra por PK");
        return adjuntarCampanhaprogra;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterAdjuntarCampanhaprogra AdjuntarCampanhaprogra
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<AdjuntarCampanhaprogra> getAll(@ModelAttribute AdjuntarCampanhaprogra filterAdjuntarCampanhaprogra) {
		AdjuntarCampanhaprograController.logger.info("[GET - find_ALL] : Obtener AdjuntarCampanhaprogra por filtro");
	    return this.adjuntarCampanhaprograService.findAll(filterAdjuntarCampanhaprogra, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param adjuntarCampanhaprogra AdjuntarCampanhaprogra 
	 * @return AdjuntarCampanhaprogra
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody AdjuntarCampanhaprogra edit(@RequestBody AdjuntarCampanhaprogra adjuntarCampanhaprogra) {		
        AdjuntarCampanhaprogra adjuntarCampanhaprograAux = this.adjuntarCampanhaprograService.update(adjuntarCampanhaprogra);
		AdjuntarCampanhaprograController.logger.info("[PUT] : AdjuntarCampanhaprogra actualizado correctamente");
        return adjuntarCampanhaprograAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param adjuntarCampanhaprogra AdjuntarCampanhaprogra 
	 * @return AdjuntarCampanhaprogra
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody AdjuntarCampanhaprogra add(@RequestBody AdjuntarCampanhaprogra adjuntarCampanhaprogra) {		
        AdjuntarCampanhaprogra adjuntarCampanhaprograAux = this.adjuntarCampanhaprograService.add(adjuntarCampanhaprogra);
        AdjuntarCampanhaprograController.logger.info("[POST] : AdjuntarCampanhaprogra insertado correctamente");
    	return adjuntarCampanhaprograAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param pgcodigo String
	 * @param pgnombre String
	 * @param pgcotpg String
	 * @param pgcocm String
	 * @param pgfedesd Date
	 * @param pgfehast Date
	 * @param pgcoor String
	 * @param pginsese String
	 * @param pgnumTomasMuestrasSol Integer
	 * @param pgnumControlesEstandarSol Integer
	 * @param pgnumControlesOtrosSol Integer
	 * @param pgnumInspecAdicionalesSol Integer
	 * @param pgfase String
	 * @return adjuntarCampanhaprogra
	 */
	@RequestMapping(value = "/{pgcodigo}/{pgnombre}/{pgcotpg}/{pgcocm}/{pgfedesd}/{pgfehast}/{pgcoor}/{pginsese}/{pgnumTomasMuestrasSol}/{pgnumControlesEstandarSol}/{pgnumControlesOtrosSol}/{pgnumInspecAdicionalesSol}/{pgfase}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody AdjuntarCampanhaprogra remove(@PathVariable String pgcodigo, @PathVariable String pgnombre, @PathVariable String pgcotpg, @PathVariable String pgcocm, @PathVariable Date pgfedesd, @PathVariable Date pgfehast, @PathVariable String pgcoor, @PathVariable String pginsese, @PathVariable Integer pgnumTomasMuestrasSol, @PathVariable Integer pgnumControlesEstandarSol, @PathVariable Integer pgnumControlesOtrosSol, @PathVariable Integer pgnumInspecAdicionalesSol, @PathVariable String pgfase) {
        AdjuntarCampanhaprogra adjuntarCampanhaprogra = new AdjuntarCampanhaprogra();
        adjuntarCampanhaprogra.setPgcodigo(pgcodigo);
        adjuntarCampanhaprogra.setPgnombre(pgnombre);
        adjuntarCampanhaprogra.setPgcotpg(pgcotpg);
        adjuntarCampanhaprogra.setPgcocm(pgcocm);
        adjuntarCampanhaprogra.setPgfedesd(pgfedesd);
        adjuntarCampanhaprogra.setPgfehast(pgfehast);
        adjuntarCampanhaprogra.setPgcoor(pgcoor);
        adjuntarCampanhaprogra.setPginsese(pginsese);
        adjuntarCampanhaprogra.setPgnumTomasMuestrasSol(pgnumTomasMuestrasSol);
        adjuntarCampanhaprogra.setPgnumControlesEstandarSol(pgnumControlesEstandarSol);
        adjuntarCampanhaprogra.setPgnumControlesOtrosSol(pgnumControlesOtrosSol);
        adjuntarCampanhaprogra.setPgnumInspecAdicionalesSol(pgnumInspecAdicionalesSol);
        adjuntarCampanhaprogra.setPgfase(pgfase);
        this.adjuntarCampanhaprograService.remove(adjuntarCampanhaprogra);
       	AdjuntarCampanhaprograController.logger.info("[DELETE] : AdjuntarCampanhaprogra borrado correctamente");
       	return adjuntarCampanhaprogra;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param adjuntarCampanhaprograIds List
	 * @return adjuntarCampanhaprograList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> adjuntarCampanhaprograIds) {
        List<AdjuntarCampanhaprogra> adjuntarCampanhaprograList = new ArrayList<AdjuntarCampanhaprogra>();
        for (List<String> adjuntarCampanhaprograId:adjuntarCampanhaprograIds) {
		    Iterator<String> iterator = adjuntarCampanhaprograId.iterator();
		    AdjuntarCampanhaprogra adjuntarCampanhaprogra = new AdjuntarCampanhaprogra(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        adjuntarCampanhaprogra.setPgcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
	        adjuntarCampanhaprogra.setPgnombre(ObjectConversionManager.convert(iterator.next(), String.class));
	        adjuntarCampanhaprogra.setPgcotpg(ObjectConversionManager.convert(iterator.next(), String.class));
	        adjuntarCampanhaprogra.setPgcocm(ObjectConversionManager.convert(iterator.next(), String.class));
	        adjuntarCampanhaprogra.setPgfedesd(ObjectConversionManager.convert(iterator.next(), java.util.Date.class));
	        adjuntarCampanhaprogra.setPgfehast(ObjectConversionManager.convert(iterator.next(), java.util.Date.class));
	        adjuntarCampanhaprogra.setPgcoor(ObjectConversionManager.convert(iterator.next(), String.class));
	        adjuntarCampanhaprogra.setPginsese(ObjectConversionManager.convert(iterator.next(), String.class));
	        adjuntarCampanhaprogra.setPgnumTomasMuestrasSol(ObjectConversionManager.convert(iterator.next(), java.lang.Integer.class));
	        adjuntarCampanhaprogra.setPgnumControlesEstandarSol(ObjectConversionManager.convert(iterator.next(), java.lang.Integer.class));
	        adjuntarCampanhaprogra.setPgnumControlesOtrosSol(ObjectConversionManager.convert(iterator.next(), java.lang.Integer.class));
	        adjuntarCampanhaprogra.setPgnumInspecAdicionalesSol(ObjectConversionManager.convert(iterator.next(), java.lang.Integer.class));
	        adjuntarCampanhaprogra.setPgfase(ObjectConversionManager.convert(iterator.next(), String.class));
		    adjuntarCampanhaprograList.add(adjuntarCampanhaprogra);
	    }
        this.adjuntarCampanhaprograService.removeMultiple(adjuntarCampanhaprograList);
		AdjuntarCampanhaprograController.logger.info("[POST - DELETE_ALL] : AdjuntarCampanhaprogra borrados correctamente");
		return adjuntarCampanhaprograIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterAdjuntarCampanhaprogra AdjuntarCampanhaprogra
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute AdjuntarCampanhaprogra filterAdjuntarCampanhaprogra, @ModelAttribute Pagination pagination) {
        List<AdjuntarCampanhaprogra> adjuntarCampanhaprogras = this.adjuntarCampanhaprograService.findAll(filterAdjuntarCampanhaprogra, pagination);
        Long recordNum = this.adjuntarCampanhaprograService.findAllCount(filterAdjuntarCampanhaprogra);
        AdjuntarCampanhaprograController.logger.info("[GET - jqGrid] : Obtener AdjuntarCampanhaprogra");
		return new JQGridJSONModel(pagination, recordNum, adjuntarCampanhaprogras);
	}
	
}	
