package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.AdjuntarCampanhaproductoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.AdjuntarCampanhaproducto;

/**
 * AdjuntarCampanhaproductoController  
 *  
 */
 
@Controller
@RequestMapping (value = "/adjuntarcampanhaproducto")

public class AdjuntarCampanhaproductoController  {

	private static final Logger logger = LoggerFactory.getLogger(AdjuntarCampanhaproductoController.class);

	@Autowired
	private AdjuntarCampanhaproductoService adjuntarCampanhaproductoService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AdjuntarCampanhaproductoController.logger.info("[GET - View] : adjuntarcampanhaproducto");
		return "adjuntarcampanhaproducto";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param cpcodigo String
	 * @return adjuntarCampanhaproducto AdjuntarCampanhaproducto
	 */
	@RequestMapping(value = "/{cpcodigo}", method = RequestMethod.GET)
	public @ResponseBody AdjuntarCampanhaproducto getById(@PathVariable String cpcodigo) {
        AdjuntarCampanhaproducto adjuntarCampanhaproducto = new AdjuntarCampanhaproducto();
		adjuntarCampanhaproducto.setCpcodigo(cpcodigo);
        adjuntarCampanhaproducto = this.adjuntarCampanhaproductoService.find(adjuntarCampanhaproducto);
        AdjuntarCampanhaproductoController.logger.info("[GET - findBy_PK] : Obtener AdjuntarCampanhaproducto por PK");
        return adjuntarCampanhaproducto;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterAdjuntarCampanhaproducto AdjuntarCampanhaproducto
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<AdjuntarCampanhaproducto> getAll(@ModelAttribute AdjuntarCampanhaproducto filterAdjuntarCampanhaproducto) {
		AdjuntarCampanhaproductoController.logger.info("[GET - find_ALL] : Obtener AdjuntarCampanhaproducto por filtro");
	    return this.adjuntarCampanhaproductoService.findAll(filterAdjuntarCampanhaproducto, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param adjuntarCampanhaproducto AdjuntarCampanhaproducto 
	 * @return AdjuntarCampanhaproducto
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody AdjuntarCampanhaproducto edit(@RequestBody AdjuntarCampanhaproducto adjuntarCampanhaproducto) {		
        AdjuntarCampanhaproducto adjuntarCampanhaproductoAux = this.adjuntarCampanhaproductoService.update(adjuntarCampanhaproducto);
		AdjuntarCampanhaproductoController.logger.info("[PUT] : AdjuntarCampanhaproducto actualizado correctamente");
        return adjuntarCampanhaproductoAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param adjuntarCampanhaproducto AdjuntarCampanhaproducto 
	 * @return AdjuntarCampanhaproducto
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody AdjuntarCampanhaproducto add(@RequestBody AdjuntarCampanhaproducto adjuntarCampanhaproducto) {		
        AdjuntarCampanhaproducto adjuntarCampanhaproductoAux = this.adjuntarCampanhaproductoService.add(adjuntarCampanhaproducto);
        AdjuntarCampanhaproductoController.logger.info("[POST] : AdjuntarCampanhaproducto insertado correctamente");
    	return adjuntarCampanhaproductoAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param cpcodigo String
	 * @return adjuntarCampanhaproducto
	 */
	@RequestMapping(value = "/{cpcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody AdjuntarCampanhaproducto remove(@PathVariable String cpcodigo) {
        AdjuntarCampanhaproducto adjuntarCampanhaproducto = new AdjuntarCampanhaproducto();
        adjuntarCampanhaproducto.setCpcodigo(cpcodigo);
        this.adjuntarCampanhaproductoService.remove(adjuntarCampanhaproducto);
       	AdjuntarCampanhaproductoController.logger.info("[DELETE] : AdjuntarCampanhaproducto borrado correctamente");
       	return adjuntarCampanhaproducto;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param adjuntarCampanhaproductoIds List
	 * @return adjuntarCampanhaproductoList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> adjuntarCampanhaproductoIds) {
        List<AdjuntarCampanhaproducto> adjuntarCampanhaproductoList = new ArrayList<AdjuntarCampanhaproducto>();
        for (List<String> adjuntarCampanhaproductoId:adjuntarCampanhaproductoIds) {
		    Iterator<String> iterator = adjuntarCampanhaproductoId.iterator();
		    AdjuntarCampanhaproducto adjuntarCampanhaproducto = new AdjuntarCampanhaproducto(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        adjuntarCampanhaproducto.setCpcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    adjuntarCampanhaproductoList.add(adjuntarCampanhaproducto);
	    }
        this.adjuntarCampanhaproductoService.removeMultiple(adjuntarCampanhaproductoList);
		AdjuntarCampanhaproductoController.logger.info("[POST - DELETE_ALL] : AdjuntarCampanhaproducto borrados correctamente");
		return adjuntarCampanhaproductoIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterAdjuntarCampanhaproducto AdjuntarCampanhaproducto
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute AdjuntarCampanhaproducto filterAdjuntarCampanhaproducto, @ModelAttribute Pagination pagination) {
        List<AdjuntarCampanhaproducto> adjuntarCampanhaproductos = this.adjuntarCampanhaproductoService.findAll(filterAdjuntarCampanhaproducto, pagination);
        Long recordNum = this.adjuntarCampanhaproductoService.findAllCount(filterAdjuntarCampanhaproducto);
        AdjuntarCampanhaproductoController.logger.info("[GET - jqGrid] : Obtener AdjuntarCampanhaproducto");
		return new JQGridJSONModel(pagination, recordNum, adjuntarCampanhaproductos);
	}
	
}	
