package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.AdjuntarAlertaprograService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.AdjuntarAlertaprogra;

/**
 * AdjuntarAlertaprograController  
 *  
 */
 
@Controller
@RequestMapping (value = "/adjuntaralertaprogra")

public class AdjuntarAlertaprograController  {

	private static final Logger logger = LoggerFactory.getLogger(AdjuntarAlertaprograController.class);

	@Autowired
	private AdjuntarAlertaprograService adjuntarAlertaprograService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AdjuntarAlertaprograController.logger.info("[GET - View] : adjuntaralertaprogra");
		return "adjuntaralertaprogra";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param crcodigo String
	 * @return adjuntarAlertaprogra AdjuntarAlertaprogra
	 */
	@RequestMapping(value = "/{crcodigo}", method = RequestMethod.GET)
	public @ResponseBody AdjuntarAlertaprogra getById(@PathVariable String crcodigo) {
        AdjuntarAlertaprogra adjuntarAlertaprogra = new AdjuntarAlertaprogra();
		adjuntarAlertaprogra.setCrcodigo(crcodigo);
        adjuntarAlertaprogra = this.adjuntarAlertaprograService.find(adjuntarAlertaprogra);
        AdjuntarAlertaprograController.logger.info("[GET - findBy_PK] : Obtener AdjuntarAlertaprogra por PK");
        return adjuntarAlertaprogra;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterAdjuntarAlertaprogra AdjuntarAlertaprogra
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<AdjuntarAlertaprogra> getAll(@ModelAttribute AdjuntarAlertaprogra filterAdjuntarAlertaprogra) {
		AdjuntarAlertaprograController.logger.info("[GET - find_ALL] : Obtener AdjuntarAlertaprogra por filtro");
	    return this.adjuntarAlertaprograService.findAll(filterAdjuntarAlertaprogra, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param adjuntarAlertaprogra AdjuntarAlertaprogra 
	 * @return AdjuntarAlertaprogra
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody AdjuntarAlertaprogra edit(@RequestBody AdjuntarAlertaprogra adjuntarAlertaprogra) {		
        AdjuntarAlertaprogra adjuntarAlertaprograAux = this.adjuntarAlertaprograService.update(adjuntarAlertaprogra);
		AdjuntarAlertaprograController.logger.info("[PUT] : AdjuntarAlertaprogra actualizado correctamente");
        return adjuntarAlertaprograAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param adjuntarAlertaprogra AdjuntarAlertaprogra 
	 * @return AdjuntarAlertaprogra
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody AdjuntarAlertaprogra add(@RequestBody AdjuntarAlertaprogra adjuntarAlertaprogra) {		
        AdjuntarAlertaprogra adjuntarAlertaprograAux = this.adjuntarAlertaprograService.add(adjuntarAlertaprogra);
        AdjuntarAlertaprograController.logger.info("[POST] : AdjuntarAlertaprogra insertado correctamente");
    	return adjuntarAlertaprograAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param crcodigo String
	 * @return adjuntarAlertaprogra
	 */
	@RequestMapping(value = "/{crcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody AdjuntarAlertaprogra remove(@PathVariable String crcodigo) {
        AdjuntarAlertaprogra adjuntarAlertaprogra = new AdjuntarAlertaprogra();
        adjuntarAlertaprogra.setCrcodigo(crcodigo);
        this.adjuntarAlertaprograService.remove(adjuntarAlertaprogra);
       	AdjuntarAlertaprograController.logger.info("[DELETE] : AdjuntarAlertaprogra borrado correctamente");
       	return adjuntarAlertaprogra;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param adjuntarAlertaprograIds List
	 * @return adjuntarAlertaprograList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> adjuntarAlertaprograIds) {
        List<AdjuntarAlertaprogra> adjuntarAlertaprograList = new ArrayList<AdjuntarAlertaprogra>();
        for (List<String> adjuntarAlertaprograId:adjuntarAlertaprograIds) {
		    Iterator<String> iterator = adjuntarAlertaprograId.iterator();
		    AdjuntarAlertaprogra adjuntarAlertaprogra = new AdjuntarAlertaprogra(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        adjuntarAlertaprogra.setCrcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    adjuntarAlertaprograList.add(adjuntarAlertaprogra);
	    }
        this.adjuntarAlertaprograService.removeMultiple(adjuntarAlertaprograList);
		AdjuntarAlertaprograController.logger.info("[POST - DELETE_ALL] : AdjuntarAlertaprogra borrados correctamente");
		return adjuntarAlertaprograIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterAdjuntarAlertaprogra AdjuntarAlertaprogra
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute AdjuntarAlertaprogra filterAdjuntarAlertaprogra, @ModelAttribute Pagination pagination) {
        List<AdjuntarAlertaprogra> adjuntarAlertaprogras = this.adjuntarAlertaprograService.findAll(filterAdjuntarAlertaprogra, pagination);
        Long recordNum = this.adjuntarAlertaprograService.findAllCount(filterAdjuntarAlertaprogra);
        AdjuntarAlertaprograController.logger.info("[GET - jqGrid] : Obtener AdjuntarAlertaprogra");
		return new JQGridJSONModel(pagination, recordNum, adjuntarAlertaprogras);
	}
	
}	
