package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.AdjunInfraccHechoDenunService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.AdjunInfraccHechoDenun;

/**
 * AdjunInfraccHechoDenunController  
 *  
 */
 
@Controller
@RequestMapping (value = "/adjuninfracchechodenun")

public class AdjunInfraccHechoDenunController  {

	private static final Logger logger = LoggerFactory.getLogger(AdjunInfraccHechoDenunController.class);

	@Autowired
	private AdjunInfraccHechoDenunService adjunInfraccHechoDenunService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AdjunInfraccHechoDenunController.logger.info("[GET - View] : adjuninfracchechodenun");
		return "adjuninfracchechodenun";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param hicodigo String
	 * @param hicohd String
	 * @param hicotti String
	 * @param hiinexii String
	 * @param hiifid String
	 * @return adjunInfraccHechoDenun AdjunInfraccHechoDenun
	 */
	@RequestMapping(value = "/{hicodigo}/{hicohd}/{hicotti}/{hiinexii}/{hiifid}", method = RequestMethod.GET)
	public @ResponseBody AdjunInfraccHechoDenun getById(@PathVariable String hicodigo, @PathVariable String hicohd, @PathVariable String hicotti, @PathVariable String hiinexii, @PathVariable String hiifid) {
        AdjunInfraccHechoDenun adjunInfraccHechoDenun = new AdjunInfraccHechoDenun();
		adjunInfraccHechoDenun.setHicodigo(hicodigo);
		adjunInfraccHechoDenun.setHicohd(hicohd);
		adjunInfraccHechoDenun.setHicotti(hicotti);
		adjunInfraccHechoDenun.setHiinexii(hiinexii);
		adjunInfraccHechoDenun.setHiifid(hiifid);
        adjunInfraccHechoDenun = this.adjunInfraccHechoDenunService.find(adjunInfraccHechoDenun);
        AdjunInfraccHechoDenunController.logger.info("[GET - findBy_PK] : Obtener AdjunInfraccHechoDenun por PK");
        return adjunInfraccHechoDenun;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterAdjunInfraccHechoDenun AdjunInfraccHechoDenun
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<AdjunInfraccHechoDenun> getAll(@ModelAttribute AdjunInfraccHechoDenun filterAdjunInfraccHechoDenun) {
		AdjunInfraccHechoDenunController.logger.info("[GET - find_ALL] : Obtener AdjunInfraccHechoDenun por filtro");
	    return this.adjunInfraccHechoDenunService.findAll(filterAdjunInfraccHechoDenun, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param adjunInfraccHechoDenun AdjunInfraccHechoDenun 
	 * @return AdjunInfraccHechoDenun
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody AdjunInfraccHechoDenun edit(@RequestBody AdjunInfraccHechoDenun adjunInfraccHechoDenun) {		
        AdjunInfraccHechoDenun adjunInfraccHechoDenunAux = this.adjunInfraccHechoDenunService.update(adjunInfraccHechoDenun);
		AdjunInfraccHechoDenunController.logger.info("[PUT] : AdjunInfraccHechoDenun actualizado correctamente");
        return adjunInfraccHechoDenunAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param adjunInfraccHechoDenun AdjunInfraccHechoDenun 
	 * @return AdjunInfraccHechoDenun
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody AdjunInfraccHechoDenun add(@RequestBody AdjunInfraccHechoDenun adjunInfraccHechoDenun) {		
        AdjunInfraccHechoDenun adjunInfraccHechoDenunAux = this.adjunInfraccHechoDenunService.add(adjunInfraccHechoDenun);
        AdjunInfraccHechoDenunController.logger.info("[POST] : AdjunInfraccHechoDenun insertado correctamente");
    	return adjunInfraccHechoDenunAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param hicodigo String
	 * @param hicohd String
	 * @param hicotti String
	 * @param hiinexii String
	 * @param hiifid String
	 * @return adjunInfraccHechoDenun
	 */
	@RequestMapping(value = "/{hicodigo}/{hicohd}/{hicotti}/{hiinexii}/{hiifid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody AdjunInfraccHechoDenun remove(@PathVariable String hicodigo, @PathVariable String hicohd, @PathVariable String hicotti, @PathVariable String hiinexii, @PathVariable String hiifid) {
        AdjunInfraccHechoDenun adjunInfraccHechoDenun = new AdjunInfraccHechoDenun();
        adjunInfraccHechoDenun.setHicodigo(hicodigo);
        adjunInfraccHechoDenun.setHicohd(hicohd);
        adjunInfraccHechoDenun.setHicotti(hicotti);
        adjunInfraccHechoDenun.setHiinexii(hiinexii);
        adjunInfraccHechoDenun.setHiifid(hiifid);
        this.adjunInfraccHechoDenunService.remove(adjunInfraccHechoDenun);
       	AdjunInfraccHechoDenunController.logger.info("[DELETE] : AdjunInfraccHechoDenun borrado correctamente");
       	return adjunInfraccHechoDenun;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param adjunInfraccHechoDenunIds List
	 * @return adjunInfraccHechoDenunList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> adjunInfraccHechoDenunIds) {
        List<AdjunInfraccHechoDenun> adjunInfraccHechoDenunList = new ArrayList<AdjunInfraccHechoDenun>();
        for (List<String> adjunInfraccHechoDenunId:adjunInfraccHechoDenunIds) {
		    Iterator<String> iterator = adjunInfraccHechoDenunId.iterator();
		    AdjunInfraccHechoDenun adjunInfraccHechoDenun = new AdjunInfraccHechoDenun(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        adjunInfraccHechoDenun.setHicodigo(ObjectConversionManager.convert(iterator.next(), String.class));
	        adjunInfraccHechoDenun.setHicohd(ObjectConversionManager.convert(iterator.next(), String.class));
	        adjunInfraccHechoDenun.setHicotti(ObjectConversionManager.convert(iterator.next(), String.class));
	        adjunInfraccHechoDenun.setHiinexii(ObjectConversionManager.convert(iterator.next(), String.class));
	        adjunInfraccHechoDenun.setHiifid(ObjectConversionManager.convert(iterator.next(), String.class));
		    adjunInfraccHechoDenunList.add(adjunInfraccHechoDenun);
	    }
        this.adjunInfraccHechoDenunService.removeMultiple(adjunInfraccHechoDenunList);
		AdjunInfraccHechoDenunController.logger.info("[POST - DELETE_ALL] : AdjunInfraccHechoDenun borrados correctamente");
		return adjunInfraccHechoDenunIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterAdjunInfraccHechoDenun AdjunInfraccHechoDenun
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute AdjunInfraccHechoDenun filterAdjunInfraccHechoDenun, @ModelAttribute Pagination pagination) {
        List<AdjunInfraccHechoDenun> adjunInfraccHechoDenuns = this.adjunInfraccHechoDenunService.findAll(filterAdjunInfraccHechoDenun, pagination);
        Long recordNum = this.adjunInfraccHechoDenunService.findAllCount(filterAdjunInfraccHechoDenun);
        AdjunInfraccHechoDenunController.logger.info("[GET - jqGrid] : Obtener AdjunInfraccHechoDenun");
		return new JQGridJSONModel(pagination, recordNum, adjunInfraccHechoDenuns);
	}
	
}	
