package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.AdjunInfraccArbService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.AdjunInfraccArb;

/**
 * AdjunInfraccArbController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/adjuninfraccarb")
public class AdjunInfraccArbController {

	private static final Logger logger = LoggerFactory
			.getLogger(AdjunInfraccArbController.class);

	@Autowired
	private AdjunInfraccArbService adjunInfraccArbService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AdjunInfraccArbController.logger.info("[GET - View] : adjuninfraccarb");
		return "adjuninfraccarb";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param hicodigo
	 *            String
	 * @param hicoarb
	 *            String
	 * @param hicotti
	 *            String
	 * @param hiinexii
	 *            String
	 * @param hiifid
	 *            String
	 * @return adjunInfraccArb AdjunInfraccArb
	 */
	@RequestMapping(value = "/{hicodigo}/{hicoarb}/{hicotti}/{hiinexii}/{hiifid}", method = RequestMethod.GET)
	public @ResponseBody
	AdjunInfraccArb getById(@PathVariable String hicodigo,
			@PathVariable String hicoarb, @PathVariable String hicotti,
			@PathVariable String hiinexii, @PathVariable String hiifid) {
		AdjunInfraccArb adjunInfraccArb = new AdjunInfraccArb();
		adjunInfraccArb.setHicodigo(hicodigo);
		adjunInfraccArb.setHicoarb(hicoarb);
		adjunInfraccArb.setHicotti(hicotti);
		adjunInfraccArb.setHiinexii(hiinexii);
		adjunInfraccArb.setHiifid(hiifid);
		adjunInfraccArb = this.adjunInfraccArbService.find(adjunInfraccArb);
		AdjunInfraccArbController.logger
				.info("[GET - findBy_PK] : Obtener AdjunInfraccArb por PK");
		return adjunInfraccArb;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterAdjunInfraccArb
	 *            AdjunInfraccArb
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<AdjunInfraccArb> getAll(
			@ModelAttribute AdjunInfraccArb filterAdjunInfraccArb) {
		AdjunInfraccArbController.logger
				.info("[GET - find_ALL] : Obtener AdjunInfraccArb por filtro");
		return this.adjunInfraccArbService.findAll(filterAdjunInfraccArb, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @return AdjunInfraccArb
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	AdjunInfraccArb edit(@RequestBody AdjunInfraccArb adjunInfraccArb) {
		AdjunInfraccArb adjunInfraccArbAux = this.adjunInfraccArbService
				.update(adjunInfraccArb);
		AdjunInfraccArbController.logger
				.info("[PUT] : AdjunInfraccArb actualizado correctamente");
		return adjunInfraccArbAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @return AdjunInfraccArb
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	AdjunInfraccArb add(@RequestBody AdjunInfraccArb adjunInfraccArb) {
		AdjunInfraccArb adjunInfraccArbAux = this.adjunInfraccArbService
				.add(adjunInfraccArb);
		AdjunInfraccArbController.logger
				.info("[POST] : AdjunInfraccArb insertado correctamente");
		return adjunInfraccArbAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param hicodigo
	 *            String
	 * @param hicoarb
	 *            String
	 * @param hicotti
	 *            String
	 * @param hiinexii
	 *            String
	 * @param hiifid
	 *            String
	 * @return adjunInfraccArb
	 */
	@RequestMapping(value = "/{hicodigo}/{hicoarb}/{hicotti}/{hiinexii}/{hiifid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	AdjunInfraccArb remove(@PathVariable String hicodigo,
			@PathVariable String hicoarb, @PathVariable String hicotti,
			@PathVariable String hiinexii, @PathVariable String hiifid) {
		AdjunInfraccArb adjunInfraccArb = new AdjunInfraccArb();
		adjunInfraccArb.setHicodigo(hicodigo);
		adjunInfraccArb.setHicoarb(hicoarb);
		adjunInfraccArb.setHicotti(hicotti);
		adjunInfraccArb.setHiinexii(hiinexii);
		adjunInfraccArb.setHiifid(hiifid);
		this.adjunInfraccArbService.remove(adjunInfraccArb);
		AdjunInfraccArbController.logger
				.info("[DELETE] : AdjunInfraccArb borrado correctamente");
		return adjunInfraccArb;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param adjunInfraccArbIds
	 *            List
	 * @return adjunInfraccArbList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> adjunInfraccArbIds) {
		List<AdjunInfraccArb> adjunInfraccArbList = new ArrayList<AdjunInfraccArb>();
		for (List<String> adjunInfraccArbId : adjunInfraccArbIds) {
			Iterator<String> iterator = adjunInfraccArbId.iterator();
			AdjunInfraccArb adjunInfraccArb = new AdjunInfraccArb(); // NOPMD -
																		// Objeto
																		// nuevo
																		// en la
																		// lista
																		// (parametro
																		// del
																		// servicio)
			adjunInfraccArb.setHicodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			adjunInfraccArb.setHicoarb(ObjectConversionManager.convert(
					iterator.next(), String.class));
			adjunInfraccArb.setHicotti(ObjectConversionManager.convert(
					iterator.next(), String.class));
			adjunInfraccArb.setHiinexii(ObjectConversionManager.convert(
					iterator.next(), String.class));
			adjunInfraccArb.setHiifid(ObjectConversionManager.convert(
					iterator.next(), String.class));
			adjunInfraccArbList.add(adjunInfraccArb);
		}
		this.adjunInfraccArbService.removeMultiple(adjunInfraccArbList);
		AdjunInfraccArbController.logger
				.info("[POST - DELETE_ALL] : AdjunInfraccArb borrados correctamente");
		return adjunInfraccArbIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterAdjunInfraccArb
	 *            AdjunInfraccArb
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute AdjunInfraccArb filterAdjunInfraccArb,
			@ModelAttribute Pagination pagination) {
		List<AdjunInfraccArb> adjunInfraccArbs = this.adjunInfraccArbService
				.findAll(filterAdjunInfraccArb, pagination);
		Long recordNum = this.adjunInfraccArbService
				.findAllCount(filterAdjunInfraccArb);
		AdjunInfraccArbController.logger
				.info("[GET - jqGrid] : Obtener AdjunInfraccArb");
		return new JQGridJSONModel(pagination, recordNum, adjunInfraccArbs);
	}

}
