package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.AdjunDatosMailSedeService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.AdjunDatosMailSede;

/**
 * AdjunDatosMailSedeController  
 *  
 */
 
@Controller
@RequestMapping (value = "/adjundatosmailsede")

public class AdjunDatosMailSedeController  {

	private static final Logger logger = LoggerFactory.getLogger(AdjunDatosMailSedeController.class);

	@Autowired
	private AdjunDatosMailSedeService adjunDatosMailSedeService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AdjunDatosMailSedeController.logger.info("[GET - View] : adjundatosmailsede");
		return "adjundatosmailsede";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param idDatomail String
	 * @return adjunDatosMailSede AdjunDatosMailSede
	 */
	@RequestMapping(value = "/{idDatomail}", method = RequestMethod.GET)
	public @ResponseBody AdjunDatosMailSede getById(@PathVariable String idDatomail) {
        AdjunDatosMailSede adjunDatosMailSede = new AdjunDatosMailSede();
		adjunDatosMailSede.setIdDatomail(idDatomail);
        adjunDatosMailSede = this.adjunDatosMailSedeService.find(adjunDatosMailSede);
        AdjunDatosMailSedeController.logger.info("[GET - findBy_PK] : Obtener AdjunDatosMailSede por PK");
        return adjunDatosMailSede;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterAdjunDatosMailSede AdjunDatosMailSede
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<AdjunDatosMailSede> getAll(@ModelAttribute AdjunDatosMailSede filterAdjunDatosMailSede) {
		AdjunDatosMailSedeController.logger.info("[GET - find_ALL] : Obtener AdjunDatosMailSede por filtro");
	    return this.adjunDatosMailSedeService.findAll(filterAdjunDatosMailSede, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param adjunDatosMailSede AdjunDatosMailSede 
	 * @return AdjunDatosMailSede
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody AdjunDatosMailSede edit(@RequestBody AdjunDatosMailSede adjunDatosMailSede) {		
        AdjunDatosMailSede adjunDatosMailSedeAux = this.adjunDatosMailSedeService.update(adjunDatosMailSede);
		AdjunDatosMailSedeController.logger.info("[PUT] : AdjunDatosMailSede actualizado correctamente");
        return adjunDatosMailSedeAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param adjunDatosMailSede AdjunDatosMailSede 
	 * @return AdjunDatosMailSede
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody AdjunDatosMailSede add(@RequestBody AdjunDatosMailSede adjunDatosMailSede) {		
        AdjunDatosMailSede adjunDatosMailSedeAux = this.adjunDatosMailSedeService.add(adjunDatosMailSede);
        AdjunDatosMailSedeController.logger.info("[POST] : AdjunDatosMailSede insertado correctamente");
    	return adjunDatosMailSedeAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param idDatomail String
	 * @return adjunDatosMailSede
	 */
	@RequestMapping(value = "/{idDatomail}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody AdjunDatosMailSede remove(@PathVariable String idDatomail) {
        AdjunDatosMailSede adjunDatosMailSede = new AdjunDatosMailSede();
        adjunDatosMailSede.setIdDatomail(idDatomail);
        this.adjunDatosMailSedeService.remove(adjunDatosMailSede);
       	AdjunDatosMailSedeController.logger.info("[DELETE] : AdjunDatosMailSede borrado correctamente");
       	return adjunDatosMailSede;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param adjunDatosMailSedeIds List
	 * @return adjunDatosMailSedeList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> adjunDatosMailSedeIds) {
        List<AdjunDatosMailSede> adjunDatosMailSedeList = new ArrayList<AdjunDatosMailSede>();
        for (List<String> adjunDatosMailSedeId:adjunDatosMailSedeIds) {
		    Iterator<String> iterator = adjunDatosMailSedeId.iterator();
		    AdjunDatosMailSede adjunDatosMailSede = new AdjunDatosMailSede(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        adjunDatosMailSede.setIdDatomail(ObjectConversionManager.convert(iterator.next(), String.class));
		    adjunDatosMailSedeList.add(adjunDatosMailSede);
	    }
        this.adjunDatosMailSedeService.removeMultiple(adjunDatosMailSedeList);
		AdjunDatosMailSedeController.logger.info("[POST - DELETE_ALL] : AdjunDatosMailSede borrados correctamente");
		return adjunDatosMailSedeIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterAdjunDatosMailSede AdjunDatosMailSede
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute AdjunDatosMailSede filterAdjunDatosMailSede, @ModelAttribute Pagination pagination) {
        List<AdjunDatosMailSede> adjunDatosMailSedes = this.adjunDatosMailSedeService.findAll(filterAdjunDatosMailSede, pagination);
        Long recordNum = this.adjunDatosMailSedeService.findAllCount(filterAdjunDatosMailSede);
        AdjunDatosMailSedeController.logger.info("[GET - jqGrid] : Obtener AdjunDatosMailSede");
		return new JQGridJSONModel(pagination, recordNum, adjunDatosMailSedes);
	}
	
}	
