package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.AdjunDatosMailEstablecService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.AdjunDatosMailEstablec;

/**
 * AdjunDatosMailEstablecController  
 *  
 */
 
@Controller
@RequestMapping (value = "/adjundatosmailestablec")

public class AdjunDatosMailEstablecController  {

	private static final Logger logger = LoggerFactory.getLogger(AdjunDatosMailEstablecController.class);

	@Autowired
	private AdjunDatosMailEstablecService adjunDatosMailEstablecService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AdjunDatosMailEstablecController.logger.info("[GET - View] : adjundatosmailestablec");
		return "adjundatosmailestablec";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param idDatomail String
	 * @return adjunDatosMailEstablec AdjunDatosMailEstablec
	 */
	@RequestMapping(value = "/{idDatomail}", method = RequestMethod.GET)
	public @ResponseBody AdjunDatosMailEstablec getById(@PathVariable String idDatomail) {
        AdjunDatosMailEstablec adjunDatosMailEstablec = new AdjunDatosMailEstablec();
		adjunDatosMailEstablec.setIdDatomail(idDatomail);
        adjunDatosMailEstablec = this.adjunDatosMailEstablecService.find(adjunDatosMailEstablec);
        AdjunDatosMailEstablecController.logger.info("[GET - findBy_PK] : Obtener AdjunDatosMailEstablec por PK");
        return adjunDatosMailEstablec;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterAdjunDatosMailEstablec AdjunDatosMailEstablec
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<AdjunDatosMailEstablec> getAll(@ModelAttribute AdjunDatosMailEstablec filterAdjunDatosMailEstablec) {
		AdjunDatosMailEstablecController.logger.info("[GET - find_ALL] : Obtener AdjunDatosMailEstablec por filtro");
	    return this.adjunDatosMailEstablecService.findAll(filterAdjunDatosMailEstablec, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param adjunDatosMailEstablec AdjunDatosMailEstablec 
	 * @return AdjunDatosMailEstablec
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody AdjunDatosMailEstablec edit(@RequestBody AdjunDatosMailEstablec adjunDatosMailEstablec) {		
        AdjunDatosMailEstablec adjunDatosMailEstablecAux = this.adjunDatosMailEstablecService.update(adjunDatosMailEstablec);
		AdjunDatosMailEstablecController.logger.info("[PUT] : AdjunDatosMailEstablec actualizado correctamente");
        return adjunDatosMailEstablecAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param adjunDatosMailEstablec AdjunDatosMailEstablec 
	 * @return AdjunDatosMailEstablec
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody AdjunDatosMailEstablec add(@RequestBody AdjunDatosMailEstablec adjunDatosMailEstablec) {		
        AdjunDatosMailEstablec adjunDatosMailEstablecAux = this.adjunDatosMailEstablecService.add(adjunDatosMailEstablec);
        AdjunDatosMailEstablecController.logger.info("[POST] : AdjunDatosMailEstablec insertado correctamente");
    	return adjunDatosMailEstablecAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param idDatomail String
	 * @return adjunDatosMailEstablec
	 */
	@RequestMapping(value = "/{idDatomail}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody AdjunDatosMailEstablec remove(@PathVariable String idDatomail) {
        AdjunDatosMailEstablec adjunDatosMailEstablec = new AdjunDatosMailEstablec();
        adjunDatosMailEstablec.setIdDatomail(idDatomail);
        this.adjunDatosMailEstablecService.remove(adjunDatosMailEstablec);
       	AdjunDatosMailEstablecController.logger.info("[DELETE] : AdjunDatosMailEstablec borrado correctamente");
       	return adjunDatosMailEstablec;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param adjunDatosMailEstablecIds List
	 * @return adjunDatosMailEstablecList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> adjunDatosMailEstablecIds) {
        List<AdjunDatosMailEstablec> adjunDatosMailEstablecList = new ArrayList<AdjunDatosMailEstablec>();
        for (List<String> adjunDatosMailEstablecId:adjunDatosMailEstablecIds) {
		    Iterator<String> iterator = adjunDatosMailEstablecId.iterator();
		    AdjunDatosMailEstablec adjunDatosMailEstablec = new AdjunDatosMailEstablec(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        adjunDatosMailEstablec.setIdDatomail(ObjectConversionManager.convert(iterator.next(), String.class));
		    adjunDatosMailEstablecList.add(adjunDatosMailEstablec);
	    }
        this.adjunDatosMailEstablecService.removeMultiple(adjunDatosMailEstablecList);
		AdjunDatosMailEstablecController.logger.info("[POST - DELETE_ALL] : AdjunDatosMailEstablec borrados correctamente");
		return adjunDatosMailEstablecIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterAdjunDatosMailEstablec AdjunDatosMailEstablec
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute AdjunDatosMailEstablec filterAdjunDatosMailEstablec, @ModelAttribute Pagination pagination) {
        List<AdjunDatosMailEstablec> adjunDatosMailEstablecs = this.adjunDatosMailEstablecService.findAll(filterAdjunDatosMailEstablec, pagination);
        Long recordNum = this.adjunDatosMailEstablecService.findAllCount(filterAdjunDatosMailEstablec);
        AdjunDatosMailEstablecController.logger.info("[GET - jqGrid] : Obtener AdjunDatosMailEstablec");
		return new JQGridJSONModel(pagination, recordNum, adjunDatosMailEstablecs);
	}
	
}	
