package com.ejie.y41b.control;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.AdjunDatosAvisosEstablecService;
import com.ejie.y41b.service.AdjunDatosMailEstablecService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.model.AdjunDatosAvisosEstablec;
import com.ejie.y41b.model.AdjunDatosMailEstablec;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Sede;

/**
 * AdjunDatosAvisosEstablecController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/adjundatosavisosestablec")

public class AdjunDatosAvisosEstablecController {

	private static final Logger logger = LoggerFactory.getLogger(AdjunDatosAvisosEstablecController.class);

	@Autowired
	private AdjunDatosAvisosEstablecService adjunDatosAvisosEstablecService;

	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		AdjunDatosAvisosEstablecController.logger.info("[GET - View] : adjundatosavisosestablec");
		return "adjundatosavisosestablec";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param idDatomail
	 *            String
	 * @return adjunDatosAvisosEstablec AdjunDatosAvisosEstablec
	 */
	@RequestMapping(value = "/{yiiddatomail}", method = RequestMethod.GET)
	public @ResponseBody AdjunDatosAvisosEstablec getById(@PathVariable String yiiddatomail) {
		AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
		adjunDatosAvisosEstablec.setYiiddatomail(yiiddatomail);
		adjunDatosAvisosEstablec = this.adjunDatosAvisosEstablecService.find(adjunDatosAvisosEstablec);
		AdjunDatosAvisosEstablecController.logger.info("[GET - findBy_PK] : Obtener AdjunDatosAvisosEstablec por PK");
		return adjunDatosAvisosEstablec;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterAdjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<AdjunDatosAvisosEstablec> getAll(
			@ModelAttribute AdjunDatosAvisosEstablec filterAdjunDatosAvisosEstablec) {
		AdjunDatosAvisosEstablecController.logger
				.info("[GET - find_ALL] : Obtener rAdjunDatosAvisosEstablec por filtro");
		return this.adjunDatosAvisosEstablecService.findAll(filterAdjunDatosAvisosEstablec, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody AdjunDatosAvisosEstablec edit(@RequestBody AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		AdjunDatosAvisosEstablec adjunDatosAvisosEstablecAux = this.adjunDatosAvisosEstablecService
				.update(adjunDatosAvisosEstablec);
		AdjunDatosAvisosEstablecController.logger.info("[PUT] : AdjunDatosAvisosEstablec actualizado correctamente");
		return adjunDatosAvisosEstablecAux;
	}

	/**
	 * Method 'add'.
	 *
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody AdjunDatosAvisosEstablec add(@RequestBody AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		AdjunDatosAvisosEstablec adjunDatosAvisosEstablecAux = this.adjunDatosAvisosEstablecService
				.add(adjunDatosAvisosEstablec);
		AdjunDatosAvisosEstablecController.logger.info("[POST] : AdjunDatosAvisosEstablec insertado correctamente");
		return adjunDatosAvisosEstablecAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param idDatomail
	 *            String
	 * @return adjunDatosAvisosEstablec
	 */
	@RequestMapping(value = "/{yiiddatomail}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody AdjunDatosAvisosEstablec remove(@PathVariable String yiiddatomail) {
		AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
		adjunDatosAvisosEstablec.setYiiddatomail(yiiddatomail);
		this.adjunDatosAvisosEstablecService.remove(adjunDatosAvisosEstablec);
		AdjunDatosAvisosEstablecController.logger.info("[DELETE] : AdjunDatosAvisosEstablec borrado correctamente");
		return adjunDatosAvisosEstablec;
	}

	/**
	 * Method 'removeAll'.
	 *
	 * @param adjunDatosMailEstablecIds
	 *            List
	 * @return adjunDatosMailEstablecList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(
			@RequestBody List<List<String>> adjunDatosAvisosEstablecIds) {
		List<AdjunDatosAvisosEstablec> adjunDatosAvisosEstablecList = new ArrayList<AdjunDatosAvisosEstablec>();
		for (List<String> adjunDatosAvisosEstablecId : adjunDatosAvisosEstablecIds) {
			Iterator<String> iterator = adjunDatosAvisosEstablecId.iterator();
			AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec(); // NOPMD
			// -
			// Objeto
			// nuevo
			// en
			// la
			// lista
			// (parametro
			// del
			// servicio)
			adjunDatosAvisosEstablec.setYiiddatomail(ObjectConversionManager.convert(iterator.next(), String.class));
			adjunDatosAvisosEstablecList.add(adjunDatosAvisosEstablec);
		}
		this.adjunDatosAvisosEstablecService.removeMultiple(adjunDatosAvisosEstablecList);
		AdjunDatosAvisosEstablecController.logger
				.info("[POST - DELETE_ALL] : AdjunDatosMailEstablec borrados correctamente");
		return adjunDatosAvisosEstablecIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterAdjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody JQGridJSONModel getAllJQGrid(
			@ModelAttribute AdjunDatosAvisosEstablec filterAdjunDatosAvisosEstablec,
			@ModelAttribute Pagination pagination) {
		List<AdjunDatosAvisosEstablec> adjunDatosAvisosEstablec = this.adjunDatosAvisosEstablecService
				.findAll(filterAdjunDatosAvisosEstablec, pagination);
		Long recordNum = this.adjunDatosAvisosEstablecService.findAllCount(filterAdjunDatosAvisosEstablec);
		AdjunDatosAvisosEstablecController.logger.info("[GET - jqGrid] : Obtener AdjunDatosAvisosEstablec");
		return new JQGridJSONModel(pagination, recordNum, adjunDatosAvisosEstablec);
	}

	////////

}
