package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ActuacionService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Actuacion;

/**
 * ActuacionController  
 *  
 */
 
@Controller
@RequestMapping (value = "/actuacion")

public class ActuacionController  {

	private static final Logger logger = LoggerFactory.getLogger(ActuacionController.class);

	@Autowired
	private ActuacionService actuacionService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ActuacionController.logger.info("[GET - View] : actuacion");
		return "actuacion";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param atcodigo String
	 * @return actuacion Actuacion
	 */
	@RequestMapping(value = "/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody Actuacion getById(@PathVariable String atcodigo) {
        Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);
        actuacion = this.actuacionService.find(actuacion);
        ActuacionController.logger.info("[GET - findBy_PK] : Obtener Actuacion por PK");
        return actuacion;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterActuacion Actuacion
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Actuacion> getAll(@ModelAttribute Actuacion filterActuacion) {
		ActuacionController.logger.info("[GET - find_ALL] : Obtener Actuacion por filtro");
	    return this.actuacionService.findAll(filterActuacion, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param actuacion Actuacion 
	 * @return Actuacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Actuacion edit(@RequestBody Actuacion actuacion) {		
        Actuacion actuacionAux = this.actuacionService.update(actuacion);
		ActuacionController.logger.info("[PUT] : Actuacion actualizado correctamente");
        return actuacionAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param actuacion Actuacion 
	 * @return Actuacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Actuacion add(@RequestBody Actuacion actuacion) {		
        Actuacion actuacionAux = this.actuacionService.add(actuacion);
        ActuacionController.logger.info("[POST] : Actuacion insertado correctamente");
    	return actuacionAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param atcodigo String
	 * @return actuacion
	 */
	@RequestMapping(value = "/{atcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Actuacion remove(@PathVariable String atcodigo) {
        Actuacion actuacion = new Actuacion();
        actuacion.setAtcodigo(atcodigo);
        this.actuacionService.remove(actuacion);
       	ActuacionController.logger.info("[DELETE] : Actuacion borrado correctamente");
       	return actuacion;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param actuacionIds List
	 * @return actuacionList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> actuacionIds) {
        List<Actuacion> actuacionList = new ArrayList<Actuacion>();
        for (List<String> actuacionId:actuacionIds) {
		    Iterator<String> iterator = actuacionId.iterator();
		    Actuacion actuacion = new Actuacion(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        actuacion.setAtcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    actuacionList.add(actuacion);
	    }
        this.actuacionService.removeMultiple(actuacionList);
		ActuacionController.logger.info("[POST - DELETE_ALL] : Actuacion borrados correctamente");
		return actuacionIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterActuacion Actuacion
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Actuacion filterActuacion, @ModelAttribute Pagination pagination) {
        List<Actuacion> actuacions = this.actuacionService.findAll(filterActuacion, pagination);
        Long recordNum = this.actuacionService.findAllCount(filterActuacion);
        ActuacionController.logger.info("[GET - jqGrid] : Obtener Actuacion");
		return new JQGridJSONModel(pagination, recordNum, actuacions);
	}
	
}	
