package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ActaNuevaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.ActaNueva;

/**
 * ActaNuevaController  
 *  
 */
 
@Controller
@RequestMapping (value = "/actanueva")

public class ActaNuevaController  {

	private static final Logger logger = LoggerFactory.getLogger(ActaNuevaController.class);

	@Autowired
	private ActaNuevaService actaNuevaService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ActaNuevaController.logger.info("[GET - View] : actanueva");
		return "actanueva";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param ancodigo String
	 * @return actaNueva ActaNueva
	 */
	@RequestMapping(value = "/{ancodigo}", method = RequestMethod.GET)
	public @ResponseBody ActaNueva getById(@PathVariable String ancodigo) {
        ActaNueva actaNueva = new ActaNueva();
		actaNueva.setAncodigo(ancodigo);
        actaNueva = this.actaNuevaService.find(actaNueva);
        ActaNuevaController.logger.info("[GET - findBy_PK] : Obtener ActaNueva por PK");
        return actaNueva;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterActaNueva ActaNueva
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<ActaNueva> getAll(@ModelAttribute ActaNueva filterActaNueva) {
		ActaNuevaController.logger.info("[GET - find_ALL] : Obtener ActaNueva por filtro");
	    return this.actaNuevaService.findAll(filterActaNueva, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param actaNueva ActaNueva 
	 * @return ActaNueva
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody ActaNueva edit(@RequestBody ActaNueva actaNueva) {		
        ActaNueva actaNuevaAux = this.actaNuevaService.update(actaNueva);
		ActaNuevaController.logger.info("[PUT] : ActaNueva actualizado correctamente");
        return actaNuevaAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param actaNueva ActaNueva 
	 * @return ActaNueva
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody ActaNueva add(@RequestBody ActaNueva actaNueva) {		
        ActaNueva actaNuevaAux = this.actaNuevaService.add(actaNueva);
        ActaNuevaController.logger.info("[POST] : ActaNueva insertado correctamente");
    	return actaNuevaAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param ancodigo String
	 * @return actaNueva
	 */
	@RequestMapping(value = "/{ancodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody ActaNueva remove(@PathVariable String ancodigo) {
        ActaNueva actaNueva = new ActaNueva();
        actaNueva.setAncodigo(ancodigo);
        this.actaNuevaService.remove(actaNueva);
       	ActaNuevaController.logger.info("[DELETE] : ActaNueva borrado correctamente");
       	return actaNueva;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param actaNuevaIds List
	 * @return actaNuevaList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> actaNuevaIds) {
        List<ActaNueva> actaNuevaList = new ArrayList<ActaNueva>();
        for (List<String> actaNuevaId:actaNuevaIds) {
		    Iterator<String> iterator = actaNuevaId.iterator();
		    ActaNueva actaNueva = new ActaNueva(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        actaNueva.setAncodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    actaNuevaList.add(actaNueva);
	    }
        this.actaNuevaService.removeMultiple(actaNuevaList);
		ActaNuevaController.logger.info("[POST - DELETE_ALL] : ActaNueva borrados correctamente");
		return actaNuevaIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterActaNueva ActaNueva
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute ActaNueva filterActaNueva, @ModelAttribute Pagination pagination) {
        List<ActaNueva> actaNuevas = this.actaNuevaService.findAll(filterActaNueva, pagination);
        Long recordNum = this.actaNuevaService.findAllCount(filterActaNueva);
        ActaNuevaController.logger.info("[GET - jqGrid] : Obtener ActaNueva");
		return new JQGridJSONModel(pagination, recordNum, actaNuevas);
	}
	
}	
