package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ActaInfraccionService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.ActaInfraccion;

/**
 * ActaInfraccionController  
 *  
 */
 
@Controller
@RequestMapping (value = "/actainfraccion")

public class ActaInfraccionController  {

	private static final Logger logger = LoggerFactory.getLogger(ActaInfraccionController.class);

	@Autowired
	private ActaInfraccionService actaInfraccionService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ActaInfraccionController.logger.info("[GET - View] : actainfraccion");
		return "actainfraccion";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param aicodigo String
	 * @return actaInfraccion ActaInfraccion
	 */
	@RequestMapping(value = "/{aicodigo}", method = RequestMethod.GET)
	public @ResponseBody ActaInfraccion getById(@PathVariable String aicodigo) {
        ActaInfraccion actaInfraccion = new ActaInfraccion();
		actaInfraccion.setAicodigo(aicodigo);
        actaInfraccion = this.actaInfraccionService.find(actaInfraccion);
        ActaInfraccionController.logger.info("[GET - findBy_PK] : Obtener ActaInfraccion por PK");
        return actaInfraccion;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterActaInfraccion ActaInfraccion
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<ActaInfraccion> getAll(@ModelAttribute ActaInfraccion filterActaInfraccion) {
		ActaInfraccionController.logger.info("[GET - find_ALL] : Obtener ActaInfraccion por filtro");
	    return this.actaInfraccionService.findAll(filterActaInfraccion, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param actaInfraccion ActaInfraccion 
	 * @return ActaInfraccion
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody ActaInfraccion edit(@RequestBody ActaInfraccion actaInfraccion) {		
        ActaInfraccion actaInfraccionAux = this.actaInfraccionService.update(actaInfraccion);
		ActaInfraccionController.logger.info("[PUT] : ActaInfraccion actualizado correctamente");
        return actaInfraccionAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param actaInfraccion ActaInfraccion 
	 * @return ActaInfraccion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody ActaInfraccion add(@RequestBody ActaInfraccion actaInfraccion) {		
        ActaInfraccion actaInfraccionAux = this.actaInfraccionService.add(actaInfraccion);
        ActaInfraccionController.logger.info("[POST] : ActaInfraccion insertado correctamente");
    	return actaInfraccionAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param aicodigo String
	 * @return actaInfraccion
	 */
	@RequestMapping(value = "/{aicodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody ActaInfraccion remove(@PathVariable String aicodigo) {
        ActaInfraccion actaInfraccion = new ActaInfraccion();
        actaInfraccion.setAicodigo(aicodigo);
        this.actaInfraccionService.remove(actaInfraccion);
       	ActaInfraccionController.logger.info("[DELETE] : ActaInfraccion borrado correctamente");
       	return actaInfraccion;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param actaInfraccionIds List
	 * @return actaInfraccionList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> actaInfraccionIds) {
        List<ActaInfraccion> actaInfraccionList = new ArrayList<ActaInfraccion>();
        for (List<String> actaInfraccionId:actaInfraccionIds) {
		    Iterator<String> iterator = actaInfraccionId.iterator();
		    ActaInfraccion actaInfraccion = new ActaInfraccion(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        actaInfraccion.setAicodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    actaInfraccionList.add(actaInfraccion);
	    }
        this.actaInfraccionService.removeMultiple(actaInfraccionList);
		ActaInfraccionController.logger.info("[POST - DELETE_ALL] : ActaInfraccion borrados correctamente");
		return actaInfraccionIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterActaInfraccion ActaInfraccion
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute ActaInfraccion filterActaInfraccion, @ModelAttribute Pagination pagination) {
        List<ActaInfraccion> actaInfraccions = this.actaInfraccionService.findAll(filterActaInfraccion, pagination);
        Long recordNum = this.actaInfraccionService.findAllCount(filterActaInfraccion);
        ActaInfraccionController.logger.info("[GET - jqGrid] : Obtener ActaInfraccion");
		return new JQGridJSONModel(pagination, recordNum, actaInfraccions);
	}
	
}	
