package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ActaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Acta;

/**
 * ActaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/acta")
public class ActaController {

	private static final Logger logger = LoggerFactory
			.getLogger(ActaController.class);

	@Autowired
	private ActaService actaService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ActaController.logger.info("[GET - View] : acta");
		return "acta";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param accodigo
	 *            String
	 * @return acta Acta
	 */

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterActa
	 *            Acta
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Acta> getAll(@ModelAttribute Acta filterActa) {
		ActaController.logger
				.info("[GET - find_ALL] : Obtener Acta por filtro");
		return this.actaService.findAll(filterActa, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param acta
	 *            Acta
	 * @return Acta
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Acta edit(@RequestBody Acta acta) {
		Acta actaAux = this.actaService.update(acta);
		ActaController.logger.info("[PUT] : Acta actualizado correctamente");
		return actaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param acta
	 *            Acta
	 * @return Acta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Acta add(@RequestBody Acta acta) {
		Acta actaAux = this.actaService.add(acta);
		ActaController.logger.info("[POST] : Acta insertado correctamente");
		return actaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param accodigo
	 *            String
	 * @return acta
	 */
	@RequestMapping(value = "/{accodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Acta remove(@PathVariable String accodigo) {
		Acta acta = new Acta();
		acta.setAccodigo(accodigo);
		this.actaService.remove(acta);
		ActaController.logger.info("[DELETE] : Acta borrado correctamente");
		return acta;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param actaIds
	 *            List
	 * @return actaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> actaIds) {
		List<Acta> actaList = new ArrayList<Acta>();
		for (List<String> actaId : actaIds) {
			Iterator<String> iterator = actaId.iterator();
			Acta acta = new Acta(); // NOPMD - Objeto nuevo en la lista
									// (parametro del servicio)
			acta.setAccodigo(ObjectConversionManager.convert(iterator.next(),
					String.class));
			actaList.add(acta);
		}
		this.actaService.removeMultiple(actaList);
		ActaController.logger
				.info("[POST - DELETE_ALL] : Acta borrados correctamente");
		return actaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterActa
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Acta filterActa,
			@ModelAttribute Pagination pagination) {
		List<Acta> actas = this.actaService.findAll(filterActa, pagination);
		Long recordNum = this.actaService.findAllCount(filterActa);
		ActaController.logger.info("[GET - jqGrid] : Obtener Acta");
		return new JQGridJSONModel(pagination, recordNum, actas);
	}

}
