package com.ejie.y41b.control;

import java.sql.Blob;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.AaccEuskadi;
import com.ejie.y41b.model.AaccEuskadiSede;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.ConsumidorDetalle;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.FormaPresentacion;
import com.ejie.y41b.model.HistorialAlerta;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.service.AaccEuskadiSedeService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AaccController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/aaccEuskadiSede")
public class AaccEuskadiSedeController {

	private static final Logger logger = LoggerFactory.getLogger(AaccEuskadiSedeController.class);

	@Autowired()
	private AaccEuskadiSedeService aaccEuskadiSedeService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'add'.
	 *
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return AaccEuskadiSede
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() AaccEuskadiSede add(@RequestBody() AaccEuskadiSede aaccEuskadiSede) {
		aaccEuskadiSede = this.aaccEuskadiSedeService.addTemp(aaccEuskadiSede);
		AaccEuskadiSedeController.logger.info("[POST] : aaccEuskadiSede insertado correctamente");
		return aaccEuskadiSede;
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return AaccEuskadiSede
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() AaccEuskadiSede update(@RequestBody() AaccEuskadiSede aaccEuskadiSede) {
		AaccEuskadiSede aaccEuskadiSedeAux = this.aaccEuskadiSedeService.update(aaccEuskadiSede);
		AaccEuskadiSedeController.logger.info("[PUT] : AaccEuskadiSede actualizado correctamente");
		return aaccEuskadiSedeAux;
	}

	/**
	 * Method 'getAllByCodOrg'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findAllByCodOrg/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllByCodOrg(@PathVariable() String codOrg, HttpServletResponse response,
			HttpServletRequest request) {
		// Idioma
		Locale locale = LocaleContextHolder.getLocale();
		try {

			AaccEuskadiSede aaccEuskadiSede = new AaccEuskadiSede();
			aaccEuskadiSede.setCodOrg(codOrg);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<AaccEuskadiSede> listaAaccEuskadiSede = this.aaccEuskadiSedeService.findAll(aaccEuskadiSede,
						pagination);

				if (listaAaccEuskadiSede == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.aaccEuskadiSedeService.findAllCount(aaccEuskadiSede);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaAaccEuskadiSede);
				return data;
			} else {
				List<AaccEuskadiSede> listaAaccEuskadiSede = this.aaccEuskadiSedeService.findAll(aaccEuskadiSede,
						pagination);
				if (listaAaccEuskadiSede == null) {
					throw new Exception("No data Found.");
				}
				return listaAaccEuskadiSede;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idSede
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{idSede}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String idSede, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			AaccEuskadiSede aaccEuskadiSede = new AaccEuskadiSede();
			aaccEuskadiSede.setIdSede(idSede);
			this.aaccEuskadiSedeService.remove(aaccEuskadiSede);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + idSede);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idExpediente
	 *            String
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/detalleSede/{idSede}", method = RequestMethod.GET)
	public @ResponseBody AaccEuskadiSede getConsumidorById(@PathVariable String idSede) {
		try {

			AaccEuskadiSede aaccEuskadiSede = new AaccEuskadiSede();
			aaccEuskadiSede.setIdSede(idSede);

			aaccEuskadiSede = this.aaccEuskadiSedeService.findSede(aaccEuskadiSede);
			if (aaccEuskadiSede == null) {
				throw new Exception(idSede.toString());
			}
			return aaccEuskadiSede;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idSede.toString());
		}
	}
}
