package com.ejie.y41b.control;

import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AaccEuskadiConfederacion;
import com.ejie.y41b.model.AaccEuskadiFederacion;
import com.ejie.y41b.model.AaccEuskadiOrganoGestor;
import com.ejie.y41b.model.AaccEuskadiSede;
import com.ejie.y41b.service.AaccEuskadiConfederacionService;
import com.ejie.y41b.service.AaccEuskadiOrganoGestorService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AaccController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/aaccEuskadiOrganoGestor")
public class AaccEuskadiOrganoGestorController {

	private static final Logger logger = LoggerFactory.getLogger(AaccEuskadiOrganoGestorController.class);

	@Autowired()
	private AaccEuskadiOrganoGestorService aaccEuskadiOrganoGestorService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'getAllByCodOrg'.
	 * 
	 * @param codOrg
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findAllByCodOrg/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllByCodOrg(@PathVariable() String codOrg, HttpServletResponse response,
			HttpServletRequest request) {
		// Idioma
		Locale locale = LocaleContextHolder.getLocale();
		try {

			AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor = new AaccEuskadiOrganoGestor();
			aaccEuskadiOrganoGestor.setOgCodOrg(codOrg);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<AaccEuskadiOrganoGestor> listaAaccEuskadiOrganoGestor = this.aaccEuskadiOrganoGestorService
						.findAll(aaccEuskadiOrganoGestor, pagination);

				if (listaAaccEuskadiOrganoGestor == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.aaccEuskadiOrganoGestorService.findAllCount(aaccEuskadiOrganoGestor);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaAaccEuskadiOrganoGestor);
				return data;
			} else {
				List<AaccEuskadiOrganoGestor> listaAaccEuskadiOrganoGestor = this.aaccEuskadiOrganoGestorService
						.findAll(aaccEuskadiOrganoGestor, pagination);
				if (listaAaccEuskadiOrganoGestor == null) {
					throw new Exception("No data Found.");
				}
				return listaAaccEuskadiOrganoGestor;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'add'.
	 *
	 * @param aaccEuskadiOrganoGestor
	 *            AaccEuskadiOrganoGestor
	 * @return AaccEuskadiOrganoGestor
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() AaccEuskadiOrganoGestor add(@RequestBody() AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor) {
		aaccEuskadiOrganoGestor = this.aaccEuskadiOrganoGestorService.addTemp(aaccEuskadiOrganoGestor);
		AaccEuskadiOrganoGestorController.logger.info("[POST] : aaccEuskadiOrganoGestor insertado correctamente");
		return aaccEuskadiOrganoGestor;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param ogId
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{ogId}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String ogId, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor = new AaccEuskadiOrganoGestor();
			aaccEuskadiOrganoGestor.setOgId(ogId);
			this.aaccEuskadiOrganoGestorService.remove(aaccEuskadiOrganoGestor);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + ogId);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}
}
