package com.ejie.y41b.control;

import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AaccEuskadi;
import com.ejie.y41b.model.AaccEuskadiFederacion;
import com.ejie.y41b.model.AaccEuskadiSede;
import com.ejie.y41b.service.AaccEuskadiFederacionService;
import com.ejie.y41b.service.AaccEuskadiSedeService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AaccController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/aaccEuskadiFederacion")
public class AaccEuskadiFederacionController {

	private static final Logger logger = LoggerFactory.getLogger(AaccEuskadiFederacionController.class);

	@Autowired()
	private AaccEuskadiFederacionService aaccEuskadiFederacionService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'addInfraccionProtocolo'.
	 * 
	 * @param codInspeccion
	 *            String
	 * @param codActa
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return
	 */
	@RequestMapping(value = "/grabarMiembroFederacion/{codOrgFederacion}/{codOrgAsocOCop}", method = RequestMethod.POST)
	public void addMiembroFederacion(@PathVariable() String codOrgFederacion, @PathVariable() String codOrgAsocOCop,
			HttpServletRequest request) {
		try {
			AaccEuskadiFederacion accEuskadiFederacion = new AaccEuskadiFederacion();
			accEuskadiFederacion.setCodOrgFederacion(codOrgFederacion);
			accEuskadiFederacion.setCodOrgAsocOCoop(codOrgAsocOCop);
			this.aaccEuskadiFederacionService.addTemp(accEuskadiFederacion);

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllByCodOrg'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findAllByCodOrg/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllByCodOrg(@PathVariable() String codOrg, HttpServletResponse response,
			HttpServletRequest request) {
		// Idioma
		Locale locale = LocaleContextHolder.getLocale();
		try {

			AaccEuskadiFederacion aaccEuskadiFederacion = new AaccEuskadiFederacion();
			aaccEuskadiFederacion.setCodOrgFederacion(codOrg);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<AaccEuskadiFederacion> listaAaccEuskadiFederacion = this.aaccEuskadiFederacionService
						.findAll(aaccEuskadiFederacion, pagination);

				if (listaAaccEuskadiFederacion == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.aaccEuskadiFederacionService.findAllCount(aaccEuskadiFederacion);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaAaccEuskadiFederacion);
				return data;
			} else {
				List<AaccEuskadiFederacion> listaAaccEuskadiFederacion = this.aaccEuskadiFederacionService
						.findAll(aaccEuskadiFederacion, pagination);
				if (listaAaccEuskadiFederacion == null) {
					throw new Exception("No data Found.");
				}
				return listaAaccEuskadiFederacion;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idFederacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{idFederacion}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String idFederacion, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			AaccEuskadiFederacion aaccEuskadiFederacion = new AaccEuskadiFederacion();
			aaccEuskadiFederacion.setIdFederacion(idFederacion);
			this.aaccEuskadiFederacionService.remove(aaccEuskadiFederacion);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + idFederacion);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getById'.
	 *
	 * @param cccodigo
	 *            String
	 * @return aaccEuskadiFederacion AaccEuskadiFederacion
	 */
	@RequestMapping(value = "/existe/{codOrgFederacion}/{codOrgAsocOCoop}", method = RequestMethod.GET)
	public @ResponseBody() long existe(@PathVariable() String codOrgFederacion,
			@PathVariable() String codOrgAsocOCoop) {
		AaccEuskadiFederacion aaccEuskadiFederacion = new AaccEuskadiFederacion();
		aaccEuskadiFederacion.setCodOrgFederacion(codOrgFederacion);
		aaccEuskadiFederacion.setCodOrgAsocOCoop(codOrgAsocOCoop);

		return this.aaccEuskadiFederacionService.existeCount(aaccEuskadiFederacion);
	}

	/**
	 * Method 'getById'.
	 *
	 * @param aeCodigo
	 *            String
	 * @return aeCodigo String
	 */
	@RequestMapping(value = "/existeEnFederaciones/{aeCodigo}", method = RequestMethod.GET)
	public @ResponseBody() long existeEnFederaciones(@PathVariable() String aeCodigo) {
		AaccEuskadiFederacion aaccEuskadiFederacion = new AaccEuskadiFederacion();
		aaccEuskadiFederacion.setCodOrgAsocOCoop(aeCodigo);
		return this.aaccEuskadiFederacionService.findAllFederacionesCount(aaccEuskadiFederacion);
	}

	/**
	 * Method 'getAllByCodOrg'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findAllFederaciones/{aeCodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllFederacionesByCodOrgAsocOcoop(@PathVariable() String aeCodigo,
			HttpServletResponse response, HttpServletRequest request) {
		// Idioma
		Locale locale = LocaleContextHolder.getLocale();
		try {

			AaccEuskadiFederacion aaccEuskadiFederacion = new AaccEuskadiFederacion();
			aaccEuskadiFederacion.setCodOrgAsocOCoop(aeCodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<AaccEuskadiFederacion> listaAaccEuskadiFederacion = this.aaccEuskadiFederacionService
						.findAllFederaciones(aaccEuskadiFederacion, pagination);

				if (listaAaccEuskadiFederacion == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.aaccEuskadiFederacionService.findAllFederacionesCount(aaccEuskadiFederacion);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaAaccEuskadiFederacion);
				return data;
			} else {
				List<AaccEuskadiFederacion> listaAaccEuskadiFederacion = this.aaccEuskadiFederacionService
						.findAllFederaciones(aaccEuskadiFederacion, pagination);
				if (listaAaccEuskadiFederacion == null) {
					throw new Exception("No data Found.");
				}
				return listaAaccEuskadiFederacion;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}
}
