package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.AaccEuskadi;
import com.ejie.y41b.model.AaccEuskadiSede;
import com.ejie.y41b.model.ActaNueva;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.service.AaccEuskadiService;
import com.ejie.y41b.service.AaccService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AaccController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/aaccEuskadi")
public class AaccEuskadiController {

	private static final Logger logger = LoggerFactory.getLogger(AaccEuskadiController.class);

	@Autowired()
	private AaccEuskadiService aaccEuskadiService;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		AaccEuskadiController.logger.info("[GET - View] : aaccEuskadi");

		// 0206141: Accceso al registro de organizaciones (actual men OCE)

		// HttpServletRequest httpRequest = (HttpServletRequest) request;
		// HttpSession httpSession = httpRequest.getSession(false);
		// CensoMonitor censoMonitor = (CensoMonitor) httpSession
		// .getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		// if (censoMonitor.getPerfilMaestros() == null
		// ||
		// (censoMonitor.getPerfilMaestros().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)
		// && censoMonitor.getPerfilArbitraje().getIdPerfil()
		// .equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO))) {
		// return new ModelAndView("accessDeniedEscritorio", "model", model);
		// } else {
		return new ModelAndView("aaccEuskadi", "model", model);
		// }
	}

	//
	// /**
	// * Method 'getCreateForm'.
	// *
	// * @param model
	// * Model
	// * @param request
	// * HttpServletRequest
	// * @return String
	// */
	// @RequestMapping(value = "seleccionAaccEuskadi", method =
	// RequestMethod.GET)
	// public ModelAndView getCreateFormModal(Model model,
	// HttpServletRequest request) {
	// model.addAttribute("defaultLanguage",
	// appConfiguration.get("y41bVistaWar.default.language"));
	// model.addAttribute("defaultLayout",
	// appConfiguration.get("y41bVistaWar.default.layout"));
	//
	// model.addAttribute("modoBusquedaAaccEuskadi",
	// Y41bConstantes.MODO_POPUP_SELECCION);
	//
	// return new ModelAndView("aaccEuskadiSeleccion", "model", model);
	// }
	//
	/**
	 * Method 'getById'.
	 *
	 * @param aeCodigo
	 *            String
	 * @return aaccEuskadi AaccEuskadi
	 */
	@RequestMapping(value = "/getById/{aeCodigo}", method = RequestMethod.GET)
	public @ResponseBody() AaccEuskadi getById(@PathVariable() String aeCodigo) {
		AaccEuskadi aaccEuskadi = new AaccEuskadi();
		aaccEuskadi.setAeCodigo(aeCodigo);
		aaccEuskadi = this.aaccEuskadiService.find(aaccEuskadi);
		AaccEuskadiController.logger.info("[GET - findBy_PK] : Obtener AaccEuskadi por	 PK");
		return aaccEuskadi;
	}

	//
	// /**
	// * Method 'getAll'.
	// *
	// * @param filterAacc
	// * Aacc
	// * @return List
	// */
	// @RequestMapping(method = RequestMethod.GET)
	// public @ResponseBody()
	// List<Aacc> getAll(@ModelAttribute() Aacc filterAacc) {
	// AaccEuskadiController.logger
	// .info("[GET - find_ALL] : Obtener Aacc por filtro");
	// return this.aaccService.findAll(filterAacc, null);
	// }
	//
	/**
	 * Method 'edit'.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return AaccEuskadi
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() AaccEuskadi edit(@RequestBody() AaccEuskadi aaccEuskadi, HttpServletRequest request) {
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		aaccEuskadi.setAeUsuUltMod(censoMonitor.getMocodigo());

		aaccEuskadi = this.aaccEuskadiService.update(aaccEuskadi);
		AaccEuskadiController.logger.info("[PUT] : Aacc actualizado	 correctamente");
		return aaccEuskadi;
	}

	/**
	 * Method 'add'.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return AaccEuskadi
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() AaccEuskadi add(@RequestBody() AaccEuskadi aaccEuskadi, HttpServletRequest request) {
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		aaccEuskadi.setAeUsuUltMod(censoMonitor.getMocodigo());

		aaccEuskadi = this.aaccEuskadiService.add(aaccEuskadi);
		AaccEuskadiController.logger.info("[POST] : AaccEuskadi insertado	 correctamente");
		return aaccEuskadi;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param aeCodigo
	 *            String
	 * @return aaccEuskadi
	 */
	@RequestMapping(value = "/{aeCodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() AaccEuskadi remove(@PathVariable() String aeCodigo) {
		try {
			AaccEuskadi aaccEuskadi = new AaccEuskadi();
			aaccEuskadi.setAeCodigo(aeCodigo);
			this.aaccEuskadiService.remove(aaccEuskadi);
			AaccEuskadiController.logger.info("[DELETE] : aaccEuskadi borrado	 correctamente");
			return aaccEuskadi;
		} catch (Exception e) {
			throw new Y41bUDAException("error.aacc.ExpedientesAbiertosException", true, new Exception());
		}
	}
	//
	// /**
	// * Method 'removeAll'.
	// *
	// * @param aaccIds
	// * List
	// * @return aaccList
	// */
	// @RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	// @ResponseStatus(value = HttpStatus.OK)
	// public @ResponseBody()
	// List<List<String>> removeMultiple(@RequestBody() List<List<String>>
	// aaccIds) {
	// List<Aacc> aaccList = new ArrayList<Aacc>();
	// for (List<String> aaccId : aaccIds) {
	// Iterator<String> iterator = aaccId.iterator();
	// Aacc aacc = new Aacc(); // NOPMD - Objeto nuevo en la lista
	// // (parametro del servicio)
	// aacc.setCccodigo(ObjectConversionManager.convert(iterator.next(),
	// String.class));
	// aaccList.add(aacc);
	// }
	// this.aaccService.removeMultiple(aaccList);
	// AaccEuskadiController.logger
	// .info("[POST - DELETE_ALL] : Aacc borrados correctamente");
	// return aaccIds;
	// }
	//

	// /**
	// * Method 'getAllJQGrid'.
	// *
	// * @param filterAaccEuskadi
	// * AaccEuskadi
	// * @param pagination
	// * Pagination
	// * @return JQGridJSONModel
	// */
	// @RequestMapping(value = "/busqueda", method = RequestMethod.GET, headers
	// = { "JQGridModel=true" })
	// public @ResponseBody() JQGridJSONModel getAllJQGrid(@ModelAttribute()
	// AaccEuskadi filterAaccEuskadi,
	// @ModelAttribute() Pagination pagination) {
	//
	//
	//
	//
	//
	//
	// List<AaccEuskadi> aaccs =
	// this.aaccEuskadiService.findAllBusqueda(filterAaccEuskadi, pagination);
	// Long recordNum =
	// this.aaccEuskadiService.findAllBusquedaCount(filterAaccEuskadi);
	// AaccEuskadiController.logger.info("[GET - jqGrid] : Obtener
	// AaccEuskadi");
	// return new JQGridJSONModel(pagination, recordNum, aaccs);
	// }

	@RequestMapping(value = "/busqueda", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilter(@RequestParam(value = "numRegistro", required = false) String numRegistro_,
			@RequestParam(value = "nif", required = false) String nif_,
			@RequestParam(value = "nombre", required = false) String nombre_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "checkAsociacion", required = false) String checkAsociacion_,
			@RequestParam(value = "checkCooperativa", required = false) String checkCooperativa_,
			@RequestParam(value = "checkFederacion", required = false) String checkFederacion_,
			@RequestParam(value = "checkConfederacion", required = false) String checkConfederacion_,
			@RequestParam(value = "checkBaja", required = false) String checkBaja_,

			HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();
		try {
			String numRegistro = ("".equals(numRegistro_)) ? null : numRegistro_;
			String nif = ("".equals(nif_)) ? null : nif_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			// control checks
			String checkAsociacion = ("on".equals(checkAsociacion_)) ? Y41bConstantes.VALOR_SI : null;
			String checkCooperativa = ("on".equals(checkCooperativa_)) ? Y41bConstantes.VALOR_SI : null;
			String checkFederacion = ("on".equals(checkFederacion_)) ? Y41bConstantes.VALOR_SI : null;
			String checkConfederacion = ("on".equals(checkConfederacion_)) ? Y41bConstantes.VALOR_SI : null;
			String checkBaja = ("on".equals(checkBaja_)) ? Y41bConstantes.VALOR_SI : null;

			AaccEuskadi filterAaccEuskadi = new AaccEuskadi();
			filterAaccEuskadi.setNumRegistro(numRegistro);
			filterAaccEuskadi.setNif(nif);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterAaccEuskadi.setNombreEu(nombre);
			} else {
				filterAaccEuskadi.setNombreEs(nombre);
			}
			filterAaccEuskadi.setProvinciaId(provinciaId);
			filterAaccEuskadi.setMunicipioId(municipioId);
			filterAaccEuskadi.setLocalidadId(localidadId);
			filterAaccEuskadi.setCheckAsociacion(checkAsociacion);
			filterAaccEuskadi.setCheckCooperativa(checkCooperativa);
			filterAaccEuskadi.setCheckFederacion(checkFederacion);
			filterAaccEuskadi.setCheckConfederacion(checkConfederacion);
			filterAaccEuskadi.setCheckBaja(checkBaja);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<AaccEuskadi> listaAaccEuskadi = this.aaccEuskadiService.findAllBusqueda(filterAaccEuskadi,
						pagination);

				if (listaAaccEuskadi == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.aaccEuskadiService.findAllBusquedaCount(filterAaccEuskadi);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaAaccEuskadi);
				return data;
			} else {
				List<AaccEuskadi> listaAaccEuskadi = this.aaccEuskadiService.findAllBusqueda(filterAaccEuskadi,
						pagination);
				if (listaAaccEuskadi == null) {
					throw new Exception("No data Found.");
				}
				return listaAaccEuskadi;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 *
	 * @param cccodigo
	 *            String
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/detalle/{aeCodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalle(@PathVariable() String aeCodigo, Model model) {
		AaccEuskadiController.logger.info("[GET - View] : aacc");
		model.addAttribute("aeCodigo", aeCodigo);
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_MODIFICACION);
		return new ModelAndView("aaccEuskadiDetalle", "model", model);
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 *
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model) {
		AaccEuskadiController.logger.info("[GET - View] : aacc");
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_ALTA);
		return new ModelAndView("aaccEuskadiDetalle", "model", model);
	}

	/**
	 * Method 'getById'.
	 *
	 * @param cccodigo
	 *            String
	 * @return aaccEuskadi AaccEuskadi
	 */
	@RequestMapping(value = "/existe/{aeCodigo}", method = RequestMethod.GET)
	public @ResponseBody() long existe(@PathVariable() String aeCodigo) {
		AaccEuskadi aaccEuskadi = new AaccEuskadi();
		aaccEuskadi.setAeCodigo(aeCodigo);
		return this.aaccEuskadiService.findAllCount(aaccEuskadi);
	}

	/**
	 * Method 'borrarTemporales'.
	 *
	 * @param aecodigo
	 *            String
	 */
	@RequestMapping(value = "/borrarTemporales/{aeCodigo}", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() void borrarTemporales(@PathVariable() String aeCodigo) {
		AaccEuskadi aaccEuskadi = new AaccEuskadi();
		aaccEuskadi.setAeCodigo(aeCodigo);
		this.aaccEuskadiService.borrarTemporales(aaccEuskadi);
		AaccEuskadiController.logger.info("[DELETE] : Aacc Temporalres borrado correctamente");

	}

	/**
	 * Method 'getAllExcel'.
	 *
	 * @param filterAaccEuskadi
	 *            AaccEuskadi
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public @ResponseBody void getAllExcel(@RequestParam(value = "numRegistro", required = false) String numRegistro_,
			@RequestParam(value = "nif", required = false) String nif_,
			@RequestParam(value = "nombre", required = false) String nombre_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "checkAsociacion", required = false) String checkAsociacion_,
			@RequestParam(value = "checkCooperativa", required = false) String checkCooperativa_,
			@RequestParam(value = "checkFederacion", required = false) String checkFederacion_,
			@RequestParam(value = "checkConfederacion", required = false) String checkConfederacion_,
			@RequestParam(value = "checkBaja", required = false) String checkBaja_,

			HttpServletRequest request, HttpServletResponse response) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();
		try {
			String numRegistro = ("".equals(numRegistro_)) ? null : numRegistro_;
			String nif = ("".equals(nif_)) ? null : nif_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			// control checks
			String checkAsociacion = ("on".equals(checkAsociacion_)) ? Y41bConstantes.VALOR_SI : null;
			String checkCooperativa = ("on".equals(checkCooperativa_)) ? Y41bConstantes.VALOR_SI : null;
			String checkFederacion = ("on".equals(checkFederacion_)) ? Y41bConstantes.VALOR_SI : null;
			String checkConfederacion = ("on".equals(checkConfederacion_)) ? Y41bConstantes.VALOR_SI : null;
			String checkBaja = ("on".equals(checkBaja_)) ? Y41bConstantes.VALOR_SI : null;

			AaccEuskadi filterAaccEuskadi = new AaccEuskadi();
			filterAaccEuskadi.setNumRegistro(numRegistro);
			filterAaccEuskadi.setNif(nif);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterAaccEuskadi.setNombreEu(nombre);
			} else {
				filterAaccEuskadi.setNombreEs(nombre);
			}
			filterAaccEuskadi.setProvinciaId(provinciaId);
			filterAaccEuskadi.setMunicipioId(municipioId);
			filterAaccEuskadi.setLocalidadId(localidadId);
			filterAaccEuskadi.setCheckAsociacion(checkAsociacion);
			filterAaccEuskadi.setCheckCooperativa(checkCooperativa);
			filterAaccEuskadi.setCheckFederacion(checkFederacion);
			filterAaccEuskadi.setCheckConfederacion(checkConfederacion);
			filterAaccEuskadi.setCheckBaja(checkBaja);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");
			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombreExcel = Y41bConstantes.EXCEL_AACCEUSKADI + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombreExcel) + "\"");

			String xslString = this.y41bExcelGeneratorService.getAaccEuskadiExcel(filterAaccEuskadi);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	// /**
	// * Method 'udaExceptionHandle'.
	// *
	// * @param e
	// * Y41bUDAException
	// * @param request
	// * HttpServletRequest
	// * @param response
	// * HttpServletResponse
	// * @return
	// */
	// @ExceptionHandler(Y41bUDAException.class)
	// public @ResponseBody()
	// void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
	// HttpServletResponse response) {
	//
	// response.setStatus(HttpServletResponse.SC_CONFLICT);
	// Writer w = null;
	// try {
	// w = response.getWriter();
	// w.write(this.errorManager.process(e, request));
	// w.flush();
	// } catch (IOException e1) {
	// // throw new ResourceNotFoundException("No data Found.");
	// }
	// }

	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionOtrasSedes", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("aaccEuskadiSeleccionOtrasSedes", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionFederacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormModalFederacion(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("aaccEuskadiSeleccionFederacion", "model", model);
	}

	/**
	 * Method 'getAllAsocCoopByCodOrg'.
	 * 
	 * @param codOrg
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/findAllAsocCoop/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllAsocCoopByCodOrg(@PathVariable() String codOrg,
			@RequestParam(value = "tipoOrg", required = false) String tipoOrg_, HttpServletResponse response,
			HttpServletRequest request) {
		// Idioma
		Locale locale = LocaleContextHolder.getLocale();
		try {

			String tipoOrg = ("".equals(tipoOrg_)) ? null : tipoOrg_;

			AaccEuskadi aaccEuskadi = new AaccEuskadi();

			aaccEuskadi.setAeTipoOrg(tipoOrg);
			aaccEuskadi.setAeCodigo(codOrg);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<AaccEuskadi> listaAaccEuskadi = this.aaccEuskadiService.findAllAsocCoop(aaccEuskadi, pagination);
				if (listaAaccEuskadi == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.aaccEuskadiService.findAllAsocCoopCount(aaccEuskadi);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaAaccEuskadi);
				return data;
			} else {
				List<AaccEuskadi> listaAaccEuskadi = this.aaccEuskadiService.findAllAsocCoop(aaccEuskadi, pagination);
				if (listaAaccEuskadi == null) {
					throw new Exception("No data Found.");
				}
				return listaAaccEuskadi;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionConfederacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormModalConfederacion(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("aaccEuskadiSeleccionConfederacion", "model", model);
	}

	/**
	 * Method 'getAllFederacionesByCodOrg'.
	 * 
	 * @param codOrg
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/findAllFederaciones/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllFederacionesByCodOrg(@PathVariable() String codOrg,
			@RequestParam(value = "naturalezaFederacion", required = false) String naturalezaFederacion_,
			HttpServletResponse response, HttpServletRequest request) {
		// Idioma
		Locale locale = LocaleContextHolder.getLocale();
		try {

			String naturalezaFederacion = ("".equals(naturalezaFederacion_)) ? null : naturalezaFederacion_;

			AaccEuskadi aaccEuskadi = new AaccEuskadi();
			aaccEuskadi.setCheckFederacion(Y41bConstantes.VALOR_SI);
			aaccEuskadi.setAeCodigo(codOrg);
			aaccEuskadi.setAeNaturalezaFederacion(naturalezaFederacion);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<AaccEuskadi> listaAaccEuskadi = this.aaccEuskadiService.findAllFederaciones(aaccEuskadi,
						pagination);
				if (listaAaccEuskadi == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.aaccEuskadiService.findAllFederacionesCount(aaccEuskadi);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaAaccEuskadi);
				return data;
			} else {
				List<AaccEuskadi> listaAaccEuskadi = this.aaccEuskadiService.findAllFederaciones(aaccEuskadi,
						pagination);
				if (listaAaccEuskadi == null) {
					throw new Exception("No data Found.");
				}
				return listaAaccEuskadi;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionOrganoGestor", method = RequestMethod.GET)
	public ModelAndView getCreateFormModalOrganoGestor(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("aaccEuskadiSeleccionOrganoGestor", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionCuota", method = RequestMethod.GET)
	public ModelAndView getCreateFormModalCuota(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("aaccEuskadiSeleccionCuota", "model", model);
	}

}
