package com.ejie.y41b.control;

import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AaccEuskadiConfederacion;
import com.ejie.y41b.model.AaccEuskadiFederacion;
import com.ejie.y41b.service.AaccEuskadiConfederacionService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AaccController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/aaccEuskadiConfederacion")
public class AaccEuskadiConfederacionController {

	private static final Logger logger = LoggerFactory.getLogger(AaccEuskadiConfederacionController.class);

	@Autowired()
	private AaccEuskadiConfederacionService aaccEuskadiConfederacionService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'addMiembroConfederacion'.
	 * 
	 * @param codOrgConfederacion
	 *            String
	 * @param codOrgFederacion
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return
	 */
	@RequestMapping(value = "/grabarMiembroConfederacion/{codOrgConfederacion}/{codOrgFederacion}", method = RequestMethod.POST)
	public void addMiembroConfederacion(@PathVariable() String codOrgConfederacion,
			@PathVariable() String codOrgFederacion, HttpServletRequest request) {
		try {
			AaccEuskadiConfederacion aaccEuskadiConfederacion = new AaccEuskadiConfederacion();
			aaccEuskadiConfederacion.setCodOrgConfederacion(codOrgConfederacion);
			aaccEuskadiConfederacion.setCodOrgFederacion(codOrgFederacion);

			this.aaccEuskadiConfederacionService.addTemp(aaccEuskadiConfederacion);

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllByCodOrg'.
	 * 
	 * @param codOrg
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findAllByCodOrg/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllByCodOrg(@PathVariable() String codOrg, HttpServletResponse response,
			HttpServletRequest request) {
		// Idioma
		Locale locale = LocaleContextHolder.getLocale();
		try {

			AaccEuskadiConfederacion aaccEuskadiConfederacion = new AaccEuskadiConfederacion();
			aaccEuskadiConfederacion.setCodOrgConfederacion(codOrg);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<AaccEuskadiConfederacion> listaAaccEuskadiSede = this.aaccEuskadiConfederacionService
						.findAll(aaccEuskadiConfederacion, pagination);

				if (listaAaccEuskadiSede == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.aaccEuskadiConfederacionService.findAllCount(aaccEuskadiConfederacion);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaAaccEuskadiSede);
				return data;
			} else {
				List<AaccEuskadiConfederacion> listaAaccEuskadiSede = this.aaccEuskadiConfederacionService
						.findAll(aaccEuskadiConfederacion, pagination);
				if (listaAaccEuskadiSede == null) {
					throw new Exception("No data Found.");
				}
				return listaAaccEuskadiSede;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idConfederacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{idConfederacion}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String idConfederacion, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			AaccEuskadiConfederacion aaccEuskadiConfederacion = new AaccEuskadiConfederacion();
			aaccEuskadiConfederacion.setIdConfederacion(idConfederacion);
			this.aaccEuskadiConfederacionService.remove(aaccEuskadiConfederacion);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + idConfederacion);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'existe'.
	 *
	 * @param codOrgConfederacion
	 *            String
	 * @param codOrgFederacion
	 *            String
	 * 
	 * @return long
	 */
	@RequestMapping(value = "/existe/{codOrgConfederacion}/{codOrgFederacion}", method = RequestMethod.GET)
	public @ResponseBody() long existe(@PathVariable() String codOrgConfederacion,
			@PathVariable() String codOrgFederacion) {
		AaccEuskadiConfederacion aaccEuskadiConfederacion = new AaccEuskadiConfederacion();
		aaccEuskadiConfederacion.setCodOrgConfederacion(codOrgConfederacion);
		aaccEuskadiConfederacion.setCodOrgFederacion(codOrgFederacion);

		return this.aaccEuskadiConfederacionService.existeCount(aaccEuskadiConfederacion);
	}

	/**
	 * Method 'getById'.
	 *
	 * @param aeCodigo
	 *            String
	 * @return aeCodigo String
	 */
	@RequestMapping(value = "/existeEnConfederaciones/{aeCodigo}", method = RequestMethod.GET)
	public @ResponseBody() long existeEnConfederaciones(@PathVariable() String aeCodigo) {
		AaccEuskadiConfederacion aaccEuskadiConfederacion = new AaccEuskadiConfederacion();
		aaccEuskadiConfederacion.setCodOrgFederacion(aeCodigo);
		return this.aaccEuskadiConfederacionService.findAllConfederacionesCount(aaccEuskadiConfederacion);
	}

	/**
	 * Method 'getAllByCodOrg'.
	 * 
	 * @param aeCodigo
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findAllConfederaciones/{aeCodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllConfederacionesByCodOrgFederacion(@PathVariable() String aeCodigo,
			HttpServletResponse response, HttpServletRequest request) {
		// Idioma
		Locale locale = LocaleContextHolder.getLocale();
		try {

			AaccEuskadiConfederacion aaccEuskadiConfederacion = new AaccEuskadiConfederacion();
			aaccEuskadiConfederacion.setCodOrgFederacion(aeCodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<AaccEuskadiConfederacion> listaAaccEuskadiConfederacion = this.aaccEuskadiConfederacionService
						.findAllConfederaciones(aaccEuskadiConfederacion, pagination);

				if (listaAaccEuskadiConfederacion == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.aaccEuskadiConfederacionService.findAllConfederacionesCount(aaccEuskadiConfederacion);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaAaccEuskadiConfederacion);
				return data;
			} else {
				List<AaccEuskadiConfederacion> listaAaccEuskadiConfederacion = this.aaccEuskadiConfederacionService
						.findAllConfederaciones(aaccEuskadiConfederacion, pagination);
				if (listaAaccEuskadiConfederacion == null) {
					throw new Exception("No data Found.");
				}
				return listaAaccEuskadiConfederacion;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}
}
