package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.service.AaccService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AaccController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/aacc")
public class AaccController {

	private static final Logger logger = LoggerFactory
			.getLogger(AaccController.class);

	@Autowired()
	private AaccService aaccService;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		AaccController.logger.info("[GET - View] : aacc");
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| (censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO) && censoMonitor
						.getPerfilArbitraje().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO))) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("aacc", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionAacc", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaAacc",
				Y41bConstantes.MODO_POPUP_SELECCION);

		return new ModelAndView("aaccSeleccion", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param cccodigo
	 *            String
	 * @return aacc Aacc
	 */
	@RequestMapping(value = "/getById/{cccodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Aacc getById(@PathVariable() String cccodigo) {
		Aacc aacc = new Aacc();
		aacc.setCccodigo(cccodigo);
		aacc = this.aaccService.find(aacc);
		AaccController.logger.info("[GET - findBy_PK] : Obtener Aacc por PK");
		return aacc;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterAacc
	 *            Aacc
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Aacc> getAll(@ModelAttribute() Aacc filterAacc) {
		AaccController.logger
				.info("[GET - find_ALL] : Obtener Aacc por filtro");
		return this.aaccService.findAll(filterAacc, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Aacc
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Aacc edit(@RequestBody() Aacc aacc) {
		Aacc aaccAux = this.aaccService.update(aacc);
		AaccController.logger.info("[PUT] : Aacc actualizado correctamente");
		return aaccAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Aacc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Aacc add(@RequestBody() Aacc aacc) {
		Aacc aaccAux = this.aaccService.add(aacc);
		AaccController.logger.info("[POST] : Aacc insertado correctamente");
		return aaccAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param cccodigo
	 *            String
	 * @return aacc
	 */
	@RequestMapping(value = "/{cccodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Aacc remove(@PathVariable() String cccodigo) {
		try {
			Aacc aacc = new Aacc();
			aacc.setCccodigo(cccodigo);
			this.aaccService.remove(aacc);
			AaccController.logger.info("[DELETE] : Aacc borrado correctamente");
			return aacc;
		} catch (Exception e) {
			throw new Y41bUDAException(
					"error.aacc.ExpedientesAbiertosException", true,
					new Exception());
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param aaccIds
	 *            List
	 * @return aaccList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(@RequestBody() List<List<String>> aaccIds) {
		List<Aacc> aaccList = new ArrayList<Aacc>();
		for (List<String> aaccId : aaccIds) {
			Iterator<String> iterator = aaccId.iterator();
			Aacc aacc = new Aacc(); // NOPMD - Objeto nuevo en la lista
									// (parametro del servicio)
			aacc.setCccodigo(ObjectConversionManager.convert(iterator.next(),
					String.class));
			aaccList.add(aacc);
		}
		this.aaccService.removeMultiple(aaccList);
		AaccController.logger
				.info("[POST - DELETE_ALL] : Aacc borrados correctamente");
		return aaccIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterAacc
	 *            Aacc
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/busqueda", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Aacc filterAacc,
			@ModelAttribute() Pagination pagination) {

		if (!Y41bUtils.esNullOCadenaVacia(filterAacc.getCcnombre())) {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				filterAacc.getOrganismo().setNombreEs(filterAacc.getCcnombre());
			} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
				filterAacc.getOrganismo().setNombreEu(filterAacc.getCcnombre());
			}
		}
		List<Aacc> aaccs = this.aaccService.findAllBusqueda(filterAacc,
				pagination);
		Long recordNum = this.aaccService.findAllBusquedaCount(filterAacc);
		AaccController.logger.info("[GET - jqGrid] : Obtener Aacc");
		return new JQGridJSONModel(pagination, recordNum, aaccs);
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 * 
	 * @param cccodigo
	 *            String
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/detalle/{cccodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalle(@PathVariable() String cccodigo,
			Model model) {
		AaccController.logger.info("[GET - View] : aacc");
		model.addAttribute("cccodigo", cccodigo);
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_MODIFICACION);
		return new ModelAndView("aaccDetalle", "model", model);
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 * 
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model) {
		AaccController.logger.info("[GET - View] : aacc");
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_ALTA);
		return new ModelAndView("aaccDetalle", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param cccodigo
	 *            String
	 * @return aacc Aacc
	 */
	@RequestMapping(value = "/existe/{cccodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	long existe(@PathVariable() String cccodigo) {
		Aacc aacc = new Aacc();
		aacc.setCccodigo(cccodigo);
		return this.aaccService.findAllCount(aacc);
	}

	/**
	 * Method 'borrarTemporales'.
	 * 
	 * @param cccodigo
	 *            String
	 */
	@RequestMapping(value = "/borrarTemporales/{cccodigo}", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	void borrarTemporales(@PathVariable() String cccodigo) {
		Aacc aacc = new Aacc();
		aacc.setCccodigo(cccodigo);
		this.aaccService.borrarTemporales(aacc);
		AaccController.logger
				.info("[DELETE] : Aacc Temporalres borrado correctamente");

	}

	/**
	 * Method 'getAllExcel'.
	 * 
	 * @param filterAacc
	 *            Aacc
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllExcel(@ModelAttribute() Aacc filterAacc,
			HttpServletRequest request, HttpServletResponse response) {
		try {
			if (!Y41bUtils.esNullOCadenaVacia(filterAacc.getCcnombre())) {
				Locale locale = LocaleContextHolder.getLocale();
				String idioma = locale.getLanguage();
				if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					filterAacc.getOrganismo().setNombreEs(
							filterAacc.getCcnombre());
				} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
					filterAacc.getOrganismo().setNombreEu(
							filterAacc.getCcnombre());
				}
			}

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");
			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_AACC + fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService
					.getAaccExcel(filterAacc);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;
		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			// throw new ResourceNotFoundException("No data Found.");
		}
	}
}
