package com.ejie.y41b.jmsModule;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.interceptor.Interceptors;
import javax.jms.Message;
import javax.jms.MessageListener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

import com.ejie.y41b.jms.Y41bSirJMSService;

/**
 * Message-Driven Bean implementation class for: Y41bJMSModuleEJB
 *
 */
@MessageDriven(
		activationConfig = { @ActivationConfigProperty(
				propertyName = "destinationType", propertyValue = "javax.jms.Queue") }, mappedName = "y41b.y41bLibroRegistroQueue")
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class Y41bSirJMSModuleEJB implements MessageListener {

	private static final Logger logger = LoggerFactory.getLogger(Y41bSirJMSModuleEJB.class);
	
	@Autowired
	private Y41bSirJMSService y41bSirJMSService;
	
    /**
     * Default constructor. 
     */
    public Y41bSirJMSModuleEJB() {
        // TODO Auto-generated constructor stub
    }
	
	/**
     * @see MessageListener#onMessage(Message)
     */
    public void onMessage(Message message) {
    	try {
    		y41bSirJMSService.onMessage(message);
		} catch(Throwable e_onMessage){
			logger.error("Y41bJMSModuleEJB.onMessage",
					e_onMessage);
		}
        
    }

}
