package com.ejie.y41b.jmsModule;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.interceptor.Interceptors;
import javax.jms.Message;
import javax.jms.MessageListener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

import com.ejie.y41b.jms.Y41bTratamientoJMSService;

/**
 * Message-Driven Bean implementation class for: Y41bJMSModuleEJB
 *
 */
@MessageDriven(
		activationConfig = { @ActivationConfigProperty(
				propertyName = "destinationType", propertyValue = "javax.jms.Queue") }, mappedName = "y41b.y41bTramitacionQueue")
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class Y41bJMSModuleEJB implements MessageListener {

	private static final Logger logger = LoggerFactory.getLogger(Y41bJMSModuleEJB.class);
	
	@Autowired
	private Y41bTratamientoJMSService y41bTratamientoJMSService;
	
    /**
     * Default constructor. 
     */
    public Y41bJMSModuleEJB() {
        // TODO Auto-generated constructor stub
    }
	
	/**
     * @see MessageListener#onMessage(Message)
     */
    public void onMessage(Message message) {
    	try {
    		y41bTratamientoJMSService.onMessage(message);
		} catch(Throwable e_onMessage){
			logger.error("Y41bJMSModuleEJB.onMessage",
					e_onMessage);
		}
        
    }

}
