package com.ejie.y41b.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

import org.junit.Assert;
import org.junit.Test;

public class Y41bLiquidacionUtilsTest {

	/**
	 * testFechaLimitePago
	 */
	@Test()
	public void testFechaLimitePago() {

		DateFormat format = new SimpleDateFormat("yyyyMMdd");
		try {
			Assert.assertEquals("05/07/2021", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20210505"), "es"));
			Assert.assertEquals("2021/07/05", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20210505"), "eu"));
			Assert.assertEquals("05/07/2021", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20210513"), "es"));
			Assert.assertEquals("2021/07/05", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20210513"), "eu"));
			Assert.assertEquals("20/07/2021", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20210520"), "es"));
			Assert.assertEquals("2021/07/20", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20210520"), "eu"));
			Assert.assertEquals("20/02/2022", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20211220"), "es"));
			Assert.assertEquals("2022/02/20", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20211220"), "eu"));
			Assert.assertEquals("05/02/2022", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20211210"), "es"));
			Assert.assertEquals("2022/02/05", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20211210"), "eu"));
			Assert.assertEquals("05/01/2022", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20211110"), "es"));
			Assert.assertEquals("2022/01/05", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20211110"), "eu"));
			Assert.assertEquals("20/04/2021", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20210228"), "es"));
			Assert.assertEquals("2021/04/20", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20210228"), "eu"));
			Assert.assertEquals("20/05/2021", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20210331"), "es"));
			Assert.assertEquals("2021/05/20", Y41bLiquidacionUtils.fechaLimitePago(format.parse("20210331"), "eu"));
		} catch (Exception e) {
			Assert.assertEquals(0, 1);
		}
	}

}
