package com.ejie.y41b.test.service;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.service.ConsumidorService;

/**
 * Clase de test de Y41bDokusiAdapterService
 * 
 *  
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = {
		"classpath:/resourcesTest/spring-test/dao-config.xml",
		"classpath:/resourcesTest/spring-test/dao-config.xml",
		"classpath:/resourcesTest/spring-test/service-config.xml" })
public class Y41bConsumidorServiceTest {

	@Autowired
	private ConsumidorService consumidorService;

	@Test
	public void testFindAll() {
		Consumidor consumidorFilter = new Consumidor();
		consumidorFilter.setDtnombre("JUNIT-TEST-DTNOMBRE");
		consumidorFilter.setDtnoraProvinciaId("01");
		consumidorFilter.setDtnoraMunicipioId("059");
		consumidorFilter.setDtnoraLocalidadId("10105900000060");
		List<Consumidor> consumidores = consumidorService.findAll(
				consumidorFilter, null);
		Assert.assertEquals(0, consumidores.size());

		Consumidor consumidorNew = new Consumidor();
		consumidorNew.setDtnif("JUNIT000");
		consumidorNew.setDtnombre("JUNIT-TEST-DTNOMBRE");
		consumidorNew.setDtnoraProvinciaId("01");
		consumidorNew.setDtnoraMunicipioId("059");
		consumidorNew.setDtnoraLocalidadId("10105900000060");
		consumidorNew = consumidorService.addConsumidor(consumidorNew);
		Consumidor consumidorDetalleFilter = new Consumidor();
		consumidorDetalleFilter.setDtcodigo(consumidorNew.getDtcodigo());
		Consumidor consumidorDetalle = consumidorService
				.find(consumidorDetalleFilter);
		Assert.assertEquals(consumidorDetalle.getDtnombre(),
				"JUNIT-TEST-DTNOMBRE");

		consumidorService.remove(consumidorNew);
		consumidores = consumidorService.findAll(consumidorFilter, null);
		Assert.assertEquals(0, consumidores.size());
	}
}
