package com.ejie.y41b.test.adapter;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.Formato;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;

/**
 * Clase de test de Y41bDokusiAdapterService
 * 
 *  
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = {
		"classpath:/resourcesTest/spring-test/log-config.xml",
		"classpath:/resourcesTest/spring-test/dao-config.xml",
		"classpath:/resourcesTest/spring-test/service-config.xml" })
public class Y41bDokusiAdapterServiceTest {

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Test
	public void testRecuperarFormatosDocumentosDokusi() {
		System.setProperty("javax.xml.soap.MessageFactory",
				"weblogic.webservice.core.soap.MessageFactoryImpl");
		// Setup the global JAX-RPC service factory
		System.setProperty("javax.xml.rpc.ServiceFactory",
				"weblogic.webservice.core.rpc.ServiceFactoryImpl");

		// Inicio Bloque del Test
		Documento documento = new Documento();
		// 1.User
		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento("Y41B_RECLAMACION");
		documento.setProcedure(procedure);

		// CON Localizador
		documento.setOidDokusi("09f4240180632a91");
		// SIN Localizador
		// documento.setOidDokusi("09f4240180601b61");

		Formato formato = y41bDokusiAdapterService
				.recuperarFormatosDocumentosDokusi(documento);
		Assert.assertEquals(formato.getName(), "pdfa");
	}
}
