package com.ejie.y41b.ws.cliente.t65bfsd;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;

/**
 * This class was  
 * source version: 2.1
 * 
 */
@WebService(name = "t65bFSDWSClasePort", targetNamespace = "http://www.ejie.es/webServiceClase/t65bFSDWar")
@SOAPBinding(style = SOAPBinding.Style.RPC)
public interface T65BFSDWSClasePort {

	/**
	 * 
	 * @param integrationToken
	 * @param auditUser
	 * @param documentIDs
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "removeLocatorVerificationResult", partName = "removeLocatorVerificationResult")
	public boolean removeLocatorVerification(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDs", partName = "documentIDs") String documentIDs);

	/**
	 * 
	 * @param integrationToken
	 * @param auditUser
	 * @param documentIDs
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "restoreLocatorVerification", partName = "restoreLocatorVerification")
	public boolean restoreLocatorVerification(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDs", partName = "documentIDs") String documentIDs);

	/**
	 * 
	 * @param boolConfirmation
	 * @param integrationToken
	 * @param auditUser
	 * @param searchConditionsList
	 * @param documentalType
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "removeNoProdRegisteredDocumentsResult", partName = "removeNoProdRegisteredDocumentsResult")
	public String removeNoProdRegisteredDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "searchConditionsList", partName = "searchConditionsList") String searchConditionsList,
			@WebParam(name = "boolConfirmation", partName = "boolConfirmation") boolean boolConfirmation);

	/**
	 * 
	 * @param locator
	 * @param keysList
	 * @param docLocation
	 * @param sede
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "verifyLocatorResult", partName = "verifyLocatorResult")
	public String verifyLocator(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "locator", partName = "locator") String locator,
			@WebParam(name = "keysList", partName = "keysList") String keysList,
			@WebParam(name = "sede", partName = "sede") String sede,
			@WebParam(name = "docLocation", partName = "docLocation") String docLocation);

	/**
	 * 
	 * @param locator
	 * @param keysList
	 * @param sede
	 * @param integrationToken
	 * @param auditUser
	 * @param pifId
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "verifyLocatorPifResult", partName = "verifyLocatorPifResult")
	public String verifyLocatorPif(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "locator", partName = "locator") String locator,
			@WebParam(name = "keysList", partName = "keysList") String keysList,
			@WebParam(name = "sede", partName = "sede") String sede,
			@WebParam(name = "pifId", partName = "pifId") String pifId);

	/**
	 * 
	 * @param integrationToken
	 * @param auditUser
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "relaunchJMSMessagesResult", partName = "relaunchJMSMessagesResult")
	public boolean relaunchJMSMessages(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser);

	/**
	 * 
	 * @param boolVersion
	 * @param documentID
	 * @param sede
	 * @param boolReducir
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "addLocatorToDocumentResult", partName = "addLocatorToDocumentResult")
	public String addLocatorToDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "boolVersion", partName = "boolVersion") boolean boolVersion,
			@WebParam(name = "boolReducir", partName = "boolReducir") boolean boolReducir,
			@WebParam(name = "sede", partName = "sede") String sede);

	/**
	 * 
	 * @param boolVersion
	 * @param documentID
	 * @param sede
	 * @param boolReducir
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "addLocatorToDocumentSyncResult", partName = "addLocatorToDocumentSyncResult")
	public String addLocatorToDocumentSync(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "boolVersion", partName = "boolVersion") boolean boolVersion,
			@WebParam(name = "boolReducir", partName = "boolReducir") boolean boolReducir,
			@WebParam(name = "sede", partName = "sede") String sede);

	/**
	 * 
	 * @param boolVersion
	 * @param documentID
	 * @param sede
	 * @param boolReducir
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "addLocatorToDocumentQRResult", partName = "addLocatorToDocumentQRResult")
	public String addLocatorToDocumentQR(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "boolVersion", partName = "boolVersion") boolean boolVersion,
			@WebParam(name = "boolReducir", partName = "boolReducir") String boolReducir,
			@WebParam(name = "sede", partName = "sede") String sede);

	/**
	 * 
	 * @param boolVersion
	 * @param documentID
	 * @param sede
	 * @param boolReducir
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "addLocatorToDocumentSyncQRResult", partName = "addLocatorToDocumentSyncQRResult")
	public String addLocatorToDocumentSyncQR(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "boolVersion", partName = "boolVersion") boolean boolVersion,
			@WebParam(name = "boolReducir", partName = "boolReducir") String boolReducir,
			@WebParam(name = "sede", partName = "sede") String sede);

	/**
	 * 
	 * @param documentID
	 * @param attributeList
	 * @param integrationToken
	 * @param auditUser
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "archiveDocumentResult", partName = "archiveDocumentResult")
	public boolean archiveDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * 
	 * @param documentID
	 * @param attributeList
	 * @param newDocumentalType
	 * @param integrationToken
	 * @param auditUser
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "rearchiveDocumentResult", partName = "rearchiveDocumentResult")
	public boolean rearchiveDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "newDocumentalType", partName = "newDocumentalType") String newDocumentalType,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * 
	 * @param documentID
	 * @param integrationToken
	 * @param format
	 * @param auditUser
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "createTransformationResult", partName = "createTransformationResult")
	public boolean createTransformation(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "format", partName = "format") String format);

	/**
	 * 
	 * @param documentID
	 * @param attributeList
	 * @param newDocumentalType
	 * @param integrationToken
	 * @param auditUser
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "retramitateDocumentResult", partName = "retramitateDocumentResult")
	public boolean retramitateDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "newDocumentalType", partName = "newDocumentalType") String newDocumentalType,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * 
	 * @param attributeList
	 * @param integrationToken
	 * @param auditUser
	 * @param documentIDs
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "retramitateDocumentsResult", partName = "retramitateDocumentsResult")
	public boolean retramitateDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDs", partName = "documentIDs") String documentIDs,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * 
	 * @param integrationToken
	 * @param documentAttrInfoList
	 * @param auditUser
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "retramitateDocumentsExResult", partName = "retramitateDocumentsExResult")
	public boolean retramitateDocumentsEx(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentAttrInfoList", partName = "documentAttrInfoList") String documentAttrInfoList);

	/**
	 * 
	 * @param integrationToken
	 * @param documentAttrInfoList
	 * @param auditUser
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "demoteDocumentsResult", partName = "demoteDocumentsResult")
	public boolean demoteDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentAttrInfoList", partName = "documentAttrInfoList") String documentAttrInfoList);

	/**
	 * 
	 * @param documentID
	 * @param attributeList
	 * @param newDocumentalType
	 * @param integrationToken
	 * @param auditUser
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "tramitateDocumentResult", partName = "tramitateDocumentResult")
	public boolean tramitateDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "newDocumentalType", partName = "newDocumentalType") String newDocumentalType,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * 
	 * @param integrationToken
	 * @param documentAttrInfoList
	 * @param auditUser
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "tramitateDocumentsResult", partName = "tramitateDocumentsResult")
	public boolean tramitateDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentAttrInfoList", partName = "documentAttrInfoList") String documentAttrInfoList);

	/**
	 * 
	 * @param documentID
	 * @param boolAllVersions
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "deleteDocumentResult", partName = "deleteDocumentResult")
	public String deleteDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "boolAllVersions", partName = "boolAllVersions") boolean boolAllVersions);

	/**
	 * 
	 * @param content
	 * @param documentID
	 * @param boolSetCurrent
	 * @param saveAsVersion
	 * @param attributeList
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "modifyDocumentResult", partName = "modifyDocumentResult")
	public String modifyDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "saveAsVersion", partName = "saveAsVersion") String saveAsVersion,
			@WebParam(name = "boolSetCurrent", partName = "boolSetCurrent") boolean boolSetCurrent,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList,
			@WebParam(name = "content", partName = "content") String content);

	/**
	 * 
	 * @param content
	 * @param documentID
	 * @param boolSetCurrent
	 * @param saveAsVersion
	 * @param attributeList
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "modifyDocumentClpResult", partName = "modifyDocumentClpResult")
	public String modifyDocumentClp(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "saveAsVersion", partName = "saveAsVersion") String saveAsVersion,
			@WebParam(name = "boolSetCurrent", partName = "boolSetCurrent") boolean boolSetCurrent,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList,
			@WebParam(name = "content", partName = "content") String content);

	/**
	 * 
	 * @param content
	 * @param documentID
	 * @param signatureInfo
	 * @param integrationToken
	 * @param auditUser
	 * @param signature
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "modifyRegisteredDocumentResult", partName = "modifyRegisteredDocumentResult")
	public String modifyRegisteredDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "content", partName = "content") String content,
			@WebParam(name = "signatureInfo", partName = "signatureInfo") String signatureInfo,
			@WebParam(name = "signature", partName = "signature") String signature);

	/**
	 * 
	 * @param documentID
	 * @param attributeList
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "shareDocumentContentsResult", partName = "shareDocumentContentsResult")
	public String shareDocumentContents(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * 
	 * @param integrationToken
	 * @param documentsToShare
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "shareDocumentsContentsResult", partName = "shareDocumentsContentsResult")
	public String shareDocumentsContents(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentsToShare", partName = "documentsToShare") String documentsToShare);

	/**
	 * 
	 * @param documentID
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveSharedContentRelationshipsResult", partName = "retrieveSharedContentRelationshipsResult")
	public String retrieveSharedContentRelationships(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID);

	/**
	 * 
	 * @param content
	 * @param documentID
	 * @param keysList
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveDocumentResult", partName = "retrieveDocumentResult")
	public String retrieveDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "keysList", partName = "keysList") String keysList,
			@WebParam(name = "content", partName = "content") String content);

	/**
	 * 
	 * @param content
	 * @param documentID
	 * @param keysList
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveDocumentDescResult", partName = "retrieveDocumentDescResult")
	public String retrieveDocumentDesc(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "keysList", partName = "keysList") String keysList,
			@WebParam(name = "content", partName = "content") String content);

	/**
	 * 
	 * @param documentsToReturn
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveDocumentsDescResult", partName = "retrieveDocumentsDescResult")
	public String retrieveDocumentsDesc(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentsToReturn", partName = "documentsToReturn") String documentsToReturn);

	/**
	 * 
	 * @param documentID
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveDocumentVersionsIdsResult", partName = "retrieveDocumentVersionsIdsResult")
	public String retrieveDocumentVersionsIds(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID);

	/**
	 * 
	 * @param contentArray
	 * @param keysListArray
	 * @param integrationToken
	 * @param auditUser
	 * @param documentIDArray
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveDocumentsResult", partName = "retrieveDocumentsResult")
	public String retrieveDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDArray", partName = "documentIDArray") String documentIDArray,
			@WebParam(name = "keysListArray", partName = "keysListArray") String keysListArray,
			@WebParam(name = "contentArray", partName = "contentArray") String contentArray);

	/**
	 * 
	 * @param attributeList
	 * @param boolAllVersions
	 * @param integrationToken
	 * @param intMaxRows
	 * @param auditUser
	 * @param documentalType
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveDocumentsIdsResult", partName = "retrieveDocumentsIdsResult")
	public String retrieveDocumentsIds(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList,
			@WebParam(name = "boolAllVersions", partName = "boolAllVersions") boolean boolAllVersions,
			@WebParam(name = "intMaxRows", partName = "intMaxRows") int intMaxRows);

	/**
	 * 
	 * @param boolAllVersions
	 * @param integrationToken
	 * @param intMaxRows
	 * @param auditUser
	 * @param searchConditionsList
	 * @param documentalType
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveDocumentsIdsExResult", partName = "retrieveDocumentsIdsExResult")
	public String retrieveDocumentsIdsEx(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "searchConditionsList", partName = "searchConditionsList") String searchConditionsList,
			@WebParam(name = "boolAllVersions", partName = "boolAllVersions") boolean boolAllVersions,
			@WebParam(name = "intMaxRows", partName = "intMaxRows") int intMaxRows);

	/**
	 * 
	 * @param documentID
	 * @param integrationToken
	 * @param signatures
	 * @param auditUser
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "addSignaturesToDocumentResult", partName = "addSignaturesToDocumentResult")
	public boolean addSignaturesToDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "signatures", partName = "signatures") String signatures);

	/**
	 * 
	 * @param documentID
	 * @param integrationToken
	 * @param format
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveSignaturesResult", partName = "retrieveSignaturesResult")
	public String retrieveSignatures(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "format", partName = "format") String format);

	/**
	 * 
	 * @param documentID
	 * @param integrationToken
	 * @param format
	 * @param auditUser
	 * @return returns int
	 */
	@WebMethod
	@WebResult(name = "retrieveSignaturesCountResult", partName = "retrieveSignaturesCountResult")
	public int retrieveSignaturesCount(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "format", partName = "format") String format);

	/**
	 * 
	 * @param appCode
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "getApplicationTokenResult", partName = "getApplicationTokenResult")
	public String getApplicationToken(
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "appCode", partName = "appCode") String appCode);

	/**
	 * 
	 * @param deleteFolder
	 * @param documentLocation
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "removeDocumentLocationResult", partName = "removeDocumentLocationResult")
	public String removeDocumentLocation(
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentLocation", partName = "documentLocation") String documentLocation,
			@WebParam(name = "deleteFolder", partName = "deleteFolder") boolean deleteFolder);

	/**
	 * 
	 * @param documentID
	 * @param integrationToken
	 * @param auditUser
	 * @param signature
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "updateSignatureResult", partName = "updateSignatureResult")
	public boolean updateSignature(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "signature", partName = "signature") String signature);

	/**
	 * 
	 * @param documentID
	 * @param signatureInfo
	 * @param integrationToken
	 * @param auditUser
	 * @param signature
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "updateSignaturesResult", partName = "updateSignaturesResult")
	public boolean updateSignatures(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "signatureInfo", partName = "signatureInfo") String signatureInfo,
			@WebParam(name = "signature", partName = "signature") String signature);

	/**
	 * 
	 * @param signatureInfo
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveSignedDocumentsIdsResult", partName = "retrieveSignedDocumentsIdsResult")
	public String retrieveSignedDocumentsIds(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "signatureInfo", partName = "signatureInfo") String signatureInfo);

	/**
	 * 
	 * @param integrationToken
	 * @param format
	 * @param auditUser
	 * @param documentIDArray
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveDocumentsSignaturesResult", partName = "retrieveDocumentsSignaturesResult")
	public String retrieveDocumentsSignatures(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDArray", partName = "documentIDArray") String documentIDArray,
			@WebParam(name = "format", partName = "format") String format);

	/**
	 * 
	 * @param keysListArray
	 * @param integrationToken
	 * @param format
	 * @param auditUser
	 * @param documentIDArray
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveDocumentsSignaturesExResult", partName = "retrieveDocumentsSignaturesExResult")
	public String retrieveDocumentsSignaturesEx(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDArray", partName = "documentIDArray") String documentIDArray,
			@WebParam(name = "keysListArray", partName = "keysListArray") String keysListArray,
			@WebParam(name = "format", partName = "format") String format);

	/**
	 * 
	 * @param searchAttributeList
	 * @param boolAllVersions
	 * @param integrationToken
	 * @param intMaxRows
	 * @param auditUser
	 * @param documentalType
	 * @param returnedAttributeKeysList
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "searchDocumentsResult", partName = "searchDocumentsResult")
	public String searchDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "returnedAttributeKeysList", partName = "returnedAttributeKeysList") String returnedAttributeKeysList,
			@WebParam(name = "searchAttributeList", partName = "searchAttributeList") String searchAttributeList,
			@WebParam(name = "boolAllVersions", partName = "boolAllVersions") boolean boolAllVersions,
			@WebParam(name = "intMaxRows", partName = "intMaxRows") int intMaxRows);

	/**
	 * 
	 * @param searchParamsList
	 * @param integrationToken
	 * @param intMaxRows
	 * @param auditUser
	 * @param searchConditionsList
	 * @param returnedAttributeKeysList
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "searchDocumentsFullTextResult", partName = "searchDocumentsFullTextResult")
	public String searchDocumentsFullText(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "returnedAttributeKeysList", partName = "returnedAttributeKeysList") String returnedAttributeKeysList,
			@WebParam(name = "searchConditionsList", partName = "searchConditionsList") String searchConditionsList,
			@WebParam(name = "searchParamsList", partName = "searchParamsList") String searchParamsList,
			@WebParam(name = "intMaxRows", partName = "intMaxRows") int intMaxRows);

	/**
	 * 
	 * @param searchParamsList
	 * @param integrationToken
	 * @param auditUser
	 * @param searchConditionsList
	 * @param parametricAttributeKeysList
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "searchParametricsFullTextResult", partName = "searchParametricsFullTextResult")
	public String searchParametricsFullText(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "parametricAttributeKeysList", partName = "parametricAttributeKeysList") String parametricAttributeKeysList,
			@WebParam(name = "searchConditionsList", partName = "searchConditionsList") String searchConditionsList,
			@WebParam(name = "searchParamsList", partName = "searchParamsList") String searchParamsList);

	/**
	 * 
	 * @param documentID
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "getDocumentIndexInfoResult", partName = "getDocumentIndexInfoResult")
	public String getDocumentIndexInfo(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID);

	/**
	 * 
	 * @param boolAllVersions
	 * @param integrationToken
	 * @param intMaxRows
	 * @param auditUser
	 * @param searchConditionsList
	 * @param documentalType
	 * @param returnedAttributeKeysList
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "searchDocumentsExResult", partName = "searchDocumentsExResult")
	public String searchDocumentsEx(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "returnedAttributeKeysList", partName = "returnedAttributeKeysList") String returnedAttributeKeysList,
			@WebParam(name = "searchConditionsList", partName = "searchConditionsList") String searchConditionsList,
			@WebParam(name = "boolAllVersions", partName = "boolAllVersions") boolean boolAllVersions,
			@WebParam(name = "intMaxRows", partName = "intMaxRows") int intMaxRows);

	/**
	 * 
	 * @param boolAllVersions
	 * @param integrationToken
	 * @param intMaxRows
	 * @param auditUser
	 * @param searchConditionsList
	 * @param returnedAttributeKeysList
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "searchDocumentsUntypedResult", partName = "searchDocumentsUntypedResult")
	public String searchDocumentsUntyped(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "returnedAttributeKeysList", partName = "returnedAttributeKeysList") String returnedAttributeKeysList,
			@WebParam(name = "searchConditionsList", partName = "searchConditionsList") String searchConditionsList,
			@WebParam(name = "boolAllVersions", partName = "boolAllVersions") boolean boolAllVersions,
			@WebParam(name = "intMaxRows", partName = "intMaxRows") int intMaxRows);

	/**
	 * 
	 * @param documentID
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "verifyDocumentFormatResult", partName = "verifyDocumentFormatResult")
	public String verifyDocumentFormat(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID);

	/**
	 * 
	 * @param formatName
	 * @param documentID
	 * @param integrationToken
	 * @param auditUser
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "modifyDocumentFormatResult", partName = "modifyDocumentFormatResult")
	public boolean modifyDocumentFormat(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "formatName", partName = "formatName") String formatName);

	/**
	 * 
	 * @param content
	 * @param attributeList
	 * @param integrationToken
	 * @param auditUser
	 * @param documentalType
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "storeDocumentResult", partName = "storeDocumentResult")
	public String storeDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "content", partName = "content") String content,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * 
	 * @param content
	 * @param attributeList
	 * @param integrationToken
	 * @param auditUser
	 * @param documentalType
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "storeDocumentVerificationFormatResult", partName = "storeDocumentVerificationFormatResult")
	public String storeDocumentVerificationFormat(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "content", partName = "content") String content,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * 
	 * @param contentArray
	 * @param documentalTypeArray
	 * @param integrationToken
	 * @param auditUser
	 * @param attributeListArray
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "storeDocumentsResult", partName = "storeDocumentsResult")
	public String storeDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "contentArray", partName = "contentArray") String contentArray,
			@WebParam(name = "documentalTypeArray", partName = "documentalTypeArray") String documentalTypeArray,
			@WebParam(name = "attributeListArray", partName = "attributeListArray") String attributeListArray);

	/**
	 * 
	 * @param integrationToken
	 * @param format
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveAvailableFormatsResult", partName = "retrieveAvailableFormatsResult")
	public String retrieveAvailableFormats(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "format", partName = "format") String format);

	/**
	 * 
	 * @param documentID
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveDocumentFormatsResult", partName = "retrieveDocumentFormatsResult")
	public String retrieveDocumentFormats(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID);

	/**
	 * 
	 * @param integrationToken
	 * @param auditUser
	 * @param documentIDArray
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveDocumentsFormatsResult", partName = "retrieveDocumentsFormatsResult")
	public String retrieveDocumentsFormats(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDArray", partName = "documentIDArray") String documentIDArray);

	/**
	 * 
	 * @param documentID
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveDocumentValidFormatsResult", partName = "retrieveDocumentValidFormatsResult")
	public String retrieveDocumentValidFormats(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID);

	/**
	 * 
	 * @param content
	 * @param documentID
	 * @param integrationToken
	 * @param digitType
	 * @param auditUser
	 * @param digitDate
	 * @return returns boolean
	 */
	@WebMethod
	@WebResult(name = "addDigitalizationToDocumentResult", partName = "addDigitalizationToDocumentResult")
	public boolean addDigitalizationToDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "content", partName = "content") String content,
			@WebParam(name = "digitType", partName = "digitType") String digitType,
			@WebParam(name = "digitDate", partName = "digitDate") String digitDate);

	/**
	 * 
	 * @param integrationToken
	 * @param auditUser
	 * @param documentalType
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveTypeDefinitionResult", partName = "retrieveTypeDefinitionResult")
	public String retrieveTypeDefinition(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType);

	/**
	 * 
	 * @param attributeKeysList
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveAttributedTypeNamesResult", partName = "retrieveAttributedTypeNamesResult")
	public String retrieveAttributedTypeNames(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "attributeKeysList", partName = "attributeKeysList") String attributeKeysList);

	/**
	 * 
	 * @param ctsFormat
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveAvailableTransformationFormatsResult", partName = "retrieveAvailableTransformationFormatsResult")
	public String retrieveAvailableTransformationFormats(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "ctsFormat", partName = "ctsFormat") String ctsFormat);

	/**
	 * 
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveAvailableFormatsScenariosResult", partName = "retrieveAvailableFormatsScenariosResult")
	public String retrieveAvailableFormatsScenarios(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser);

	/**
	 * 
	 * @param integrationToken
	 * @param auditUser
	 * @param formatsScenarioId
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveFormatsScenarioResult", partName = "retrieveFormatsScenarioResult")
	public String retrieveFormatsScenario(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "formatsScenarioId", partName = "formatsScenarioId") String formatsScenarioId);

	/**
	 * 
	 * @param integrationToken
	 * @param auditUser
	 * @return returns java.lang.String
	 */
	@WebMethod
	@WebResult(name = "retrieveLocatorTimerDatesResult", partName = "retrieveLocatorTimerDatesResult")
	public String retrieveLocatorTimerDates(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser);

}
