package com.ejie.y41b.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import com.ejie.y41b.utils.Y41bUtils;

public class Y41bNifValidator implements ConstraintValidator<Y41bNif, String> {

	private Pattern mask = Pattern.compile("[0-9]{8,8}[A-Z]");
	private static final int longitudCero = 0;

	@Override
	public void initialize(Y41bNif constraintAnnotation) {
	}

	@Override
	public boolean isValid(String value, ConstraintValidatorContext context) {

		if (value == null || value.length() == Y41bNifValidator.longitudCero) {
			return true;
		} else {

			Matcher matcher = mask.matcher(value.toUpperCase());

			if (matcher.matches()) {
				char letra = Y41bUtils.calcularLetraNIF(value);

				if (letra == value.toUpperCase().charAt(value.length() - 1)) {
					return true;
				}
				return false;
			} else {
				return false;
			}
		}
	}
}