package com.ejie.y41b.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import com.ejie.y41b.utils.Y41bUtils;

public class Y41bNieValidator implements ConstraintValidator<Y41bNie, String> {

	private Pattern mask = Pattern.compile("[X-Z]\\d{7}[A-Z]");
	private static final int longitudCero = 0;

	@Override
	public void initialize(Y41bNie constraintAnnotation) {
	}

	@Override
	public boolean isValid(String value, ConstraintValidatorContext context) {

		if (value == null || value.length() == Y41bNieValidator.longitudCero) {
			return true;
		} else {

			Matcher matcher = mask.matcher(value.toUpperCase());

			if (matcher.matches()) {
				if ('X' == value.toUpperCase().charAt(0)) {
					value = value.toUpperCase().replaceFirst("X", "0");
				} else if ('Y' == value.toUpperCase().charAt(0)) {
					value = value.toUpperCase().replaceFirst("Y", "1");
				} else if ('Z' == value.toUpperCase().charAt(0)) {
					value = value.toUpperCase().replaceFirst("Z", "2");
				}
				char letra = Y41bUtils.calcularLetraNIF(value);

				if (letra == value.toUpperCase().charAt(value.length() - 1)) {
					return true;
				}
				return false;
			} else {
				return false;
			}
		}
	}
}