package com.ejie.y41b.utils.xml;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.ejie.r02K.xml.DescriptionDocument;
import com.ejie.r02K.xml.DescriptionDocument.Description;
import com.ejie.y41b.constantes.Y41bConstantes;

import java.io.IOException;
import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;

/**
 * V34bbUtils
 * 
 *  
 */
public class Y41bXMLUtils {
	/** Constructor privado */
	private Y41bXMLUtils() {
	}

	/**
	 * quitarNameSpaces(com.bea.xml.XmlObject oXmlEntrada)
	 * 
	 * @param oXmlEntrada
	 *            XmlObject
	 * @return XmlObject
	 * @exception Exception
	 *                e
	 */
	public static com.bea.xml.XmlObject quitarNameSpaces(
			com.bea.xml.XmlObject oXmlEntrada) throws Exception {

		String sNuevoNameSpace;

		com.bea.xml.XmlObject oXmlRetorno = oXmlEntrada;
		com.bea.xml.XmlCursor oXmlCursor = oXmlRetorno.newCursor();

		oXmlCursor.toNextToken();

		while (oXmlCursor.hasNextToken()) {

			if (oXmlCursor.isNamespace()) {
				oXmlCursor.removeXml();
			} else {

				if (oXmlCursor.isStart()) {
					sNuevoNameSpace = oXmlCursor.getName().getLocalPart();
					oXmlCursor.setName(new javax.xml.namespace.QName(
							sNuevoNameSpace));
				}
				oXmlCursor.toNextToken();
			}
		}
		oXmlCursor.dispose();

		return oXmlRetorno;

	}

	/**
	 * quitarNameSpacesString(com.bea.xml.XmlObject oXmlEntrada)
	 * 
	 * @param oXmlEntrada
	 *            XmlObject
	 * @return String
	 * @exception Exception
	 *                e
	 */
	public static String quitarNameSpacesString(
			com.bea.xml.XmlObject oXmlEntrada) throws Exception {

		com.bea.xml.XmlObject xmlO = Y41bXMLUtils.quitarNameSpaces(oXmlEntrada);

		return (xmlO != null) ? xmlO.xmlText() : "";
	}

	/**
	 * quitarXMLFragment(String xmlFragment)
	 * 
	 * @param xmlFragment
	 *            String
	 * @return String
	 * @exception Exception
	 *                e
	 */
	public static String quitarXMLFragment(String xmlFragment) throws Exception {
		String xmlSinFragment = null;
		if (xmlFragment != null) {
			xmlSinFragment = xmlFragment.replaceAll("<xml-fragment>", "");
			xmlSinFragment = xmlSinFragment.replaceAll("</xml-fragment>", "");
		}
		return xmlSinFragment;
	}

	/**
	 * createLanguageEstructura(String etiqueta, String value)
	 * 
	 * @param etiqueta
	 *            String
	 * @param value
	 *            String
	 * @return String
	 * @exception Exception
	 *                e
	 */
	public static String createLanguageEstructura(String etiqueta, String value)
			throws Exception {
		StringBuffer languageEstructura = new StringBuffer();
		languageEstructura.append("<").append(etiqueta).append(">");
		languageEstructura.append("<language locale=\"es\">").append(value)
				.append("</language>");
		languageEstructura.append("<language locale=\"eu\">").append(value)
				.append("</language>");
		languageEstructura.append("</").append(etiqueta).append(">");
		return languageEstructura.toString();
	}

	/**
	 * createLanguageEstructura(String etiqueta, String value_es, String
	 * value_eu)
	 * 
	 * @param etiqueta
	 *            String
	 * @param value_es
	 *            String
	 * @param value_eu
	 *            String
	 * @return String
	 * @exception Exception
	 *                e
	 */
	public static String createLanguageEstructura(String etiqueta,
			String value_es, String value_eu) throws Exception {
		StringBuffer languageEstructura = new StringBuffer();
		languageEstructura.append("<").append(etiqueta).append(">");
		languageEstructura.append("<language locale=\"es\">").append(value_es)
				.append("</language>");
		languageEstructura.append("<language locale=\"eu\">").append(value_eu)
				.append("</language>");
		languageEstructura.append("</").append(etiqueta).append(">");
		return languageEstructura.toString();
	}

	/**
	 * getDescLanguageByDesc(String idioma, Description description)
	 * 
	 * @param idioma
	 *            String
	 * @param descriptionXML
	 *            DescriptionXML
	 * @return String
	 * @exception Exception
	 *                Exception
	 */
	public static String getDescLanguageByDesc(String idioma,
			String descriptionXML) throws Exception {
		String valueDesc = "";
		descriptionXML = descriptionXML.replaceAll("<description>",
				Y41bConstantes.ETIQUETA_DESCRIPTION_INI_XMLNS);
		DescriptionDocument descriptionDoc = DescriptionDocument.Factory
				.parse(descriptionXML);
		Description description = descriptionDoc.getDescription();

		if (description != null && description.getLanguageArray() != null
				&& description.getLanguageArray().length > 0) {
			for (int i = 0; i < description.getLanguageArray().length; i++) {
				if (idioma.equals(description.getLanguageArray(i).getLocale()
						.toString())) {
					valueDesc = description.getLanguageArray(i)
							.getStringValue();
					break;
				}
			}
		}
		return valueDesc;
	}

	/**
	 * Removes namespaces from string
	 * 
	 * @param xmlString
	 *            String
	 * @return String
	 */
	public static String removeXmlStringNamespaceAndPreamble(String xmlString) {
		return xmlString.replaceAll("(<\\?[^<]*\\?>)?", ""). /* remove preamble */
		replaceAll("xmlns.*?(\"|\').*?(\"|\')", "") /* remove xmlns declaration */
		.replaceAll("(<)(\\w+:)(.*?>)", "$1$3") /* remove opening tag prefix */
		.replaceAll("(</)(\\w+:)(.*?>)", "$1$3"); /* remove closing tags prefix */
	}

	public static Document getDocumentFromString(String strInput)
			throws Exception {
		/**
		 * Variables para la generacion del Document a partir del String
		 */

		Document document = null;

		// Inizializacion del parser
		DocumentBuilderFactory docBFact = DocumentBuilderFactory.newInstance();
		DocumentBuilder documentBuilder = docBFact.newDocumentBuilder();

		/*
		 * Se parsea el xml segun encoding del xml Si no hay encoding se
		 * utilizara el de por defecto de la libreria -> UTF-8
		 */
		String encoding = "UTF-8";
		document = documentBuilder
				.parse((InputStream) new ByteArrayInputStream(strInput
						.getBytes(encoding)));

		return document;
	}

	/**
	 * Convierte un Node en String
	 * 
	 * @param nodo
	 *            Nodo que se quiere transformar en String
	 * @return El nodo convertido a String
	 * @throws Exception
	 *             exception
	 */
	public static String getStringFromNode(Node nodo) throws Exception {
		String xmlString = "";
		TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer;
		try {
			transformer = tFactory.newTransformer();
			DOMSource source = new DOMSource(nodo);
			StringWriter sw = new StringWriter();
			StreamResult result = new StreamResult(sw);
			try {
				transformer.transform(source, result);
			} catch (TransformerException e1) {
				throw new Exception(e1.getMessage());
			}
			xmlString = sw.toString();
		} catch (TransformerConfigurationException e1) {
			throw new Exception(e1.getMessage());
		}

		try {
			Document doc = getDocumentFromString(xmlString);
			// doc.appendChild(nodo);
			// Document doc = nodo.getOwnerDocument();
			OutputFormat format = new OutputFormat(doc);
			format.setIndent(Y41bConstantes.NUM_3);
			StringWriter stringOut = new StringWriter();
			XMLSerializer serial = new XMLSerializer(stringOut, format);
			serial.serialize(doc);
			xmlString = stringOut.toString();
		} catch (FactoryConfigurationError e) {
			throw new Exception(e.getMessage());
		} catch (ParserConfigurationException e) {
			throw new Exception(e.getMessage());
		} catch (IOException e) {
			throw new Exception(e.getMessage());
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		}

		return xmlString;
	}

	/**
	 * Recupera el vector con los valores de los elementos parseados en un
	 * documento XML.
	 * 
	 * @param strPfDocument
	 *            Documento que contiene el XML
	 * @param strPfXPath
	 *            Ruta de la etiqueta que se quiere parsear
	 * @return El nodo seleccionado por la ruta
	 * @throws Exception
	 *             dom util exception
	 */
	public static Node retrieveNodeXPath(Document strPfDocument,
			String strPfXPath) throws Exception {
		try {
			return XPathAPI.selectSingleNode(strPfDocument, strPfXPath);

		} catch (TransformerException e) {
			throw new Exception(e.getMessage());
		}
	}

	/**
	 * Removes &lt; y &gt;
	 * 
	 * @param xmlString
	 *            String
	 * @return String
	 */
	public static String replaceXMLCharacters(String xmlString) {
		return xmlString.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
	}

	/**
	 * Removes < y >
	 * 
	 * @param xmlString
	 *            String
	 * @return String
	 */
	public static String unreplaceXMLCharacters(String xmlString) {
		return xmlString.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
	}
}