package com.ejie.y41b.utils.xlnets;

import java.io.*;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import n38a.exe.N38APISesion;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.exception.Y41bUDAException;

public class Y41bUtils {
	private static Y41bUtils INSTANCE = null;

	private static final Logger logger = LoggerFactory
			.getLogger(Y41bUtils.class);

	// Private constructor suppresses
	private Y41bUtils() {
	}

	// creador sincronizado para protegerse de posibles problemas multi-hilo
	// otra prueba para evitar instanciación múltiple
	private synchronized static void createInstance() {
		if (INSTANCE == null) {
			INSTANCE = new Y41bUtils();
		}
	}

	public static Y41bUtils getInstance() {
		if (INSTANCE == null)
			createInstance();
		return INSTANCE;
	}

	/**
	 * Metodo que realiza el login de aplicacion en XLNETs
	 * 
	 * @param isSimulated
	 *            String: Parametro que determina si el login de aplicacion se
	 *            realiza o se simula
	 * 
	 * @return String: Token de aplicación de XLNets
	 */
	public String getTokenAplicacion(boolean isSimulated) {
		String strDocumento = "";
		if (isSimulated) {
			logger.debug("Y41bUtils.getTokenAplicacion - LOCAL");
			// strDocumento =
			// "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><n38><elementos tipo=\"n38APISesionCrearToken\"><elemento subtipo=\"N38Sesion\"><parametro id=\"n38fhum\"><valor>1274172332621</valor></parametro><parametro id=\"cn\"><valor>U94B1266482307127</valor></parametro><parametro id=\"n38uidsesion\"><valor>1266483038919</valor></parametro><parametro id=\"n38login\"><valor>U94B</valor></parametro><parametro id=\"n38perfiles\"><valor>Publico</valor><valor>R02F-PF-0005</valor><valor>R02F-PF-0015</valor><valor>U94B-PF-0003</valor></parametro><parametro id=\"n38organizacion\"><valor>400</valor></parametro><parametro id=\"iphostnumber\"><valor>10.190.20.40</valor></parametro><parametro id=\"n38reintentossesion\"><valor>1</valor></parametro><parametro id=\"n38sexpiracion\"><valor>988999999999</valor></parametro><parametro id=\"n38tiposesion\"><valor>C/S</valor></parametro><parametro id=\"n38puestouid\"><valor>U94B</valor></parametro><parametro id=\"n38fechacreacion\"><valor>1266482307127</valor></parametro><parametro id=\"n38personauid\"><valor>U94B</valor></parametro><parametro id=\"n38fechalogoff\"><valor/></parametro><parametro id=\"n38valorhash\"><valor>PsVYfgAOyNCqCJDeNgqrNOw4PPQ=</valor></parametro><parametro id=\"n38fechainicio\"><valor>1266482307127</valor></parametro><parametro id=\"n38idioma\"><valor>3</valor></parametro><parametro id=\"dni\"><valor>U94B</valor></parametro><parametro id=\"n38comportamientoip\"><valor>ipv</valor></parametro><parametro id=\"n38idcontexto\"><valor>intranet</valor><valor>internet</valor></parametro><parametro id=\"n38loginasociado\"><valor>https://xlnets.servicios.jakina.ejiedes.net:443/n38a/N38LoginInicioServlet</valor></parametro><parametro id=\"n38listacede\"><valor>x_cddes01:48880:1000</valor><valor>x_cddes02:48880:1000</valor></parametro><parametro id=\"n38comportamientofirma\"><valor>False</valor></parametro><parametro id=\"n38exclusivo\"><valor>False</valor></parametro><parametro id=\"n38dominiouid\"><valor>D0_Servidores11</valor></parametro><parametro id=\"n38urlsredireccion\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38NodoEstrellaServlet</valor></parametro><parametro id=\"n38listags\"><valor>x_ssdes01:47770:1000</valor><valor>x_ssdes02:47770:1000</valor></parametro><parametro id=\"n38rangoip\"><valor>10.200.56.11</valor><valor>10.170.9.109</valor><valor>10.170.8.4</valor><valor>10.170.8.5</valor><valor>10.170.9.4</valor><valor>10.170.9.5</valor><valor>10.170.9.137</valor><valor>10.170.9.79</valor><valor>10.200.56.57</valor><valor>10.170.17.114</valor><valor>10.200.8.216</valor><valor>10.200.8.217</valor><valor>10.200.8.218</valor><valor>10.190.8.14</valor><valor>10.170.17.105</valor><valor>192.168.56.231</valor><valor>192.168.56.233</valor><valor>192.168.56.242</valor><valor>192.168.56.241</valor><valor>10.190.20.25</valor><valor>10.190.24.15</valor><valor>192.168.56.234</valor><valor>10.190.8.101</valor><valor>10.190.20.20</valor><valor>192.168.56.21</valor><valor>192.168.56.13</valor><valor>192.168.56.17</valor><valor>192.168.56.11</valor><valor>192.168.56.228</valor><valor>10.170.8.216</valor><valor>192.168.56.58</valor><valor>10.190.20.14</valor><valor>10.170.17.201</valor><valor>555.</valor><valor>10.190.20.43</valor><valor>10.190.20.47</valor><valor>10.190.20.32</valor><valor>10.190.20.40</valor><valor>10.190.20.11</valor><valor>10.190.20.56</valor><valor>10.190.20.38</valor><valor>10.190.8.69</valor><valor>10.190.8.70</valor><valor>10.170.17.200</valor><valor>10.190.20.50</valor><valor>10.190.40.15</valor><valor>10.190.40.16</valor><valor>10.190.40.18</valor><valor>10.190.40.19</valor><valor>10.190.20.69</valor><valor>10.190.20.70</valor><valor>10.170.9.21</valor></parametro><parametro id=\"n38dominioscookies\"><valor>.jakina.ejgvdns</valor></parametro><parametro id=\"n38listamsservidores\"><valor>hola Aitzi</valor></parametro><parametro id=\"n38servidoraudit\"><valor>x_auddes01:4560</valor></parametro><parametro id=\"n38subjectcert\"><valor>NO</valor></parametro><parametro id=\"n38certificadopoliticas\"><valor>NO</valor></parametro><parametro id=\"n38oleserver\"><valor>false</valor></parametro><parametro id=\"n38cadescripciondominio\"><valor>ras internete</valor></parametro><parametro id=\"n38eudescripciondominio\"><valor>rak Interneta</valor></parametro><parametro id=\"n38crearsesionapp\"><valor>true</valor></parametro><parametro id=\"n38urlportal\"><valor>https://xlnets.servicios.jakina.ejiedes.net/n38a/N38servletPortal</valor></parametro><parametro id=\"n38urldispatcher\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38DispatcherEstrellaServlet</valor></parametro><parametro id=\"n38urlsgsd\"><valor>https://xlnets.servicios.jakina.ejiedes.net/n38nCDominioWar/N38GestorCDominioServlet</valor></parametro><parametro id=\"n38dominiocomuncookie\"><valor>.jakina.ejgvdns</valor></parametro><parametro id=\"n38sistemaxlnetsuid\"><valor>desarrollo-produccion</valor></parametro><parametro id=\"n38direccionproxy\"><valor>http://www.servicios.comunes.ejiedes.net/proxy</valor></parametro><parametro id=\"n38direcciongrc\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38rWar/N38rFachadaGRCServlet</valor></parametro><parametro id=\"n38grupoorganicouid\"><valor/></parametro><parametro id=\"n38orgunituid\"><valor/></parametro><parametro id=\"n38urlfinal\"><valor>http://jakina</valor></parametro><parametro id=\"n38uidsesionglobal\"><valor>desarrollo-produccion-1266483038919</valor></parametro><parametro id=\"n38cadenaconfianza\"><valor>desarrollo-produccion</valor></parametro><parametro id=\"n38politicauid\"><valor>P2</valor></parametro></elemento></elementos></n38>";
			strDocumento = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><n38><elementos tipo=\"n38APISesionCrearToken\"><elemento subtipo=\"N38Sesion\"><parametro id=\"cn\"><valor>y41b1392278525821</valor></parametro><parametro id=\"n38uidsesion\"><valor>1392308353192</valor></parametro><parametro id=\"n38login\"><valor>Y41B</valor></parametro><parametro id=\"n38perfiles\"><valor>Publico</valor><valor>AA66-PF-0007</valor><valor>Y41B-PF-0003</valor><valor>Y41B-PF-0002</valor><valor>Y41B-PF-0001</valor><valor>Y59-PF-0006</valor></parametro><parametro id=\"n38organizacion\"><valor>400</valor></parametro><parametro id=\"iphostnumber\"><valor>10.190.20.195</valor></parametro><parametro id=\"n38reintentossesion\"><valor>1</valor></parametro><parametro id=\"n38fhum\"><valor>1392278525821</valor></parametro><parametro id=\"n38sexpiracion\"><valor>988999999999</valor></parametro><parametro id=\"n38tiposesion\"><valor>C/S</valor></parametro><parametro id=\"n38puestouid\"><valor>Y41B</valor></parametro><parametro id=\"n38fechacreacion\"><valor>1392278525821</valor></parametro><parametro id=\"n38personauid\"><valor>Y41B</valor></parametro><parametro id=\"n38fechalogoff\"><valor/></parametro><parametro id=\"n38valorhash\"><valor>vZj6JE2aI1w4RPA7uLslTYgSzXc=</valor></parametro><parametro id=\"n38fechainicio\"><valor>1392278525821</valor></parametro><parametro id=\"n38idioma\"><valor>3</valor></parametro><parametro id=\"dni\"><valor>Y41B</valor></parametro><parametro id=\"n38comportamientoip\"><valor>ipv</valor></parametro><parametro id=\"n38idcontexto\"><valor>intranet</valor><valor>internet</valor></parametro><parametro id=\"n38loginasociado\"><valor>https://xlnets.servicios.jakina.ejiedes.net:443/n38a/N38LoginInicioServlet</valor></parametro><parametro id=\"n38listacede\"><valor>x_cddes01:48880:1000</valor><valor>x_cddes02:48880:1000</valor></parametro><parametro id=\"n38comportamientofirma\"><valor>False</valor></parametro><parametro id=\"n38exclusivo\"><valor>False</valor></parametro><parametro id=\"n38dominiouid\"><valor>D0_Servidores11</valor></parametro><parametro id=\"n38urlsredireccion\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38NodoEstrellaServlet</valor></parametro><parametro id=\"n38listags\"><valor>x_ssdes01:47770:1000</valor><valor>x_ssdes02:47770:1000</valor></parametro><parametro id=\"n38rangoip\"><valor>10.200.56.11</valor><valor>10.170.9.109</valor><valor>10.170.8.4</valor><valor>10.170.8.5</valor><valor>10.170.9.4</valor><valor>10.170.9.5</valor><valor>10.170.9.137</valor><valor>10.170.9.79</valor><valor>10.200.56.57</valor><valor>10.170.17.114</valor><valor>10.200.8.216</valor><valor>10.200.8.217</valor><valor>10.200.8.218</valor><valor>10.190.8.14</valor><valor>10.170.17.105</valor><valor>192.168.56.231</valor><valor>192.168.56.233</valor><valor>192.168.56.242</valor><valor>192.168.56.241</valor><valor>10.190.20.25</valor><valor>10.190.24.15</valor><valor>192.168.56.234</valor><valor>10.190.8.101</valor><valor>10.190.20.20</valor><valor>192.168.56.21</valor><valor>192.168.56.13</valor><valor>192.168.56.17</valor><valor>192.168.56.11</valor><valor>192.168.56.228</valor><valor>10.170.8.216</valor><valor>192.168.56.58</valor><valor>10.190.20.14</valor><valor>10.170.17.201</valor><valor>555.</valor><valor>10.190.20.43</valor><valor>10.190.20.47</valor><valor>10.190.20.32</valor><valor>10.190.20.40</valor><valor>10.190.20.11</valor><valor>10.190.20.56</valor><valor>10.190.20.38</valor><valor>10.190.8.69</valor><valor>10.190.8.70</valor><valor>10.170.17.200</valor><valor>10.190.20.50</valor><valor>10.190.40.15</valor><valor>10.190.40.16</valor><valor>10.190.40.18</valor><valor>10.190.40.19</valor><valor>10.190.20.69</valor><valor>10.190.20.70</valor><valor>10.170.9.21</valor><valor>10.190.20.67</valor><valor>10.170.16.172</valor><valor>10.190.20.100</valor><valor>10.190.20.102</valor><valor>10.190.20.63</valor><valor>10.190.20.64</valor><valor>10.170.17.203</valor><valor>10.170.17.207</valor><valor>10.190.20.101</valor><valor>10.190.28.18</valor><valor>10.190.20.71</valor><valor>10.190.20.138</valor><valor>10.190.20.139</valor><valor>10.190.20.86</valor><valor>10.170.18.235</valor><valor>10.190.16.12</valor><valor>10.170.18.230</valor><valor>10.190.28.28</valor><valor>10.190.20.175</valor><valor>10.190.20.177</valor><valor>10.190.20.179</valor><valor>10.190.20.181</valor><valor>10.190.20.183</valor><valor>10.190.20.185</valor><valor>10.190.20.191</valor><valor>10.190.20.193</valor><valor>10.190.40.46</valor><valor>10.190.40.48</valor><valor>10.190.40.38</valor><valor>10.190.40.40</valor><valor>10.190.20.197</valor><valor>10.190.20.195</valor><valor>10.190.40.42</valor><valor>10.190.40.44</valor><valor>10.190.16.31</valor><valor>10.190.20.189</valor><valor>10.190.20.190</valor><valor>10.190.20.215</valor><valor>10.190.20.217</valor><valor>10.190.20.219</valor><valor>10.190.20.221</valor><valor>10.190.20.199</valor><valor>10.190.20.201</valor><valor>10.190.20.203</valor><valor>10.190.20.205</valor><valor>10.190.28.11</valor><valor>10.190.28.24</valor><valor>10.190.20.227</valor><valor>10.190.20.229</valor><valor>10.190.20.235</valor><valor>10.190.20.233</valor><valor>10.190.20.207</valor><valor>10.190.20.209</valor><valor>10.190.20.223</valor><valor>10.190.20.225</valor><valor>10.190.20.27</valor><valor>10.190.20.45</valor><valor>10.190.20.49</valor><valor>10.190.20.187</valor><valor>10.190.20.237</valor><valor>10.190.20.239</valor><valor>10.190.20.241</valor><valor>10.190.20.243</valor><valor>10.190.20.245</valor><valor>10.190.20.247</valor><valor>10.190.20.249</valor><valor>10.190.20.251</valor><valor>10.190.20.253</valor><valor>10.190.21.1</valor><valor>10.190.21.3</valor><valor>10.190.21.4</valor><valor>10.190.20.26</valor><valor>10.190.20.42</valor><valor>10.190.20.169</valor><valor>1.1.1.1</valor><valor>10.190.28.35</valor><valor>10.190.21.14</valor><valor>10.190.21.16</valor><valor>10.190.21.15</valor><valor>10.190.21.17</valor></parametro><parametro id=\"n38dominioscookies\"><valor>.jakina.ejgvdns</valor></parametro><parametro id=\"n38listamsservidores\"><valor>hola Aitzi</valor></parametro><parametro id=\"n38servidoraudit\"><valor>x_auddes01:4560</valor></parametro><parametro id=\"n38subjectcert\"><valor>NO</valor></parametro><parametro id=\"n38certificadopoliticas\"><valor>NO</valor></parametro><parametro id=\"n38b64thirdpartyassertion\"><valor>NO</valor></parametro><parametro id=\"n38oleserver\"><valor>false</valor></parametro><parametro id=\"n38cadescripciondominio\"><valor>ras internete</valor></parametro><parametro id=\"n38eudescripciondominio\"><valor>rak Interneta</valor></parametro><parametro id=\"n38crearsesionapp\"><valor>true</valor></parametro><parametro id=\"n38urlportal\"><valor>https://xlnets.servicios.jakina.ejiedes.net/n38a/N38servletPortal</valor></parametro><parametro id=\"n38urldispatcher\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38DispatcherEstrellaServlet</valor></parametro><parametro id=\"n38urlsgsd\"><valor>https://xlnets.servicios.jakina.ejiedes.net/n38nCDominioWar/N38GestorCDominioServlet</valor></parametro><parametro id=\"n38dominiocomuncookie\"><valor>.jakina.ejgvdns</valor></parametro><parametro id=\"n38sistemaxlnetsuid\"><valor>desarrollo-produccion</valor></parametro><parametro id=\"n38direccionproxy\"><valor>http://www.servicios.comunes.ejiedes.net/proxy</valor></parametro><parametro id=\"n38direcciongrc\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38rWar/N38rFachadaGRCServlet</valor></parametro><parametro id=\"n38grupoorganicouid\"><valor>400</valor></parametro><parametro id=\"n38orgunituid\"><valor>10500</valor></parametro><parametro id=\"n38urlfinal\"><valor>http://jakina</valor></parametro><parametro id=\"n38uidsesionglobal\"><valor>desarrollo-produccion-1392308353192</valor></parametro><parametro id=\"n38cadenaconfianza\"><valor>desarrollo-produccion</valor></parametro><parametro id=\"n38politicauid\"><valor>P2</valor></parametro></elemento></elementos></n38>";
		} else {
			try {
				logger.debug("Y41bUtils.getTokenAplicacion - EJIE");
				N38APISesion miApiSesion = new N38APISesion();
				Document documento = miApiSesion
						.n38APISesionCrearApp(Y41bConstantes.COD_APLICACION);
				strDocumento = this.fncObtenerStringDoc(documento);
			} catch (TransformerException e_getTokenAplicacion) {
				logger.error("Y41bUtils.getTokenAplicacion",
						e_getTokenAplicacion);
				throw new Y41bUDAException("error.xlnets.getTokenAplicacion",
						true, e_getTokenAplicacion);
			}
		}

		logger.debug("Y41bUtils.getTokenAplicacion - Token:" + strDocumento);
		return strDocumento;
	}

	/**
	 * Devuelve el String a partir de un Document.
	 * 
	 * @param doc
	 *            Document: El xml
	 * 
	 * @return the string
	 * @throws TransformerException
	 * @throws TransformerException
	 *             the exception
	 */
	private String fncObtenerStringDoc(Document doc)
			throws TransformerException {
		StringWriter sw;
		TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer = tFactory.newTransformer();
		DOMSource source = new DOMSource(doc);
		sw = new StringWriter();
		StreamResult result = new StreamResult(sw);
		transformer.transform(source, result);
		return sw.toString();

	}

	/**
	 * Metodo que realiza el login de aplicacion en XLNETs
	 * 
	 * @param isSimulated
	 *            String: Parametro que determina si el login de aplicacion se
	 *            realiza o se simula
	 * 
	 * @return String: Token de aplicación de XLNets
	 * @throws ParserConfigurationException
	 * @throws IOException
	 * @throws Exception
	 */
	public Document getDocumentItemSesion(boolean isSimulated) throws Exception {
		Document docItemSesion = null;
		if (isSimulated) {
			logger.debug("Y41bUtils.getTokenAplicacion - LOCAL");
			DocumentBuilderFactory builder = DocumentBuilderFactory
					.newInstance();
			// String stoken =
			// "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><n38><elementos tipo=\"n38APISesionCrearToken\"><elemento subtipo=\"N38Sesion\"><parametro id=\"cn\"><valor>y41b1392278525821</valor></parametro><parametro id=\"n38uidsesion\"><valor>1392308353192</valor></parametro><parametro id=\"n38login\"><valor>Y41B</valor></parametro><parametro id=\"n38perfiles\"><valor>Publico</valor><valor>Y41B-PF-0003</valor><valor>Y41B-PF-0002</valor><valor>Y41B-PF-0001</valor></parametro><parametro id=\"n38organizacion\"><valor>400</valor></parametro><parametro id=\"iphostnumber\"><valor>10.190.20.195</valor></parametro><parametro id=\"n38reintentossesion\"><valor>1</valor></parametro><parametro id=\"n38fhum\"><valor>1392278525821</valor></parametro><parametro id=\"n38sexpiracion\"><valor>988999999999</valor></parametro><parametro id=\"n38tiposesion\"><valor>C/S</valor></parametro><parametro id=\"n38puestouid\"><valor>Y41B</valor></parametro><parametro id=\"n38fechacreacion\"><valor>1392278525821</valor></parametro><parametro id=\"n38personauid\"><valor>Y41B</valor></parametro><parametro id=\"n38fechalogoff\"><valor/></parametro><parametro id=\"n38valorhash\"><valor>vZj6JE2aI1w4RPA7uLslTYgSzXc=</valor></parametro><parametro id=\"n38fechainicio\"><valor>1392278525821</valor></parametro><parametro id=\"n38idioma\"><valor>3</valor></parametro><parametro id=\"dni\"><valor>Y41B</valor></parametro><parametro id=\"n38comportamientoip\"><valor>ipv</valor></parametro><parametro id=\"n38idcontexto\"><valor>intranet</valor><valor>internet</valor></parametro><parametro id=\"n38loginasociado\"><valor>https://xlnets.servicios.jakina.ejiedes.net:443/n38a/N38LoginInicioServlet</valor></parametro><parametro id=\"n38listacede\"><valor>x_cddes01:48880:1000</valor><valor>x_cddes02:48880:1000</valor></parametro><parametro id=\"n38comportamientofirma\"><valor>False</valor></parametro><parametro id=\"n38exclusivo\"><valor>False</valor></parametro><parametro id=\"n38dominiouid\"><valor>D0_Servidores11</valor></parametro><parametro id=\"n38urlsredireccion\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38NodoEstrellaServlet</valor></parametro><parametro id=\"n38listags\"><valor>x_ssdes01:47770:1000</valor><valor>x_ssdes02:47770:1000</valor></parametro><parametro id=\"n38rangoip\"><valor>10.200.56.11</valor><valor>10.170.9.109</valor><valor>10.170.8.4</valor><valor>10.170.8.5</valor><valor>10.170.9.4</valor><valor>10.170.9.5</valor><valor>10.170.9.137</valor><valor>10.170.9.79</valor><valor>10.200.56.57</valor><valor>10.170.17.114</valor><valor>10.200.8.216</valor><valor>10.200.8.217</valor><valor>10.200.8.218</valor><valor>10.190.8.14</valor><valor>10.170.17.105</valor><valor>192.168.56.231</valor><valor>192.168.56.233</valor><valor>192.168.56.242</valor><valor>192.168.56.241</valor><valor>10.190.20.25</valor><valor>10.190.24.15</valor><valor>192.168.56.234</valor><valor>10.190.8.101</valor><valor>10.190.20.20</valor><valor>192.168.56.21</valor><valor>192.168.56.13</valor><valor>192.168.56.17</valor><valor>192.168.56.11</valor><valor>192.168.56.228</valor><valor>10.170.8.216</valor><valor>192.168.56.58</valor><valor>10.190.20.14</valor><valor>10.170.17.201</valor><valor>555.</valor><valor>10.190.20.43</valor><valor>10.190.20.47</valor><valor>10.190.20.32</valor><valor>10.190.20.40</valor><valor>10.190.20.11</valor><valor>10.190.20.56</valor><valor>10.190.20.38</valor><valor>10.190.8.69</valor><valor>10.190.8.70</valor><valor>10.170.17.200</valor><valor>10.190.20.50</valor><valor>10.190.40.15</valor><valor>10.190.40.16</valor><valor>10.190.40.18</valor><valor>10.190.40.19</valor><valor>10.190.20.69</valor><valor>10.190.20.70</valor><valor>10.170.9.21</valor><valor>10.190.20.67</valor><valor>10.170.16.172</valor><valor>10.190.20.100</valor><valor>10.190.20.102</valor><valor>10.190.20.63</valor><valor>10.190.20.64</valor><valor>10.170.17.203</valor><valor>10.170.17.207</valor><valor>10.190.20.101</valor><valor>10.190.28.18</valor><valor>10.190.20.71</valor><valor>10.190.20.138</valor><valor>10.190.20.139</valor><valor>10.190.20.86</valor><valor>10.170.18.235</valor><valor>10.190.16.12</valor><valor>10.170.18.230</valor><valor>10.190.28.28</valor><valor>10.190.20.175</valor><valor>10.190.20.177</valor><valor>10.190.20.179</valor><valor>10.190.20.181</valor><valor>10.190.20.183</valor><valor>10.190.20.185</valor><valor>10.190.20.191</valor><valor>10.190.20.193</valor><valor>10.190.40.46</valor><valor>10.190.40.48</valor><valor>10.190.40.38</valor><valor>10.190.40.40</valor><valor>10.190.20.197</valor><valor>10.190.20.195</valor><valor>10.190.40.42</valor><valor>10.190.40.44</valor><valor>10.190.16.31</valor><valor>10.190.20.189</valor><valor>10.190.20.190</valor><valor>10.190.20.215</valor><valor>10.190.20.217</valor><valor>10.190.20.219</valor><valor>10.190.20.221</valor><valor>10.190.20.199</valor><valor>10.190.20.201</valor><valor>10.190.20.203</valor><valor>10.190.20.205</valor><valor>10.190.28.11</valor><valor>10.190.28.24</valor><valor>10.190.20.227</valor><valor>10.190.20.229</valor><valor>10.190.20.235</valor><valor>10.190.20.233</valor><valor>10.190.20.207</valor><valor>10.190.20.209</valor><valor>10.190.20.223</valor><valor>10.190.20.225</valor><valor>10.190.20.27</valor><valor>10.190.20.45</valor><valor>10.190.20.49</valor><valor>10.190.20.187</valor><valor>10.190.20.237</valor><valor>10.190.20.239</valor><valor>10.190.20.241</valor><valor>10.190.20.243</valor><valor>10.190.20.245</valor><valor>10.190.20.247</valor><valor>10.190.20.249</valor><valor>10.190.20.251</valor><valor>10.190.20.253</valor><valor>10.190.21.1</valor><valor>10.190.21.3</valor><valor>10.190.21.4</valor><valor>10.190.20.26</valor><valor>10.190.20.42</valor><valor>10.190.20.169</valor><valor>1.1.1.1</valor><valor>10.190.28.35</valor><valor>10.190.21.14</valor><valor>10.190.21.16</valor><valor>10.190.21.15</valor><valor>10.190.21.17</valor></parametro><parametro id=\"n38dominioscookies\"><valor>.jakina.ejgvdns</valor></parametro><parametro id=\"n38listamsservidores\"><valor>hola Aitzi</valor></parametro><parametro id=\"n38servidoraudit\"><valor>x_auddes01:4560</valor></parametro><parametro id=\"n38subjectcert\"><valor>NO</valor></parametro><parametro id=\"n38certificadopoliticas\"><valor>NO</valor></parametro><parametro id=\"n38b64thirdpartyassertion\"><valor>NO</valor></parametro><parametro id=\"n38oleserver\"><valor>false</valor></parametro><parametro id=\"n38cadescripciondominio\"><valor>ras internete</valor></parametro><parametro id=\"n38eudescripciondominio\"><valor>rak Interneta</valor></parametro><parametro id=\"n38crearsesionapp\"><valor>true</valor></parametro><parametro id=\"n38urlportal\"><valor>https://xlnets.servicios.jakina.ejiedes.net/n38a/N38servletPortal</valor></parametro><parametro id=\"n38urldispatcher\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38DispatcherEstrellaServlet</valor></parametro><parametro id=\"n38urlsgsd\"><valor>https://xlnets.servicios.jakina.ejiedes.net/n38nCDominioWar/N38GestorCDominioServlet</valor></parametro><parametro id=\"n38dominiocomuncookie\"><valor>.jakina.ejgvdns</valor></parametro><parametro id=\"n38sistemaxlnetsuid\"><valor>desarrollo-produccion</valor></parametro><parametro id=\"n38direccionproxy\"><valor>http://www.servicios.comunes.ejiedes.net/proxy</valor></parametro><parametro id=\"n38direcciongrc\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38rWar/N38rFachadaGRCServlet</valor></parametro><parametro id=\"n38grupoorganicouid\"><valor>400</valor></parametro><parametro id=\"n38orgunituid\"><valor>10500</valor></parametro><parametro id=\"n38urlfinal\"><valor>http://jakina</valor></parametro><parametro id=\"n38uidsesionglobal\"><valor>desarrollo-produccion-1392308353192</valor></parametro><parametro id=\"n38cadenaconfianza\"><valor>desarrollo-produccion</valor></parametro><parametro id=\"n38politicauid\"><valor>P2</valor></parametro></elemento></elementos></n38>";
			String stoken = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><n38><elementos tipo=\"n38APISesionCrearToken\"><elemento subtipo=\"N38Sesion\"><parametro id=\"n38tiposesion\"><valor>C/S</valor></parametro><parametro id=\"n38fechalogoff\"><valor>1529997749046</valor></parametro><parametro id=\"n38dominiocomuncookie\"><valor>.jakina.ejgvdns</valor></parametro><parametro id=\"n38perfiles\"><valor>Publico</valor><valor>Y41E-PF-0002</valor><valor>Y41E-PF-0001</valor><valor>AA66-PF-0007</valor><valor>Y59-PF-0006</valor><valor>Y41B-PF-0003</valor><valor>Y41B-PF-0002</valor><valor>Y41B-PF-0001</valor><valor>X43F-PF-0051</valor></parametro><parametro id=\"n38exclusivo\"><valor>False</valor></parametro><parametro id=\"n38urlfinal\"><valor>http://jakina</valor></parametro><parametro id=\"n38oleserver\"><valor>false</valor></parametro><parametro id=\"n38cadescripciondominio\"><valor>ras internete</valor></parametro><parametro id=\"n38reintentossesion\"><valor>1</valor></parametro><parametro id=\"n38eudescripciondominio\"><valor>rak Interneta</valor></parametro><parametro id=\"n38servidoraudit\"><valor>x_auddes01:4560</valor></parametro><parametro id=\"n38urldispatcher\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38DispatcherEstrellaServlet</valor></parametro><parametro id=\"n38comportamientoip\"><valor>ipv</valor></parametro><parametro id=\"n38personauid\"><valor>Y41B</valor></parametro><parametro id=\"n38login\"><valor>Y41B</valor></parametro><parametro id=\"n38urlsgsd\"><valor>https://xlnets.servicios.jakina.ejiedes.net/n38nCDominioWar/N38GestorCDominioServlet</valor></parametro><parametro id=\"n38puestouid\"><valor>Y41B</valor></parametro><parametro id=\"n38politicauid\"><valor>P2</valor></parametro><parametro id=\"n38fechacreacion\"><valor>1392278525821</valor></parametro><parametro id=\"n38direccionproxy\"><valor>http://www.servicios.comunes.ejiedes.net/proxy</valor></parametro><parametro id=\"n38listamsservidores\"><valor>hola Aitzi</valor></parametro><parametro id=\"n38crearsesionapp\"><valor>true</valor></parametro><parametro id=\"n38urlsredireccion\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38NodoEstrellaServlet</valor></parametro><parametro id=\"n38certificadopoliticas\"><valor>NO</valor></parametro><parametro id=\"n38subjectcert\"><valor>NO</valor></parametro><parametro id=\"n38direcciongrc\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38rWar/N38rFachadaGRCServlet</valor></parametro><parametro id=\"n38dominioscookies\"><valor>.jakina.ejgvdns</valor></parametro><parametro id=\"dni\"><valor>Y41B</valor></parametro><parametro id=\"iphostnumber\"><valor>10.190.21.14</valor></parametro><parametro id=\"n38loginasociado\"><valor>https://xlnets.servicios.jakina.ejiedes.net:443/n38a/N38LoginInicioServlet</valor></parametro><parametro id=\"n38grupoorganicouid\"><valor>400</valor></parametro><parametro id=\"n38listacede\"><valor>x_v4_cd_des_11:48880:1000</valor><valor>x_v4_cd_des_21:48880:1000</valor><valor>x_v4_cd_des_12:48881:1000</valor><valor>x_v4_cd_des_22:48881:1000</valor></parametro><parametro id=\"n38fechainicio\"><valor>1537344010782</valor></parametro><parametro id=\"n38rangoip\"><valor>10.200.56.11</valor><valor>10.170.9.109</valor><valor>10.170.8.4</valor><valor>10.170.8.5</valor><valor>10.170.9.4</valor><valor>10.170.9.5</valor><valor>10.170.9.137</valor><valor>10.170.9.79</valor><valor>10.200.56.57</valor><valor>10.170.17.114</valor><valor>10.200.8.216</valor><valor>10.200.8.217</valor><valor>10.200.8.218</valor><valor>10.190.8.14</valor><valor>10.170.17.105</valor><valor>192.168.56.231</valor><valor>192.168.56.233</valor><valor>192.168.56.242</valor><valor>192.168.56.241</valor><valor>10.190.20.25</valor><valor>10.190.24.15</valor><valor>192.168.56.234</valor><valor>10.190.8.101</valor><valor>10.190.20.20</valor><valor>192.168.56.21</valor><valor>192.168.56.13</valor><valor>192.168.56.17</valor><valor>192.168.56.11</valor><valor>192.168.56.228</valor><valor>10.170.8.216</valor><valor>192.168.56.58</valor><valor>10.190.20.14</valor><valor>10.170.17.201</valor><valor>555.</valor><valor>10.190.20.43</valor><valor>10.190.20.47</valor><valor>10.190.20.32</valor><valor>10.190.20.40</valor><valor>10.190.20.11</valor><valor>10.190.20.56</valor><valor>10.190.20.38</valor><valor>10.190.8.69</valor><valor>10.190.8.70</valor><valor>10.170.17.200</valor><valor>10.190.20.50</valor><valor>10.190.40.15</valor><valor>10.190.40.16</valor><valor>10.190.40.18</valor><valor>10.190.40.19</valor><valor>10.190.20.69</valor><valor>10.190.20.70</valor><valor>10.170.9.21</valor><valor>10.190.20.67</valor><valor>10.170.16.172</valor><valor>10.190.20.100</valor><valor>10.190.20.102</valor><valor>10.190.20.63</valor><valor>10.190.20.64</valor><valor>10.170.17.203</valor><valor>10.170.17.207</valor><valor>10.190.20.101</valor><valor>10.190.28.18</valor><valor>10.190.20.71</valor><valor>10.190.20.138</valor><valor>10.190.20.139</valor><valor>10.190.20.86</valor><valor>10.170.18.235</valor><valor>10.190.16.12</valor><valor>10.170.18.230</valor><valor>10.190.28.28</valor><valor>10.190.20.175</valor><valor>10.190.20.177</valor><valor>10.190.20.179</valor><valor>10.190.20.181</valor><valor>10.190.20.183</valor><valor>10.190.20.185</valor><valor>10.190.20.191</valor><valor>10.190.20.193</valor><valor>10.190.40.46</valor><valor>10.190.40.48</valor><valor>10.190.40.38</valor><valor>10.190.40.40</valor><valor>10.190.20.197</valor><valor>10.190.20.195</valor><valor>10.190.40.42</valor><valor>10.190.40.44</valor><valor>10.190.16.31</valor><valor>10.190.20.189</valor><valor>10.190.20.190</valor><valor>10.190.20.215</valor><valor>10.190.20.217</valor><valor>10.190.20.219</valor><valor>10.190.20.221</valor><valor>10.190.20.199</valor><valor>10.190.20.201</valor><valor>10.190.20.203</valor><valor>10.190.20.205</valor><valor>10.190.28.11</valor><valor>10.190.28.24</valor><valor>10.190.21.111</valor><valor>10.190.28.101</valor><valor>10.190.21.24</valor><valor>10.190.21.26</valor><valor>10.190.21.20</valor><valor>10.190.21.22</valor><valor>10.190.21.113</valor><valor>10.190.40.66</valor><valor>10.190.21.17</valor><valor>10.190.20.49</valor><valor>10.190.21.16</valor><valor>10.190.21.18</valor><valor>10.190.20.60</valor><valor>10.190.21.36</valor><valor>10.168.212.21</valor><valor>10.1.1.</valor><valor>10.190.21.27</valor><valor>10.190.20.209</valor><valor>10.190.20.207</valor><valor>10.190.20.169</valor><valor>10.190.21.82</valor><valor>10.190.21.81</valor><valor>10.190.21.83</valor><valor>10.190.21.80</valor><valor>10.190.21.89</valor><valor>10.190.21.85</valor><valor>10.190.28.35</valor><valor>10.190.21.87</valor><valor>10.190.20.253</valor><valor>10.190.20.26</valor><valor>10.190.20.27</valor><valor>10.190.20.251</valor><valor>10.190.16.55</valor><valor>1.1.1.1</valor><valor>10.190.21.93</valor><valor>10.190.21.95</valor><valor>10.190.28.111</valor><valor>10.190.21.91</valor><valor>10.190.28.113</valor><valor>10.190.20.45</valor><valor>10.190.21.15</valor><valor>10.190.21.14</valor><valor>10.190.21.97</valor><valor>10.190.21.105</valor><valor>10.190.20.42</valor><valor>10.190.21.103</valor><valor>10.168.214.65</valor><valor>10.168.214.66</valor><valor>10.190.28.103</valor><valor>10.190.21.61</valor><valor>10.190.21.67</valor><valor>10.190.21.63</valor><valor>10.190.21.65</valor><valor>10.190.20.233</valor><valor>10.190.28.136</valor><valor>10.190.16.136</valor><valor>10.190.16.135</valor><valor>10.190.20.239</valor><valor>10.190.20.238</valor><valor>10.190.20.237</valor><valor>10.190.20.235</valor><valor>10.190.21.70</valor><valor>10.190.21.72</valor><valor>10.190.28.134</valor><valor>10.190.28.22</valor><valor>10.190.21.74</valor><valor>10.190.8.164</valor><valor>10.190.21.76</valor><valor>10.190.28.25</valor><valor>10.190.20.245</valor><valor>10.190.20.244</valor><valor>10.190.20.243</valor><valor>10.190.20.242</valor><valor>10.190.20.241</valor><valor>10.190.20.240</valor><valor>10.190.20.249</valor><valor>10.190.20.247</valor><valor>10.190.20.246</valor><valor>10.190.21.40</valor><valor>10.190.21.47</valor><valor>10.190.21.42</valor><valor>10.190.20.211</valor><valor>10.190.21.8</valor><valor>10.190.21.38</valor><valor>10.190.21.3</valor><valor>10.190.21.4</valor><valor>10.190.21.1</valor><valor>10.190.20.213</valor><valor>10.190.8.102</valor><valor>10.190.21.57</valor><valor>10.190.21.59</valor><valor>10.190.20.180</valor><valor>10.190.21.53</valor><valor>10.190.21.55</valor><valor>10.190.20.223</valor><valor>10.190.40.68</valor><valor>10.190.20.187</valor><valor>10.190.20.229</valor><valor>10.190.20.227</valor><valor>10.190.20.225</valor><valor>10.190.21.144</valor><valor>10.190.21.145</valor><valor>10.190.21.146</valor><valor>10.190.21.147</valor><valor>10.190.28.226</valor><valor>172.26.128.123</valor><valor>10.190.28.194</valor><valor>10.190.21.121</valor><valor>10.190.21.122</valor><valor>10.190.21.123</valor><valor>10.190.21.124</valor><valor>10.190.21.148</valor><valor>10.190.28.200</valor><valor>10.190.28.182</valor><valor>10.190.28.44</valor><valor>10.190.28.218</valor><valor>10.190.28.36</valor><valor>10.190.28.223</valor><valor>10.190.28.219</valor><valor>10.190.28.224</valor><valor>10.190.28.225</valor><valor>10.190.28.227</valor><valor>10.190.28.221</valor><valor>10.190.28.180</valor><valor>10.190.28.183</valor><valor>10.190.28.195</valor><valor>10.190.28.230</valor><valor>10.190.28.202</valor><valor>10.190.28.204</valor><valor>10.190.28.184</valor><valor>10.190.28.186</valor><valor>10.168.214.68</valor><valor>10.190.28.181</valor><valor>10.190.28.246</valor><valor>10.190.28.245</valor><valor>10.190.28.247</valor><valor>10.190.28.220</valor><valor>10.190.28.228</valor><valor>10.190.28.249</valor><valor>10.190.28.88</valor><valor>10.190.28.85</valor><valor>10.190.8.169</valor><valor>10.168.212.25</valor><valor>10.190.21.137</valor><valor>10.190.21.154</valor><valor>10.190.21.156</valor><valor>10.190.21.160</valor><valor>10.190.21.161</valor><valor>10.190.21.162</valor><valor>10.190.21.163</valor><valor>10.190.21.164</valor><valor>10.190.21.165</valor><valor>10.190.21.158</valor><valor>10.128.</valor><valor>10.129.</valor><valor>10.130.</valor><valor>10.131.</valor><valor>10.190.21.176</valor><valor>10.190.21.177</valor><valor>10.190.28.179</valor><valor>10.190.28.191</valor><valor>10.190.20.8</valor><valor>10.200.227.6</valor></parametro><parametro id=\"n38idioma\"><valor>3</valor></parametro><parametro id=\"n38orgunituid\"><valor>10500</valor></parametro><parametro id=\"n38idcontexto\"><valor>intranet</valor><valor>internet</valor><valor>BUS-Internet</valor><valor>Authentication-Asserter=XLNetS</valor><valor>Authentication-Method=Usuario-Password</valor></parametro><parametro id=\"n38sistemaxlnetsuid\"><valor>desarrollo-produccion</valor></parametro><parametro id=\"n38organizacion\"><valor>400</valor></parametro><parametro id=\"n38comportamientofirma\"><valor>False</valor></parametro><parametro id=\"n38dominiouid\"><valor>D0_Servidores11</valor></parametro><parametro id=\"n38uidsesionglobal\"><valor>desarrollo-produccion-1392308353192</valor></parametro><parametro id=\"n38b64thirdpartyassertion\"><valor>NO</valor></parametro><parametro id=\"n38valorhash\"><valor>vZj6JE2aI1w4RPA7uLslTYgSzXc=</valor></parametro><parametro id=\"n38urlportal\"><valor>https://xlnets.servicios.jakina.ejiedes.net/n38a/N38servletPortal</valor></parametro><parametro id=\"n38cadenaconfianza\"><valor>desarrollo-produccion</valor></parametro><parametro id=\"n38fhum\"><valor>1537356248681</valor></parametro><parametro id=\"cn\"><valor>y41b1392278525821</valor></parametro><parametro id=\"objectClass\"><valor>top</valor><valor>n38Sesion</valor></parametro><parametro id=\"n38listags\"><valor>x_v4_ss_des_11:47770:1000</valor><valor>x_v4_ss_des_21:47770:1000</valor><valor>x_v4_ss_des_12:47771:1000</valor><valor>x_v4_ss_des_22:47771:1000</valor></parametro><parametro id=\"n38sexpiracion\"><valor>43200000</valor></parametro><parametro id=\"n38uidsesion\"><valor>1392308353192</valor></parametro></elemento></elementos></n38>";
			docItemSesion = builder.newDocumentBuilder().parse(
					new InputSource(new StringReader(stoken)));
		} else {
			logger.debug("Y41bUtils.getTokenAplicacion - EJIE");
			N38APISesion miApiSesion = new N38APISesion();
			docItemSesion = miApiSesion
					.n38APISesionCrearApp(Y41bConstantes.COD_APLICACION);
		}
		return docItemSesion;
	}
}
