package com.ejie.y41b.utils.ws.arbitraje;

import java.io.StringWriter;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import n38c.exe.N38API;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.xml.Y41bXMLUtils;

/**
 * Y41bArbitrajeServiceHandler
 * 
 *  
 * 
 */
public class Y41bArbitrajeServiceHandler implements
		SOAPHandler<SOAPMessageContext> {

	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(Y41bArbitrajeServiceHandler.class);

	private String tokenU86XQuery = "//n38";
	private XPathExpression expression;
	private TransformerFactory transformerFactory;

	/**
	 * Constructor por defecto.
	 * 
	 * @throws XPathExpressionException
	 *             XPathExpressionException
	 */
	public Y41bArbitrajeServiceHandler() throws XPathExpressionException {
		// inicializacion de la expresion XPATH
		XPathFactory xpFactory = XPathFactory.newInstance();
		XPath xpath = xpFactory.newXPath();
		this.expression = xpath.compile(this.tokenU86XQuery);
		this.transformerFactory = TransformerFactory.newInstance();
	}

	/**
	 * getHeaders
	 * 
	 * @return HashSet<QName>
	 * 
	 * @see javax.xml.ws.handler.soap.SOAPHandler#getHeaders()
	 */
	public Set<QName> getHeaders() {
		return new HashSet<QName>();
	}

	/**
	 * close
	 * 
	 * @param context
	 *            MessageContext
	 * 
	 * @see javax.xml.ws.handler.Handler#close(javax.xml.ws.handler.MessageContext)
	 */
	public void close(MessageContext context) {
		// Nada que hacer
	}

	/**
	 * handleFault
	 * 
	 * @param context
	 *            SOAPMessageContext
	 * @return boolean
	 * @see javax.xml.ws.handler.Handler#handleFault(javax.xml.ws.handler.MessageContext)
	 */
	public boolean handleFault(SOAPMessageContext context) {
		return true;
	}

	/**
	 * handleMessage
	 * 
	 * @param context
	 *            SOAPMessageContext
	 * @return boolean
	 * @see javax.xml.ws.handler.Handler#handleMessage(javax.xml.ws.handler.MessageContext)
	 */
	public boolean handleMessage(SOAPMessageContext context) {
		Y41bArbitrajeServiceHandler.logger
				.info("Y41bArbitrajeServiceHandler - handleMessage");
		boolean valid = true;

		Boolean outbound = (Boolean) context
				.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);
		Y41bArbitrajeServiceHandler.logger
				.info("Y41bArbitrajeServiceHandler - handleMessage:" + outbound);
		// solo para los mensajes entrantes
		if (outbound != null && !outbound.booleanValue()) {
			valid = false;
			try {
				Properties prop = Y41bConfig
						.loadProperties(Y41bConstantes.CONFIG_PATH);

				String local = (String) prop
						.getProperty("y41bVistaWar.entorno.local");

				if ("true".equals(local)) {
					return true;
				}

				String tokenN38 = this.doExtractToken(context.getMessage()
						.getSOAPHeader());
				Y41bArbitrajeServiceHandler.logger
						.info("Y41bArbitrajeServiceHandler - token38:"
								+ tokenN38);
				if (tokenN38 != null && !tokenN38.equals("")) {
					// verificar que la sesion es valida con el API java de
					// XLNets y que tiene autorizacion
					Y41bArbitrajeServiceHandler.logger
							.info("Y41bArbitrajeServiceHandler - handleRequest - Cogiendo nodos Paso 1");
					Document tokenDocument = Y41bXMLUtils
							.getDocumentFromString(tokenN38);
					Y41bArbitrajeServiceHandler.logger
							.info("Y41bArbitrajeServiceHandler - handleRequest - Cogiendo nodos Paso 1.1");
					N38API n38 = new N38API(tokenDocument);
					Y41bArbitrajeServiceHandler.logger
							.info("Y41bArbitrajeServiceHandler - handleRequest - Cogiendo nodos Paso 1.2");

					Document n38ItemSesion = n38.n38ItemSesion();

					Y41bArbitrajeServiceHandler.logger
							.info("Y41bArbitrajeServiceHandler - handleRequest - Cogiendo nodos Paso 1.3");

					Node nodeNologedIn = Y41bXMLUtils.retrieveNodeXPath(
							n38ItemSesion, "/n38/warning[@codigo='W009']");

					Y41bArbitrajeServiceHandler.logger
							.info("Y41bArbitrajeServiceHandler - handleRequest - Cogiendo nodos Paso 2");

					Node nodeNoAuth = Y41bXMLUtils.retrieveNodeXPath(
							n38ItemSesion, "/n38/warning[@codigo='W111']");

					Y41bArbitrajeServiceHandler.logger
							.info("Y41bArbitrajeServiceHandler - handleRequest - Cogiendo nodos Paso 3");

					Node node = Y41bXMLUtils
							.retrieveNodeXPath(n38ItemSesion,
									"/n38/elementos/elemento/parametro[@id='n38login']");

					Y41bArbitrajeServiceHandler.logger
							.info("Y41bArbitrajeServiceHandler - handleRequest - nodeNologedIn:"
									+ nodeNologedIn);
					Y41bArbitrajeServiceHandler.logger
							.info("Y41bArbitrajeServiceHandler - handleRequest - nodeNoAuth:"
									+ nodeNoAuth);
					Y41bArbitrajeServiceHandler.logger
							.info("Y41bArbitrajeServiceHandler - handleRequest - nodeAuth:"
									+ node);

					if (nodeNologedIn != null) {
						Y41bArbitrajeServiceHandler.logger
								.info("Y41bArbitrajeServiceHandler - handleRequest - El usuario logeado no tiene acceso al servicio web");
						this.generateSOAPErrMessage(context,
								"Usuario no logado NO ACCESO a servicio web");
						return false;
					} else if (nodeNoAuth != null) {
						Y41bArbitrajeServiceHandler.logger
								.info("Y41bArbitrajeServiceHandler - handleRequest - El usuario no tiene autorizacin");
						this.generateSOAPErrMessage(context,
								"Usuario SIN AUTORIZACION");
						return false;
					} else if (node != null) {
						Y41bArbitrajeServiceHandler.logger
								.info("Y41bArbitrajeServiceHandler - handleRequest - El usuario SI tiene autorizacion");
					} else {
						Y41bArbitrajeServiceHandler.logger
								.info("Y41bArbitrajeServiceHandler - handleRequest - El usuario NO tiene la funcin de autorizacion correcta");
						this.generateSOAPErrMessage(context,
								"Usuario SIN ACCESO AL WS");
						return false;
					}
					Y41bArbitrajeServiceHandler.logger
							.info("Y41bArbitrajeServiceHandler - handleRequest - FINAL");
					valid = true;
				}
			} catch (Exception e) {
				Y41bArbitrajeServiceHandler.logger
						.error("Y41bArbitrajeServiceHandler - handleMessage - Excepcion:"
								+ e.getMessage());
			}
		}
		return valid;
	}

	/**
	 * generateSOAPErrMessage
	 * 
	 * @param context
	 *            SOAPMessageContext
	 * @param reason
	 *            String
	 */
	private void generateSOAPErrMessage(SOAPMessageContext context,
			String reason) {
		Y41bArbitrajeServiceHandler.logger
				.info("Y41bArbitrajeServiceHandler - generateSOAPErrMessage - Inicio");
		try {
			SOAPMessage msg = context.getMessage();

			SOAPBody soapBody = msg.getSOAPPart().getEnvelope().getBody();

			soapBody.removeContents();

			SOAPFault soapFault = soapBody.addFault();
			soapFault.setFaultString(reason);
			soapFault.setFaultCode("01");

			SOAPFactory soapFactory = SOAPFactory.newInstance();

			Detail detail = soapFault.addDetail();

			Name a61tExceptionTokenName = soapFactory
					.createName("Y41bException");
			SOAPElement a61tExceptionTokenMsgElem = soapFactory
					.createElement(a61tExceptionTokenName);

			Name codigoName = soapFactory.createName("codigo");
			SOAPElement codigoMsgElem = soapFactory.createElement(codigoName);
			codigoMsgElem.addTextNode("01");
			a61tExceptionTokenMsgElem.addChildElement(codigoMsgElem);

			Name mensajeName = soapFactory.createName("mensaje");
			SOAPElement mensajeMsgElem = soapFactory.createElement(mensajeName);
			mensajeMsgElem.addTextNode(reason);
			a61tExceptionTokenMsgElem.addChildElement(mensajeMsgElem);

			detail.addChildElement(a61tExceptionTokenMsgElem);

			context.getMessage().getSOAPHeader().removeContents();

		} catch (SOAPException e) {
			Y41bArbitrajeServiceHandler.logger
					.error("Y41bArbitrajeServiceHandler - generateSOAPErrMessage - Excepcion:"
							+ e.getMessage());
		}
	}

	/**
	 * Extrae el xml correspondiente a la sesin de aplicacin.
	 * 
	 * @param node
	 *            Node
	 * @return String
	 * @throws XPathExpressionException
	 *             excepcion
	 * @throws TransformerException
	 *             excepcion
	 */
	private String doExtractToken(Node node) throws XPathExpressionException,
			TransformerException {
		Y41bArbitrajeServiceHandler.logger
				.info("Y41bArbitrajeServiceHandler - doExtractToken - Inicio");
		String tokenN38 = "";

		try {
			// busqueda XPath del nodo n38
			Y41bArbitrajeServiceHandler.logger
					.info("Y41bArbitrajeServiceHandler - doExtractToken - Paso 1 - node:"
							+ node);
			Node tokenN38Node = (Node) this.expression.evaluate(node,
					XPathConstants.NODE);
			Y41bArbitrajeServiceHandler.logger
					.info("Y41bArbitrajeServiceHandler - doExtractToken - Paso 2 - tokenN38Node:"
							+ tokenN38Node);
			if (tokenN38Node != null) {
				Y41bArbitrajeServiceHandler.logger
						.info("Y41bArbitrajeServiceHandler - doExtractToken - Paso 3");
				// convertimos a String el nodo del token
				Source tokenN38NodeSource = new DOMSource(tokenN38Node);
				Y41bArbitrajeServiceHandler.logger
						.info("Y41bArbitrajeServiceHandler - doExtractToken - Paso 4");
				StringWriter writer = new StringWriter();
				Y41bArbitrajeServiceHandler.logger
						.info("Y41bArbitrajeServiceHandler - doExtractToken - Paso 5");
				Result result = new StreamResult(writer);
				Y41bArbitrajeServiceHandler.logger
						.info("Y41bArbitrajeServiceHandler - doExtractToken - Paso 6");
				this.transformerFactory.newTransformer().transform(
						tokenN38NodeSource, result);
				Y41bArbitrajeServiceHandler.logger
						.info("Y41bArbitrajeServiceHandler - doExtractToken - Paso 7");
				tokenN38 = writer.toString();
				Y41bArbitrajeServiceHandler.logger
						.info("Y41bArbitrajeServiceHandler - doExtractToken - Paso 8 - tokenN38:"
								+ tokenN38);
			}
		} catch (Exception e) {
			Y41bArbitrajeServiceHandler.logger
					.error("Y41bArbitrajeServiceHandler - doExtractToken - Excepcion:"
							+ e.getMessage());
		}

		return tokenN38;
	}

}
