package com.ejie.y41b.utils.tree;

import java.util.Iterator;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Y41bArbolTiposInfraccion;
import com.ejie.y41b.model.Y41bTipoInfraccionTree;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * 
 *  
 * 
 */
public class Y41bTiposInfraccionTree {

	/**
     * 
     */
	private String _activeNode = "";

	/**
	 * Nodo Activo
	 * 
	 * @param key
	 *            String
	 */
	public void setActiveNode(String key) {
		this._activeNode = key;
	}

	/**
	 * Nodo Activo
	 * 
	 * @return String
	 */
	public String getActiveNode() {
		return this._activeNode;
	}

	/**
	 * Preseleccionar un nodo
	 * 
	 * @param key
	 *            String
	 * @return String
	 */
	private String printNodeKey(String key) {
		if (this._activeNode.equals(key)) {
			return "\"activate\": true, \"focus\": true, \"expand\": true, \"select\": false, \"key\": \""
					+ key + "\"";

			// activate: false, // Initial active status.
			// focus: false, // Initial focused status.
			// expand: false, // Initial expanded status.
			// select: false,

		} else {
			if (this._activeNode.startsWith(key)) {
				// return "\"activate\": false, \"key\": \"" + key + "\"";
				return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": false, \"key\": \""
						+ key + "\"";
			} else {
				return "\"activate\": false, \"focus\": false, \"expand\": false, \"select\": false, \"key\": \""
						+ key + "\"";
			}

		}

	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param _tree
	 *            Y41bArbolTiposInfraccion
	 * @return String
	 */
	public static String obtieneJsonArbol(Y41bArbolTiposInfraccion _tree) {
		Y41bTiposInfraccionTree t = new Y41bTiposInfraccionTree();
		t._activeNode = (_tree.getNodeActive() != null ? _tree.getNodeActive()
				: "");

		return t.getTreeStructureStr(_tree);
	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param tree
	 *            Y41bArbolTiposInfraccion
	 * @return json tree
	 */
	private String getTreeStructureStr(Y41bArbolTiposInfraccion tree) {

		// Pintar arbolito
		StringBuffer aux = new StringBuffer();

		try {
			aux.append("["); // [

			Iterator<Y41bTipoInfraccionTree> itGr = tree
					.getLstTiposInfraccion().iterator();
			Y41bTipoInfraccionTree tipoinfraccion = null;
			while (itGr.hasNext()) {
				tipoinfraccion = itGr.next();
				aux.append(this.bloqueTiposInfraccion(tipoinfraccion));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");
		} catch (Exception e1) {
			e1.printStackTrace();
		}

		return aux.toString();
	}

	/**
	 * bloqueProductos
	 * 
	 * @param tipoinfraccion
	 *            Y41bTipoInfraccionTree
	 * @return String
	 */
	private String bloqueTiposInfraccion(Y41bTipoInfraccionTree tipoinfraccion) {
		StringBuffer aux = new StringBuffer(Y41bConstantes.BUFFER_300);

		String key = tipoinfraccion.getTticodigo();

		aux.append("{\"title\": \"")
				.append(key)
				.append(" - ")
				.append(Y41bUtils.printTreeLabel(tipoinfraccion.getTtinombre(),
						tipoinfraccion.getTtinombree())).append("\", ");

		aux.append("\"isFolder\": false, ");

		if (tipoinfraccion.getSeleccionable() == null
				|| !tipoinfraccion.getSeleccionable().equals(
						Y41bConstantes.ELEMENTO_SELECCIONABLE)) {
			aux.append("\"addClass\": \"elemento_noseleccionable\", ");
		}

		aux.append(this.printNodeKey(key));

		if (tipoinfraccion.getTiposInfraccion().size() > 0) {
			aux.append(",");
			aux.append("\"children\": [");

			Iterator<?> itGr = tipoinfraccion.getTiposInfraccion().iterator();
			Object child = null;
			while (itGr.hasNext()) {
				child = itGr.next();
				aux.append(this
						.bloqueTiposInfraccion((Y41bTipoInfraccionTree) child));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");

		}
		aux.append("}");

		return aux.toString();
	}
}
