package com.ejie.y41b.utils.tree;

import java.util.Iterator;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Y41bArbolSectores;
import com.ejie.y41b.model.Y41bSectorTree;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * 
 *  
 * 
 */
public class Y41bSectoresTree {

	/**
     * 
     */
	private String _activeNode = "";

	/**
	 * Nodo Activo
	 * 
	 * @param key
	 *            String
	 */
	public void setActiveNode(String key) {
		this._activeNode = key;
	}

	/**
	 * Nodo Activo
	 * 
	 * @return String
	 */
	public String getActiveNode() {
		return this._activeNode;
	}

	/**
	 * Preseleccionar un nodo
	 * 
	 * @param key
	 *            String
	 * @return String
	 */
	private String printNodeKey(String key) {
		if (this._activeNode.equals(key)) {
			return "\"activate\": true, \"focus\": true, \"expand\": true, \"select\": false, \"key\": \""
					+ key + "\"";

			// activate: false, // Initial active status.
			// focus: false, // Initial focused status.
			// expand: false, // Initial expanded status.
			// select: false,

		} else {
			if (this._activeNode.startsWith(key)) {
				// return "\"activate\": false, \"key\": \"" + key + "\"";
				return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": false, \"key\": \""
						+ key + "\"";
			} else {
				return "\"activate\": false, \"focus\": false, \"expand\": false, \"select\": false, \"key\": \""
						+ key + "\"";
			}

		}

	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param _tree
	 *            Y41bArbolSectores
	 * @return String
	 */
	public static String obtieneJsonArbol(Y41bArbolSectores _tree) {
		Y41bSectoresTree t = new Y41bSectoresTree();
		t._activeNode = (_tree.getNodeActive() != null ? _tree.getNodeActive()
				: "");

		return t.getTreeStructureStr(_tree);
	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param tree
	 *            Y41bArbolSectores
	 * @return json tree
	 */
	private String getTreeStructureStr(Y41bArbolSectores tree) {

		// Pintar arbolito
		StringBuffer aux = new StringBuffer();

		try {
			aux.append("["); // [

			Iterator<Y41bSectorTree> itGr = tree.getLstSectores().iterator();
			Y41bSectorTree sector = null;
			while (itGr.hasNext()) {
				sector = itGr.next();
				aux.append(this.bloqueSectores(sector));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");
		} catch (Exception e1) {
			e1.printStackTrace();
		}

		return aux.toString();
	}

	/**
	 * bloqueSectores
	 * 
	 * @param sector
	 *            Y41bSectorTree
	 * @return String
	 */
	private String bloqueSectores(Y41bSectorTree sector) {
		StringBuffer aux = new StringBuffer(Y41bConstantes.BUFFER_300);

		String key = sector.getSecodigo();

		aux.append("{\"title\": \"")
				.append(key.toUpperCase())
				.append(" - ")
				.append(Y41bUtils.printTreeLabel(sector.getSenombre()
						.toUpperCase(), sector.getSenombree().toUpperCase()))
				.append("\", ");

		aux.append("\"isFolder\": false, ");

		if (sector.getSeleccionable() == null
				|| !sector.getSeleccionable().equals(
						Y41bConstantes.ELEMENTO_SELECCIONABLE)) {
			aux.append("\"addClass\": \"elemento_noseleccionable\", ");
		}

		aux.append(this.printNodeKey(key));

		if (sector.getSectores().size() > 0) {
			aux.append(",");
			aux.append("\"children\": [");

			Iterator<?> itGr = sector.getSectores().iterator();
			Object child = null;
			while (itGr.hasNext()) {
				child = itGr.next();
				aux.append(this.bloqueSectores((Y41bSectorTree) child));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");

		}
		aux.append("}");

		return aux.toString();
	}
}
