package com.ejie.y41b.utils.tree;

import java.util.Iterator;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Y41bArbolProductos;
import com.ejie.y41b.model.Y41bProductoTree;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * 
 *  
 * 
 */
public class Y41bProductosTree {

	/**
     * 
     */
	private String _activeNode = "";

	/**
	 * Nodo Activo
	 * 
	 * @param key
	 *            String
	 */
	public void setActiveNode(String key) {
		this._activeNode = key;
	}

	/**
	 * Nodo Activo
	 * 
	 * @return String
	 */
	public String getActiveNode() {
		return this._activeNode;
	}

	/**
	 * Preseleccionar un nodo
	 * 
	 * @param key
	 *            String
	 * @return String
	 */
	private String printNodeKey(String key) {
		if (this._activeNode.equals(key)) {
			return "\"activate\": true, \"focus\": true, \"expand\": true, \"select\": false, \"key\": \""
					+ key + "\"";

			// activate: false, // Initial active status.
			// focus: false, // Initial focused status.
			// expand: false, // Initial expanded status.
			// select: false,

		} else {
			if (this._activeNode.startsWith(key)) {
				// return "\"activate\": false, \"key\": \"" + key + "\"";
				return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": false, \"key\": \""
						+ key + "\"";
			} else {
				return "\"activate\": false, \"focus\": false, \"expand\": false, \"select\": false, \"key\": \""
						+ key + "\"";
			}

		}

	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param _tree
	 *            Y41bArbolProductos
	 * @return String
	 */
	public static String obtieneJsonArbol(Y41bArbolProductos _tree) {
		Y41bProductosTree t = new Y41bProductosTree();
		t._activeNode = (_tree.getNodeActive() != null ? _tree.getNodeActive()
				: "");

		return t.getTreeStructureStr(_tree);
	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param _tree
	 *            Y41bArbolProductos
	 * @return String
	 */
	public static String obtieneJsonArbolChildren(Y41bArbolProductos _tree) {
		Y41bProductosTree t = new Y41bProductosTree();
		t._activeNode = (_tree.getNodeActive() != null ? _tree.getNodeActive()
				: "");

		return t.getTreeStructureStrChildren(_tree);
	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param tree
	 *            Y41bArbolProductos
	 * @return json tree
	 */
	private String getTreeStructureStr(Y41bArbolProductos tree) {

		// Pintar arbolito
		StringBuffer aux = new StringBuffer();

		try {
			aux.append("["); // [

			Iterator<Y41bProductoTree> itGr = tree.getLstProductos().iterator();
			Y41bProductoTree producto = null;
			while (itGr.hasNext()) {
				producto = itGr.next();
				aux.append(this.bloqueProductos(producto));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");
		} catch (Exception e1) {
			e1.printStackTrace();
		}

		return aux.toString();
	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param tree
	 *            Y41bArbolProductos
	 * @return json tree
	 */
	private String getTreeStructureStrChildren(Y41bArbolProductos tree) {

		// Pintar arbolito
		StringBuffer aux = new StringBuffer();

		try {
			aux.append("["); // [

			Iterator<Y41bProductoTree> itGr = tree.getLstProductos().iterator();
			Y41bProductoTree producto = null;
			while (itGr.hasNext()) {
				producto = itGr.next();
				aux.append(this.bloqueProductosChildren(producto));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");
		} catch (Exception e1) {
			e1.printStackTrace();
		}

		return aux.toString();
	}

	/**
	 * bloqueProductos
	 * 
	 * @param producto
	 *            Y41bProductoTree
	 * @return String
	 */
	private String bloqueProductos(Y41bProductoTree producto) {
		StringBuffer aux = new StringBuffer(Y41bConstantes.BUFFER_300);

		String key = producto.getPscodigo();

		aux.append("{\"title\": \"")
				.append(key.toUpperCase())
				.append(" - ")
				.append(Y41bUtils.printTreeLabel(producto.getPsnombre()
						.toUpperCase(), producto.getPsnombree().toUpperCase()))
				.append("\", ");

		aux.append("\"isFolder\": false, ");

		if (producto.getSeleccionable() == null
				|| !producto.getSeleccionable().equals(
						Y41bConstantes.ELEMENTO_SELECCIONABLE)) {
			aux.append("\"addClass\": \"elemento_noseleccionable\", ");
		}

		aux.append(this.printNodeKey(key));

		if (producto.getProductos().size() > 0) {
			aux.append(",");
			aux.append("\"children\": [");

			Iterator<?> itGr = producto.getProductos().iterator();
			Object child = null;
			while (itGr.hasNext()) {
				child = itGr.next();
				aux.append(this.bloqueProductos((Y41bProductoTree) child));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");

		}
		aux.append("}");

		return aux.toString();
	}

	/**
	 * bloqueProductos
	 * 
	 * @param producto
	 *            Y41bProductoTree
	 * @return String
	 */
	private String bloqueProductosChildren(Y41bProductoTree producto) {
		StringBuffer aux = new StringBuffer(Y41bConstantes.BUFFER_300);

		Iterator<?> itGr = producto.getProductos().iterator();
		Object child = null;
		while (itGr.hasNext()) {
			child = itGr.next();
			aux.append(this.bloqueProductos((Y41bProductoTree) child));
			if (itGr.hasNext()) {
				aux.append(",");
			}
		}

		return aux.toString();
	}
}
